/* Copyright (c) 2020 Red Hat, Inc. */

export const mockManagedClusters = {
  apiVersion: 'cluster.open-cluster-management.io/v1',
  kind: 'ManagedCluster',
  metadata: {
    creationTimestamp: '2020-06-09T13:54:42Z',
    finalizers: [
      'cluster.open-cluster-management.io/api-resource-cleanup',
      'managedclusterinfo.finalizers.open-cluster-management.io',
    ],
    generation: 2,
    name: 'ironman',
    resourceVersion: '29737338',
    selfLink: '/apis/cluster.open-cluster-management.io/v1/managedclusters/ironman',
    uid: 'bdb8e137-07c1-4745-b70b-3d79c6ddcb17',
  },
  spec: {
    hubAcceptsClient: true,
    managedClusterClientConfigs: [
      {
        caBundle: '',
        url: 'https://localhost',
      },
    ],
  },
  status: {
    allocatable: {
      cpu: '50',
      memory: '107049Mi',
    },
    capacity: {
      cpu: '52',
      memory: '109449Mi',
    },
    conditions: [
      {
        lastTransitionTime: '2020-06-09T13:58:44Z',
        message: 'Accepted by hub cluster admin',
        reason: 'HubClusterAdminAccepted',
        status: 'True',
        type: 'HubAcceptedManagedCluster',
      },
      {
        lastTransitionTime: '2020-06-09T13:58:55Z',
        message: 'Managed cluster joined',
        reason: 'ManagedClusterJoined',
        status: 'True',
        type: 'ManagedClusterJoined',
      },
      {
        lastTransitionTime: '2020-06-14T16:06:51Z',
        message: 'Managed cluster is available',
        reason: 'ManagedClusterAvailable',
        status: 'True',
        type: 'ManagedClusterConditionAvailable',
      },
    ],
    version: {
      kubernetes: 'v1.16.2',
    },
  },
};

export const mockManagedClusterInfos = {
  apiVersion: 'internal.open-cluster-management.io/v1beta1',
  kind: 'ManagedClusterInfo',
  metadata: {
    creationTimestamp: '2020-06-16T13:58:50Z',
    generation: 2,
    labels: {
      cloud: 'auto-detect',
      environment: '',
      name: 'ironman',
      vendor: 'auto-detect',
    },
    name: 'ironman',
    namespace: 'ironman',
    resourceVersion: '7497297',
    selfLink: '/apis/internal.open-cluster-management.io/v1beta1/namespaces/ironman/managedclusterinfos/ironman',
    uid: '23b04acb-6d80-40c5-9db8-4a53782cbfb8',
  },
  spec: {
    loggingCA: 'LS0tLS1CRUdJTiBDRVJUSUZJQ0FURS0tLS0tCk1JSURGekNDQWYrZ0F3SUJBZ0lSQUkrd09nc3lwZjVBSk5WNGNPR00wc0l3RFFZSktvWklodmNOQVFFTEJRQXcKSlRFak1DRUdBMVVFQXhNYWJYVnNkR2xqYkhWemRHVnlhSFZpTFd0c2RYTjBaWEpzWlhRd0hoY05NakF3TmpFMgpNVE0wT1RBM1doY05NakV3TmpFMk1UTTBPVEEzV2pBbE1TTXdJUVlEVlFRREV4cHRkV3gwYVdOc2RYTjBaWEpvCmRXSXRhMngxYzNSbGNteGxkRENDQVNJd0RRWUpLb1pJaHZjTkFRRUJCUUFEZ2dFUEFEQ0NBUW9DZ2dFQkFNRTcKNldjT2ZXMUxwUnk4N2l6R3pGMHpHMkZzMnlLd0J0eTh4SXZVYVJva3JOTFM0aUpxeHhlSFBsRDdYOW80ZFQzOApLWkVDTHRpZzV1VmdobVgrQXdkVmIyRjdYQS9MazBDZG9LSGZiNzdqZytFNkYxR0dOVGNqTDN4NFJaZ3hxKzFaCnluR2FUNVQvMFNZSXBvUlAzSE95NE1xWGNZaEE1T2FYbkRuS2Q4RmhkMzRPT1haN0NLcmpTQldmM1R3UVk5am4KK3c1d2VwZWdQOUU2cTBiQUFya3JIcWt6WERScFB4aldwMEJDRGdjckpmZzJ4WkhwaythTUZpYzVyV2xvQ2pZSwpVeXN2UGJvenl6SHlvYUhpRE9lUEVvdTRLdWY3aFpPSGpQbVFMdGN3OW5zOFZMOFNPWXR5MWN3TW1qSS8vUnF1Clc0QUJrQWVieWtPdHZJaEVHNzBDQXdFQUFhTkNNRUF3RGdZRFZSMFBBUUgvQkFRREFnS2tNQjBHQTFVZEpRUVcKTUJRR0NDc0dBUVVGQndNQkJnZ3JCZ0VGQlFjREFqQVBCZ05WSFJNQkFmOEVCVEFEQVFIL01BMEdDU3FHU0liMwpEUUVCQ3dVQUE0SUJBUUNObTlRc1NneXV4aWJlWS9jcWQ5MjcyeU1rT3JMUHpSSUVMaHU2MWVSU3RHeDM5bHplCmY3YnQzVDhBNTA4MUhRUXlHM1B3VWJNWVZieVJYZnFDWnNJa2h4ZTJzYzRVZzB1Mm95dUl0VkNmMmUrcjBHSzAKOWZTalBIWmJaZWFLYjZob1BaRUV5OTM0dkFQajcwKzRSanVTY25BQUtkZU9HNzJ2ajlxdGh5cVY5c21GVjgwaAordCtCK3VWNit5VU5FK1hWbFh6VG9nVnd3aktRa2tVL1EwaXNXNk0vSk41YnFUQ1RyUXpKS2E3dDByRlNyZjU4CkpxcTFHNjdMemJ0dE93T3hkeGJFbTg0ekt4NEhvU2FVQms5SXhkWmZPMUVvWE44VVRHUzVyVWdoUjBSUDBqaHcKV1UzODhrLzNIRG1Bck1DOWJCbVNoWWFoSHJlMTVQSmpMb0RBCi0tLS0tRU5EIENFUlRJRklDQVRFLS0tLS0K',
    masterEndpoint: 'api.ironman.dev08.red-chesterfield.com:6443',
  },
  status: {
    conditions: [
      {
        lastTransitionTime: '2020-06-22T14:47:13Z',
        message: 'cluster is posting ready status',
        reason: 'ClusterReady',
        status: 'True',
        type: 'ManagedClusterJoined',
      },
    ],
    distributionInfo: {
      ocp: {},
    },
    loggingEndpoint: {
      ip: '',
    },
    loggingPort: {
      port: 0,
    },
  },
};

export const mockClusterList = {
  kind: 'ClusterList',
  apiVersion: 'clusterregistry.k8s.io/v1alpha1',
  metadata: {
    selfLink: '/apis/clusterregistry.k8s.io/v1alpha1/namespaces/ironman/clusters/',
    resourceVersion: '56657',
  },
  items: [
    {
      metadata: {
        name: 'ironman',
        namespace: 'ironman',
        selfLink: '/apis/clusterregistry.k8s.io/v1alpha1/namespaces/ironman/clusters/ironman',
        uid: 'c1b6f84a-13a2-4a6a-90c5-e2a98a1f8cf8',
        resourceVersion: '56657',
        creationTimestamp: '2020-06-16T13:58:48Z',
        labels: {
          cloud: 'Amazon',
          environment: '',
          name: 'ironman',
          vendor: 'OpenShift',
        },
        annotations: {
          'mcm.ibm.com/user-group': 'c3lzdGVtOnNlcnZpY2VhY2NvdW50cyxzeXN0ZW06c2VydmljZWFjY291bnRzOm9wZW4tY2x1c3Rlci1tYW5hZ2VtZW50LHN5c3RlbTphdXRoZW50aWNhdGVk',
          'mcm.ibm.com/user-identity': 'c3lzdGVtOnNlcnZpY2VhY2NvdW50Om9wZW4tY2x1c3Rlci1tYW5hZ2VtZW50OnJjbS1jb250cm9sbGVy',
        },
        finalizers: [
          'managedclusterrbac.finalizers.open-cluster-management.io',
          'managedclusterinfo.finalizers.open-cluster-management.io',
          'rcm-controller.cluster',
        ],
      },
      spec: {
        kubernetesApiEndpoints: {
          serverEndpoints: [
            {
              clientCIDR: '0.0.0.0/0',
              serverAddress: 'api.ironman.dev08.red-chesterfield.com:6443',
            },
          ],
        },
        authInfo: {},
      },
      status: {
        conditions: [
          {
            type: 'OK',
            status: '',
            lastHeartbeatTime: '2020-06-22T13:50:08Z',
            lastTransitionTime: null,
          },
        ],
      },
    },
  ],
};

export const mockNonClusterList = {
  kind: 'ClusterList',
  apiVersion: 'clusterregistry.k8s.io/v1alpha1',
  metadata: {
    selfLink: '/apis/clusterregistry.k8s.io/v1alpha1/namespaces/default/clusters/',
    resourceVersion: '56657',
  },
};
