/** *****************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 ****************************************************************************** */
/* Copyright (c) 2020 Red Hat, Inc. */
import _ from 'lodash';

async function getClusterElements(clusterModel, complianceModel) {
  const nodes = [];
  const clusters = await clusterModel.getClusters();

  const clusterMap = {};
  clusters.forEach((cluster) => {
    const {
      metadata: {
        name, namespace,
      },
    } = cluster;
    const clusterId = `cluster--${name}`;
    const clusterNode = {
      name,
      namespace,
      type: 'cluster',
      id: clusterId,
      uid: clusterId,
      specs: {
        isLive: true,
        cluster,
        violations: [],
      },
    };
    clusterMap[name] = clusterNode;
    nodes.push(clusterNode);
  });

  // add compliance violations
  const compliances = await complianceModel.getCompliances();
  compliances.forEach(({ name, status }) => {
    const stats = _.get(status, 'status');
    if (stats) {
      stats.forEach((entry) => {
        const { compliance, compliant, clustername } = entry;
        const complianceStatus = compliance || compliant;
        if (clusterMap[clustername]
          && (!complianceStatus || complianceStatus.toLowerCase().trim() === 'noncompliant')) {
          const { specs: { violations } } = clusterMap[clustername];
          violations.push(name);
        }
      });
    }
  });

  return { resources: nodes };
}

export { getClusterElements as default };
