"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = _interopRequireDefault(require("lodash.isequal"));

var _editorOptions = require("./editorOptions.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var ace = (0, _editorOptions.getAceInstance)();

var _ace$acequire = ace.acequire("ace/range"),
    Range = _ace$acequire.Range;

var ReactAce =
/*#__PURE__*/
function (_Component) {
  _inherits(ReactAce, _Component);

  function ReactAce(props) {
    var _this;

    _classCallCheck(this, ReactAce);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(ReactAce).call(this, props));

    _editorOptions.editorEvents.forEach(function (method) {
      _this[method] = _this[method].bind(_assertThisInitialized(_this));
    });

    _this.debounce = _editorOptions.debounce;
    return _this;
  }

  _createClass(ReactAce, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      var _this$props = this.props,
          className = _this$props.className,
          onBeforeLoad = _this$props.onBeforeLoad,
          onValidate = _this$props.onValidate,
          mode = _this$props.mode,
          focus = _this$props.focus,
          theme = _this$props.theme,
          fontSize = _this$props.fontSize,
          value = _this$props.value,
          defaultValue = _this$props.defaultValue,
          cursorStart = _this$props.cursorStart,
          showGutter = _this$props.showGutter,
          wrapEnabled = _this$props.wrapEnabled,
          showPrintMargin = _this$props.showPrintMargin,
          _this$props$scrollMar = _this$props.scrollMargin,
          scrollMargin = _this$props$scrollMar === void 0 ? [0, 0, 0, 0] : _this$props$scrollMar,
          keyboardHandler = _this$props.keyboardHandler,
          onLoad = _this$props.onLoad,
          commands = _this$props.commands,
          annotations = _this$props.annotations,
          markers = _this$props.markers,
          placeholder = _this$props.placeholder;
      this.editor = ace.edit(this.refEditor);

      if (onBeforeLoad) {
        onBeforeLoad(ace);
      }

      var editorProps = Object.keys(this.props.editorProps);

      for (var i = 0; i < editorProps.length; i++) {
        this.editor[editorProps[i]] = this.props.editorProps[editorProps[i]];
      }

      if (this.props.debounceChangePeriod) {
        this.onChange = this.debounce(this.onChange, this.props.debounceChangePeriod);
      }

      this.editor.renderer.setScrollMargin(scrollMargin[0], scrollMargin[1], scrollMargin[2], scrollMargin[3]);
      this.editor.getSession().setMode("ace/mode/".concat(mode));
      this.editor.setTheme("ace/theme/".concat(theme));
      this.editor.setFontSize(fontSize);
      this.editor.getSession().setValue(!defaultValue ? value : defaultValue, cursorStart);

      if (this.props.navigateToFileEnd) {
        this.editor.navigateFileEnd();
      }

      this.editor.renderer.setShowGutter(showGutter);
      this.editor.getSession().setUseWrapMode(wrapEnabled);
      this.editor.setShowPrintMargin(showPrintMargin);
      this.editor.on("focus", this.onFocus);
      this.editor.on("blur", this.onBlur);
      this.editor.on("copy", this.onCopy);
      this.editor.on("paste", this.onPaste);
      this.editor.on("change", this.onChange);
      this.editor.on("input", this.onInput);

      if (placeholder) {
        this.updatePlaceholder(this.editor, placeholder);
      }

      this.editor.getSession().selection.on("changeSelection", this.onSelectionChange);
      this.editor.getSession().selection.on("changeCursor", this.onCursorChange);

      if (onValidate) {
        this.editor.getSession().on("changeAnnotation", function () {
          var annotations = _this2.editor.getSession().getAnnotations();

          _this2.props.onValidate(annotations);
        });
      }

      this.editor.session.on("changeScrollTop", this.onScroll);
      this.editor.getSession().setAnnotations(annotations || []);

      if (markers && markers.length > 0) {
        this.handleMarkers(markers);
      } // get a list of possible options to avoid 'misspelled option errors'


      var availableOptions = this.editor.$options;

      for (var _i = 0; _i < _editorOptions.editorOptions.length; _i++) {
        var option = _editorOptions.editorOptions[_i];

        if (availableOptions.hasOwnProperty(option)) {
          this.editor.setOption(option, this.props[option]);
        } else if (this.props[option]) {
          console.warn("ReactAce: editor option ".concat(option, " was activated but not found. Did you need to import a related tool or did you possibly mispell the option?"));
        }
      }

      this.handleOptions(this.props);

      if (Array.isArray(commands)) {
        commands.forEach(function (command) {
          if (typeof command.exec == "string") {
            _this2.editor.commands.bindKey(command.bindKey, command.exec);
          } else {
            _this2.editor.commands.addCommand(command);
          }
        });
      }

      if (keyboardHandler) {
        this.editor.setKeyboardHandler("ace/keyboard/" + keyboardHandler);
      }

      if (className) {
        this.refEditor.className += " " + className;
      }

      if (onLoad) {
        onLoad(this.editor);
      }

      this.editor.resize();

      if (focus) {
        this.editor.focus();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var oldProps = prevProps;
      var nextProps = this.props;

      for (var i = 0; i < _editorOptions.editorOptions.length; i++) {
        var option = _editorOptions.editorOptions[i];

        if (nextProps[option] !== oldProps[option]) {
          this.editor.setOption(option, nextProps[option]);
        }
      }

      if (nextProps.className !== oldProps.className) {
        var appliedClasses = this.refEditor.className;
        var appliedClassesArray = appliedClasses.trim().split(" ");
        var oldClassesArray = oldProps.className.trim().split(" ");
        oldClassesArray.forEach(function (oldClass) {
          var index = appliedClassesArray.indexOf(oldClass);
          appliedClassesArray.splice(index, 1);
        });
        this.refEditor.className = " " + nextProps.className + " " + appliedClassesArray.join(" ");
      } // First process editor value, as it may create a new session (see issue #300)


      if (this.editor && this.editor.getValue() !== nextProps.value) {
        // editor.setValue is a synchronous function call, change event is emitted before setValue return.
        this.silent = true;
        var pos = this.editor.session.selection.toJSON();
        this.editor.setValue(nextProps.value, nextProps.cursorStart);
        this.editor.session.selection.fromJSON(pos);
        this.silent = false;
      }

      if (nextProps.placeholder !== oldProps.placeholder) {
        this.updatePlaceholder();
      }

      if (nextProps.mode !== oldProps.mode) {
        this.editor.getSession().setMode("ace/mode/" + nextProps.mode);
      }

      if (nextProps.theme !== oldProps.theme) {
        this.editor.setTheme("ace/theme/" + nextProps.theme);
      }

      if (nextProps.keyboardHandler !== oldProps.keyboardHandler) {
        if (nextProps.keyboardHandler) {
          this.editor.setKeyboardHandler("ace/keyboard/" + nextProps.keyboardHandler);
        } else {
          this.editor.setKeyboardHandler(null);
        }
      }

      if (nextProps.fontSize !== oldProps.fontSize) {
        this.editor.setFontSize(nextProps.fontSize);
      }

      if (nextProps.wrapEnabled !== oldProps.wrapEnabled) {
        this.editor.getSession().setUseWrapMode(nextProps.wrapEnabled);
      }

      if (nextProps.showPrintMargin !== oldProps.showPrintMargin) {
        this.editor.setShowPrintMargin(nextProps.showPrintMargin);
      }

      if (nextProps.showGutter !== oldProps.showGutter) {
        this.editor.renderer.setShowGutter(nextProps.showGutter);
      }

      if (!(0, _lodash["default"])(nextProps.setOptions, oldProps.setOptions)) {
        this.handleOptions(nextProps);
      }

      if (!(0, _lodash["default"])(nextProps.annotations, oldProps.annotations)) {
        this.editor.getSession().setAnnotations(nextProps.annotations || []);
      }

      if (!(0, _lodash["default"])(nextProps.markers, oldProps.markers) && Array.isArray(nextProps.markers)) {
        this.handleMarkers(nextProps.markers);
      } // this doesn't look like it works at all....


      if (!(0, _lodash["default"])(nextProps.scrollMargin, oldProps.scrollMargin)) {
        this.handleScrollMargins(nextProps.scrollMargin);
      }

      if (prevProps.height !== this.props.height || prevProps.width !== this.props.width) {
        this.editor.resize();
      }

      if (this.props.focus && !prevProps.focus) {
        this.editor.focus();
      }
    }
  }, {
    key: "handleScrollMargins",
    value: function handleScrollMargins() {
      var margins = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [0, 0, 0, 0];
      this.editor.renderer.setScrollMargins(margins[0], margins[1], margins[2], margins[3]);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.editor.destroy();
      this.editor = null;
    }
  }, {
    key: "onChange",
    value: function onChange(event) {
      if (this.props.onChange && !this.silent) {
        var value = this.editor.getValue();
        this.props.onChange(value, event);
      }
    }
  }, {
    key: "onSelectionChange",
    value: function onSelectionChange(event) {
      if (this.props.onSelectionChange) {
        var value = this.editor.getSelection();
        this.props.onSelectionChange(value, event);
      }
    }
  }, {
    key: "onCursorChange",
    value: function onCursorChange(event) {
      if (this.props.onCursorChange) {
        var value = this.editor.getSelection();
        this.props.onCursorChange(value, event);
      }
    }
  }, {
    key: "onInput",
    value: function onInput(event) {
      if (this.props.onInput) {
        this.props.onInput(event);
      }

      if (this.props.placeholder) {
        this.updatePlaceholder();
      }
    }
  }, {
    key: "onFocus",
    value: function onFocus(event) {
      if (this.props.onFocus) {
        this.props.onFocus(event, this.editor);
      }
    }
  }, {
    key: "onBlur",
    value: function onBlur(event) {
      if (this.props.onBlur) {
        this.props.onBlur(event, this.editor);
      }
    }
  }, {
    key: "onCopy",
    value: function onCopy(text) {
      if (this.props.onCopy) {
        this.props.onCopy(text);
      }
    }
  }, {
    key: "onPaste",
    value: function onPaste(text) {
      if (this.props.onPaste) {
        this.props.onPaste(text);
      }
    }
  }, {
    key: "onScroll",
    value: function onScroll() {
      if (this.props.onScroll) {
        this.props.onScroll(this.editor);
      }
    }
  }, {
    key: "handleOptions",
    value: function handleOptions(props) {
      var setOptions = Object.keys(props.setOptions);

      for (var y = 0; y < setOptions.length; y++) {
        this.editor.setOption(setOptions[y], props.setOptions[setOptions[y]]);
      }
    }
  }, {
    key: "handleMarkers",
    value: function handleMarkers(markers) {
      var _this3 = this;

      // remove foreground markers
      var currentMarkers = this.editor.getSession().getMarkers(true);

      for (var i in currentMarkers) {
        if (currentMarkers.hasOwnProperty(i)) {
          this.editor.getSession().removeMarker(currentMarkers[i].id);
        }
      } // remove background markers except active line marker and selected word marker


      currentMarkers = this.editor.getSession().getMarkers(false);

      for (var _i2 in currentMarkers) {
        if (currentMarkers.hasOwnProperty(_i2) && currentMarkers[_i2].clazz !== "ace_active-line" && currentMarkers[_i2].clazz !== "ace_selected-word") {
          this.editor.getSession().removeMarker(currentMarkers[_i2].id);
        }
      } // add new markers


      markers.forEach(function (_ref) {
        var startRow = _ref.startRow,
            startCol = _ref.startCol,
            endRow = _ref.endRow,
            endCol = _ref.endCol,
            className = _ref.className,
            type = _ref.type,
            _ref$inFront = _ref.inFront,
            inFront = _ref$inFront === void 0 ? false : _ref$inFront;
        var range = new Range(startRow, startCol, endRow, endCol);

        _this3.editor.getSession().addMarker(range, className, type, inFront);
      });
    }
  }, {
    key: "updatePlaceholder",
    value: function updatePlaceholder() {
      // Adapted from https://stackoverflow.com/questions/26695708/how-can-i-add-placeholder-text-when-the-editor-is-empty
      var editor = this.editor;
      var placeholder = this.props.placeholder;
      var showPlaceholder = !editor.session.getValue().length;
      var node = editor.renderer.placeholderNode;

      if (!showPlaceholder && node) {
        editor.renderer.scroller.removeChild(editor.renderer.placeholderNode);
        editor.renderer.placeholderNode = null;
      } else if (showPlaceholder && !node) {
        node = editor.renderer.placeholderNode = document.createElement("div");
        node.textContent = placeholder || "";
        node.className = "ace_comment ace_placeholder";
        node.style.padding = "0 9px";
        node.style.position = "absolute";
        node.style.zIndex = "3";
        editor.renderer.scroller.appendChild(node);
      } else if (showPlaceholder && node) {
        node.textContent = placeholder;
      }
    }
  }, {
    key: "updateRef",
    value: function updateRef(item) {
      this.refEditor = item;
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          name = _this$props2.name,
          width = _this$props2.width,
          height = _this$props2.height,
          style = _this$props2.style;

      var divStyle = _objectSpread({
        width: width,
        height: height
      }, style);

      return _react["default"].createElement("div", {
        ref: this.updateRef,
        id: name,
        style: divStyle
      });
    }
  }]);

  return ReactAce;
}(_react.Component);

exports["default"] = ReactAce;
ReactAce.propTypes = {
  mode: _propTypes["default"].string,
  focus: _propTypes["default"].bool,
  theme: _propTypes["default"].string,
  name: _propTypes["default"].string,
  className: _propTypes["default"].string,
  height: _propTypes["default"].string,
  width: _propTypes["default"].string,
  fontSize: _propTypes["default"].oneOfType([_propTypes["default"].number, _propTypes["default"].string]),
  showGutter: _propTypes["default"].bool,
  onChange: _propTypes["default"].func,
  onCopy: _propTypes["default"].func,
  onPaste: _propTypes["default"].func,
  onFocus: _propTypes["default"].func,
  onInput: _propTypes["default"].func,
  onBlur: _propTypes["default"].func,
  onScroll: _propTypes["default"].func,
  value: _propTypes["default"].string,
  defaultValue: _propTypes["default"].string,
  onLoad: _propTypes["default"].func,
  onSelectionChange: _propTypes["default"].func,
  onCursorChange: _propTypes["default"].func,
  onBeforeLoad: _propTypes["default"].func,
  onValidate: _propTypes["default"].func,
  minLines: _propTypes["default"].number,
  maxLines: _propTypes["default"].number,
  readOnly: _propTypes["default"].bool,
  highlightActiveLine: _propTypes["default"].bool,
  tabSize: _propTypes["default"].number,
  showPrintMargin: _propTypes["default"].bool,
  cursorStart: _propTypes["default"].number,
  debounceChangePeriod: _propTypes["default"].number,
  editorProps: _propTypes["default"].object,
  setOptions: _propTypes["default"].object,
  style: _propTypes["default"].object,
  scrollMargin: _propTypes["default"].array,
  annotations: _propTypes["default"].array,
  markers: _propTypes["default"].array,
  keyboardHandler: _propTypes["default"].string,
  wrapEnabled: _propTypes["default"].bool,
  enableBasicAutocompletion: _propTypes["default"].oneOfType([_propTypes["default"].bool, _propTypes["default"].array]),
  enableLiveAutocompletion: _propTypes["default"].oneOfType([_propTypes["default"].bool, _propTypes["default"].array]),
  navigateToFileEnd: _propTypes["default"].bool,
  commands: _propTypes["default"].array,
  placeholder: _propTypes["default"].string
};
ReactAce.defaultProps = {
  name: "brace-editor",
  focus: false,
  mode: "",
  theme: "",
  height: "500px",
  width: "500px",
  value: "",
  fontSize: 12,
  showGutter: true,
  onChange: null,
  onPaste: null,
  onLoad: null,
  onScroll: null,
  minLines: null,
  maxLines: null,
  readOnly: false,
  highlightActiveLine: true,
  showPrintMargin: true,
  tabSize: 4,
  cursorStart: 1,
  editorProps: {},
  style: {},
  scrollMargin: [0, 0, 0, 0],
  setOptions: {},
  wrapEnabled: false,
  enableBasicAutocompletion: false,
  enableLiveAutocompletion: false,
  placeholder: null,
  navigateToFileEnd: true
};