"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _uniqueId = _interopRequireDefault(require("../../tools/uniqueId"));

var _Icon = _interopRequireDefault(require("../Icon"));

var _carbonIcons = require("carbon-icons");

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _ = _interopRequireDefault(require("@carbon/icons-react/lib/checkmark--filled/16"));

var _FeatureFlags = require("../../internal/FeatureFlags");

var _key2 = require("../../tools/key");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var prefix = _carbonComponents.settings.prefix;

var RadioTile =
/*#__PURE__*/
function (_React$Component) {
  _inherits(RadioTile, _React$Component);

  function RadioTile() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, RadioTile);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(RadioTile)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "uid", _this.props.id || (0, _uniqueId.default)());

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "handleChange", function (evt) {
      _this.props.onChange(_this.props.value, _this.props.name, evt);
    });

    _defineProperty(_assertThisInitialized(_assertThisInitialized(_this)), "handleKeyDown", function (evt) {
      if ((0, _key2.matches)(evt, [_key2.keys.ENTER, _key2.keys.SPACE])) {
        evt.preventDefault();

        _this.props.onChange(_this.props.value, _this.props.name, evt);
      }
    });

    return _this;
  }

  _createClass(RadioTile, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          iconDescription = _this$props.iconDescription,
          other = _objectWithoutProperties(_this$props, ["children", "className", "iconDescription"]);

      var classes = (0, _classnames.default)(className, "".concat(prefix, "--tile"), "".concat(prefix, "--tile--selectable"), _defineProperty({}, "".concat(prefix, "--tile--is-selected"), this.props.checked));
      return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement("input", _extends({}, other, {
        type: "radio",
        className: "".concat(prefix, "--tile-input"),
        onChange: this.handleChange,
        id: this.uid
      })), _react.default.createElement("label", {
        htmlFor: this.uid,
        className: classes,
        tabIndex: this.props.tabIndex,
        onKeyDown: this.handleKeyDown
      }, _react.default.createElement("div", {
        className: "".concat(prefix, "--tile__checkmark")
      }, _FeatureFlags.componentsX ? _react.default.createElement(_.default, {
        "aria-label": iconDescription
      }, iconDescription && _react.default.createElement("title", null, iconDescription)) : _react.default.createElement(_Icon.default, {
        icon: _carbonIcons.iconCheckmarkSolid,
        description: iconDescription
      })), _react.default.createElement("div", {
        className: "".concat(prefix, "--tile-content")
      }, children)));
    }
  }]);

  return RadioTile;
}(_react.default.Component);

exports.default = RadioTile;

_defineProperty(RadioTile, "propTypes", {
  /**
   * `true` if this tile should be selected.
   */
  checked: _propTypes.default.bool,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * `true` if the `<input>` should be checked at initialization.
   */
  defaultChecked: _propTypes.default.bool,

  /**
   * The ID of the `<input>`.
   */
  id: _propTypes.default.string,

  /**
   * The `name` of the `<input>`.
   */
  name: _propTypes.default.string,

  /**
   * The description of the tile checkmark icon.
   */
  iconDescription: _propTypes.default.string,

  /**
   * The handler of the massaged `change` event on the `<input>`.
   */
  onChange: _propTypes.default.func,

  /**
   * The `value` of the `<input>`.
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired,

  /**
   * Specify the tab index of the wrapper element
   */
  tabIndex: _propTypes.default.number
});

_defineProperty(RadioTile, "defaultProps", {
  iconDescription: 'Tile checkmark',
  onChange: function onChange() {},
  tabIndex: 0
});