"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _ListBoxMenuIcon = _interopRequireDefault(require("./ListBoxMenuIcon"));

var _ListBoxSelection = _interopRequireDefault(require("./ListBoxSelection"));

var _childrenOf = _interopRequireDefault(require("../../prop-types/childrenOf"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;
/**
 * `ListBoxField` is responsible for creating the containing node for valid
 * elements inside of a field. It also provides a11y-related attributes like
 * `role` to make sure a user can focus the given field.
 */

var ListBoxField = function ListBoxField(_ref) {
  var children = _ref.children,
      id = _ref.id,
      rest = _objectWithoutProperties(_ref, ["children", "id"]);

  return _react.default.createElement("div", _extends({
    role: "button",
    className: "".concat(prefix, "--list-box__field"),
    tabIndex: "0"
  }, rest, {
    "aria-expanded": rest['aria-expanded'],
    "aria-owns": rest['aria-expanded'] && "".concat(id, "__menu") || null,
    "aria-controls": rest['aria-expanded'] && "".concat(id, "__menu") || null
  }), children);
};

ListBoxField.propTypes = {
  /**
   * Provide the contents of your ListBoxField
   */
  children: (0, _childrenOf.default)([_ListBoxMenuIcon.default, _ListBoxSelection.default, 'span', 'input'])
};
var _default = ListBoxField;
exports.default = _default;