import _extends from 'babel-runtime/helpers/extends';
import _objectWithoutProperties from 'babel-runtime/helpers/objectWithoutProperties';
import _Object$getPrototypeOf from 'babel-runtime/core-js/object/get-prototype-of';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import classNames from 'classnames';

var propTypes = {
  className: PropTypes.string,
  data: PropTypes.array,
  direction: PropTypes.string,
  id: PropTypes.string,
  heading: PropTypes.array,
  isActive: PropTypes.bool,
  hasSections: PropTypes.bool
};

var defaultProps = {
  data: [100],
  direction: 'top',
  id: 'bx--data-tooltip',
  heading: null,
  isActive: true,
  hasSections: false
};

var DataTooltip = function (_Component) {
  _inherits(DataTooltip, _Component);

  function DataTooltip() {
    _classCallCheck(this, DataTooltip);

    return _possibleConstructorReturn(this, (DataTooltip.__proto__ || _Object$getPrototypeOf(DataTooltip)).apply(this, arguments));
  }

  _createClass(DataTooltip, [{
    key: 'renderTooltipData',
    value: function renderTooltipData(data, heading) {
      var items = data.map(function (item, i) {
        var divStyle = void 0;
        if (item.color) {
          if (data.length > 1 && heading) {
            divStyle = {
              borderLeft: '4px solid ' + item.color
            };
          }
        }

        var tooltipItemClasses = classNames('bx--data-tooltip-list-item', {
          'bx--data-tooltip__base': !item.color && data.length <= 1
        }, {
          'bx--data-tooltip__single': item.color && data.length <= 1
        }, {
          'bx--data-tooltip__multiple': item.color && data.length > 1
        }, {
          'bx--data-tooltip__multiple--right': item.color && data.length > 3 && i >= data.length / 2
        }, {
          'bx--data-tooltip__multiple--left': item.color && data.length > 3 && i < data.length / 2
        });

        return React.createElement(
          'li',
          { key: i, style: divStyle, className: tooltipItemClasses },
          item.label && React.createElement(
            'span',
            { className: 'bx--data-tooltip-list-item__label' },
            item.label
          ),
          React.createElement(
            'span',
            { className: 'bx--data-tooltip-list-item__data' },
            item.data
          )
        );
      });

      return items;
    }
  }, {
    key: 'getTootlTipClasses',
    value: function getTootlTipClasses(isActive, className) {
      return classNames('bx--tooltip', 'bx--data-tooltip', {
        'bx--tooltip--shown': isActive
      }, className);
    }
  }, {
    key: 'getTootleTipListClasses',
    value: function getTootleTipListClasses(data) {
      return classNames('bx--data-tooltip-list', {
        'bx--data-tooltip-list--block': data.length >= 4
      });
    }
  }, {
    key: 'getListStyle',
    value: function getListStyle(data) {
      return {
        columnCount: data.length > 3 ? '2' : '1',
        columnGap: '1.25rem'
      };
    }
  }, {
    key: 'getHeadingClasses',
    value: function getHeadingClasses(data) {
      return classNames('bx--data-tooltip__label', {
        'bx--data-tooltip__label--no-margin': data.length === 1
      });
    }
  }, {
    key: 'renderTooltipHeading',
    value: function renderTooltipHeading(data, heading) {
      var headingClasses = this.getHeadingClasses(data);
      return heading && React.createElement(
        'p',
        { className: headingClasses },
        heading
      );
    }
  }, {
    key: 'renderTooltipBody',
    value: function renderTooltipBody(data, heading) {
      var direction = this.props.direction;
      var tooltipListClasses = this.getTootleTipListClasses(data);
      var listStyle = this.getListStyle(data);
      if (data.length === 1 && data[0].color) {
        if (direction === 'top') {
          listStyle.borderTop = '4px solid ' + data[0].color;
        } else if (direction === 'bottom') {
          listStyle.borderBottom = '4px solid ' + data[0].color;
        }
      }
      return React.createElement(
        'ul',
        { className: tooltipListClasses, style: listStyle },
        this.renderTooltipData(data, heading)
      );
    }
  }, {
    key: 'renderTooltipSections',
    value: function renderTooltipSections(data, heading) {
      var self = this;
      return data.map(function (section, i) {
        return React.createElement(
          'div',
          null,
          self.renderTooltipHeading(data, heading[i]),
          self.renderTooltipBody(section, heading[i])
        );
      });
    }
  }, {
    key: 'renderAllSections',
    value: function renderAllSections(data, heading) {
      var sections = this.renderTooltipSections(data, heading);
      return sections.map(function (section) {
        return section;
      });
    }
  }, {
    key: 'renderDefault',
    value: function renderDefault(data, heading) {
      return React.createElement(
        'div',
        null,
        this.renderTooltipHeading(data, heading),
        this.renderTooltipBody(data, heading)
      );
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          className = _props.className,
          direction = _props.direction,
          heading = _props.heading,
          isActive = _props.isActive,
          data = _props.data,
          hasSections = _props.hasSections,
          other = _objectWithoutProperties(_props, ['className', 'direction', 'heading', 'isActive', 'data', 'hasSections']);

      return React.createElement(
        'div',
        _extends({
          className: this.getTootlTipClasses(isActive, className),
          'data-floating-menu-direction': direction
        }, other),
        hasSections ? this.renderAllSections(data, heading) : this.renderDefault(data, heading)
      );
    }
  }]);

  return DataTooltip;
}(Component);

DataTooltip.propTypes = propTypes;
DataTooltip.defaultProps = defaultProps;

export default DataTooltip;