// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package siterecovery

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/recoveryservices/mgmt/2018-01-10/siterecovery"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type A2ARpRecoveryPointType = original.A2ARpRecoveryPointType

const (
	Latest                      A2ARpRecoveryPointType = original.Latest
	LatestApplicationConsistent A2ARpRecoveryPointType = original.LatestApplicationConsistent
	LatestCrashConsistent       A2ARpRecoveryPointType = original.LatestCrashConsistent
	LatestProcessed             A2ARpRecoveryPointType = original.LatestProcessed
)

type AgentAutoUpdateStatus = original.AgentAutoUpdateStatus

const (
	Disabled AgentAutoUpdateStatus = original.Disabled
	Enabled  AgentAutoUpdateStatus = original.Enabled
)

type AgentVersionStatus = original.AgentVersionStatus

const (
	Deprecated             AgentVersionStatus = original.Deprecated
	NotSupported           AgentVersionStatus = original.NotSupported
	SecurityUpdateRequired AgentVersionStatus = original.SecurityUpdateRequired
	Supported              AgentVersionStatus = original.Supported
	UpdateRequired         AgentVersionStatus = original.UpdateRequired
)

type AlternateLocationRecoveryOption = original.AlternateLocationRecoveryOption

const (
	CreateVMIfNotFound AlternateLocationRecoveryOption = original.CreateVMIfNotFound
	NoAction           AlternateLocationRecoveryOption = original.NoAction
)

type DataSyncStatus = original.DataSyncStatus

const (
	ForDownTime        DataSyncStatus = original.ForDownTime
	ForSynchronization DataSyncStatus = original.ForSynchronization
)

type DisableProtectionReason = original.DisableProtectionReason

const (
	MigrationComplete DisableProtectionReason = original.MigrationComplete
	NotSpecified      DisableProtectionReason = original.NotSpecified
)

type FailoverDeploymentModel = original.FailoverDeploymentModel

const (
	Classic         FailoverDeploymentModel = original.Classic
	NotApplicable   FailoverDeploymentModel = original.NotApplicable
	ResourceManager FailoverDeploymentModel = original.ResourceManager
)

type HealthErrorCategory = original.HealthErrorCategory

const (
	AgentAutoUpdate      HealthErrorCategory = original.AgentAutoUpdate
	Configuration        HealthErrorCategory = original.Configuration
	FabricInfrastructure HealthErrorCategory = original.FabricInfrastructure
	None                 HealthErrorCategory = original.None
	Replication          HealthErrorCategory = original.Replication
	TestFailover         HealthErrorCategory = original.TestFailover
	VersionExpiry        HealthErrorCategory = original.VersionExpiry
)

type HyperVReplicaAzureRpRecoveryPointType = original.HyperVReplicaAzureRpRecoveryPointType

const (
	HyperVReplicaAzureRpRecoveryPointTypeLatest                      HyperVReplicaAzureRpRecoveryPointType = original.HyperVReplicaAzureRpRecoveryPointTypeLatest
	HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent HyperVReplicaAzureRpRecoveryPointType = original.HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent
	HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed             HyperVReplicaAzureRpRecoveryPointType = original.HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed
)

type IdentityProviderType = original.IdentityProviderType

const (
	RecoveryServicesActiveDirectory IdentityProviderType = original.RecoveryServicesActiveDirectory
)

type InMageV2RpRecoveryPointType = original.InMageV2RpRecoveryPointType

const (
	InMageV2RpRecoveryPointTypeLatest                      InMageV2RpRecoveryPointType = original.InMageV2RpRecoveryPointTypeLatest
	InMageV2RpRecoveryPointTypeLatestApplicationConsistent InMageV2RpRecoveryPointType = original.InMageV2RpRecoveryPointTypeLatestApplicationConsistent
	InMageV2RpRecoveryPointTypeLatestCrashConsistent       InMageV2RpRecoveryPointType = original.InMageV2RpRecoveryPointTypeLatestCrashConsistent
	InMageV2RpRecoveryPointTypeLatestProcessed             InMageV2RpRecoveryPointType = original.InMageV2RpRecoveryPointTypeLatestProcessed
)

type InstanceType = original.InstanceType

const (
	InstanceTypeA2A                                     InstanceType = original.InstanceTypeA2A
	InstanceTypeApplyRecoveryPointProviderSpecificInput InstanceType = original.InstanceTypeApplyRecoveryPointProviderSpecificInput
	InstanceTypeHyperVReplicaAzure                      InstanceType = original.InstanceTypeHyperVReplicaAzure
	InstanceTypeInMageAzureV2                           InstanceType = original.InstanceTypeInMageAzureV2
)

type InstanceTypeBasicConfigurationSettings = original.InstanceTypeBasicConfigurationSettings

const (
	InstanceTypeConfigurationSettings   InstanceTypeBasicConfigurationSettings = original.InstanceTypeConfigurationSettings
	InstanceTypeHyperVVirtualMachine    InstanceTypeBasicConfigurationSettings = original.InstanceTypeHyperVVirtualMachine
	InstanceTypeReplicationGroupDetails InstanceTypeBasicConfigurationSettings = original.InstanceTypeReplicationGroupDetails
	InstanceTypeVmmVirtualMachine       InstanceTypeBasicConfigurationSettings = original.InstanceTypeVmmVirtualMachine
	InstanceTypeVMwareVirtualMachine    InstanceTypeBasicConfigurationSettings = original.InstanceTypeVMwareVirtualMachine
)

type InstanceTypeBasicDisableProtectionProviderSpecificInput = original.InstanceTypeBasicDisableProtectionProviderSpecificInput

const (
	InstanceTypeDisableProtectionProviderSpecificInput InstanceTypeBasicDisableProtectionProviderSpecificInput = original.InstanceTypeDisableProtectionProviderSpecificInput
	InstanceTypeInMage                                 InstanceTypeBasicDisableProtectionProviderSpecificInput = original.InstanceTypeInMage
)

type InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInput

const (
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A                                   InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure                    InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage                                InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2                         InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan                                   InstanceTypeBasicEnableProtectionProviderSpecificInput = original.InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan
)

type InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetails

const (
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A                           InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeA2A
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails  InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeEventProviderSpecificDetails
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012             InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2           InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplica2012R2
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure            InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeHyperVReplicaBaseEventDetails
	InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2                 InstanceTypeBasicEventProviderSpecificDetails = original.InstanceTypeBasicEventProviderSpecificDetailsInstanceTypeInMageAzureV2
)

type InstanceTypeBasicEventSpecificDetails = original.InstanceTypeBasicEventSpecificDetails

const (
	InstanceTypeEventSpecificDetails InstanceTypeBasicEventSpecificDetails = original.InstanceTypeEventSpecificDetails
	InstanceTypeJobStatus            InstanceTypeBasicEventSpecificDetails = original.InstanceTypeJobStatus
)

type InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificCreateNetworkMappingInput

const (
	InstanceTypeAzureToAzure                            InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = original.InstanceTypeAzureToAzure
	InstanceTypeFabricSpecificCreateNetworkMappingInput InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = original.InstanceTypeFabricSpecificCreateNetworkMappingInput
	InstanceTypeVmmToAzure                              InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = original.InstanceTypeVmmToAzure
	InstanceTypeVmmToVmm                                InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = original.InstanceTypeVmmToVmm
)

type InstanceTypeBasicFabricSpecificCreationInput = original.InstanceTypeBasicFabricSpecificCreationInput

const (
	InstanceTypeAzure                       InstanceTypeBasicFabricSpecificCreationInput = original.InstanceTypeAzure
	InstanceTypeFabricSpecificCreationInput InstanceTypeBasicFabricSpecificCreationInput = original.InstanceTypeFabricSpecificCreationInput
	InstanceTypeVMwareV2                    InstanceTypeBasicFabricSpecificCreationInput = original.InstanceTypeVMwareV2
)

type InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetails

const (
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure                 InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite            InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM                   InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware                InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2              InstanceTypeBasicFabricSpecificDetails = original.InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2
)

type InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput

const (
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure                            InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure                              InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm                                InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = original.InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm
)

type InstanceTypeBasicGroupTaskDetails = original.InstanceTypeBasicGroupTaskDetails

const (
	InstanceTypeGroupTaskDetails                     InstanceTypeBasicGroupTaskDetails = original.InstanceTypeGroupTaskDetails
	InstanceTypeInlineWorkflowTaskDetails            InstanceTypeBasicGroupTaskDetails = original.InstanceTypeInlineWorkflowTaskDetails
	InstanceTypeRecoveryPlanGroupTaskDetails         InstanceTypeBasicGroupTaskDetails = original.InstanceTypeRecoveryPlanGroupTaskDetails
	InstanceTypeRecoveryPlanShutdownGroupTaskDetails InstanceTypeBasicGroupTaskDetails = original.InstanceTypeRecoveryPlanShutdownGroupTaskDetails
)

type InstanceTypeBasicJobDetails = original.InstanceTypeBasicJobDetails

const (
	InstanceTypeAsrJobDetails              InstanceTypeBasicJobDetails = original.InstanceTypeAsrJobDetails
	InstanceTypeExportJobDetails           InstanceTypeBasicJobDetails = original.InstanceTypeExportJobDetails
	InstanceTypeFailoverJobDetails         InstanceTypeBasicJobDetails = original.InstanceTypeFailoverJobDetails
	InstanceTypeJobDetails                 InstanceTypeBasicJobDetails = original.InstanceTypeJobDetails
	InstanceTypeSwitchProtectionJobDetails InstanceTypeBasicJobDetails = original.InstanceTypeSwitchProtectionJobDetails
	InstanceTypeTestFailoverJobDetails     InstanceTypeBasicJobDetails = original.InstanceTypeTestFailoverJobDetails
)

type InstanceTypeBasicNetworkMappingFabricSpecificSettings = original.InstanceTypeBasicNetworkMappingFabricSpecificSettings

const (
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure                         InstanceTypeBasicNetworkMappingFabricSpecificSettings = original.InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings InstanceTypeBasicNetworkMappingFabricSpecificSettings = original.InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure                           InstanceTypeBasicNetworkMappingFabricSpecificSettings = original.InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm                             InstanceTypeBasicNetworkMappingFabricSpecificSettings = original.InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm
)

type InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetails

const (
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A                            InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012              InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2            InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure             InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage                         InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2                  InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails        InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails  InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration              InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt                      InstanceTypeBasicPolicyProviderSpecificDetails = original.InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt
)

type InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInput

const (
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A                         InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012           InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2         InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure          InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage                      InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2               InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt                   InstanceTypeBasicPolicyProviderSpecificInput = original.InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt
)

type InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails = original.InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails

const (
	InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeA2A                                               InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails = original.InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeA2A
	InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeProtectionContainerMappingProviderSpecificDetails InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails = original.InstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsInstanceTypeProtectionContainerMappingProviderSpecificDetails
)

type InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInput

const (
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A                           InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure            InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback    InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage                        InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2                 InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput InstanceTypeBasicProviderSpecificFailoverInput = original.InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput
)

type InstanceTypeBasicProviderSpecificRecoveryPointDetails = original.InstanceTypeBasicProviderSpecificRecoveryPointDetails

const (
	InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeA2A                                  InstanceTypeBasicProviderSpecificRecoveryPointDetails = original.InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeA2A
	InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageAzureV2                        InstanceTypeBasicProviderSpecificRecoveryPointDetails = original.InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeInMageAzureV2
	InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeProviderSpecificRecoveryPointDetails InstanceTypeBasicProviderSpecificRecoveryPointDetails = original.InstanceTypeBasicProviderSpecificRecoveryPointDetailsInstanceTypeProviderSpecificRecoveryPointDetails
)

type InstanceTypeBasicRecoveryPlanActionDetails = original.InstanceTypeBasicRecoveryPlanActionDetails

const (
	InstanceTypeAutomationRunbookActionDetails InstanceTypeBasicRecoveryPlanActionDetails = original.InstanceTypeAutomationRunbookActionDetails
	InstanceTypeManualActionDetails            InstanceTypeBasicRecoveryPlanActionDetails = original.InstanceTypeManualActionDetails
	InstanceTypeRecoveryPlanActionDetails      InstanceTypeBasicRecoveryPlanActionDetails = original.InstanceTypeRecoveryPlanActionDetails
	InstanceTypeScriptActionDetails            InstanceTypeBasicRecoveryPlanActionDetails = original.InstanceTypeScriptActionDetails
)

type InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput

const (
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A                                       InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure                        InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback                InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage                                    InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2                             InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = original.InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput
)

type InstanceTypeBasicReplicationProviderSpecificContainerCreationInput = original.InstanceTypeBasicReplicationProviderSpecificContainerCreationInput

const (
	InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A                                               InstanceTypeBasicReplicationProviderSpecificContainerCreationInput = original.InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A
	InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput InstanceTypeBasicReplicationProviderSpecificContainerCreationInput = original.InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput
)

type InstanceTypeBasicReplicationProviderSpecificContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificContainerMappingInput

const (
	InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeA2A                                              InstanceTypeBasicReplicationProviderSpecificContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeA2A
	InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeReplicationProviderSpecificContainerMappingInput InstanceTypeBasicReplicationProviderSpecificContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificContainerMappingInputInstanceTypeReplicationProviderSpecificContainerMappingInput
)

type InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettings

const (
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A                                 InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012                   InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2                 InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure                  InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage                              InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2                       InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings InstanceTypeBasicReplicationProviderSpecificSettings = original.InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings
)

type InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInput

const (
	InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputInstanceTypeA2A                                                    InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputInstanceTypeA2A
	InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputInstanceTypeReplicationProviderSpecificUpdateContainerMappingInput InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInput = original.InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputInstanceTypeReplicationProviderSpecificUpdateContainerMappingInput
)

type InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInput

const (
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A                                     InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure                      InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage                                  InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2                           InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput InstanceTypeBasicReverseReplicationProviderSpecificInput = original.InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput
)

type InstanceTypeBasicSwitchProtectionProviderSpecificInput = original.InstanceTypeBasicSwitchProtectionProviderSpecificInput

const (
	InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A                                   InstanceTypeBasicSwitchProtectionProviderSpecificInput = original.InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A
	InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput InstanceTypeBasicSwitchProtectionProviderSpecificInput = original.InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput
)

type InstanceTypeBasicTaskTypeDetails = original.InstanceTypeBasicTaskTypeDetails

const (
	InstanceTypeAutomationRunbookTaskDetails      InstanceTypeBasicTaskTypeDetails = original.InstanceTypeAutomationRunbookTaskDetails
	InstanceTypeConsistencyCheckTaskDetails       InstanceTypeBasicTaskTypeDetails = original.InstanceTypeConsistencyCheckTaskDetails
	InstanceTypeFabricReplicationGroupTaskDetails InstanceTypeBasicTaskTypeDetails = original.InstanceTypeFabricReplicationGroupTaskDetails
	InstanceTypeJobTaskDetails                    InstanceTypeBasicTaskTypeDetails = original.InstanceTypeJobTaskDetails
	InstanceTypeManualActionTaskDetails           InstanceTypeBasicTaskTypeDetails = original.InstanceTypeManualActionTaskDetails
	InstanceTypeScriptActionTaskDetails           InstanceTypeBasicTaskTypeDetails = original.InstanceTypeScriptActionTaskDetails
	InstanceTypeTaskTypeDetails                   InstanceTypeBasicTaskTypeDetails = original.InstanceTypeTaskTypeDetails
	InstanceTypeVirtualMachineTaskDetails         InstanceTypeBasicTaskTypeDetails = original.InstanceTypeVirtualMachineTaskDetails
	InstanceTypeVMNicUpdatesTaskDetails           InstanceTypeBasicTaskTypeDetails = original.InstanceTypeVMNicUpdatesTaskDetails
)

type InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = original.InstanceTypeBasicUpdateReplicationProtectedItemProviderInput

const (
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A                                         InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = original.InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure                          InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = original.InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2                               InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = original.InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = original.InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput
)

type LicenseType = original.LicenseType

const (
	LicenseTypeNoLicenseType LicenseType = original.LicenseTypeNoLicenseType
	LicenseTypeNotSpecified  LicenseType = original.LicenseTypeNotSpecified
	LicenseTypeWindowsServer LicenseType = original.LicenseTypeWindowsServer
)

type MultiVMGroupCreateOption = original.MultiVMGroupCreateOption

const (
	AutoCreated   MultiVMGroupCreateOption = original.AutoCreated
	UserSpecified MultiVMGroupCreateOption = original.UserSpecified
)

type MultiVMSyncPointOption = original.MultiVMSyncPointOption

const (
	UseMultiVMSyncRecoveryPoint MultiVMSyncPointOption = original.UseMultiVMSyncRecoveryPoint
	UsePerVMRecoveryPoint       MultiVMSyncPointOption = original.UsePerVMRecoveryPoint
)

type MultiVMSyncStatus = original.MultiVMSyncStatus

const (
	MultiVMSyncStatusDisabled MultiVMSyncStatus = original.MultiVMSyncStatusDisabled
	MultiVMSyncStatusEnabled  MultiVMSyncStatus = original.MultiVMSyncStatusEnabled
)

type PossibleOperationsDirections = original.PossibleOperationsDirections

const (
	PrimaryToRecovery PossibleOperationsDirections = original.PrimaryToRecovery
	RecoveryToPrimary PossibleOperationsDirections = original.RecoveryToPrimary
)

type PresenceStatus = original.PresenceStatus

const (
	NotPresent PresenceStatus = original.NotPresent
	Present    PresenceStatus = original.Present
	Unknown    PresenceStatus = original.Unknown
)

type RecoveryPlanActionLocation = original.RecoveryPlanActionLocation

const (
	Primary  RecoveryPlanActionLocation = original.Primary
	Recovery RecoveryPlanActionLocation = original.Recovery
)

type RecoveryPlanGroupType = original.RecoveryPlanGroupType

const (
	Boot     RecoveryPlanGroupType = original.Boot
	Failover RecoveryPlanGroupType = original.Failover
	Shutdown RecoveryPlanGroupType = original.Shutdown
)

type RecoveryPointSyncType = original.RecoveryPointSyncType

const (
	MultiVMSyncRecoveryPoint RecoveryPointSyncType = original.MultiVMSyncRecoveryPoint
	PerVMRecoveryPoint       RecoveryPointSyncType = original.PerVMRecoveryPoint
)

type RecoveryPointType = original.RecoveryPointType

const (
	Custom     RecoveryPointType = original.Custom
	LatestTag  RecoveryPointType = original.LatestTag
	LatestTime RecoveryPointType = original.LatestTime
)

type ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperation

const (
	ReplicationProtectedItemOperationChangePit           ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationChangePit
	ReplicationProtectedItemOperationCommit              ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationCommit
	ReplicationProtectedItemOperationCompleteMigration   ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationCompleteMigration
	ReplicationProtectedItemOperationDisableProtection   ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationDisableProtection
	ReplicationProtectedItemOperationFailback            ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationFailback
	ReplicationProtectedItemOperationFinalizeFailback    ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationFinalizeFailback
	ReplicationProtectedItemOperationPlannedFailover     ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationPlannedFailover
	ReplicationProtectedItemOperationRepairReplication   ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationRepairReplication
	ReplicationProtectedItemOperationReverseReplicate    ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationReverseReplicate
	ReplicationProtectedItemOperationSwitchProtection    ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationSwitchProtection
	ReplicationProtectedItemOperationTestFailover        ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationTestFailover
	ReplicationProtectedItemOperationTestFailoverCleanup ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationTestFailoverCleanup
	ReplicationProtectedItemOperationUnplannedFailover   ReplicationProtectedItemOperation = original.ReplicationProtectedItemOperationUnplannedFailover
)

type RpInMageRecoveryPointType = original.RpInMageRecoveryPointType

const (
	RpInMageRecoveryPointTypeCustom     RpInMageRecoveryPointType = original.RpInMageRecoveryPointTypeCustom
	RpInMageRecoveryPointTypeLatestTag  RpInMageRecoveryPointType = original.RpInMageRecoveryPointTypeLatestTag
	RpInMageRecoveryPointTypeLatestTime RpInMageRecoveryPointType = original.RpInMageRecoveryPointTypeLatestTime
)

type SetMultiVMSyncStatus = original.SetMultiVMSyncStatus

const (
	Disable SetMultiVMSyncStatus = original.Disable
	Enable  SetMultiVMSyncStatus = original.Enable
)

type Severity = original.Severity

const (
	Error   Severity = original.Error
	Info    Severity = original.Info
	NONE    Severity = original.NONE
	Warning Severity = original.Warning
)

type SourceSiteOperations = original.SourceSiteOperations

const (
	NotRequired SourceSiteOperations = original.NotRequired
	Required    SourceSiteOperations = original.Required
)

type A2AApplyRecoveryPointInput = original.A2AApplyRecoveryPointInput
type A2AContainerCreationInput = original.A2AContainerCreationInput
type A2AContainerMappingInput = original.A2AContainerMappingInput
type A2AEnableProtectionInput = original.A2AEnableProtectionInput
type A2AEventDetails = original.A2AEventDetails
type A2AFailoverProviderInput = original.A2AFailoverProviderInput
type A2APolicyCreationInput = original.A2APolicyCreationInput
type A2APolicyDetails = original.A2APolicyDetails
type A2AProtectedDiskDetails = original.A2AProtectedDiskDetails
type A2AProtectedManagedDiskDetails = original.A2AProtectedManagedDiskDetails
type A2AProtectionContainerMappingDetails = original.A2AProtectionContainerMappingDetails
type A2ARecoveryPointDetails = original.A2ARecoveryPointDetails
type A2AReplicationDetails = original.A2AReplicationDetails
type A2AReprotectInput = original.A2AReprotectInput
type A2ASwitchProtectionInput = original.A2ASwitchProtectionInput
type A2AUpdateContainerMappingInput = original.A2AUpdateContainerMappingInput
type A2AUpdateReplicationProtectedItemInput = original.A2AUpdateReplicationProtectedItemInput
type A2AVMDiskInputDetails = original.A2AVMDiskInputDetails
type A2AVMManagedDiskInputDetails = original.A2AVMManagedDiskInputDetails
type A2AVMManagedDiskUpdateDetails = original.A2AVMManagedDiskUpdateDetails
type AddVCenterRequest = original.AddVCenterRequest
type AddVCenterRequestProperties = original.AddVCenterRequestProperties
type Alert = original.Alert
type AlertCollection = original.AlertCollection
type AlertCollectionIterator = original.AlertCollectionIterator
type AlertCollectionPage = original.AlertCollectionPage
type AlertProperties = original.AlertProperties
type ApplyRecoveryPointInput = original.ApplyRecoveryPointInput
type ApplyRecoveryPointInputProperties = original.ApplyRecoveryPointInputProperties
type BasicApplyRecoveryPointProviderSpecificInput = original.BasicApplyRecoveryPointProviderSpecificInput
type ApplyRecoveryPointProviderSpecificInput = original.ApplyRecoveryPointProviderSpecificInput
type AsrJobDetails = original.AsrJobDetails
type ASRTask = original.ASRTask
type AutomationRunbookTaskDetails = original.AutomationRunbookTaskDetails
type AzureFabricCreationInput = original.AzureFabricCreationInput
type AzureFabricSpecificDetails = original.AzureFabricSpecificDetails
type AzureToAzureCreateNetworkMappingInput = original.AzureToAzureCreateNetworkMappingInput
type AzureToAzureNetworkMappingSettings = original.AzureToAzureNetworkMappingSettings
type AzureToAzureUpdateNetworkMappingInput = original.AzureToAzureUpdateNetworkMappingInput
type AzureToAzureVMSyncedConfigDetails = original.AzureToAzureVMSyncedConfigDetails
type AzureVMDiskDetails = original.AzureVMDiskDetails
type ComputeSizeErrorDetails = original.ComputeSizeErrorDetails
type BasicConfigurationSettings = original.BasicConfigurationSettings
type ConfigurationSettings = original.ConfigurationSettings
type ConfigureAlertRequest = original.ConfigureAlertRequest
type ConfigureAlertRequestProperties = original.ConfigureAlertRequestProperties
type ConsistencyCheckTaskDetails = original.ConsistencyCheckTaskDetails
type CreateNetworkMappingInput = original.CreateNetworkMappingInput
type CreateNetworkMappingInputProperties = original.CreateNetworkMappingInputProperties
type CreatePolicyInput = original.CreatePolicyInput
type CreatePolicyInputProperties = original.CreatePolicyInputProperties
type CreateProtectionContainerInput = original.CreateProtectionContainerInput
type CreateProtectionContainerInputProperties = original.CreateProtectionContainerInputProperties
type CreateProtectionContainerMappingInput = original.CreateProtectionContainerMappingInput
type CreateProtectionContainerMappingInputProperties = original.CreateProtectionContainerMappingInputProperties
type CreateRecoveryPlanInput = original.CreateRecoveryPlanInput
type CreateRecoveryPlanInputProperties = original.CreateRecoveryPlanInputProperties
type CurrentScenarioDetails = original.CurrentScenarioDetails
type DataStore = original.DataStore
type DisableProtectionInput = original.DisableProtectionInput
type DisableProtectionInputProperties = original.DisableProtectionInputProperties
type BasicDisableProtectionProviderSpecificInput = original.BasicDisableProtectionProviderSpecificInput
type DisableProtectionProviderSpecificInput = original.DisableProtectionProviderSpecificInput
type DiscoverProtectableItemRequest = original.DiscoverProtectableItemRequest
type DiscoverProtectableItemRequestProperties = original.DiscoverProtectableItemRequestProperties
type DiskDetails = original.DiskDetails
type DiskEncryptionInfo = original.DiskEncryptionInfo
type DiskEncryptionKeyInfo = original.DiskEncryptionKeyInfo
type DiskVolumeDetails = original.DiskVolumeDetails
type Display = original.Display
type EnableProtectionInput = original.EnableProtectionInput
type EnableProtectionInputProperties = original.EnableProtectionInputProperties
type BasicEnableProtectionProviderSpecificInput = original.BasicEnableProtectionProviderSpecificInput
type EnableProtectionProviderSpecificInput = original.EnableProtectionProviderSpecificInput
type EncryptionDetails = original.EncryptionDetails
type Event = original.Event
type EventCollection = original.EventCollection
type EventCollectionIterator = original.EventCollectionIterator
type EventCollectionPage = original.EventCollectionPage
type EventProperties = original.EventProperties
type BasicEventProviderSpecificDetails = original.BasicEventProviderSpecificDetails
type EventProviderSpecificDetails = original.EventProviderSpecificDetails
type EventQueryParameter = original.EventQueryParameter
type BasicEventSpecificDetails = original.BasicEventSpecificDetails
type EventSpecificDetails = original.EventSpecificDetails
type ExportJobDetails = original.ExportJobDetails
type Fabric = original.Fabric
type FabricCollection = original.FabricCollection
type FabricCollectionIterator = original.FabricCollectionIterator
type FabricCollectionPage = original.FabricCollectionPage
type FabricCreationInput = original.FabricCreationInput
type FabricCreationInputProperties = original.FabricCreationInputProperties
type FabricProperties = original.FabricProperties
type FabricReplicationGroupTaskDetails = original.FabricReplicationGroupTaskDetails
type BasicFabricSpecificCreateNetworkMappingInput = original.BasicFabricSpecificCreateNetworkMappingInput
type FabricSpecificCreateNetworkMappingInput = original.FabricSpecificCreateNetworkMappingInput
type BasicFabricSpecificCreationInput = original.BasicFabricSpecificCreationInput
type FabricSpecificCreationInput = original.FabricSpecificCreationInput
type BasicFabricSpecificDetails = original.BasicFabricSpecificDetails
type FabricSpecificDetails = original.FabricSpecificDetails
type BasicFabricSpecificUpdateNetworkMappingInput = original.BasicFabricSpecificUpdateNetworkMappingInput
type FabricSpecificUpdateNetworkMappingInput = original.FabricSpecificUpdateNetworkMappingInput
type FailoverJobDetails = original.FailoverJobDetails
type FailoverProcessServerRequest = original.FailoverProcessServerRequest
type FailoverProcessServerRequestProperties = original.FailoverProcessServerRequestProperties
type FailoverReplicationProtectedItemDetails = original.FailoverReplicationProtectedItemDetails
type BasicGroupTaskDetails = original.BasicGroupTaskDetails
type GroupTaskDetails = original.GroupTaskDetails
type HealthError = original.HealthError
type HealthErrorSummary = original.HealthErrorSummary
type HyperVReplica2012EventDetails = original.HyperVReplica2012EventDetails
type HyperVReplica2012R2EventDetails = original.HyperVReplica2012R2EventDetails
type HyperVReplicaAzureApplyRecoveryPointInput = original.HyperVReplicaAzureApplyRecoveryPointInput
type HyperVReplicaAzureEnableProtectionInput = original.HyperVReplicaAzureEnableProtectionInput
type HyperVReplicaAzureEventDetails = original.HyperVReplicaAzureEventDetails
type HyperVReplicaAzureFailbackProviderInput = original.HyperVReplicaAzureFailbackProviderInput
type HyperVReplicaAzureFailoverProviderInput = original.HyperVReplicaAzureFailoverProviderInput
type HyperVReplicaAzurePolicyDetails = original.HyperVReplicaAzurePolicyDetails
type HyperVReplicaAzurePolicyInput = original.HyperVReplicaAzurePolicyInput
type HyperVReplicaAzureReplicationDetails = original.HyperVReplicaAzureReplicationDetails
type HyperVReplicaAzureReprotectInput = original.HyperVReplicaAzureReprotectInput
type HyperVReplicaAzureUpdateReplicationProtectedItemInput = original.HyperVReplicaAzureUpdateReplicationProtectedItemInput
type HyperVReplicaBaseEventDetails = original.HyperVReplicaBaseEventDetails
type HyperVReplicaBasePolicyDetails = original.HyperVReplicaBasePolicyDetails
type HyperVReplicaBaseReplicationDetails = original.HyperVReplicaBaseReplicationDetails
type HyperVReplicaBluePolicyDetails = original.HyperVReplicaBluePolicyDetails
type HyperVReplicaBluePolicyInput = original.HyperVReplicaBluePolicyInput
type HyperVReplicaBlueReplicationDetails = original.HyperVReplicaBlueReplicationDetails
type HyperVReplicaPolicyDetails = original.HyperVReplicaPolicyDetails
type HyperVReplicaPolicyInput = original.HyperVReplicaPolicyInput
type HyperVReplicaReplicationDetails = original.HyperVReplicaReplicationDetails
type HyperVSiteDetails = original.HyperVSiteDetails
type HyperVVirtualMachineDetails = original.HyperVVirtualMachineDetails
type IdentityInformation = original.IdentityInformation
type InconsistentVMDetails = original.InconsistentVMDetails
type InitialReplicationDetails = original.InitialReplicationDetails
type InlineWorkflowTaskDetails = original.InlineWorkflowTaskDetails
type InMageAgentDetails = original.InMageAgentDetails
type InMageAgentVersionDetails = original.InMageAgentVersionDetails
type InMageAzureV2ApplyRecoveryPointInput = original.InMageAzureV2ApplyRecoveryPointInput
type InMageAzureV2EnableProtectionInput = original.InMageAzureV2EnableProtectionInput
type InMageAzureV2EventDetails = original.InMageAzureV2EventDetails
type InMageAzureV2FailoverProviderInput = original.InMageAzureV2FailoverProviderInput
type InMageAzureV2PolicyDetails = original.InMageAzureV2PolicyDetails
type InMageAzureV2PolicyInput = original.InMageAzureV2PolicyInput
type InMageAzureV2ProtectedDiskDetails = original.InMageAzureV2ProtectedDiskDetails
type InMageAzureV2RecoveryPointDetails = original.InMageAzureV2RecoveryPointDetails
type InMageAzureV2ReplicationDetails = original.InMageAzureV2ReplicationDetails
type InMageAzureV2ReprotectInput = original.InMageAzureV2ReprotectInput
type InMageAzureV2UpdateReplicationProtectedItemInput = original.InMageAzureV2UpdateReplicationProtectedItemInput
type InMageBasePolicyDetails = original.InMageBasePolicyDetails
type InMageDisableProtectionProviderSpecificInput = original.InMageDisableProtectionProviderSpecificInput
type InMageDiskDetails = original.InMageDiskDetails
type InMageDiskExclusionInput = original.InMageDiskExclusionInput
type InMageDiskSignatureExclusionOptions = original.InMageDiskSignatureExclusionOptions
type InMageEnableProtectionInput = original.InMageEnableProtectionInput
type InMageFailoverProviderInput = original.InMageFailoverProviderInput
type InMagePolicyDetails = original.InMagePolicyDetails
type InMagePolicyInput = original.InMagePolicyInput
type InMageProtectedDiskDetails = original.InMageProtectedDiskDetails
type InMageReplicationDetails = original.InMageReplicationDetails
type InMageReprotectInput = original.InMageReprotectInput
type InMageVolumeExclusionOptions = original.InMageVolumeExclusionOptions
type InnerHealthError = original.InnerHealthError
type InputEndpoint = original.InputEndpoint
type Job = original.Job
type JobCollection = original.JobCollection
type JobCollectionIterator = original.JobCollectionIterator
type JobCollectionPage = original.JobCollectionPage
type BasicJobDetails = original.BasicJobDetails
type JobDetails = original.JobDetails
type JobEntity = original.JobEntity
type JobErrorDetails = original.JobErrorDetails
type JobProperties = original.JobProperties
type JobQueryParameter = original.JobQueryParameter
type JobStatusEventDetails = original.JobStatusEventDetails
type JobTaskDetails = original.JobTaskDetails
type KeyEncryptionKeyInfo = original.KeyEncryptionKeyInfo
type LogicalNetwork = original.LogicalNetwork
type LogicalNetworkCollection = original.LogicalNetworkCollection
type LogicalNetworkCollectionIterator = original.LogicalNetworkCollectionIterator
type LogicalNetworkCollectionPage = original.LogicalNetworkCollectionPage
type LogicalNetworkProperties = original.LogicalNetworkProperties
type ManualActionTaskDetails = original.ManualActionTaskDetails
type MasterTargetServer = original.MasterTargetServer
type MobilityServiceUpdate = original.MobilityServiceUpdate
type Network = original.Network
type NetworkCollection = original.NetworkCollection
type NetworkCollectionIterator = original.NetworkCollectionIterator
type NetworkCollectionPage = original.NetworkCollectionPage
type NetworkMapping = original.NetworkMapping
type NetworkMappingCollection = original.NetworkMappingCollection
type NetworkMappingCollectionIterator = original.NetworkMappingCollectionIterator
type NetworkMappingCollectionPage = original.NetworkMappingCollectionPage
type BasicNetworkMappingFabricSpecificSettings = original.BasicNetworkMappingFabricSpecificSettings
type NetworkMappingFabricSpecificSettings = original.NetworkMappingFabricSpecificSettings
type NetworkMappingProperties = original.NetworkMappingProperties
type NetworkProperties = original.NetworkProperties
type OperationsDiscovery = original.OperationsDiscovery
type OperationsDiscoveryCollection = original.OperationsDiscoveryCollection
type OperationsDiscoveryCollectionIterator = original.OperationsDiscoveryCollectionIterator
type OperationsDiscoveryCollectionPage = original.OperationsDiscoveryCollectionPage
type OSDetails = original.OSDetails
type OSDiskDetails = original.OSDiskDetails
type PlannedFailoverInput = original.PlannedFailoverInput
type PlannedFailoverInputProperties = original.PlannedFailoverInputProperties
type Policy = original.Policy
type PolicyCollection = original.PolicyCollection
type PolicyCollectionIterator = original.PolicyCollectionIterator
type PolicyCollectionPage = original.PolicyCollectionPage
type PolicyProperties = original.PolicyProperties
type BasicPolicyProviderSpecificDetails = original.BasicPolicyProviderSpecificDetails
type PolicyProviderSpecificDetails = original.PolicyProviderSpecificDetails
type BasicPolicyProviderSpecificInput = original.BasicPolicyProviderSpecificInput
type PolicyProviderSpecificInput = original.PolicyProviderSpecificInput
type ProcessServer = original.ProcessServer
type ProtectableItem = original.ProtectableItem
type ProtectableItemCollection = original.ProtectableItemCollection
type ProtectableItemCollectionIterator = original.ProtectableItemCollectionIterator
type ProtectableItemCollectionPage = original.ProtectableItemCollectionPage
type ProtectableItemProperties = original.ProtectableItemProperties
type ProtectableItemQueryParameter = original.ProtectableItemQueryParameter
type ProtectedItemsQueryParameter = original.ProtectedItemsQueryParameter
type ProtectionContainer = original.ProtectionContainer
type ProtectionContainerCollection = original.ProtectionContainerCollection
type ProtectionContainerCollectionIterator = original.ProtectionContainerCollectionIterator
type ProtectionContainerCollectionPage = original.ProtectionContainerCollectionPage
type ProtectionContainerFabricSpecificDetails = original.ProtectionContainerFabricSpecificDetails
type ProtectionContainerMapping = original.ProtectionContainerMapping
type ProtectionContainerMappingCollection = original.ProtectionContainerMappingCollection
type ProtectionContainerMappingCollectionIterator = original.ProtectionContainerMappingCollectionIterator
type ProtectionContainerMappingCollectionPage = original.ProtectionContainerMappingCollectionPage
type ProtectionContainerMappingProperties = original.ProtectionContainerMappingProperties
type BasicProtectionContainerMappingProviderSpecificDetails = original.BasicProtectionContainerMappingProviderSpecificDetails
type ProtectionContainerMappingProviderSpecificDetails = original.ProtectionContainerMappingProviderSpecificDetails
type ProtectionContainerProperties = original.ProtectionContainerProperties
type ProviderError = original.ProviderError
type BasicProviderSpecificFailoverInput = original.BasicProviderSpecificFailoverInput
type ProviderSpecificFailoverInput = original.ProviderSpecificFailoverInput
type BasicProviderSpecificRecoveryPointDetails = original.BasicProviderSpecificRecoveryPointDetails
type ProviderSpecificRecoveryPointDetails = original.ProviderSpecificRecoveryPointDetails
type RcmAzureMigrationPolicyDetails = original.RcmAzureMigrationPolicyDetails
type RecoveryPlan = original.RecoveryPlan
type RecoveryPlanA2AFailoverInput = original.RecoveryPlanA2AFailoverInput
type RecoveryPlanAction = original.RecoveryPlanAction
type BasicRecoveryPlanActionDetails = original.BasicRecoveryPlanActionDetails
type RecoveryPlanActionDetails = original.RecoveryPlanActionDetails
type RecoveryPlanAutomationRunbookActionDetails = original.RecoveryPlanAutomationRunbookActionDetails
type RecoveryPlanCollection = original.RecoveryPlanCollection
type RecoveryPlanCollectionIterator = original.RecoveryPlanCollectionIterator
type RecoveryPlanCollectionPage = original.RecoveryPlanCollectionPage
type RecoveryPlanGroup = original.RecoveryPlanGroup
type RecoveryPlanGroupTaskDetails = original.RecoveryPlanGroupTaskDetails
type RecoveryPlanHyperVReplicaAzureFailbackInput = original.RecoveryPlanHyperVReplicaAzureFailbackInput
type RecoveryPlanHyperVReplicaAzureFailoverInput = original.RecoveryPlanHyperVReplicaAzureFailoverInput
type RecoveryPlanInMageAzureV2FailoverInput = original.RecoveryPlanInMageAzureV2FailoverInput
type RecoveryPlanInMageFailoverInput = original.RecoveryPlanInMageFailoverInput
type RecoveryPlanManualActionDetails = original.RecoveryPlanManualActionDetails
type RecoveryPlanPlannedFailoverInput = original.RecoveryPlanPlannedFailoverInput
type RecoveryPlanPlannedFailoverInputProperties = original.RecoveryPlanPlannedFailoverInputProperties
type RecoveryPlanProperties = original.RecoveryPlanProperties
type RecoveryPlanProtectedItem = original.RecoveryPlanProtectedItem
type BasicRecoveryPlanProviderSpecificFailoverInput = original.BasicRecoveryPlanProviderSpecificFailoverInput
type RecoveryPlanProviderSpecificFailoverInput = original.RecoveryPlanProviderSpecificFailoverInput
type RecoveryPlanScriptActionDetails = original.RecoveryPlanScriptActionDetails
type RecoveryPlanShutdownGroupTaskDetails = original.RecoveryPlanShutdownGroupTaskDetails
type RecoveryPlanTestFailoverCleanupInput = original.RecoveryPlanTestFailoverCleanupInput
type RecoveryPlanTestFailoverCleanupInputProperties = original.RecoveryPlanTestFailoverCleanupInputProperties
type RecoveryPlanTestFailoverInput = original.RecoveryPlanTestFailoverInput
type RecoveryPlanTestFailoverInputProperties = original.RecoveryPlanTestFailoverInputProperties
type RecoveryPlanUnplannedFailoverInput = original.RecoveryPlanUnplannedFailoverInput
type RecoveryPlanUnplannedFailoverInputProperties = original.RecoveryPlanUnplannedFailoverInputProperties
type RecoveryPoint = original.RecoveryPoint
type RecoveryPointCollection = original.RecoveryPointCollection
type RecoveryPointCollectionIterator = original.RecoveryPointCollectionIterator
type RecoveryPointCollectionPage = original.RecoveryPointCollectionPage
type RecoveryPointProperties = original.RecoveryPointProperties
type RecoveryServicesProvider = original.RecoveryServicesProvider
type RecoveryServicesProviderCollection = original.RecoveryServicesProviderCollection
type RecoveryServicesProviderCollectionIterator = original.RecoveryServicesProviderCollectionIterator
type RecoveryServicesProviderCollectionPage = original.RecoveryServicesProviderCollectionPage
type RecoveryServicesProviderProperties = original.RecoveryServicesProviderProperties
type RemoveProtectionContainerMappingInput = original.RemoveProtectionContainerMappingInput
type RemoveProtectionContainerMappingInputProperties = original.RemoveProtectionContainerMappingInputProperties
type RenewCertificateInput = original.RenewCertificateInput
type RenewCertificateInputProperties = original.RenewCertificateInputProperties
type ReplicationFabricsCheckConsistencyFuture = original.ReplicationFabricsCheckConsistencyFuture
type ReplicationFabricsCreateFuture = original.ReplicationFabricsCreateFuture
type ReplicationFabricsDeleteFuture = original.ReplicationFabricsDeleteFuture
type ReplicationFabricsMigrateToAadFuture = original.ReplicationFabricsMigrateToAadFuture
type ReplicationFabricsPurgeFuture = original.ReplicationFabricsPurgeFuture
type ReplicationFabricsReassociateGatewayFuture = original.ReplicationFabricsReassociateGatewayFuture
type ReplicationFabricsRenewCertificateFuture = original.ReplicationFabricsRenewCertificateFuture
type ReplicationGroupDetails = original.ReplicationGroupDetails
type ReplicationJobsCancelFuture = original.ReplicationJobsCancelFuture
type ReplicationJobsExportFuture = original.ReplicationJobsExportFuture
type ReplicationJobsRestartFuture = original.ReplicationJobsRestartFuture
type ReplicationJobsResumeFuture = original.ReplicationJobsResumeFuture
type ReplicationNetworkMappingsCreateFuture = original.ReplicationNetworkMappingsCreateFuture
type ReplicationNetworkMappingsDeleteFuture = original.ReplicationNetworkMappingsDeleteFuture
type ReplicationNetworkMappingsUpdateFuture = original.ReplicationNetworkMappingsUpdateFuture
type ReplicationPoliciesCreateFuture = original.ReplicationPoliciesCreateFuture
type ReplicationPoliciesDeleteFuture = original.ReplicationPoliciesDeleteFuture
type ReplicationPoliciesUpdateFuture = original.ReplicationPoliciesUpdateFuture
type ReplicationProtectedItem = original.ReplicationProtectedItem
type ReplicationProtectedItemCollection = original.ReplicationProtectedItemCollection
type ReplicationProtectedItemCollectionIterator = original.ReplicationProtectedItemCollectionIterator
type ReplicationProtectedItemCollectionPage = original.ReplicationProtectedItemCollectionPage
type ReplicationProtectedItemProperties = original.ReplicationProtectedItemProperties
type ReplicationProtectedItemsApplyRecoveryPointFuture = original.ReplicationProtectedItemsApplyRecoveryPointFuture
type ReplicationProtectedItemsCreateFuture = original.ReplicationProtectedItemsCreateFuture
type ReplicationProtectedItemsDeleteFuture = original.ReplicationProtectedItemsDeleteFuture
type ReplicationProtectedItemsFailoverCommitFuture = original.ReplicationProtectedItemsFailoverCommitFuture
type ReplicationProtectedItemsPlannedFailoverFuture = original.ReplicationProtectedItemsPlannedFailoverFuture
type ReplicationProtectedItemsPurgeFuture = original.ReplicationProtectedItemsPurgeFuture
type ReplicationProtectedItemsRepairReplicationFuture = original.ReplicationProtectedItemsRepairReplicationFuture
type ReplicationProtectedItemsReprotectFuture = original.ReplicationProtectedItemsReprotectFuture
type ReplicationProtectedItemsTestFailoverCleanupFuture = original.ReplicationProtectedItemsTestFailoverCleanupFuture
type ReplicationProtectedItemsTestFailoverFuture = original.ReplicationProtectedItemsTestFailoverFuture
type ReplicationProtectedItemsUnplannedFailoverFuture = original.ReplicationProtectedItemsUnplannedFailoverFuture
type ReplicationProtectedItemsUpdateFuture = original.ReplicationProtectedItemsUpdateFuture
type ReplicationProtectedItemsUpdateMobilityServiceFuture = original.ReplicationProtectedItemsUpdateMobilityServiceFuture
type ReplicationProtectionContainerMappingsCreateFuture = original.ReplicationProtectionContainerMappingsCreateFuture
type ReplicationProtectionContainerMappingsDeleteFuture = original.ReplicationProtectionContainerMappingsDeleteFuture
type ReplicationProtectionContainerMappingsPurgeFuture = original.ReplicationProtectionContainerMappingsPurgeFuture
type ReplicationProtectionContainerMappingsUpdateFuture = original.ReplicationProtectionContainerMappingsUpdateFuture
type ReplicationProtectionContainersCreateFuture = original.ReplicationProtectionContainersCreateFuture
type ReplicationProtectionContainersDeleteFuture = original.ReplicationProtectionContainersDeleteFuture
type ReplicationProtectionContainersDiscoverProtectableItemFuture = original.ReplicationProtectionContainersDiscoverProtectableItemFuture
type ReplicationProtectionContainersSwitchProtectionFuture = original.ReplicationProtectionContainersSwitchProtectionFuture
type ReplicationProviderContainerUnmappingInput = original.ReplicationProviderContainerUnmappingInput
type BasicReplicationProviderSpecificContainerCreationInput = original.BasicReplicationProviderSpecificContainerCreationInput
type ReplicationProviderSpecificContainerCreationInput = original.ReplicationProviderSpecificContainerCreationInput
type BasicReplicationProviderSpecificContainerMappingInput = original.BasicReplicationProviderSpecificContainerMappingInput
type ReplicationProviderSpecificContainerMappingInput = original.ReplicationProviderSpecificContainerMappingInput
type BasicReplicationProviderSpecificSettings = original.BasicReplicationProviderSpecificSettings
type ReplicationProviderSpecificSettings = original.ReplicationProviderSpecificSettings
type BasicReplicationProviderSpecificUpdateContainerMappingInput = original.BasicReplicationProviderSpecificUpdateContainerMappingInput
type ReplicationProviderSpecificUpdateContainerMappingInput = original.ReplicationProviderSpecificUpdateContainerMappingInput
type ReplicationRecoveryPlansCreateFuture = original.ReplicationRecoveryPlansCreateFuture
type ReplicationRecoveryPlansDeleteFuture = original.ReplicationRecoveryPlansDeleteFuture
type ReplicationRecoveryPlansFailoverCommitFuture = original.ReplicationRecoveryPlansFailoverCommitFuture
type ReplicationRecoveryPlansPlannedFailoverFuture = original.ReplicationRecoveryPlansPlannedFailoverFuture
type ReplicationRecoveryPlansReprotectFuture = original.ReplicationRecoveryPlansReprotectFuture
type ReplicationRecoveryPlansTestFailoverCleanupFuture = original.ReplicationRecoveryPlansTestFailoverCleanupFuture
type ReplicationRecoveryPlansTestFailoverFuture = original.ReplicationRecoveryPlansTestFailoverFuture
type ReplicationRecoveryPlansUnplannedFailoverFuture = original.ReplicationRecoveryPlansUnplannedFailoverFuture
type ReplicationRecoveryPlansUpdateFuture = original.ReplicationRecoveryPlansUpdateFuture
type ReplicationRecoveryServicesProvidersDeleteFuture = original.ReplicationRecoveryServicesProvidersDeleteFuture
type ReplicationRecoveryServicesProvidersPurgeFuture = original.ReplicationRecoveryServicesProvidersPurgeFuture
type ReplicationRecoveryServicesProvidersRefreshProviderFuture = original.ReplicationRecoveryServicesProvidersRefreshProviderFuture
type ReplicationStorageClassificationMappingsCreateFuture = original.ReplicationStorageClassificationMappingsCreateFuture
type ReplicationStorageClassificationMappingsDeleteFuture = original.ReplicationStorageClassificationMappingsDeleteFuture
type ReplicationVaultHealthRefreshFuture = original.ReplicationVaultHealthRefreshFuture
type ReplicationvCentersCreateFuture = original.ReplicationvCentersCreateFuture
type ReplicationvCentersDeleteFuture = original.ReplicationvCentersDeleteFuture
type ReplicationvCentersUpdateFuture = original.ReplicationvCentersUpdateFuture
type Resource = original.Resource
type ResourceHealthSummary = original.ResourceHealthSummary
type ResumeJobParams = original.ResumeJobParams
type ResumeJobParamsProperties = original.ResumeJobParamsProperties
type RetentionVolume = original.RetentionVolume
type ReverseReplicationInput = original.ReverseReplicationInput
type ReverseReplicationInputProperties = original.ReverseReplicationInputProperties
type BasicReverseReplicationProviderSpecificInput = original.BasicReverseReplicationProviderSpecificInput
type ReverseReplicationProviderSpecificInput = original.ReverseReplicationProviderSpecificInput
type RoleAssignment = original.RoleAssignment
type RunAsAccount = original.RunAsAccount
type SanEnableProtectionInput = original.SanEnableProtectionInput
type ScriptActionTaskDetails = original.ScriptActionTaskDetails
type ServiceError = original.ServiceError
type StorageClassification = original.StorageClassification
type StorageClassificationCollection = original.StorageClassificationCollection
type StorageClassificationCollectionIterator = original.StorageClassificationCollectionIterator
type StorageClassificationCollectionPage = original.StorageClassificationCollectionPage
type StorageClassificationMapping = original.StorageClassificationMapping
type StorageClassificationMappingCollection = original.StorageClassificationMappingCollection
type StorageClassificationMappingCollectionIterator = original.StorageClassificationMappingCollectionIterator
type StorageClassificationMappingCollectionPage = original.StorageClassificationMappingCollectionPage
type StorageClassificationMappingInput = original.StorageClassificationMappingInput
type StorageClassificationMappingProperties = original.StorageClassificationMappingProperties
type StorageClassificationProperties = original.StorageClassificationProperties
type StorageMappingInputProperties = original.StorageMappingInputProperties
type Subnet = original.Subnet
type SwitchProtectionInput = original.SwitchProtectionInput
type SwitchProtectionInputProperties = original.SwitchProtectionInputProperties
type SwitchProtectionJobDetails = original.SwitchProtectionJobDetails
type BasicSwitchProtectionProviderSpecificInput = original.BasicSwitchProtectionProviderSpecificInput
type SwitchProtectionProviderSpecificInput = original.SwitchProtectionProviderSpecificInput
type TargetComputeSize = original.TargetComputeSize
type TargetComputeSizeCollection = original.TargetComputeSizeCollection
type TargetComputeSizeCollectionIterator = original.TargetComputeSizeCollectionIterator
type TargetComputeSizeCollectionPage = original.TargetComputeSizeCollectionPage
type TargetComputeSizeProperties = original.TargetComputeSizeProperties
type BasicTaskTypeDetails = original.BasicTaskTypeDetails
type TaskTypeDetails = original.TaskTypeDetails
type TestFailoverCleanupInput = original.TestFailoverCleanupInput
type TestFailoverCleanupInputProperties = original.TestFailoverCleanupInputProperties
type TestFailoverInput = original.TestFailoverInput
type TestFailoverInputProperties = original.TestFailoverInputProperties
type TestFailoverJobDetails = original.TestFailoverJobDetails
type UnplannedFailoverInput = original.UnplannedFailoverInput
type UnplannedFailoverInputProperties = original.UnplannedFailoverInputProperties
type UpdateMobilityServiceRequest = original.UpdateMobilityServiceRequest
type UpdateMobilityServiceRequestProperties = original.UpdateMobilityServiceRequestProperties
type UpdateNetworkMappingInput = original.UpdateNetworkMappingInput
type UpdateNetworkMappingInputProperties = original.UpdateNetworkMappingInputProperties
type UpdatePolicyInput = original.UpdatePolicyInput
type UpdatePolicyInputProperties = original.UpdatePolicyInputProperties
type UpdateProtectionContainerMappingInput = original.UpdateProtectionContainerMappingInput
type UpdateProtectionContainerMappingInputProperties = original.UpdateProtectionContainerMappingInputProperties
type UpdateRecoveryPlanInput = original.UpdateRecoveryPlanInput
type UpdateRecoveryPlanInputProperties = original.UpdateRecoveryPlanInputProperties
type UpdateReplicationProtectedItemInput = original.UpdateReplicationProtectedItemInput
type UpdateReplicationProtectedItemInputProperties = original.UpdateReplicationProtectedItemInputProperties
type BasicUpdateReplicationProtectedItemProviderInput = original.BasicUpdateReplicationProtectedItemProviderInput
type UpdateReplicationProtectedItemProviderInput = original.UpdateReplicationProtectedItemProviderInput
type UpdateVCenterRequest = original.UpdateVCenterRequest
type UpdateVCenterRequestProperties = original.UpdateVCenterRequestProperties
type VaultHealthDetails = original.VaultHealthDetails
type VaultHealthProperties = original.VaultHealthProperties
type VCenter = original.VCenter
type VCenterCollection = original.VCenterCollection
type VCenterCollectionIterator = original.VCenterCollectionIterator
type VCenterCollectionPage = original.VCenterCollectionPage
type VCenterProperties = original.VCenterProperties
type VersionDetails = original.VersionDetails
type VirtualMachineTaskDetails = original.VirtualMachineTaskDetails
type VmmDetails = original.VmmDetails
type VmmToAzureCreateNetworkMappingInput = original.VmmToAzureCreateNetworkMappingInput
type VmmToAzureNetworkMappingSettings = original.VmmToAzureNetworkMappingSettings
type VmmToAzureUpdateNetworkMappingInput = original.VmmToAzureUpdateNetworkMappingInput
type VmmToVmmCreateNetworkMappingInput = original.VmmToVmmCreateNetworkMappingInput
type VmmToVmmNetworkMappingSettings = original.VmmToVmmNetworkMappingSettings
type VmmToVmmUpdateNetworkMappingInput = original.VmmToVmmUpdateNetworkMappingInput
type VmmVirtualMachineDetails = original.VmmVirtualMachineDetails
type VMNicDetails = original.VMNicDetails
type VMNicInputDetails = original.VMNicInputDetails
type VMNicUpdatesTaskDetails = original.VMNicUpdatesTaskDetails
type VMwareCbtPolicyCreationInput = original.VMwareCbtPolicyCreationInput
type VmwareCbtPolicyDetails = original.VmwareCbtPolicyDetails
type VMwareDetails = original.VMwareDetails
type VMwareV2FabricCreationInput = original.VMwareV2FabricCreationInput
type VMwareV2FabricSpecificDetails = original.VMwareV2FabricSpecificDetails
type VMwareVirtualMachineDetails = original.VMwareVirtualMachineDetails
type OperationsClient = original.OperationsClient
type RecoveryPointsClient = original.RecoveryPointsClient
type ReplicationAlertSettingsClient = original.ReplicationAlertSettingsClient
type ReplicationEventsClient = original.ReplicationEventsClient
type ReplicationFabricsClient = original.ReplicationFabricsClient
type ReplicationJobsClient = original.ReplicationJobsClient
type ReplicationLogicalNetworksClient = original.ReplicationLogicalNetworksClient
type ReplicationNetworkMappingsClient = original.ReplicationNetworkMappingsClient
type ReplicationNetworksClient = original.ReplicationNetworksClient
type ReplicationPoliciesClient = original.ReplicationPoliciesClient
type ReplicationProtectableItemsClient = original.ReplicationProtectableItemsClient
type ReplicationProtectedItemsClient = original.ReplicationProtectedItemsClient
type ReplicationProtectionContainerMappingsClient = original.ReplicationProtectionContainerMappingsClient
type ReplicationProtectionContainersClient = original.ReplicationProtectionContainersClient
type ReplicationRecoveryPlansClient = original.ReplicationRecoveryPlansClient
type ReplicationRecoveryServicesProvidersClient = original.ReplicationRecoveryServicesProvidersClient
type ReplicationStorageClassificationMappingsClient = original.ReplicationStorageClassificationMappingsClient
type ReplicationStorageClassificationsClient = original.ReplicationStorageClassificationsClient
type ReplicationVaultHealthClient = original.ReplicationVaultHealthClient
type ReplicationvCentersClient = original.ReplicationvCentersClient
type TargetComputeSizesClient = original.TargetComputeSizesClient

func New(subscriptionID string, resourceGroupName string, resourceName string) BaseClient {
	return original.New(subscriptionID, resourceGroupName, resourceName)
}
func NewWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func PossibleA2ARpRecoveryPointTypeValues() []A2ARpRecoveryPointType {
	return original.PossibleA2ARpRecoveryPointTypeValues()
}
func PossibleAgentAutoUpdateStatusValues() []AgentAutoUpdateStatus {
	return original.PossibleAgentAutoUpdateStatusValues()
}
func PossibleAgentVersionStatusValues() []AgentVersionStatus {
	return original.PossibleAgentVersionStatusValues()
}
func PossibleAlternateLocationRecoveryOptionValues() []AlternateLocationRecoveryOption {
	return original.PossibleAlternateLocationRecoveryOptionValues()
}
func PossibleDataSyncStatusValues() []DataSyncStatus {
	return original.PossibleDataSyncStatusValues()
}
func PossibleDisableProtectionReasonValues() []DisableProtectionReason {
	return original.PossibleDisableProtectionReasonValues()
}
func PossibleFailoverDeploymentModelValues() []FailoverDeploymentModel {
	return original.PossibleFailoverDeploymentModelValues()
}
func PossibleHealthErrorCategoryValues() []HealthErrorCategory {
	return original.PossibleHealthErrorCategoryValues()
}
func PossibleHyperVReplicaAzureRpRecoveryPointTypeValues() []HyperVReplicaAzureRpRecoveryPointType {
	return original.PossibleHyperVReplicaAzureRpRecoveryPointTypeValues()
}
func PossibleIdentityProviderTypeValues() []IdentityProviderType {
	return original.PossibleIdentityProviderTypeValues()
}
func PossibleInMageV2RpRecoveryPointTypeValues() []InMageV2RpRecoveryPointType {
	return original.PossibleInMageV2RpRecoveryPointTypeValues()
}
func PossibleInstanceTypeValues() []InstanceType {
	return original.PossibleInstanceTypeValues()
}
func PossibleInstanceTypeBasicConfigurationSettingsValues() []InstanceTypeBasicConfigurationSettings {
	return original.PossibleInstanceTypeBasicConfigurationSettingsValues()
}
func PossibleInstanceTypeBasicDisableProtectionProviderSpecificInputValues() []InstanceTypeBasicDisableProtectionProviderSpecificInput {
	return original.PossibleInstanceTypeBasicDisableProtectionProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicEnableProtectionProviderSpecificInputValues() []InstanceTypeBasicEnableProtectionProviderSpecificInput {
	return original.PossibleInstanceTypeBasicEnableProtectionProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicEventProviderSpecificDetailsValues() []InstanceTypeBasicEventProviderSpecificDetails {
	return original.PossibleInstanceTypeBasicEventProviderSpecificDetailsValues()
}
func PossibleInstanceTypeBasicEventSpecificDetailsValues() []InstanceTypeBasicEventSpecificDetails {
	return original.PossibleInstanceTypeBasicEventSpecificDetailsValues()
}
func PossibleInstanceTypeBasicFabricSpecificCreateNetworkMappingInputValues() []InstanceTypeBasicFabricSpecificCreateNetworkMappingInput {
	return original.PossibleInstanceTypeBasicFabricSpecificCreateNetworkMappingInputValues()
}
func PossibleInstanceTypeBasicFabricSpecificCreationInputValues() []InstanceTypeBasicFabricSpecificCreationInput {
	return original.PossibleInstanceTypeBasicFabricSpecificCreationInputValues()
}
func PossibleInstanceTypeBasicFabricSpecificDetailsValues() []InstanceTypeBasicFabricSpecificDetails {
	return original.PossibleInstanceTypeBasicFabricSpecificDetailsValues()
}
func PossibleInstanceTypeBasicFabricSpecificUpdateNetworkMappingInputValues() []InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput {
	return original.PossibleInstanceTypeBasicFabricSpecificUpdateNetworkMappingInputValues()
}
func PossibleInstanceTypeBasicGroupTaskDetailsValues() []InstanceTypeBasicGroupTaskDetails {
	return original.PossibleInstanceTypeBasicGroupTaskDetailsValues()
}
func PossibleInstanceTypeBasicJobDetailsValues() []InstanceTypeBasicJobDetails {
	return original.PossibleInstanceTypeBasicJobDetailsValues()
}
func PossibleInstanceTypeBasicNetworkMappingFabricSpecificSettingsValues() []InstanceTypeBasicNetworkMappingFabricSpecificSettings {
	return original.PossibleInstanceTypeBasicNetworkMappingFabricSpecificSettingsValues()
}
func PossibleInstanceTypeBasicPolicyProviderSpecificDetailsValues() []InstanceTypeBasicPolicyProviderSpecificDetails {
	return original.PossibleInstanceTypeBasicPolicyProviderSpecificDetailsValues()
}
func PossibleInstanceTypeBasicPolicyProviderSpecificInputValues() []InstanceTypeBasicPolicyProviderSpecificInput {
	return original.PossibleInstanceTypeBasicPolicyProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsValues() []InstanceTypeBasicProtectionContainerMappingProviderSpecificDetails {
	return original.PossibleInstanceTypeBasicProtectionContainerMappingProviderSpecificDetailsValues()
}
func PossibleInstanceTypeBasicProviderSpecificFailoverInputValues() []InstanceTypeBasicProviderSpecificFailoverInput {
	return original.PossibleInstanceTypeBasicProviderSpecificFailoverInputValues()
}
func PossibleInstanceTypeBasicProviderSpecificRecoveryPointDetailsValues() []InstanceTypeBasicProviderSpecificRecoveryPointDetails {
	return original.PossibleInstanceTypeBasicProviderSpecificRecoveryPointDetailsValues()
}
func PossibleInstanceTypeBasicRecoveryPlanActionDetailsValues() []InstanceTypeBasicRecoveryPlanActionDetails {
	return original.PossibleInstanceTypeBasicRecoveryPlanActionDetailsValues()
}
func PossibleInstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputValues() []InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput {
	return original.PossibleInstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputValues()
}
func PossibleInstanceTypeBasicReplicationProviderSpecificContainerCreationInputValues() []InstanceTypeBasicReplicationProviderSpecificContainerCreationInput {
	return original.PossibleInstanceTypeBasicReplicationProviderSpecificContainerCreationInputValues()
}
func PossibleInstanceTypeBasicReplicationProviderSpecificContainerMappingInputValues() []InstanceTypeBasicReplicationProviderSpecificContainerMappingInput {
	return original.PossibleInstanceTypeBasicReplicationProviderSpecificContainerMappingInputValues()
}
func PossibleInstanceTypeBasicReplicationProviderSpecificSettingsValues() []InstanceTypeBasicReplicationProviderSpecificSettings {
	return original.PossibleInstanceTypeBasicReplicationProviderSpecificSettingsValues()
}
func PossibleInstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputValues() []InstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInput {
	return original.PossibleInstanceTypeBasicReplicationProviderSpecificUpdateContainerMappingInputValues()
}
func PossibleInstanceTypeBasicReverseReplicationProviderSpecificInputValues() []InstanceTypeBasicReverseReplicationProviderSpecificInput {
	return original.PossibleInstanceTypeBasicReverseReplicationProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicSwitchProtectionProviderSpecificInputValues() []InstanceTypeBasicSwitchProtectionProviderSpecificInput {
	return original.PossibleInstanceTypeBasicSwitchProtectionProviderSpecificInputValues()
}
func PossibleInstanceTypeBasicTaskTypeDetailsValues() []InstanceTypeBasicTaskTypeDetails {
	return original.PossibleInstanceTypeBasicTaskTypeDetailsValues()
}
func PossibleInstanceTypeBasicUpdateReplicationProtectedItemProviderInputValues() []InstanceTypeBasicUpdateReplicationProtectedItemProviderInput {
	return original.PossibleInstanceTypeBasicUpdateReplicationProtectedItemProviderInputValues()
}
func PossibleLicenseTypeValues() []LicenseType {
	return original.PossibleLicenseTypeValues()
}
func PossibleMultiVMGroupCreateOptionValues() []MultiVMGroupCreateOption {
	return original.PossibleMultiVMGroupCreateOptionValues()
}
func PossibleMultiVMSyncPointOptionValues() []MultiVMSyncPointOption {
	return original.PossibleMultiVMSyncPointOptionValues()
}
func PossibleMultiVMSyncStatusValues() []MultiVMSyncStatus {
	return original.PossibleMultiVMSyncStatusValues()
}
func PossiblePossibleOperationsDirectionsValues() []PossibleOperationsDirections {
	return original.PossiblePossibleOperationsDirectionsValues()
}
func PossiblePresenceStatusValues() []PresenceStatus {
	return original.PossiblePresenceStatusValues()
}
func PossibleRecoveryPlanActionLocationValues() []RecoveryPlanActionLocation {
	return original.PossibleRecoveryPlanActionLocationValues()
}
func PossibleRecoveryPlanGroupTypeValues() []RecoveryPlanGroupType {
	return original.PossibleRecoveryPlanGroupTypeValues()
}
func PossibleRecoveryPointSyncTypeValues() []RecoveryPointSyncType {
	return original.PossibleRecoveryPointSyncTypeValues()
}
func PossibleRecoveryPointTypeValues() []RecoveryPointType {
	return original.PossibleRecoveryPointTypeValues()
}
func PossibleReplicationProtectedItemOperationValues() []ReplicationProtectedItemOperation {
	return original.PossibleReplicationProtectedItemOperationValues()
}
func PossibleRpInMageRecoveryPointTypeValues() []RpInMageRecoveryPointType {
	return original.PossibleRpInMageRecoveryPointTypeValues()
}
func PossibleSetMultiVMSyncStatusValues() []SetMultiVMSyncStatus {
	return original.PossibleSetMultiVMSyncStatusValues()
}
func PossibleSeverityValues() []Severity {
	return original.PossibleSeverityValues()
}
func PossibleSourceSiteOperationsValues() []SourceSiteOperations {
	return original.PossibleSourceSiteOperationsValues()
}
func NewAlertCollectionIterator(page AlertCollectionPage) AlertCollectionIterator {
	return original.NewAlertCollectionIterator(page)
}
func NewAlertCollectionPage(getNextPage func(context.Context, AlertCollection) (AlertCollection, error)) AlertCollectionPage {
	return original.NewAlertCollectionPage(getNextPage)
}
func NewEventCollectionIterator(page EventCollectionPage) EventCollectionIterator {
	return original.NewEventCollectionIterator(page)
}
func NewEventCollectionPage(getNextPage func(context.Context, EventCollection) (EventCollection, error)) EventCollectionPage {
	return original.NewEventCollectionPage(getNextPage)
}
func NewFabricCollectionIterator(page FabricCollectionPage) FabricCollectionIterator {
	return original.NewFabricCollectionIterator(page)
}
func NewFabricCollectionPage(getNextPage func(context.Context, FabricCollection) (FabricCollection, error)) FabricCollectionPage {
	return original.NewFabricCollectionPage(getNextPage)
}
func NewJobCollectionIterator(page JobCollectionPage) JobCollectionIterator {
	return original.NewJobCollectionIterator(page)
}
func NewJobCollectionPage(getNextPage func(context.Context, JobCollection) (JobCollection, error)) JobCollectionPage {
	return original.NewJobCollectionPage(getNextPage)
}
func NewLogicalNetworkCollectionIterator(page LogicalNetworkCollectionPage) LogicalNetworkCollectionIterator {
	return original.NewLogicalNetworkCollectionIterator(page)
}
func NewLogicalNetworkCollectionPage(getNextPage func(context.Context, LogicalNetworkCollection) (LogicalNetworkCollection, error)) LogicalNetworkCollectionPage {
	return original.NewLogicalNetworkCollectionPage(getNextPage)
}
func NewNetworkCollectionIterator(page NetworkCollectionPage) NetworkCollectionIterator {
	return original.NewNetworkCollectionIterator(page)
}
func NewNetworkCollectionPage(getNextPage func(context.Context, NetworkCollection) (NetworkCollection, error)) NetworkCollectionPage {
	return original.NewNetworkCollectionPage(getNextPage)
}
func NewNetworkMappingCollectionIterator(page NetworkMappingCollectionPage) NetworkMappingCollectionIterator {
	return original.NewNetworkMappingCollectionIterator(page)
}
func NewNetworkMappingCollectionPage(getNextPage func(context.Context, NetworkMappingCollection) (NetworkMappingCollection, error)) NetworkMappingCollectionPage {
	return original.NewNetworkMappingCollectionPage(getNextPage)
}
func NewOperationsDiscoveryCollectionIterator(page OperationsDiscoveryCollectionPage) OperationsDiscoveryCollectionIterator {
	return original.NewOperationsDiscoveryCollectionIterator(page)
}
func NewOperationsDiscoveryCollectionPage(getNextPage func(context.Context, OperationsDiscoveryCollection) (OperationsDiscoveryCollection, error)) OperationsDiscoveryCollectionPage {
	return original.NewOperationsDiscoveryCollectionPage(getNextPage)
}
func NewPolicyCollectionIterator(page PolicyCollectionPage) PolicyCollectionIterator {
	return original.NewPolicyCollectionIterator(page)
}
func NewPolicyCollectionPage(getNextPage func(context.Context, PolicyCollection) (PolicyCollection, error)) PolicyCollectionPage {
	return original.NewPolicyCollectionPage(getNextPage)
}
func NewProtectableItemCollectionIterator(page ProtectableItemCollectionPage) ProtectableItemCollectionIterator {
	return original.NewProtectableItemCollectionIterator(page)
}
func NewProtectableItemCollectionPage(getNextPage func(context.Context, ProtectableItemCollection) (ProtectableItemCollection, error)) ProtectableItemCollectionPage {
	return original.NewProtectableItemCollectionPage(getNextPage)
}
func NewProtectionContainerCollectionIterator(page ProtectionContainerCollectionPage) ProtectionContainerCollectionIterator {
	return original.NewProtectionContainerCollectionIterator(page)
}
func NewProtectionContainerCollectionPage(getNextPage func(context.Context, ProtectionContainerCollection) (ProtectionContainerCollection, error)) ProtectionContainerCollectionPage {
	return original.NewProtectionContainerCollectionPage(getNextPage)
}
func NewProtectionContainerMappingCollectionIterator(page ProtectionContainerMappingCollectionPage) ProtectionContainerMappingCollectionIterator {
	return original.NewProtectionContainerMappingCollectionIterator(page)
}
func NewProtectionContainerMappingCollectionPage(getNextPage func(context.Context, ProtectionContainerMappingCollection) (ProtectionContainerMappingCollection, error)) ProtectionContainerMappingCollectionPage {
	return original.NewProtectionContainerMappingCollectionPage(getNextPage)
}
func NewRecoveryPlanCollectionIterator(page RecoveryPlanCollectionPage) RecoveryPlanCollectionIterator {
	return original.NewRecoveryPlanCollectionIterator(page)
}
func NewRecoveryPlanCollectionPage(getNextPage func(context.Context, RecoveryPlanCollection) (RecoveryPlanCollection, error)) RecoveryPlanCollectionPage {
	return original.NewRecoveryPlanCollectionPage(getNextPage)
}
func NewRecoveryPointCollectionIterator(page RecoveryPointCollectionPage) RecoveryPointCollectionIterator {
	return original.NewRecoveryPointCollectionIterator(page)
}
func NewRecoveryPointCollectionPage(getNextPage func(context.Context, RecoveryPointCollection) (RecoveryPointCollection, error)) RecoveryPointCollectionPage {
	return original.NewRecoveryPointCollectionPage(getNextPage)
}
func NewRecoveryServicesProviderCollectionIterator(page RecoveryServicesProviderCollectionPage) RecoveryServicesProviderCollectionIterator {
	return original.NewRecoveryServicesProviderCollectionIterator(page)
}
func NewRecoveryServicesProviderCollectionPage(getNextPage func(context.Context, RecoveryServicesProviderCollection) (RecoveryServicesProviderCollection, error)) RecoveryServicesProviderCollectionPage {
	return original.NewRecoveryServicesProviderCollectionPage(getNextPage)
}
func NewReplicationProtectedItemCollectionIterator(page ReplicationProtectedItemCollectionPage) ReplicationProtectedItemCollectionIterator {
	return original.NewReplicationProtectedItemCollectionIterator(page)
}
func NewReplicationProtectedItemCollectionPage(getNextPage func(context.Context, ReplicationProtectedItemCollection) (ReplicationProtectedItemCollection, error)) ReplicationProtectedItemCollectionPage {
	return original.NewReplicationProtectedItemCollectionPage(getNextPage)
}
func NewStorageClassificationCollectionIterator(page StorageClassificationCollectionPage) StorageClassificationCollectionIterator {
	return original.NewStorageClassificationCollectionIterator(page)
}
func NewStorageClassificationCollectionPage(getNextPage func(context.Context, StorageClassificationCollection) (StorageClassificationCollection, error)) StorageClassificationCollectionPage {
	return original.NewStorageClassificationCollectionPage(getNextPage)
}
func NewStorageClassificationMappingCollectionIterator(page StorageClassificationMappingCollectionPage) StorageClassificationMappingCollectionIterator {
	return original.NewStorageClassificationMappingCollectionIterator(page)
}
func NewStorageClassificationMappingCollectionPage(getNextPage func(context.Context, StorageClassificationMappingCollection) (StorageClassificationMappingCollection, error)) StorageClassificationMappingCollectionPage {
	return original.NewStorageClassificationMappingCollectionPage(getNextPage)
}
func NewTargetComputeSizeCollectionIterator(page TargetComputeSizeCollectionPage) TargetComputeSizeCollectionIterator {
	return original.NewTargetComputeSizeCollectionIterator(page)
}
func NewTargetComputeSizeCollectionPage(getNextPage func(context.Context, TargetComputeSizeCollection) (TargetComputeSizeCollection, error)) TargetComputeSizeCollectionPage {
	return original.NewTargetComputeSizeCollectionPage(getNextPage)
}
func NewVCenterCollectionIterator(page VCenterCollectionPage) VCenterCollectionIterator {
	return original.NewVCenterCollectionIterator(page)
}
func NewVCenterCollectionPage(getNextPage func(context.Context, VCenterCollection) (VCenterCollection, error)) VCenterCollectionPage {
	return original.NewVCenterCollectionPage(getNextPage)
}
func NewOperationsClient(subscriptionID string, resourceGroupName string, resourceName string) OperationsClient {
	return original.NewOperationsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewRecoveryPointsClient(subscriptionID string, resourceGroupName string, resourceName string) RecoveryPointsClient {
	return original.NewRecoveryPointsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewRecoveryPointsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) RecoveryPointsClient {
	return original.NewRecoveryPointsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationAlertSettingsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationAlertSettingsClient {
	return original.NewReplicationAlertSettingsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationAlertSettingsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationAlertSettingsClient {
	return original.NewReplicationAlertSettingsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationEventsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationEventsClient {
	return original.NewReplicationEventsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationEventsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationEventsClient {
	return original.NewReplicationEventsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationFabricsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationFabricsClient {
	return original.NewReplicationFabricsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationFabricsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationFabricsClient {
	return original.NewReplicationFabricsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationJobsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationJobsClient {
	return original.NewReplicationJobsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationJobsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationJobsClient {
	return original.NewReplicationJobsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationLogicalNetworksClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationLogicalNetworksClient {
	return original.NewReplicationLogicalNetworksClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationLogicalNetworksClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationLogicalNetworksClient {
	return original.NewReplicationLogicalNetworksClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationNetworkMappingsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationNetworkMappingsClient {
	return original.NewReplicationNetworkMappingsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationNetworkMappingsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationNetworkMappingsClient {
	return original.NewReplicationNetworkMappingsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationNetworksClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationNetworksClient {
	return original.NewReplicationNetworksClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationNetworksClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationNetworksClient {
	return original.NewReplicationNetworksClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationPoliciesClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationPoliciesClient {
	return original.NewReplicationPoliciesClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationPoliciesClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationPoliciesClient {
	return original.NewReplicationPoliciesClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectableItemsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectableItemsClient {
	return original.NewReplicationProtectableItemsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectableItemsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectableItemsClient {
	return original.NewReplicationProtectableItemsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectedItemsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectedItemsClient {
	return original.NewReplicationProtectedItemsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectedItemsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectedItemsClient {
	return original.NewReplicationProtectedItemsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectionContainerMappingsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectionContainerMappingsClient {
	return original.NewReplicationProtectionContainerMappingsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectionContainerMappingsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectionContainerMappingsClient {
	return original.NewReplicationProtectionContainerMappingsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectionContainersClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectionContainersClient {
	return original.NewReplicationProtectionContainersClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationProtectionContainersClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectionContainersClient {
	return original.NewReplicationProtectionContainersClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationRecoveryPlansClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationRecoveryPlansClient {
	return original.NewReplicationRecoveryPlansClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationRecoveryPlansClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationRecoveryPlansClient {
	return original.NewReplicationRecoveryPlansClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationRecoveryServicesProvidersClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationRecoveryServicesProvidersClient {
	return original.NewReplicationRecoveryServicesProvidersClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationRecoveryServicesProvidersClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationRecoveryServicesProvidersClient {
	return original.NewReplicationRecoveryServicesProvidersClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationStorageClassificationMappingsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationStorageClassificationMappingsClient {
	return original.NewReplicationStorageClassificationMappingsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationStorageClassificationMappingsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationStorageClassificationMappingsClient {
	return original.NewReplicationStorageClassificationMappingsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationStorageClassificationsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationStorageClassificationsClient {
	return original.NewReplicationStorageClassificationsClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationStorageClassificationsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationStorageClassificationsClient {
	return original.NewReplicationStorageClassificationsClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationVaultHealthClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationVaultHealthClient {
	return original.NewReplicationVaultHealthClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationVaultHealthClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationVaultHealthClient {
	return original.NewReplicationVaultHealthClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationvCentersClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationvCentersClient {
	return original.NewReplicationvCentersClient(subscriptionID, resourceGroupName, resourceName)
}
func NewReplicationvCentersClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationvCentersClient {
	return original.NewReplicationvCentersClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func NewTargetComputeSizesClient(subscriptionID string, resourceGroupName string, resourceName string) TargetComputeSizesClient {
	return original.NewTargetComputeSizesClient(subscriptionID, resourceGroupName, resourceName)
}
func NewTargetComputeSizesClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) TargetComputeSizesClient {
	return original.NewTargetComputeSizesClientWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
