// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/sql/jobs.proto
// DO NOT EDIT!

/*
	Package sql is a generated protocol buffer package.

	It is generated from these files:
		cockroach/pkg/sql/jobs.proto

	It has these top-level messages:
		BackupJobDetails
		RestoreJobDetails
		SchemaChangeJobDetails
		JobPayload
*/
package sql

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import github_com_cockroachdb_cockroach_pkg_sql_sqlbase "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type BackupJobDetails struct {
}

func (m *BackupJobDetails) Reset()                    { *m = BackupJobDetails{} }
func (m *BackupJobDetails) String() string            { return proto.CompactTextString(m) }
func (*BackupJobDetails) ProtoMessage()               {}
func (*BackupJobDetails) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{0} }

type RestoreJobDetails struct {
}

func (m *RestoreJobDetails) Reset()                    { *m = RestoreJobDetails{} }
func (m *RestoreJobDetails) String() string            { return proto.CompactTextString(m) }
func (*RestoreJobDetails) ProtoMessage()               {}
func (*RestoreJobDetails) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{1} }

type SchemaChangeJobDetails struct {
}

func (m *SchemaChangeJobDetails) Reset()                    { *m = SchemaChangeJobDetails{} }
func (m *SchemaChangeJobDetails) String() string            { return proto.CompactTextString(m) }
func (*SchemaChangeJobDetails) ProtoMessage()               {}
func (*SchemaChangeJobDetails) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{2} }

type JobPayload struct {
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	Username    string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// For consistency with the SQL timestamp type, which has microsecond
	// precision, we avoid the timestamp.Timestamp WKT, which has nanosecond
	// precision, and use microsecond integers directly.
	StartedMicros     int64                                                 `protobuf:"varint,3,opt,name=started_micros,json=startedMicros,proto3" json:"started_micros,omitempty"`
	FinishedMicros    int64                                                 `protobuf:"varint,4,opt,name=finished_micros,json=finishedMicros,proto3" json:"finished_micros,omitempty"`
	ModifiedMicros    int64                                                 `protobuf:"varint,5,opt,name=modified_micros,json=modifiedMicros,proto3" json:"modified_micros,omitempty"`
	DescriptorIDs     []github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID `protobuf:"varint,6,rep,packed,name=descriptor_ids,json=descriptorIds,casttype=github.com/cockroachdb/cockroach/pkg/sql/sqlbase.ID" json:"descriptor_ids,omitempty"`
	FractionCompleted float32                                               `protobuf:"fixed32,7,opt,name=fraction_completed,json=fractionCompleted,proto3" json:"fraction_completed,omitempty"`
	Error             string                                                `protobuf:"bytes,8,opt,name=error,proto3" json:"error,omitempty"`
	// Types that are valid to be assigned to Details:
	//	*JobPayload_Backup
	//	*JobPayload_Restore
	//	*JobPayload_SchemaChange
	Details isJobPayload_Details `protobuf_oneof:"details"`
}

func (m *JobPayload) Reset()                    { *m = JobPayload{} }
func (m *JobPayload) String() string            { return proto.CompactTextString(m) }
func (*JobPayload) ProtoMessage()               {}
func (*JobPayload) Descriptor() ([]byte, []int) { return fileDescriptorJobs, []int{3} }

type isJobPayload_Details interface {
	isJobPayload_Details()
	MarshalTo([]byte) (int, error)
	Size() int
}

type JobPayload_Backup struct {
	Backup *BackupJobDetails `protobuf:"bytes,10,opt,name=backup,oneof"`
}
type JobPayload_Restore struct {
	Restore *RestoreJobDetails `protobuf:"bytes,11,opt,name=restore,oneof"`
}
type JobPayload_SchemaChange struct {
	SchemaChange *SchemaChangeJobDetails `protobuf:"bytes,12,opt,name=schemaChange,oneof"`
}

func (*JobPayload_Backup) isJobPayload_Details()       {}
func (*JobPayload_Restore) isJobPayload_Details()      {}
func (*JobPayload_SchemaChange) isJobPayload_Details() {}

func (m *JobPayload) GetDetails() isJobPayload_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *JobPayload) GetBackup() *BackupJobDetails {
	if x, ok := m.GetDetails().(*JobPayload_Backup); ok {
		return x.Backup
	}
	return nil
}

func (m *JobPayload) GetRestore() *RestoreJobDetails {
	if x, ok := m.GetDetails().(*JobPayload_Restore); ok {
		return x.Restore
	}
	return nil
}

func (m *JobPayload) GetSchemaChange() *SchemaChangeJobDetails {
	if x, ok := m.GetDetails().(*JobPayload_SchemaChange); ok {
		return x.SchemaChange
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*JobPayload) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _JobPayload_OneofMarshaler, _JobPayload_OneofUnmarshaler, _JobPayload_OneofSizer, []interface{}{
		(*JobPayload_Backup)(nil),
		(*JobPayload_Restore)(nil),
		(*JobPayload_SchemaChange)(nil),
	}
}

func _JobPayload_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*JobPayload)
	// details
	switch x := m.Details.(type) {
	case *JobPayload_Backup:
		_ = b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Backup); err != nil {
			return err
		}
	case *JobPayload_Restore:
		_ = b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Restore); err != nil {
			return err
		}
	case *JobPayload_SchemaChange:
		_ = b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SchemaChange); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("JobPayload.Details has unexpected type %T", x)
	}
	return nil
}

func _JobPayload_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*JobPayload)
	switch tag {
	case 10: // details.backup
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BackupJobDetails)
		err := b.DecodeMessage(msg)
		m.Details = &JobPayload_Backup{msg}
		return true, err
	case 11: // details.restore
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RestoreJobDetails)
		err := b.DecodeMessage(msg)
		m.Details = &JobPayload_Restore{msg}
		return true, err
	case 12: // details.schemaChange
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SchemaChangeJobDetails)
		err := b.DecodeMessage(msg)
		m.Details = &JobPayload_SchemaChange{msg}
		return true, err
	default:
		return false, nil
	}
}

func _JobPayload_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*JobPayload)
	// details
	switch x := m.Details.(type) {
	case *JobPayload_Backup:
		s := proto.Size(x.Backup)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *JobPayload_Restore:
		s := proto.Size(x.Restore)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *JobPayload_SchemaChange:
		s := proto.Size(x.SchemaChange)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*BackupJobDetails)(nil), "cockroach.sql.BackupJobDetails")
	proto.RegisterType((*RestoreJobDetails)(nil), "cockroach.sql.RestoreJobDetails")
	proto.RegisterType((*SchemaChangeJobDetails)(nil), "cockroach.sql.SchemaChangeJobDetails")
	proto.RegisterType((*JobPayload)(nil), "cockroach.sql.JobPayload")
}
func (m *BackupJobDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupJobDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *RestoreJobDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RestoreJobDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *SchemaChangeJobDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SchemaChangeJobDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *JobPayload) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JobPayload) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Description) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.Username) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.Username)))
		i += copy(dAtA[i:], m.Username)
	}
	if m.StartedMicros != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.StartedMicros))
	}
	if m.FinishedMicros != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.FinishedMicros))
	}
	if m.ModifiedMicros != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.ModifiedMicros))
	}
	if len(m.DescriptorIDs) > 0 {
		dAtA2 := make([]byte, len(m.DescriptorIDs)*10)
		var j1 int
		for _, num := range m.DescriptorIDs {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		dAtA[i] = 0x32
		i++
		i = encodeVarintJobs(dAtA, i, uint64(j1))
		i += copy(dAtA[i:], dAtA2[:j1])
	}
	if m.FractionCompleted != 0 {
		dAtA[i] = 0x3d
		i++
		i = encodeFixed32Jobs(dAtA, i, uint32(math.Float32bits(float32(m.FractionCompleted))))
	}
	if len(m.Error) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintJobs(dAtA, i, uint64(len(m.Error)))
		i += copy(dAtA[i:], m.Error)
	}
	if m.Details != nil {
		nn3, err := m.Details.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn3
	}
	return i, nil
}

func (m *JobPayload_Backup) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Backup != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Backup.Size()))
		n4, err := m.Backup.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *JobPayload_Restore) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Restore != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.Restore.Size()))
		n5, err := m.Restore.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *JobPayload_SchemaChange) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SchemaChange != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintJobs(dAtA, i, uint64(m.SchemaChange.Size()))
		n6, err := m.SchemaChange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func encodeFixed64Jobs(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Jobs(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintJobs(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *BackupJobDetails) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *RestoreJobDetails) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *SchemaChangeJobDetails) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *JobPayload) Size() (n int) {
	var l int
	_ = l
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	if m.StartedMicros != 0 {
		n += 1 + sovJobs(uint64(m.StartedMicros))
	}
	if m.FinishedMicros != 0 {
		n += 1 + sovJobs(uint64(m.FinishedMicros))
	}
	if m.ModifiedMicros != 0 {
		n += 1 + sovJobs(uint64(m.ModifiedMicros))
	}
	if len(m.DescriptorIDs) > 0 {
		l = 0
		for _, e := range m.DescriptorIDs {
			l += sovJobs(uint64(e))
		}
		n += 1 + sovJobs(uint64(l)) + l
	}
	if m.FractionCompleted != 0 {
		n += 5
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovJobs(uint64(l))
	}
	if m.Details != nil {
		n += m.Details.Size()
	}
	return n
}

func (m *JobPayload_Backup) Size() (n int) {
	var l int
	_ = l
	if m.Backup != nil {
		l = m.Backup.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *JobPayload_Restore) Size() (n int) {
	var l int
	_ = l
	if m.Restore != nil {
		l = m.Restore.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}
func (m *JobPayload_SchemaChange) Size() (n int) {
	var l int
	_ = l
	if m.SchemaChange != nil {
		l = m.SchemaChange.Size()
		n += 1 + l + sovJobs(uint64(l))
	}
	return n
}

func sovJobs(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozJobs(x uint64) (n int) {
	return sovJobs(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *BackupJobDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupJobDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupJobDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RestoreJobDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RestoreJobDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RestoreJobDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SchemaChangeJobDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SchemaChangeJobDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SchemaChangeJobDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JobPayload) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JobPayload: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JobPayload: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartedMicros", wireType)
			}
			m.StartedMicros = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartedMicros |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FinishedMicros", wireType)
			}
			m.FinishedMicros = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FinishedMicros |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ModifiedMicros", wireType)
			}
			m.ModifiedMicros = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ModifiedMicros |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType == 0 {
				var v github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.DescriptorIDs = append(m.DescriptorIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthJobs
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowJobs
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (github_com_cockroachdb_cockroach_pkg_sql_sqlbase.ID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.DescriptorIDs = append(m.DescriptorIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorIDs", wireType)
			}
		case 7:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field FractionCompleted", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 4
			v = uint32(dAtA[iNdEx-4])
			v |= uint32(dAtA[iNdEx-3]) << 8
			v |= uint32(dAtA[iNdEx-2]) << 16
			v |= uint32(dAtA[iNdEx-1]) << 24
			m.FractionCompleted = float32(math.Float32frombits(v))
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Backup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &BackupJobDetails{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &JobPayload_Backup{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restore", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RestoreJobDetails{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &JobPayload_Restore{v}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaChange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJobs
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SchemaChangeJobDetails{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Details = &JobPayload_SchemaChange{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJobs(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthJobs
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipJobs(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowJobs
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowJobs
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthJobs
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowJobs
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipJobs(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthJobs = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowJobs   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/sql/jobs.proto", fileDescriptorJobs) }

var fileDescriptorJobs = []byte{
	// 458 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x92, 0xcf, 0x6e, 0xda, 0x4c,
	0x14, 0xc5, 0x71, 0x20, 0xfc, 0xb9, 0x04, 0xbe, 0x64, 0xbe, 0xa8, 0x1a, 0x45, 0xad, 0xb1, 0x22,
	0x45, 0xf5, 0xa6, 0xb6, 0xd4, 0xac, 0x2a, 0x75, 0x45, 0x58, 0x00, 0x55, 0xa5, 0xca, 0xdd, 0x75,
	0x83, 0xc6, 0xe3, 0xc1, 0x9e, 0x62, 0x73, 0xcd, 0x8c, 0x59, 0xf4, 0x2d, 0xfa, 0x58, 0x59, 0x66,
	0xd9, 0x55, 0xd4, 0xba, 0x6f, 0xd1, 0x55, 0x85, 0x8d, 0x81, 0x90, 0xee, 0x3c, 0xe7, 0x77, 0xce,
	0x95, 0x75, 0xcf, 0x85, 0x97, 0x1c, 0xf9, 0x42, 0x21, 0xe3, 0x91, 0x9b, 0x2e, 0x42, 0x57, 0xaf,
	0x62, 0xf7, 0x2b, 0xfa, 0xda, 0x49, 0x15, 0x66, 0x48, 0x7a, 0x3b, 0xea, 0xe8, 0x55, 0x7c, 0x75,
	0x19, 0x62, 0x88, 0x05, 0x71, 0x37, 0x5f, 0xa5, 0xe9, 0x9a, 0xc0, 0xf9, 0x90, 0xf1, 0xc5, 0x3a,
	0x9d, 0xa2, 0x3f, 0x12, 0x19, 0x93, 0xb1, 0xbe, 0xfe, 0x1f, 0x2e, 0x3c, 0xa1, 0x33, 0x54, 0xe2,
	0x40, 0xa4, 0xf0, 0xe2, 0x33, 0x8f, 0x44, 0xc2, 0xee, 0x22, 0xb6, 0x0c, 0x0f, 0xc9, 0x43, 0x03,
	0x60, 0x8a, 0xfe, 0x27, 0xf6, 0x2d, 0x46, 0x16, 0x10, 0x0b, 0xba, 0x81, 0xd0, 0x5c, 0xc9, 0x34,
	0x93, 0xb8, 0xa4, 0x86, 0x65, 0xd8, 0x1d, 0xef, 0x50, 0x22, 0x57, 0xd0, 0x5e, 0x6b, 0xa1, 0x96,
	0x2c, 0x11, 0xf4, 0xa4, 0xc0, 0xbb, 0x37, 0xb9, 0x81, 0xbe, 0xce, 0x98, 0xca, 0x44, 0x30, 0x4b,
	0x24, 0x57, 0xa8, 0x69, 0xdd, 0x32, 0xec, 0xba, 0xd7, 0xdb, 0xaa, 0x1f, 0x0b, 0x91, 0xbc, 0x86,
	0xff, 0xe6, 0x72, 0x29, 0x75, 0xb4, 0xf7, 0x35, 0x0a, 0x5f, 0xbf, 0x92, 0xf7, 0xc6, 0x04, 0x03,
	0x39, 0x97, 0x7b, 0xe3, 0x69, 0x69, 0xac, 0xe4, 0xad, 0x11, 0xa1, 0x5f, 0xfd, 0x23, 0xaa, 0x99,
	0x0c, 0x34, 0x6d, 0x5a, 0x75, 0xbb, 0x37, 0x1c, 0xe7, 0x8f, 0x83, 0xde, 0x68, 0x47, 0x26, 0x23,
	0xfd, 0xe7, 0x71, 0x70, 0x1b, 0xca, 0x2c, 0x5a, 0xfb, 0x0e, 0xc7, 0xc4, 0xdd, 0x6d, 0x39, 0xf0,
	0xdd, 0xe7, 0x7d, 0xe8, 0x55, 0xec, 0x33, 0x2d, 0x9c, 0xc9, 0xc8, 0xeb, 0xed, 0xe7, 0x4f, 0x02,
	0x4d, 0xde, 0x00, 0x99, 0x2b, 0xc6, 0x37, 0x1b, 0x99, 0x71, 0x4c, 0xd2, 0x58, 0x64, 0x22, 0xa0,
	0x2d, 0xcb, 0xb0, 0x4f, 0xbc, 0x8b, 0x8a, 0xdc, 0x55, 0x80, 0x5c, 0xc2, 0xa9, 0x50, 0x0a, 0x15,
	0x6d, 0x17, 0x1b, 0x2b, 0x1f, 0xe4, 0x1d, 0x34, 0xfd, 0xa2, 0x3e, 0x0a, 0x96, 0x61, 0x77, 0xdf,
	0x0e, 0x9c, 0x27, 0xa5, 0x3b, 0xc7, 0xdd, 0x8e, 0x6b, 0xde, 0x36, 0x40, 0xde, 0x43, 0x4b, 0x95,
	0x2d, 0xd3, 0x6e, 0x91, 0xb5, 0x8e, 0xb2, 0xcf, 0x6e, 0x60, 0x5c, 0xf3, 0xaa, 0x08, 0xf9, 0x00,
	0x67, 0xfa, 0xe0, 0x1c, 0xe8, 0x59, 0x31, 0xe2, 0xe6, 0x68, 0xc4, 0xbf, 0x2f, 0x66, 0x5c, 0xf3,
	0x9e, 0x84, 0x87, 0x1d, 0x68, 0x05, 0x25, 0x9a, 0x36, 0xda, 0x9d, 0x73, 0x18, 0xbe, 0xba, 0xff,
	0x65, 0xd6, 0xee, 0x73, 0xd3, 0x78, 0xc8, 0x4d, 0xe3, 0x47, 0x6e, 0x1a, 0x3f, 0x73, 0xd3, 0xf8,
	0xfe, 0xdb, 0xac, 0x7d, 0xa9, 0x6f, 0x16, 0xda, 0x2c, 0x6e, 0xf7, 0xf6, 0x6f, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x32, 0x45, 0xbd, 0x6d, 0x00, 0x03, 0x00, 0x00,
}
