// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateChannelRequest method.
//    req, resp := client.CreateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel
func (c *MediaLive) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/channels",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannel API operation for AWS Elemental MediaLive.
//
// Creates a new channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnprocessableEntityException "UnprocessableEntityException"
//
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeConflictException "ConflictException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel
func (c *MediaLive) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInput = "CreateInput"

// CreateInputRequest generates a "aws/request.Request" representing the
// client's request for the CreateInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInput for more information on using the CreateInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInputRequest method.
//    req, resp := client.CreateInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput
func (c *MediaLive) CreateInputRequest(input *CreateInputInput) (req *request.Request, output *CreateInputOutput) {
	op := &request.Operation{
		Name:       opCreateInput,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputs",
	}

	if input == nil {
		input = &CreateInputInput{}
	}

	output = &CreateInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInput API operation for AWS Elemental MediaLive.
//
// Create an input
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateInput for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput
func (c *MediaLive) CreateInput(input *CreateInputInput) (*CreateInputOutput, error) {
	req, out := c.CreateInputRequest(input)
	return out, req.Send()
}

// CreateInputWithContext is the same as CreateInput with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateInputWithContext(ctx aws.Context, input *CreateInputInput, opts ...request.Option) (*CreateInputOutput, error) {
	req, out := c.CreateInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInputSecurityGroup = "CreateInputSecurityGroup"

// CreateInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInputSecurityGroup for more information on using the CreateInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInputSecurityGroupRequest method.
//    req, resp := client.CreateInputSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup
func (c *MediaLive) CreateInputSecurityGroupRequest(input *CreateInputSecurityGroupInput) (req *request.Request, output *CreateInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateInputSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputSecurityGroups",
	}

	if input == nil {
		input = &CreateInputSecurityGroupInput{}
	}

	output = &CreateInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// Creates a Input Security Group
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateInputSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup
func (c *MediaLive) CreateInputSecurityGroup(input *CreateInputSecurityGroupInput) (*CreateInputSecurityGroupOutput, error) {
	req, out := c.CreateInputSecurityGroupRequest(input)
	return out, req.Send()
}

// CreateInputSecurityGroupWithContext is the same as CreateInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateInputSecurityGroupWithContext(ctx aws.Context, input *CreateInputSecurityGroupInput, opts ...request.Option) (*CreateInputSecurityGroupOutput, error) {
	req, out := c.CreateInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteChannelRequest method.
//    req, resp := client.DeleteChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel
func (c *MediaLive) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/channels/{channelId}",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteChannel API operation for AWS Elemental MediaLive.
//
// Starts deletion of channel. The associated outputs are also deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeConflictException "ConflictException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel
func (c *MediaLive) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInput = "DeleteInput"

// DeleteInputRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInput for more information on using the DeleteInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInputRequest method.
//    req, resp := client.DeleteInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput
func (c *MediaLive) DeleteInputRequest(input *DeleteInputInput) (req *request.Request, output *DeleteInputOutput) {
	op := &request.Operation{
		Name:       opDeleteInput,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/inputs/{inputId}",
	}

	if input == nil {
		input = &DeleteInputInput{}
	}

	output = &DeleteInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInput API operation for AWS Elemental MediaLive.
//
// Deletes the input end point
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteInput for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeConflictException "ConflictException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput
func (c *MediaLive) DeleteInput(input *DeleteInputInput) (*DeleteInputOutput, error) {
	req, out := c.DeleteInputRequest(input)
	return out, req.Send()
}

// DeleteInputWithContext is the same as DeleteInput with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteInputWithContext(ctx aws.Context, input *DeleteInputInput, opts ...request.Option) (*DeleteInputOutput, error) {
	req, out := c.DeleteInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInputSecurityGroup = "DeleteInputSecurityGroup"

// DeleteInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInputSecurityGroup for more information on using the DeleteInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInputSecurityGroupRequest method.
//    req, resp := client.DeleteInputSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup
func (c *MediaLive) DeleteInputSecurityGroupRequest(input *DeleteInputSecurityGroupInput) (req *request.Request, output *DeleteInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteInputSecurityGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/inputSecurityGroups/{inputSecurityGroupId}",
	}

	if input == nil {
		input = &DeleteInputSecurityGroupInput{}
	}

	output = &DeleteInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// Deletes an Input Security Group
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteInputSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup
func (c *MediaLive) DeleteInputSecurityGroup(input *DeleteInputSecurityGroupInput) (*DeleteInputSecurityGroupOutput, error) {
	req, out := c.DeleteInputSecurityGroupRequest(input)
	return out, req.Send()
}

// DeleteInputSecurityGroupWithContext is the same as DeleteInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteInputSecurityGroupWithContext(ctx aws.Context, input *DeleteInputSecurityGroupInput, opts ...request.Option) (*DeleteInputSecurityGroupOutput, error) {
	req, out := c.DeleteInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannel = "DescribeChannel"

// DescribeChannelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannel for more information on using the DescribeChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeChannelRequest method.
//    req, resp := client.DescribeChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel
func (c *MediaLive) DescribeChannelRequest(input *DescribeChannelInput) (req *request.Request, output *DescribeChannelOutput) {
	op := &request.Operation{
		Name:       opDescribeChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/channels/{channelId}",
	}

	if input == nil {
		input = &DescribeChannelInput{}
	}

	output = &DescribeChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannel API operation for AWS Elemental MediaLive.
//
// Gets details about a channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel
func (c *MediaLive) DescribeChannel(input *DescribeChannelInput) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	return out, req.Send()
}

// DescribeChannelWithContext is the same as DescribeChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeChannelWithContext(ctx aws.Context, input *DescribeChannelInput, opts ...request.Option) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInput = "DescribeInput"

// DescribeInputRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInput for more information on using the DescribeInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInputRequest method.
//    req, resp := client.DescribeInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput
func (c *MediaLive) DescribeInputRequest(input *DescribeInputInput) (req *request.Request, output *DescribeInputOutput) {
	op := &request.Operation{
		Name:       opDescribeInput,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputs/{inputId}",
	}

	if input == nil {
		input = &DescribeInputInput{}
	}

	output = &DescribeInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInput API operation for AWS Elemental MediaLive.
//
// Produces details about an input
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeInput for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput
func (c *MediaLive) DescribeInput(input *DescribeInputInput) (*DescribeInputOutput, error) {
	req, out := c.DescribeInputRequest(input)
	return out, req.Send()
}

// DescribeInputWithContext is the same as DescribeInput with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeInputWithContext(ctx aws.Context, input *DescribeInputInput, opts ...request.Option) (*DescribeInputOutput, error) {
	req, out := c.DescribeInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInputSecurityGroup = "DescribeInputSecurityGroup"

// DescribeInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInputSecurityGroup for more information on using the DescribeInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInputSecurityGroupRequest method.
//    req, resp := client.DescribeInputSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup
func (c *MediaLive) DescribeInputSecurityGroupRequest(input *DescribeInputSecurityGroupInput) (req *request.Request, output *DescribeInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeInputSecurityGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputSecurityGroups/{inputSecurityGroupId}",
	}

	if input == nil {
		input = &DescribeInputSecurityGroupInput{}
	}

	output = &DescribeInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// Produces a summary of an Input Security Group
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeInputSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup
func (c *MediaLive) DescribeInputSecurityGroup(input *DescribeInputSecurityGroupInput) (*DescribeInputSecurityGroupOutput, error) {
	req, out := c.DescribeInputSecurityGroupRequest(input)
	return out, req.Send()
}

// DescribeInputSecurityGroupWithContext is the same as DescribeInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeInputSecurityGroupWithContext(ctx aws.Context, input *DescribeInputSecurityGroupInput, opts ...request.Option) (*DescribeInputSecurityGroupOutput, error) {
	req, out := c.DescribeInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListChannelsRequest method.
//    req, resp := client.ListChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels
func (c *MediaLive) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannels API operation for AWS Elemental MediaLive.
//
// Produces list of channels that have been created
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListChannels for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels
func (c *MediaLive) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListChannels operation.
//    pageNum := 0
//    err := client.ListChannelsPages(params,
//        func(page *ListChannelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListChannelsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListInputSecurityGroups = "ListInputSecurityGroups"

// ListInputSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListInputSecurityGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInputSecurityGroups for more information on using the ListInputSecurityGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInputSecurityGroupsRequest method.
//    req, resp := client.ListInputSecurityGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups
func (c *MediaLive) ListInputSecurityGroupsRequest(input *ListInputSecurityGroupsInput) (req *request.Request, output *ListInputSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opListInputSecurityGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputSecurityGroups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputSecurityGroupsInput{}
	}

	output = &ListInputSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInputSecurityGroups API operation for AWS Elemental MediaLive.
//
// Produces a list of Input Security Groups for an account
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListInputSecurityGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups
func (c *MediaLive) ListInputSecurityGroups(input *ListInputSecurityGroupsInput) (*ListInputSecurityGroupsOutput, error) {
	req, out := c.ListInputSecurityGroupsRequest(input)
	return out, req.Send()
}

// ListInputSecurityGroupsWithContext is the same as ListInputSecurityGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListInputSecurityGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputSecurityGroupsWithContext(ctx aws.Context, input *ListInputSecurityGroupsInput, opts ...request.Option) (*ListInputSecurityGroupsOutput, error) {
	req, out := c.ListInputSecurityGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInputSecurityGroupsPages iterates over the pages of a ListInputSecurityGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInputSecurityGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInputSecurityGroups operation.
//    pageNum := 0
//    err := client.ListInputSecurityGroupsPages(params,
//        func(page *ListInputSecurityGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) ListInputSecurityGroupsPages(input *ListInputSecurityGroupsInput, fn func(*ListInputSecurityGroupsOutput, bool) bool) error {
	return c.ListInputSecurityGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInputSecurityGroupsPagesWithContext same as ListInputSecurityGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputSecurityGroupsPagesWithContext(ctx aws.Context, input *ListInputSecurityGroupsInput, fn func(*ListInputSecurityGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInputSecurityGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInputSecurityGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListInputSecurityGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListInputs = "ListInputs"

// ListInputsRequest generates a "aws/request.Request" representing the
// client's request for the ListInputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInputs for more information on using the ListInputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInputsRequest method.
//    req, resp := client.ListInputsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs
func (c *MediaLive) ListInputsRequest(input *ListInputsInput) (req *request.Request, output *ListInputsOutput) {
	op := &request.Operation{
		Name:       opListInputs,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputsInput{}
	}

	output = &ListInputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInputs API operation for AWS Elemental MediaLive.
//
// Produces list of inputs that have been created
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListInputs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs
func (c *MediaLive) ListInputs(input *ListInputsInput) (*ListInputsOutput, error) {
	req, out := c.ListInputsRequest(input)
	return out, req.Send()
}

// ListInputsWithContext is the same as ListInputs with the addition of
// the ability to pass a context and additional request options.
//
// See ListInputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputsWithContext(ctx aws.Context, input *ListInputsInput, opts ...request.Option) (*ListInputsOutput, error) {
	req, out := c.ListInputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInputsPages iterates over the pages of a ListInputs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInputs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInputs operation.
//    pageNum := 0
//    err := client.ListInputsPages(params,
//        func(page *ListInputsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaLive) ListInputsPages(input *ListInputsInput, fn func(*ListInputsOutput, bool) bool) error {
	return c.ListInputsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInputsPagesWithContext same as ListInputsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputsPagesWithContext(ctx aws.Context, input *ListInputsInput, fn func(*ListInputsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInputsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInputsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListInputsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opStartChannel = "StartChannel"

// StartChannelRequest generates a "aws/request.Request" representing the
// client's request for the StartChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartChannel for more information on using the StartChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartChannelRequest method.
//    req, resp := client.StartChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel
func (c *MediaLive) StartChannelRequest(input *StartChannelInput) (req *request.Request, output *StartChannelOutput) {
	op := &request.Operation{
		Name:       opStartChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/channels/{channelId}/start",
	}

	if input == nil {
		input = &StartChannelInput{}
	}

	output = &StartChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartChannel API operation for AWS Elemental MediaLive.
//
// Starts an existing channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StartChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeConflictException "ConflictException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel
func (c *MediaLive) StartChannel(input *StartChannelInput) (*StartChannelOutput, error) {
	req, out := c.StartChannelRequest(input)
	return out, req.Send()
}

// StartChannelWithContext is the same as StartChannel with the addition of
// the ability to pass a context and additional request options.
//
// See StartChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StartChannelWithContext(ctx aws.Context, input *StartChannelInput, opts ...request.Option) (*StartChannelOutput, error) {
	req, out := c.StartChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopChannel = "StopChannel"

// StopChannelRequest generates a "aws/request.Request" representing the
// client's request for the StopChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopChannel for more information on using the StopChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopChannelRequest method.
//    req, resp := client.StopChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel
func (c *MediaLive) StopChannelRequest(input *StopChannelInput) (req *request.Request, output *StopChannelOutput) {
	op := &request.Operation{
		Name:       opStopChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/channels/{channelId}/stop",
	}

	if input == nil {
		input = &StopChannelInput{}
	}

	output = &StopChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopChannel API operation for AWS Elemental MediaLive.
//
// Stops a running channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StopChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeConflictException "ConflictException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel
func (c *MediaLive) StopChannel(input *StopChannelInput) (*StopChannelOutput, error) {
	req, out := c.StopChannelRequest(input)
	return out, req.Send()
}

// StopChannelWithContext is the same as StopChannel with the addition of
// the ability to pass a context and additional request options.
//
// See StopChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StopChannelWithContext(ctx aws.Context, input *StopChannelInput, opts ...request.Option) (*StopChannelOutput, error) {
	req, out := c.StopChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateChannelRequest method.
//    req, resp := client.UpdateChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel
func (c *MediaLive) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/channels/{channelId}",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannel API operation for AWS Elemental MediaLive.
//
// Updates a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnprocessableEntityException "UnprocessableEntityException"
//
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeConflictException "ConflictException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel
func (c *MediaLive) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInput = "UpdateInput"

// UpdateInputRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInput for more information on using the UpdateInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInputRequest method.
//    req, resp := client.UpdateInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput
func (c *MediaLive) UpdateInputRequest(input *UpdateInputInput) (req *request.Request, output *UpdateInputOutput) {
	op := &request.Operation{
		Name:       opUpdateInput,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/inputs/{inputId}",
	}

	if input == nil {
		input = &UpdateInputInput{}
	}

	output = &UpdateInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateInput API operation for AWS Elemental MediaLive.
//
// Updates an input.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateInput for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeConflictException "ConflictException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput
func (c *MediaLive) UpdateInput(input *UpdateInputInput) (*UpdateInputOutput, error) {
	req, out := c.UpdateInputRequest(input)
	return out, req.Send()
}

// UpdateInputWithContext is the same as UpdateInput with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateInputWithContext(ctx aws.Context, input *UpdateInputInput, opts ...request.Option) (*UpdateInputOutput, error) {
	req, out := c.UpdateInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInputSecurityGroup = "UpdateInputSecurityGroup"

// UpdateInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInputSecurityGroup for more information on using the UpdateInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInputSecurityGroupRequest method.
//    req, resp := client.UpdateInputSecurityGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup
func (c *MediaLive) UpdateInputSecurityGroupRequest(input *UpdateInputSecurityGroupInput) (req *request.Request, output *UpdateInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateInputSecurityGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/inputSecurityGroups/{inputSecurityGroupId}",
	}

	if input == nil {
		input = &UpdateInputSecurityGroupInput{}
	}

	output = &UpdateInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// Update an Input Security Group's Whilelists.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateInputSecurityGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeBadGatewayException "BadGatewayException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeGatewayTimeoutException "GatewayTimeoutException"
//
//   * ErrCodeConflictException "ConflictException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup
func (c *MediaLive) UpdateInputSecurityGroup(input *UpdateInputSecurityGroupInput) (*UpdateInputSecurityGroupOutput, error) {
	req, out := c.UpdateInputSecurityGroupRequest(input)
	return out, req.Send()
}

// UpdateInputSecurityGroupWithContext is the same as UpdateInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateInputSecurityGroupWithContext(ctx aws.Context, input *UpdateInputSecurityGroupInput, opts ...request.Option) (*UpdateInputSecurityGroupOutput, error) {
	req, out := c.UpdateInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AacSettings struct {
	_ struct{} `type:"structure"`

	// Average bitrate in bits/second. Valid values depend on rate control mode
	// and profile.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control
	// mode and profile. The adReceiverMix setting receives a stereo description
	// plus control track and emits a mono AAC encode of the description track,
	// with control data emitted in the PES header as per ETSI TS 101 154 Annex
	// E.
	CodingMode *string `locationName:"codingMode" type:"string" enum:"AacCodingMode"`

	// Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD
	// (narration) as a stereo pair. The Audio Type field (audioType) will be set
	// to 3, which signals to downstream systems that this stream contains "broadcaster
	// mixed AD". Note that the input received by the encoder must contain pre-mixed
	// audio; the encoder does not perform the mixing. The values in audioTypeControl
	// and audioType (in AudioDescription) are ignored when set to broadcasterMixedAd.Leave
	// set to "normal" when input does not contain pre-mixed audio + AD.
	InputType *string `locationName:"inputType" type:"string" enum:"AacInputType"`

	// AAC Profile.
	Profile *string `locationName:"profile" type:"string" enum:"AacProfile"`

	// Rate Control Mode.
	RateControlMode *string `locationName:"rateControlMode" type:"string" enum:"AacRateControlMode"`

	// Sets LATM / LOAS AAC output for raw containers.
	RawFormat *string `locationName:"rawFormat" type:"string" enum:"AacRawFormat"`

	// Sample rate in Hz. Valid values depend on rate control mode and profile.
	SampleRate *float64 `locationName:"sampleRate" type:"double"`

	// Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport
	// Stream containers.
	Spec *string `locationName:"spec" type:"string" enum:"AacSpec"`

	// VBR Quality Level - Only used if rateControlMode is VBR.
	VbrQuality *string `locationName:"vbrQuality" type:"string" enum:"AacVbrQuality"`
}

// String returns the string representation
func (s AacSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AacSettings) GoString() string {
	return s.String()
}

// SetBitrate sets the Bitrate field's value.
func (s *AacSettings) SetBitrate(v float64) *AacSettings {
	s.Bitrate = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *AacSettings) SetCodingMode(v string) *AacSettings {
	s.CodingMode = &v
	return s
}

// SetInputType sets the InputType field's value.
func (s *AacSettings) SetInputType(v string) *AacSettings {
	s.InputType = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *AacSettings) SetProfile(v string) *AacSettings {
	s.Profile = &v
	return s
}

// SetRateControlMode sets the RateControlMode field's value.
func (s *AacSettings) SetRateControlMode(v string) *AacSettings {
	s.RateControlMode = &v
	return s
}

// SetRawFormat sets the RawFormat field's value.
func (s *AacSettings) SetRawFormat(v string) *AacSettings {
	s.RawFormat = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *AacSettings) SetSampleRate(v float64) *AacSettings {
	s.SampleRate = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *AacSettings) SetSpec(v string) *AacSettings {
	s.Spec = &v
	return s
}

// SetVbrQuality sets the VbrQuality field's value.
func (s *AacSettings) SetVbrQuality(v string) *AacSettings {
	s.VbrQuality = &v
	return s
}

type Ac3Settings struct {
	_ struct{} `type:"structure"`

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Specifies the bitstream mode (bsmod) for the emitted AC-3 stream. See ATSC
	// A/52-2012 for background on these values.
	BitstreamMode *string `locationName:"bitstreamMode" type:"string" enum:"Ac3BitstreamMode"`

	// Dolby Digital coding mode. Determines number of channels.
	CodingMode *string `locationName:"codingMode" type:"string" enum:"Ac3CodingMode"`

	// Sets the dialnorm for the output. If excluded and input audio is Dolby Digital,
	// dialnorm will be passed through.
	Dialnorm *int64 `locationName:"dialnorm" min:"1" type:"integer"`

	// If set to filmStandard, adds dynamic range compression signaling to the output
	// bitstream as defined in the Dolby Digital specification.
	DrcProfile *string `locationName:"drcProfile" type:"string" enum:"Ac3DrcProfile"`

	// When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior
	// to encoding. Only valid in codingMode32Lfe mode.
	LfeFilter *string `locationName:"lfeFilter" type:"string" enum:"Ac3LfeFilter"`

	// When set to "followInput", encoder metadata will be sourced from the DD,
	// DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied
	// from one of these streams, then the static metadata settings will be used.
	MetadataControl *string `locationName:"metadataControl" type:"string" enum:"Ac3MetadataControl"`
}

// String returns the string representation
func (s Ac3Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ac3Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ac3Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ac3Settings"}
	if s.Dialnorm != nil && *s.Dialnorm < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Dialnorm", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBitrate sets the Bitrate field's value.
func (s *Ac3Settings) SetBitrate(v float64) *Ac3Settings {
	s.Bitrate = &v
	return s
}

// SetBitstreamMode sets the BitstreamMode field's value.
func (s *Ac3Settings) SetBitstreamMode(v string) *Ac3Settings {
	s.BitstreamMode = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *Ac3Settings) SetCodingMode(v string) *Ac3Settings {
	s.CodingMode = &v
	return s
}

// SetDialnorm sets the Dialnorm field's value.
func (s *Ac3Settings) SetDialnorm(v int64) *Ac3Settings {
	s.Dialnorm = &v
	return s
}

// SetDrcProfile sets the DrcProfile field's value.
func (s *Ac3Settings) SetDrcProfile(v string) *Ac3Settings {
	s.DrcProfile = &v
	return s
}

// SetLfeFilter sets the LfeFilter field's value.
func (s *Ac3Settings) SetLfeFilter(v string) *Ac3Settings {
	s.LfeFilter = &v
	return s
}

// SetMetadataControl sets the MetadataControl field's value.
func (s *Ac3Settings) SetMetadataControl(v string) *Ac3Settings {
	s.MetadataControl = &v
	return s
}

type ArchiveContainerSettings struct {
	_ struct{} `type:"structure"`

	M2tsSettings *M2tsSettings `locationName:"m2tsSettings" type:"structure"`
}

// String returns the string representation
func (s ArchiveContainerSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveContainerSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveContainerSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveContainerSettings"}
	if s.M2tsSettings != nil {
		if err := s.M2tsSettings.Validate(); err != nil {
			invalidParams.AddNested("M2tsSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetM2tsSettings sets the M2tsSettings field's value.
func (s *ArchiveContainerSettings) SetM2tsSettings(v *M2tsSettings) *ArchiveContainerSettings {
	s.M2tsSettings = v
	return s
}

type ArchiveGroupSettings struct {
	_ struct{} `type:"structure"`

	// A directory and base filename where archive files should be written. If the
	// base filename portion of the URI is left blank, the base filename of the
	// first input will be automatically inserted.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Number of seconds to write to archive file before closing and starting a
	// new one.
	RolloverInterval *int64 `locationName:"rolloverInterval" min:"1" type:"integer"`
}

// String returns the string representation
func (s ArchiveGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveGroupSettings"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.RolloverInterval != nil && *s.RolloverInterval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RolloverInterval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *ArchiveGroupSettings) SetDestination(v *OutputLocationRef) *ArchiveGroupSettings {
	s.Destination = v
	return s
}

// SetRolloverInterval sets the RolloverInterval field's value.
func (s *ArchiveGroupSettings) SetRolloverInterval(v int64) *ArchiveGroupSettings {
	s.RolloverInterval = &v
	return s
}

type ArchiveOutputSettings struct {
	_ struct{} `type:"structure"`

	// Settings specific to the container type of the file.
	//
	// ContainerSettings is a required field
	ContainerSettings *ArchiveContainerSettings `locationName:"containerSettings" type:"structure" required:"true"`

	// Output file extension. If excluded, this will be auto-selected from the container
	// type.
	Extension *string `locationName:"extension" type:"string"`

	// String concatenated to the end of the destination filename. Required for
	// multiple outputs of the same type.
	NameModifier *string `locationName:"nameModifier" type:"string"`
}

// String returns the string representation
func (s ArchiveOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveOutputSettings"}
	if s.ContainerSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerSettings"))
	}
	if s.ContainerSettings != nil {
		if err := s.ContainerSettings.Validate(); err != nil {
			invalidParams.AddNested("ContainerSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerSettings sets the ContainerSettings field's value.
func (s *ArchiveOutputSettings) SetContainerSettings(v *ArchiveContainerSettings) *ArchiveOutputSettings {
	s.ContainerSettings = v
	return s
}

// SetExtension sets the Extension field's value.
func (s *ArchiveOutputSettings) SetExtension(v string) *ArchiveOutputSettings {
	s.Extension = &v
	return s
}

// SetNameModifier sets the NameModifier field's value.
func (s *ArchiveOutputSettings) SetNameModifier(v string) *ArchiveOutputSettings {
	s.NameModifier = &v
	return s
}

type AribDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AribDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AribDestinationSettings) GoString() string {
	return s.String()
}

type AribSourceSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AribSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AribSourceSettings) GoString() string {
	return s.String()
}

type AudioChannelMapping struct {
	_ struct{} `type:"structure"`

	// Indices and gain values for each input channel that should be remixed into
	// this output channel.
	//
	// InputChannelLevels is a required field
	InputChannelLevels []*InputChannelLevel `locationName:"inputChannelLevels" type:"list" required:"true"`

	// The index of the output channel being produced.
	//
	// OutputChannel is a required field
	OutputChannel *int64 `locationName:"outputChannel" type:"integer" required:"true"`
}

// String returns the string representation
func (s AudioChannelMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioChannelMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioChannelMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioChannelMapping"}
	if s.InputChannelLevels == nil {
		invalidParams.Add(request.NewErrParamRequired("InputChannelLevels"))
	}
	if s.OutputChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputChannel"))
	}
	if s.InputChannelLevels != nil {
		for i, v := range s.InputChannelLevels {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputChannelLevels", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputChannelLevels sets the InputChannelLevels field's value.
func (s *AudioChannelMapping) SetInputChannelLevels(v []*InputChannelLevel) *AudioChannelMapping {
	s.InputChannelLevels = v
	return s
}

// SetOutputChannel sets the OutputChannel field's value.
func (s *AudioChannelMapping) SetOutputChannel(v int64) *AudioChannelMapping {
	s.OutputChannel = &v
	return s
}

type AudioCodecSettings struct {
	_ struct{} `type:"structure"`

	AacSettings *AacSettings `locationName:"aacSettings" type:"structure"`

	Ac3Settings *Ac3Settings `locationName:"ac3Settings" type:"structure"`

	Eac3Settings *Eac3Settings `locationName:"eac3Settings" type:"structure"`

	Mp2Settings *Mp2Settings `locationName:"mp2Settings" type:"structure"`

	PassThroughSettings *PassThroughSettings `locationName:"passThroughSettings" type:"structure"`
}

// String returns the string representation
func (s AudioCodecSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioCodecSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioCodecSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioCodecSettings"}
	if s.Ac3Settings != nil {
		if err := s.Ac3Settings.Validate(); err != nil {
			invalidParams.AddNested("Ac3Settings", err.(request.ErrInvalidParams))
		}
	}
	if s.Eac3Settings != nil {
		if err := s.Eac3Settings.Validate(); err != nil {
			invalidParams.AddNested("Eac3Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAacSettings sets the AacSettings field's value.
func (s *AudioCodecSettings) SetAacSettings(v *AacSettings) *AudioCodecSettings {
	s.AacSettings = v
	return s
}

// SetAc3Settings sets the Ac3Settings field's value.
func (s *AudioCodecSettings) SetAc3Settings(v *Ac3Settings) *AudioCodecSettings {
	s.Ac3Settings = v
	return s
}

// SetEac3Settings sets the Eac3Settings field's value.
func (s *AudioCodecSettings) SetEac3Settings(v *Eac3Settings) *AudioCodecSettings {
	s.Eac3Settings = v
	return s
}

// SetMp2Settings sets the Mp2Settings field's value.
func (s *AudioCodecSettings) SetMp2Settings(v *Mp2Settings) *AudioCodecSettings {
	s.Mp2Settings = v
	return s
}

// SetPassThroughSettings sets the PassThroughSettings field's value.
func (s *AudioCodecSettings) SetPassThroughSettings(v *PassThroughSettings) *AudioCodecSettings {
	s.PassThroughSettings = v
	return s
}

type AudioDescription struct {
	_ struct{} `type:"structure"`

	// Advanced audio normalization settings.
	AudioNormalizationSettings *AudioNormalizationSettings `locationName:"audioNormalizationSettings" type:"structure"`

	// The name of the AudioSelector used as the source for this AudioDescription.
	//
	// AudioSelectorName is a required field
	AudioSelectorName *string `locationName:"audioSelectorName" type:"string" required:"true"`

	// Applies only if audioTypeControl is useConfigured. The values for audioType
	// are defined in ISO-IEC 13818-1.
	AudioType *string `locationName:"audioType" type:"string" enum:"AudioType"`

	// Determines how audio type is determined. followInput: If the input contains
	// an ISO 639 audioType, then that value is passed through to the output. If
	// the input contains no ISO 639 audioType, the value in Audio Type is included
	// in the output. useConfigured: The value in Audio Type is included in the
	// output.Note that this field and audioType are both ignored if inputType is
	// broadcasterMixedAd.
	AudioTypeControl *string `locationName:"audioTypeControl" type:"string" enum:"AudioDescriptionAudioTypeControl"`

	// Audio codec settings.
	CodecSettings *AudioCodecSettings `locationName:"codecSettings" type:"structure"`

	// Indicates the language of the audio output track. Only used if languageControlMode
	// is useConfigured, or there is no ISO 639 language code specified in the input.
	LanguageCode *string `locationName:"languageCode" min:"3" type:"string"`

	// Choosing followInput will cause the ISO 639 language code of the output to
	// follow the ISO 639 language code of the input. The languageCode will be used
	// when useConfigured is set, or when followInput is selected but there is no
	// ISO 639 language code specified by the input.
	LanguageCodeControl *string `locationName:"languageCodeControl" type:"string" enum:"AudioDescriptionLanguageCodeControl"`

	// The name of this AudioDescription. Outputs will use this name to uniquely
	// identify this AudioDescription. Description names should be unique within
	// this Live Event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Settings that control how input audio channels are remixed into the output
	// audio channels.
	RemixSettings *RemixSettings `locationName:"remixSettings" type:"structure"`

	// Used for MS Smooth and Apple HLS outputs. Indicates the name displayed by
	// the player (eg. English, or Director Commentary).
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s AudioDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioDescription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioDescription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioDescription"}
	if s.AudioSelectorName == nil {
		invalidParams.Add(request.NewErrParamRequired("AudioSelectorName"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageCode", 3))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.CodecSettings != nil {
		if err := s.CodecSettings.Validate(); err != nil {
			invalidParams.AddNested("CodecSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.RemixSettings != nil {
		if err := s.RemixSettings.Validate(); err != nil {
			invalidParams.AddNested("RemixSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioNormalizationSettings sets the AudioNormalizationSettings field's value.
func (s *AudioDescription) SetAudioNormalizationSettings(v *AudioNormalizationSettings) *AudioDescription {
	s.AudioNormalizationSettings = v
	return s
}

// SetAudioSelectorName sets the AudioSelectorName field's value.
func (s *AudioDescription) SetAudioSelectorName(v string) *AudioDescription {
	s.AudioSelectorName = &v
	return s
}

// SetAudioType sets the AudioType field's value.
func (s *AudioDescription) SetAudioType(v string) *AudioDescription {
	s.AudioType = &v
	return s
}

// SetAudioTypeControl sets the AudioTypeControl field's value.
func (s *AudioDescription) SetAudioTypeControl(v string) *AudioDescription {
	s.AudioTypeControl = &v
	return s
}

// SetCodecSettings sets the CodecSettings field's value.
func (s *AudioDescription) SetCodecSettings(v *AudioCodecSettings) *AudioDescription {
	s.CodecSettings = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *AudioDescription) SetLanguageCode(v string) *AudioDescription {
	s.LanguageCode = &v
	return s
}

// SetLanguageCodeControl sets the LanguageCodeControl field's value.
func (s *AudioDescription) SetLanguageCodeControl(v string) *AudioDescription {
	s.LanguageCodeControl = &v
	return s
}

// SetName sets the Name field's value.
func (s *AudioDescription) SetName(v string) *AudioDescription {
	s.Name = &v
	return s
}

// SetRemixSettings sets the RemixSettings field's value.
func (s *AudioDescription) SetRemixSettings(v *RemixSettings) *AudioDescription {
	s.RemixSettings = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *AudioDescription) SetStreamName(v string) *AudioDescription {
	s.StreamName = &v
	return s
}

type AudioLanguageSelection struct {
	_ struct{} `type:"structure"`

	// Selects a specific three-letter language code from within an audio source.
	//
	// LanguageCode is a required field
	LanguageCode *string `locationName:"languageCode" type:"string" required:"true"`

	// When set to "strict", the transport stream demux strictly identifies audio
	// streams by their language descriptor. If a PMT update occurs such that an
	// audio stream matching the initially selected language is no longer present
	// then mute will be encoded until the language returns. If "loose", then on
	// a PMT update the demux will choose another audio stream in the program with
	// the same stream type if it can't find one with the same language.
	LanguageSelectionPolicy *string `locationName:"languageSelectionPolicy" type:"string" enum:"AudioLanguageSelectionPolicy"`
}

// String returns the string representation
func (s AudioLanguageSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioLanguageSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioLanguageSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioLanguageSelection"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *AudioLanguageSelection) SetLanguageCode(v string) *AudioLanguageSelection {
	s.LanguageCode = &v
	return s
}

// SetLanguageSelectionPolicy sets the LanguageSelectionPolicy field's value.
func (s *AudioLanguageSelection) SetLanguageSelectionPolicy(v string) *AudioLanguageSelection {
	s.LanguageSelectionPolicy = &v
	return s
}

type AudioNormalizationSettings struct {
	_ struct{} `type:"structure"`

	// Audio normalization algorithm to use. itu17701 conforms to the CALM Act specification,
	// itu17702 conforms to the EBU R-128 specification.
	Algorithm *string `locationName:"algorithm" type:"string" enum:"AudioNormalizationAlgorithm"`

	// When set to correctAudio the output audio is corrected using the chosen algorithm.
	// If set to measureOnly, the audio will be measured but not adjusted.
	AlgorithmControl *string `locationName:"algorithmControl" type:"string" enum:"AudioNormalizationAlgorithmControl"`

	// Target LKFS(loudness) to adjust volume to. If no value is entered, a default
	// value will be used according to the chosen algorithm. The CALM Act (1770-1)
	// recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends
	// a target of -23 LKFS.
	TargetLkfs *float64 `locationName:"targetLkfs" type:"double"`
}

// String returns the string representation
func (s AudioNormalizationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioNormalizationSettings) GoString() string {
	return s.String()
}

// SetAlgorithm sets the Algorithm field's value.
func (s *AudioNormalizationSettings) SetAlgorithm(v string) *AudioNormalizationSettings {
	s.Algorithm = &v
	return s
}

// SetAlgorithmControl sets the AlgorithmControl field's value.
func (s *AudioNormalizationSettings) SetAlgorithmControl(v string) *AudioNormalizationSettings {
	s.AlgorithmControl = &v
	return s
}

// SetTargetLkfs sets the TargetLkfs field's value.
func (s *AudioNormalizationSettings) SetTargetLkfs(v float64) *AudioNormalizationSettings {
	s.TargetLkfs = &v
	return s
}

type AudioOnlyHlsSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the group to which the audio Rendition belongs.
	AudioGroupId *string `locationName:"audioGroupId" type:"string"`

	// For use with an audio only Stream. Must be a .jpg or .png file. If given,
	// this image will be used as the cover-art for the audio only output. Ideally,
	// it should be formatted for an iPhone screen for two reasons. The iPhone does
	// not resize the image, it crops a centered image on the top/bottom and left/right.
	// Additionally, this image file gets saved bit-for-bit into every 10-second
	// segment file, so will increase bandwidth by {image file size} * {segment
	// count} * {user count.}.
	AudioOnlyImage *InputLocation `locationName:"audioOnlyImage" type:"structure"`

	// Four types of audio-only tracks are supported:Audio-Only Variant StreamThe
	// client can play back this audio-only stream instead of video in low-bandwidth
	// scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.Alternate
	// Audio, Auto Select, DefaultAlternate rendition that the client should try
	// to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest
	// with DEFAULT=YES, AUTOSELECT=YESAlternate Audio, Auto Select, Not DefaultAlternate
	// rendition that the client may try to play back by default. Represented as
	// an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YESAlternate
	// Audio, not Auto SelectAlternate rendition that the client will not try to
	// play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with
	// DEFAULT=NO, AUTOSELECT=NO
	AudioTrackType *string `locationName:"audioTrackType" type:"string" enum:"AudioOnlyHlsTrackType"`
}

// String returns the string representation
func (s AudioOnlyHlsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioOnlyHlsSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioOnlyHlsSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioOnlyHlsSettings"}
	if s.AudioOnlyImage != nil {
		if err := s.AudioOnlyImage.Validate(); err != nil {
			invalidParams.AddNested("AudioOnlyImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioGroupId sets the AudioGroupId field's value.
func (s *AudioOnlyHlsSettings) SetAudioGroupId(v string) *AudioOnlyHlsSettings {
	s.AudioGroupId = &v
	return s
}

// SetAudioOnlyImage sets the AudioOnlyImage field's value.
func (s *AudioOnlyHlsSettings) SetAudioOnlyImage(v *InputLocation) *AudioOnlyHlsSettings {
	s.AudioOnlyImage = v
	return s
}

// SetAudioTrackType sets the AudioTrackType field's value.
func (s *AudioOnlyHlsSettings) SetAudioTrackType(v string) *AudioOnlyHlsSettings {
	s.AudioTrackType = &v
	return s
}

type AudioPidSelection struct {
	_ struct{} `type:"structure"`

	// Selects a specific PID from within a source.
	//
	// Pid is a required field
	Pid *int64 `locationName:"pid" type:"integer" required:"true"`
}

// String returns the string representation
func (s AudioPidSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioPidSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioPidSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioPidSelection"}
	if s.Pid == nil {
		invalidParams.Add(request.NewErrParamRequired("Pid"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPid sets the Pid field's value.
func (s *AudioPidSelection) SetPid(v int64) *AudioPidSelection {
	s.Pid = &v
	return s
}

type AudioSelector struct {
	_ struct{} `type:"structure"`

	// The name of this AudioSelector. AudioDescriptions will use this name to uniquely
	// identify this Selector. Selector names should be unique per input.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The audio selector settings.
	SelectorSettings *AudioSelectorSettings `locationName:"selectorSettings" type:"structure"`
}

// String returns the string representation
func (s AudioSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioSelector"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SelectorSettings != nil {
		if err := s.SelectorSettings.Validate(); err != nil {
			invalidParams.AddNested("SelectorSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AudioSelector) SetName(v string) *AudioSelector {
	s.Name = &v
	return s
}

// SetSelectorSettings sets the SelectorSettings field's value.
func (s *AudioSelector) SetSelectorSettings(v *AudioSelectorSettings) *AudioSelector {
	s.SelectorSettings = v
	return s
}

type AudioSelectorSettings struct {
	_ struct{} `type:"structure"`

	AudioLanguageSelection *AudioLanguageSelection `locationName:"audioLanguageSelection" type:"structure"`

	AudioPidSelection *AudioPidSelection `locationName:"audioPidSelection" type:"structure"`
}

// String returns the string representation
func (s AudioSelectorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioSelectorSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioSelectorSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioSelectorSettings"}
	if s.AudioLanguageSelection != nil {
		if err := s.AudioLanguageSelection.Validate(); err != nil {
			invalidParams.AddNested("AudioLanguageSelection", err.(request.ErrInvalidParams))
		}
	}
	if s.AudioPidSelection != nil {
		if err := s.AudioPidSelection.Validate(); err != nil {
			invalidParams.AddNested("AudioPidSelection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioLanguageSelection sets the AudioLanguageSelection field's value.
func (s *AudioSelectorSettings) SetAudioLanguageSelection(v *AudioLanguageSelection) *AudioSelectorSettings {
	s.AudioLanguageSelection = v
	return s
}

// SetAudioPidSelection sets the AudioPidSelection field's value.
func (s *AudioSelectorSettings) SetAudioPidSelection(v *AudioPidSelection) *AudioSelectorSettings {
	s.AudioPidSelection = v
	return s
}

type AvailBlanking struct {
	_ struct{} `type:"structure"`

	// Blanking image to be used. Leave empty for solid black. Only bmp and png
	// images are supported.
	AvailBlankingImage *InputLocation `locationName:"availBlankingImage" type:"structure"`

	// When set to enabled, causes video, audio and captions to be blanked when
	// insertion metadata is added.
	State *string `locationName:"state" type:"string" enum:"AvailBlankingState"`
}

// String returns the string representation
func (s AvailBlanking) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailBlanking) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailBlanking) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AvailBlanking"}
	if s.AvailBlankingImage != nil {
		if err := s.AvailBlankingImage.Validate(); err != nil {
			invalidParams.AddNested("AvailBlankingImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailBlankingImage sets the AvailBlankingImage field's value.
func (s *AvailBlanking) SetAvailBlankingImage(v *InputLocation) *AvailBlanking {
	s.AvailBlankingImage = v
	return s
}

// SetState sets the State field's value.
func (s *AvailBlanking) SetState(v string) *AvailBlanking {
	s.State = &v
	return s
}

type AvailConfiguration struct {
	_ struct{} `type:"structure"`

	// Ad avail settings.
	AvailSettings *AvailSettings `locationName:"availSettings" type:"structure"`
}

// String returns the string representation
func (s AvailConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AvailConfiguration"}
	if s.AvailSettings != nil {
		if err := s.AvailSettings.Validate(); err != nil {
			invalidParams.AddNested("AvailSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailSettings sets the AvailSettings field's value.
func (s *AvailConfiguration) SetAvailSettings(v *AvailSettings) *AvailConfiguration {
	s.AvailSettings = v
	return s
}

type AvailSettings struct {
	_ struct{} `type:"structure"`

	Scte35SpliceInsert *Scte35SpliceInsert `locationName:"scte35SpliceInsert" type:"structure"`

	Scte35TimeSignalApos *Scte35TimeSignalApos `locationName:"scte35TimeSignalApos" type:"structure"`
}

// String returns the string representation
func (s AvailSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AvailSettings"}
	if s.Scte35SpliceInsert != nil {
		if err := s.Scte35SpliceInsert.Validate(); err != nil {
			invalidParams.AddNested("Scte35SpliceInsert", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte35TimeSignalApos != nil {
		if err := s.Scte35TimeSignalApos.Validate(); err != nil {
			invalidParams.AddNested("Scte35TimeSignalApos", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScte35SpliceInsert sets the Scte35SpliceInsert field's value.
func (s *AvailSettings) SetScte35SpliceInsert(v *Scte35SpliceInsert) *AvailSettings {
	s.Scte35SpliceInsert = v
	return s
}

// SetScte35TimeSignalApos sets the Scte35TimeSignalApos field's value.
func (s *AvailSettings) SetScte35TimeSignalApos(v *Scte35TimeSignalApos) *AvailSettings {
	s.Scte35TimeSignalApos = v
	return s
}

type BlackoutSlate struct {
	_ struct{} `type:"structure"`

	// Blackout slate image to be used. Leave empty for solid black. Only bmp and
	// png images are supported.
	BlackoutSlateImage *InputLocation `locationName:"blackoutSlateImage" type:"structure"`

	// Setting to enabled causes the encoder to blackout the video, audio, and captions,
	// and raise the "Network Blackout Image" slate when an SCTE104/35 Network End
	// Segmentation Descriptor is encountered. The blackout will be lifted when
	// the Network Start Segmentation Descriptor is encountered. The Network End
	// and Network Start descriptors must contain a network ID that matches the
	// value entered in "Network ID".
	NetworkEndBlackout *string `locationName:"networkEndBlackout" type:"string" enum:"BlackoutSlateNetworkEndBlackout"`

	// Path to local file to use as Network End Blackout image. Image will be scaled
	// to fill the entire output raster.
	NetworkEndBlackoutImage *InputLocation `locationName:"networkEndBlackoutImage" type:"structure"`

	// Provides Network ID that matches EIDR ID format (e.g., "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
	NetworkId *string `locationName:"networkId" min:"34" type:"string"`

	// When set to enabled, causes video, audio and captions to be blanked when
	// indicated by program metadata.
	State *string `locationName:"state" type:"string" enum:"BlackoutSlateState"`
}

// String returns the string representation
func (s BlackoutSlate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlackoutSlate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlackoutSlate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BlackoutSlate"}
	if s.NetworkId != nil && len(*s.NetworkId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 34))
	}
	if s.BlackoutSlateImage != nil {
		if err := s.BlackoutSlateImage.Validate(); err != nil {
			invalidParams.AddNested("BlackoutSlateImage", err.(request.ErrInvalidParams))
		}
	}
	if s.NetworkEndBlackoutImage != nil {
		if err := s.NetworkEndBlackoutImage.Validate(); err != nil {
			invalidParams.AddNested("NetworkEndBlackoutImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlackoutSlateImage sets the BlackoutSlateImage field's value.
func (s *BlackoutSlate) SetBlackoutSlateImage(v *InputLocation) *BlackoutSlate {
	s.BlackoutSlateImage = v
	return s
}

// SetNetworkEndBlackout sets the NetworkEndBlackout field's value.
func (s *BlackoutSlate) SetNetworkEndBlackout(v string) *BlackoutSlate {
	s.NetworkEndBlackout = &v
	return s
}

// SetNetworkEndBlackoutImage sets the NetworkEndBlackoutImage field's value.
func (s *BlackoutSlate) SetNetworkEndBlackoutImage(v *InputLocation) *BlackoutSlate {
	s.NetworkEndBlackoutImage = v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *BlackoutSlate) SetNetworkId(v string) *BlackoutSlate {
	s.NetworkId = &v
	return s
}

// SetState sets the State field's value.
func (s *BlackoutSlate) SetState(v string) *BlackoutSlate {
	s.State = &v
	return s
}

type BurnInDestinationSettings struct {
	_ struct{} `type:"structure"`

	// If no explicit xPosition or yPosition is provided, setting alignment to centered
	// will place the captions at the bottom center of the output. Similarly, setting
	// a left alignment will align captions to the bottom left of the output. If
	// x and y positions are given in conjunction with the alignment parameter,
	// the font will be justified (either left or centered) relative to those coordinates.
	// Selecting "smart" justification will left-justify live subtitles and center-justify
	// pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
	Alignment *string `locationName:"alignment" type:"string" enum:"BurnInAlignment"`

	// Specifies the color of the rectangle behind the captions. All burn-in and
	// DVB-Sub font settings must match.
	BackgroundColor *string `locationName:"backgroundColor" type:"string" enum:"BurnInBackgroundColor"`

	// Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent.
	// Leaving this parameter out is equivalent to setting it to 0 (transparent).
	// All burn-in and DVB-Sub font settings must match.
	BackgroundOpacity *int64 `locationName:"backgroundOpacity" type:"integer"`

	// External font file used for caption burn-in. File extension must be 'ttf'
	// or 'tte'. Although the user can select output fonts for many different types
	// of input captions, embedded, STL and teletext sources use a strict grid system.
	// Using external fonts with these caption sources could cause unexpected display
	// of proportional fonts. All burn-in and DVB-Sub font settings must match.
	Font *InputLocation `locationName:"font" type:"structure"`

	// Specifies the color of the burned-in captions. This option is not valid for
	// source captions that are STL, 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	FontColor *string `locationName:"fontColor" type:"string" enum:"BurnInFontColor"`

	// Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
	// All burn-in and DVB-Sub font settings must match.
	FontOpacity *int64 `locationName:"fontOpacity" type:"integer"`

	// Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and
	// DVB-Sub font settings must match.
	FontResolution *int64 `locationName:"fontResolution" min:"96" type:"integer"`

	// When set to 'auto' fontSize will scale depending on the size of the output.
	// Giving a positive integer will specify the exact font size in points. All
	// burn-in and DVB-Sub font settings must match.
	FontSize *string `locationName:"fontSize" type:"string"`

	// Specifies font outline color. This option is not valid for source captions
	// that are either 608/embedded or teletext. These source settings are already
	// pre-defined by the caption stream. All burn-in and DVB-Sub font settings
	// must match.
	OutlineColor *string `locationName:"outlineColor" type:"string" enum:"BurnInOutlineColor"`

	// Specifies font outline size in pixels. This option is not valid for source
	// captions that are either 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	OutlineSize *int64 `locationName:"outlineSize" type:"integer"`

	// Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub
	// font settings must match.
	ShadowColor *string `locationName:"shadowColor" type:"string" enum:"BurnInShadowColor"`

	// Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving
	// this parameter out is equivalent to setting it to 0 (transparent). All burn-in
	// and DVB-Sub font settings must match.
	ShadowOpacity *int64 `locationName:"shadowOpacity" type:"integer"`

	// Specifies the horizontal offset of the shadow relative to the captions in
	// pixels. A value of -2 would result in a shadow offset 2 pixels to the left.
	// All burn-in and DVB-Sub font settings must match.
	ShadowXOffset *int64 `locationName:"shadowXOffset" type:"integer"`

	// Specifies the vertical offset of the shadow relative to the captions in pixels.
	// A value of -2 would result in a shadow offset 2 pixels above the text. All
	// burn-in and DVB-Sub font settings must match.
	ShadowYOffset *int64 `locationName:"shadowYOffset" type:"integer"`

	// Controls whether a fixed grid size will be used to generate the output subtitles
	// bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
	TeletextGridControl *string `locationName:"teletextGridControl" type:"string" enum:"BurnInTeletextGridControl"`

	// Specifies the horizontal position of the caption relative to the left side
	// of the output in pixels. A value of 10 would result in the captions starting
	// 10 pixels from the left of the output. If no explicit xPosition is provided,
	// the horizontal caption position will be determined by the alignment parameter.
	// All burn-in and DVB-Sub font settings must match.
	XPosition *int64 `locationName:"xPosition" type:"integer"`

	// Specifies the vertical position of the caption relative to the top of the
	// output in pixels. A value of 10 would result in the captions starting 10
	// pixels from the top of the output. If no explicit yPosition is provided,
	// the caption will be positioned towards the bottom of the output. All burn-in
	// and DVB-Sub font settings must match.
	YPosition *int64 `locationName:"yPosition" type:"integer"`
}

// String returns the string representation
func (s BurnInDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BurnInDestinationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BurnInDestinationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BurnInDestinationSettings"}
	if s.FontResolution != nil && *s.FontResolution < 96 {
		invalidParams.Add(request.NewErrParamMinValue("FontResolution", 96))
	}
	if s.Font != nil {
		if err := s.Font.Validate(); err != nil {
			invalidParams.AddNested("Font", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlignment sets the Alignment field's value.
func (s *BurnInDestinationSettings) SetAlignment(v string) *BurnInDestinationSettings {
	s.Alignment = &v
	return s
}

// SetBackgroundColor sets the BackgroundColor field's value.
func (s *BurnInDestinationSettings) SetBackgroundColor(v string) *BurnInDestinationSettings {
	s.BackgroundColor = &v
	return s
}

// SetBackgroundOpacity sets the BackgroundOpacity field's value.
func (s *BurnInDestinationSettings) SetBackgroundOpacity(v int64) *BurnInDestinationSettings {
	s.BackgroundOpacity = &v
	return s
}

// SetFont sets the Font field's value.
func (s *BurnInDestinationSettings) SetFont(v *InputLocation) *BurnInDestinationSettings {
	s.Font = v
	return s
}

// SetFontColor sets the FontColor field's value.
func (s *BurnInDestinationSettings) SetFontColor(v string) *BurnInDestinationSettings {
	s.FontColor = &v
	return s
}

// SetFontOpacity sets the FontOpacity field's value.
func (s *BurnInDestinationSettings) SetFontOpacity(v int64) *BurnInDestinationSettings {
	s.FontOpacity = &v
	return s
}

// SetFontResolution sets the FontResolution field's value.
func (s *BurnInDestinationSettings) SetFontResolution(v int64) *BurnInDestinationSettings {
	s.FontResolution = &v
	return s
}

// SetFontSize sets the FontSize field's value.
func (s *BurnInDestinationSettings) SetFontSize(v string) *BurnInDestinationSettings {
	s.FontSize = &v
	return s
}

// SetOutlineColor sets the OutlineColor field's value.
func (s *BurnInDestinationSettings) SetOutlineColor(v string) *BurnInDestinationSettings {
	s.OutlineColor = &v
	return s
}

// SetOutlineSize sets the OutlineSize field's value.
func (s *BurnInDestinationSettings) SetOutlineSize(v int64) *BurnInDestinationSettings {
	s.OutlineSize = &v
	return s
}

// SetShadowColor sets the ShadowColor field's value.
func (s *BurnInDestinationSettings) SetShadowColor(v string) *BurnInDestinationSettings {
	s.ShadowColor = &v
	return s
}

// SetShadowOpacity sets the ShadowOpacity field's value.
func (s *BurnInDestinationSettings) SetShadowOpacity(v int64) *BurnInDestinationSettings {
	s.ShadowOpacity = &v
	return s
}

// SetShadowXOffset sets the ShadowXOffset field's value.
func (s *BurnInDestinationSettings) SetShadowXOffset(v int64) *BurnInDestinationSettings {
	s.ShadowXOffset = &v
	return s
}

// SetShadowYOffset sets the ShadowYOffset field's value.
func (s *BurnInDestinationSettings) SetShadowYOffset(v int64) *BurnInDestinationSettings {
	s.ShadowYOffset = &v
	return s
}

// SetTeletextGridControl sets the TeletextGridControl field's value.
func (s *BurnInDestinationSettings) SetTeletextGridControl(v string) *BurnInDestinationSettings {
	s.TeletextGridControl = &v
	return s
}

// SetXPosition sets the XPosition field's value.
func (s *BurnInDestinationSettings) SetXPosition(v int64) *BurnInDestinationSettings {
	s.XPosition = &v
	return s
}

// SetYPosition sets the YPosition field's value.
func (s *BurnInDestinationSettings) SetYPosition(v int64) *BurnInDestinationSettings {
	s.YPosition = &v
	return s
}

// Output groups for this Live Event. Output groups contain information about
// where streams should be distributed.
type CaptionDescription struct {
	_ struct{} `type:"structure"`

	// Specifies which input caption selector to use as a caption source when generating
	// output captions. This field should match a captionSelector name.
	//
	// CaptionSelectorName is a required field
	CaptionSelectorName *string `locationName:"captionSelectorName" type:"string" required:"true"`

	// Additional settings for captions destination that depend on the destination
	// type.
	DestinationSettings *CaptionDestinationSettings `locationName:"destinationSettings" type:"structure"`

	// ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
	LanguageCode *string `locationName:"languageCode" type:"string"`

	// Human readable information to indicate captions available for players (eg.
	// English, or Spanish).
	LanguageDescription *string `locationName:"languageDescription" type:"string"`

	// Name of the caption description. Used to associate a caption description
	// with an output. Names must be unique within an event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s CaptionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionDescription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionDescription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionDescription"}
	if s.CaptionSelectorName == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptionSelectorName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.DestinationSettings != nil {
		if err := s.DestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("DestinationSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptionSelectorName sets the CaptionSelectorName field's value.
func (s *CaptionDescription) SetCaptionSelectorName(v string) *CaptionDescription {
	s.CaptionSelectorName = &v
	return s
}

// SetDestinationSettings sets the DestinationSettings field's value.
func (s *CaptionDescription) SetDestinationSettings(v *CaptionDestinationSettings) *CaptionDescription {
	s.DestinationSettings = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CaptionDescription) SetLanguageCode(v string) *CaptionDescription {
	s.LanguageCode = &v
	return s
}

// SetLanguageDescription sets the LanguageDescription field's value.
func (s *CaptionDescription) SetLanguageDescription(v string) *CaptionDescription {
	s.LanguageDescription = &v
	return s
}

// SetName sets the Name field's value.
func (s *CaptionDescription) SetName(v string) *CaptionDescription {
	s.Name = &v
	return s
}

type CaptionDestinationSettings struct {
	_ struct{} `type:"structure"`

	AribDestinationSettings *AribDestinationSettings `locationName:"aribDestinationSettings" type:"structure"`

	BurnInDestinationSettings *BurnInDestinationSettings `locationName:"burnInDestinationSettings" type:"structure"`

	DvbSubDestinationSettings *DvbSubDestinationSettings `locationName:"dvbSubDestinationSettings" type:"structure"`

	EmbeddedDestinationSettings *EmbeddedDestinationSettings `locationName:"embeddedDestinationSettings" type:"structure"`

	EmbeddedPlusScte20DestinationSettings *EmbeddedPlusScte20DestinationSettings `locationName:"embeddedPlusScte20DestinationSettings" type:"structure"`

	RtmpCaptionInfoDestinationSettings *RtmpCaptionInfoDestinationSettings `locationName:"rtmpCaptionInfoDestinationSettings" type:"structure"`

	Scte20PlusEmbeddedDestinationSettings *Scte20PlusEmbeddedDestinationSettings `locationName:"scte20PlusEmbeddedDestinationSettings" type:"structure"`

	Scte27DestinationSettings *Scte27DestinationSettings `locationName:"scte27DestinationSettings" type:"structure"`

	SmpteTtDestinationSettings *SmpteTtDestinationSettings `locationName:"smpteTtDestinationSettings" type:"structure"`

	TeletextDestinationSettings *TeletextDestinationSettings `locationName:"teletextDestinationSettings" type:"structure"`

	TtmlDestinationSettings *TtmlDestinationSettings `locationName:"ttmlDestinationSettings" type:"structure"`

	WebvttDestinationSettings *WebvttDestinationSettings `locationName:"webvttDestinationSettings" type:"structure"`
}

// String returns the string representation
func (s CaptionDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionDestinationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionDestinationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionDestinationSettings"}
	if s.BurnInDestinationSettings != nil {
		if err := s.BurnInDestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("BurnInDestinationSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.DvbSubDestinationSettings != nil {
		if err := s.DvbSubDestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbSubDestinationSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAribDestinationSettings sets the AribDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetAribDestinationSettings(v *AribDestinationSettings) *CaptionDestinationSettings {
	s.AribDestinationSettings = v
	return s
}

// SetBurnInDestinationSettings sets the BurnInDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetBurnInDestinationSettings(v *BurnInDestinationSettings) *CaptionDestinationSettings {
	s.BurnInDestinationSettings = v
	return s
}

// SetDvbSubDestinationSettings sets the DvbSubDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetDvbSubDestinationSettings(v *DvbSubDestinationSettings) *CaptionDestinationSettings {
	s.DvbSubDestinationSettings = v
	return s
}

// SetEmbeddedDestinationSettings sets the EmbeddedDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetEmbeddedDestinationSettings(v *EmbeddedDestinationSettings) *CaptionDestinationSettings {
	s.EmbeddedDestinationSettings = v
	return s
}

// SetEmbeddedPlusScte20DestinationSettings sets the EmbeddedPlusScte20DestinationSettings field's value.
func (s *CaptionDestinationSettings) SetEmbeddedPlusScte20DestinationSettings(v *EmbeddedPlusScte20DestinationSettings) *CaptionDestinationSettings {
	s.EmbeddedPlusScte20DestinationSettings = v
	return s
}

// SetRtmpCaptionInfoDestinationSettings sets the RtmpCaptionInfoDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetRtmpCaptionInfoDestinationSettings(v *RtmpCaptionInfoDestinationSettings) *CaptionDestinationSettings {
	s.RtmpCaptionInfoDestinationSettings = v
	return s
}

// SetScte20PlusEmbeddedDestinationSettings sets the Scte20PlusEmbeddedDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetScte20PlusEmbeddedDestinationSettings(v *Scte20PlusEmbeddedDestinationSettings) *CaptionDestinationSettings {
	s.Scte20PlusEmbeddedDestinationSettings = v
	return s
}

// SetScte27DestinationSettings sets the Scte27DestinationSettings field's value.
func (s *CaptionDestinationSettings) SetScte27DestinationSettings(v *Scte27DestinationSettings) *CaptionDestinationSettings {
	s.Scte27DestinationSettings = v
	return s
}

// SetSmpteTtDestinationSettings sets the SmpteTtDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetSmpteTtDestinationSettings(v *SmpteTtDestinationSettings) *CaptionDestinationSettings {
	s.SmpteTtDestinationSettings = v
	return s
}

// SetTeletextDestinationSettings sets the TeletextDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetTeletextDestinationSettings(v *TeletextDestinationSettings) *CaptionDestinationSettings {
	s.TeletextDestinationSettings = v
	return s
}

// SetTtmlDestinationSettings sets the TtmlDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetTtmlDestinationSettings(v *TtmlDestinationSettings) *CaptionDestinationSettings {
	s.TtmlDestinationSettings = v
	return s
}

// SetWebvttDestinationSettings sets the WebvttDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetWebvttDestinationSettings(v *WebvttDestinationSettings) *CaptionDestinationSettings {
	s.WebvttDestinationSettings = v
	return s
}

// Maps a caption channel to an ISO 693-2 language code (http://www.loc.gov/standards/iso639-2),
// with an optional description.
type CaptionLanguageMapping struct {
	_ struct{} `type:"structure"`

	// The closed caption channel being described by this CaptionLanguageMapping.
	// Each channel mapping must have a unique channel number (maximum of 4)
	//
	// CaptionChannel is a required field
	CaptionChannel *int64 `locationName:"captionChannel" min:"1" type:"integer" required:"true"`

	// Three character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2)
	//
	// LanguageCode is a required field
	LanguageCode *string `locationName:"languageCode" min:"3" type:"string" required:"true"`

	// Textual description of language
	//
	// LanguageDescription is a required field
	LanguageDescription *string `locationName:"languageDescription" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CaptionLanguageMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionLanguageMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionLanguageMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionLanguageMapping"}
	if s.CaptionChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptionChannel"))
	}
	if s.CaptionChannel != nil && *s.CaptionChannel < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CaptionChannel", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageCode", 3))
	}
	if s.LanguageDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageDescription"))
	}
	if s.LanguageDescription != nil && len(*s.LanguageDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageDescription", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptionChannel sets the CaptionChannel field's value.
func (s *CaptionLanguageMapping) SetCaptionChannel(v int64) *CaptionLanguageMapping {
	s.CaptionChannel = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CaptionLanguageMapping) SetLanguageCode(v string) *CaptionLanguageMapping {
	s.LanguageCode = &v
	return s
}

// SetLanguageDescription sets the LanguageDescription field's value.
func (s *CaptionLanguageMapping) SetLanguageDescription(v string) *CaptionLanguageMapping {
	s.LanguageDescription = &v
	return s
}

// Output groups for this Live Event. Output groups contain information about
// where streams should be distributed.
type CaptionSelector struct {
	_ struct{} `type:"structure"`

	// When specified this field indicates the three letter language code of the
	// caption track to extract from the source.
	LanguageCode *string `locationName:"languageCode" type:"string"`

	// Name identifier for a caption selector. This name is used to associate this
	// caption selector with one or more caption descriptions. Names must be unique
	// within an event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Caption selector settings.
	SelectorSettings *CaptionSelectorSettings `locationName:"selectorSettings" type:"structure"`
}

// String returns the string representation
func (s CaptionSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionSelector"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SelectorSettings != nil {
		if err := s.SelectorSettings.Validate(); err != nil {
			invalidParams.AddNested("SelectorSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CaptionSelector) SetLanguageCode(v string) *CaptionSelector {
	s.LanguageCode = &v
	return s
}

// SetName sets the Name field's value.
func (s *CaptionSelector) SetName(v string) *CaptionSelector {
	s.Name = &v
	return s
}

// SetSelectorSettings sets the SelectorSettings field's value.
func (s *CaptionSelector) SetSelectorSettings(v *CaptionSelectorSettings) *CaptionSelector {
	s.SelectorSettings = v
	return s
}

type CaptionSelectorSettings struct {
	_ struct{} `type:"structure"`

	AribSourceSettings *AribSourceSettings `locationName:"aribSourceSettings" type:"structure"`

	DvbSubSourceSettings *DvbSubSourceSettings `locationName:"dvbSubSourceSettings" type:"structure"`

	EmbeddedSourceSettings *EmbeddedSourceSettings `locationName:"embeddedSourceSettings" type:"structure"`

	Scte20SourceSettings *Scte20SourceSettings `locationName:"scte20SourceSettings" type:"structure"`

	Scte27SourceSettings *Scte27SourceSettings `locationName:"scte27SourceSettings" type:"structure"`

	TeletextSourceSettings *TeletextSourceSettings `locationName:"teletextSourceSettings" type:"structure"`
}

// String returns the string representation
func (s CaptionSelectorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionSelectorSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionSelectorSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionSelectorSettings"}
	if s.DvbSubSourceSettings != nil {
		if err := s.DvbSubSourceSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbSubSourceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.EmbeddedSourceSettings != nil {
		if err := s.EmbeddedSourceSettings.Validate(); err != nil {
			invalidParams.AddNested("EmbeddedSourceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte20SourceSettings != nil {
		if err := s.Scte20SourceSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte20SourceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte27SourceSettings != nil {
		if err := s.Scte27SourceSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte27SourceSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAribSourceSettings sets the AribSourceSettings field's value.
func (s *CaptionSelectorSettings) SetAribSourceSettings(v *AribSourceSettings) *CaptionSelectorSettings {
	s.AribSourceSettings = v
	return s
}

// SetDvbSubSourceSettings sets the DvbSubSourceSettings field's value.
func (s *CaptionSelectorSettings) SetDvbSubSourceSettings(v *DvbSubSourceSettings) *CaptionSelectorSettings {
	s.DvbSubSourceSettings = v
	return s
}

// SetEmbeddedSourceSettings sets the EmbeddedSourceSettings field's value.
func (s *CaptionSelectorSettings) SetEmbeddedSourceSettings(v *EmbeddedSourceSettings) *CaptionSelectorSettings {
	s.EmbeddedSourceSettings = v
	return s
}

// SetScte20SourceSettings sets the Scte20SourceSettings field's value.
func (s *CaptionSelectorSettings) SetScte20SourceSettings(v *Scte20SourceSettings) *CaptionSelectorSettings {
	s.Scte20SourceSettings = v
	return s
}

// SetScte27SourceSettings sets the Scte27SourceSettings field's value.
func (s *CaptionSelectorSettings) SetScte27SourceSettings(v *Scte27SourceSettings) *CaptionSelectorSettings {
	s.Scte27SourceSettings = v
	return s
}

// SetTeletextSourceSettings sets the TeletextSourceSettings field's value.
func (s *CaptionSelectorSettings) SetTeletextSourceSettings(v *TeletextSourceSettings) *CaptionSelectorSettings {
	s.TeletextSourceSettings = v
	return s
}

type Channel struct {
	_ struct{} `type:"structure"`

	// The unique arn of the channel.
	Arn *string `locationName:"arn" type:"string"`

	// A list of destinations of the channel. For UDP outputs, there is onedestination
	// per output. For other types (HLS, for example), there isone destination per
	// packager.
	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	// The endpoints where outgoing connections initiate from
	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	// The unique id of the channel.
	Id *string `locationName:"id" type:"string"`

	// List of input attachments for channel.
	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The name of the channel. (user-mutable)
	Name *string `locationName:"name" type:"string"`

	// The number of currently healthy pipelines.
	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Channel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Channel) SetArn(v string) *Channel {
	s.Arn = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *Channel) SetDestinations(v []*OutputDestination) *Channel {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *Channel) SetEgressEndpoints(v []*ChannelEgressEndpoint) *Channel {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *Channel) SetEncoderSettings(v *EncoderSettings) *Channel {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *Channel) SetId(v string) *Channel {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *Channel) SetInputAttachments(v []*InputAttachment) *Channel {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *Channel) SetInputSpecification(v *InputSpecification) *Channel {
	s.InputSpecification = v
	return s
}

// SetName sets the Name field's value.
func (s *Channel) SetName(v string) *Channel {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *Channel) SetPipelinesRunningCount(v int64) *Channel {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Channel) SetRoleArn(v string) *Channel {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *Channel) SetState(v string) *Channel {
	s.State = &v
	return s
}

type ChannelEgressEndpoint struct {
	_ struct{} `type:"structure"`

	// Public IP of where a channel's output comes from
	SourceIp *string `locationName:"sourceIp" type:"string"`
}

// String returns the string representation
func (s ChannelEgressEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelEgressEndpoint) GoString() string {
	return s.String()
}

// SetSourceIp sets the SourceIp field's value.
func (s *ChannelEgressEndpoint) SetSourceIp(v string) *ChannelEgressEndpoint {
	s.SourceIp = &v
	return s
}

type ChannelSummary struct {
	_ struct{} `type:"structure"`

	// The unique arn of the channel.
	Arn *string `locationName:"arn" type:"string"`

	// A list of destinations of the channel. For UDP outputs, there is onedestination
	// per output. For other types (HLS, for example), there isone destination per
	// packager.
	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	// The endpoints where outgoing connections initiate from
	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// The unique id of the channel.
	Id *string `locationName:"id" type:"string"`

	// List of input attachments for channel.
	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The name of the channel. (user-mutable)
	Name *string `locationName:"name" type:"string"`

	// The number of currently healthy pipelines.
	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`
}

// String returns the string representation
func (s ChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChannelSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ChannelSummary) SetArn(v string) *ChannelSummary {
	s.Arn = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *ChannelSummary) SetDestinations(v []*OutputDestination) *ChannelSummary {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *ChannelSummary) SetEgressEndpoints(v []*ChannelEgressEndpoint) *ChannelSummary {
	s.EgressEndpoints = v
	return s
}

// SetId sets the Id field's value.
func (s *ChannelSummary) SetId(v string) *ChannelSummary {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *ChannelSummary) SetInputAttachments(v []*InputAttachment) *ChannelSummary {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *ChannelSummary) SetInputSpecification(v *InputSpecification) *ChannelSummary {
	s.InputSpecification = v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelSummary) SetName(v string) *ChannelSummary {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *ChannelSummary) SetPipelinesRunningCount(v int64) *ChannelSummary {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ChannelSummary) SetRoleArn(v string) *ChannelSummary {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *ChannelSummary) SetState(v string) *ChannelSummary {
	s.State = &v
	return s
}

type CreateChannelInput struct {
	_ struct{} `type:"structure"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`

	Reserved *string `locationName:"reserved" deprecated:"true" type:"string"`

	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s CreateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelInput"}
	if s.EncoderSettings != nil {
		if err := s.EncoderSettings.Validate(); err != nil {
			invalidParams.AddNested("EncoderSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.InputAttachments != nil {
		for i, v := range s.InputAttachments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputAttachments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinations sets the Destinations field's value.
func (s *CreateChannelInput) SetDestinations(v []*OutputDestination) *CreateChannelInput {
	s.Destinations = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *CreateChannelInput) SetEncoderSettings(v *EncoderSettings) *CreateChannelInput {
	s.EncoderSettings = v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *CreateChannelInput) SetInputAttachments(v []*InputAttachment) *CreateChannelInput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *CreateChannelInput) SetInputSpecification(v *InputSpecification) *CreateChannelInput {
	s.InputSpecification = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateChannelInput) SetName(v string) *CreateChannelInput {
	s.Name = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateChannelInput) SetRequestId(v string) *CreateChannelInput {
	s.RequestId = &v
	return s
}

// SetReserved sets the Reserved field's value.
func (s *CreateChannelInput) SetReserved(v string) *CreateChannelInput {
	s.Reserved = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateChannelInput) SetRoleArn(v string) *CreateChannelInput {
	s.RoleArn = &v
	return s
}

type CreateChannelOutput struct {
	_ struct{} `type:"structure"`

	Channel *Channel `locationName:"channel" type:"structure"`
}

// String returns the string representation
func (s CreateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *CreateChannelOutput) SetChannel(v *Channel) *CreateChannelOutput {
	s.Channel = v
	return s
}

type CreateInputInput struct {
	_ struct{} `type:"structure"`

	Destinations []*InputDestinationRequest `locationName:"destinations" type:"list"`

	InputSecurityGroups []*string `locationName:"inputSecurityGroups" type:"list"`

	Name *string `locationName:"name" type:"string"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`

	Sources []*InputSourceRequest `locationName:"sources" type:"list"`

	Type *string `locationName:"type" type:"string" enum:"InputType"`
}

// String returns the string representation
func (s CreateInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInputInput) GoString() string {
	return s.String()
}

// SetDestinations sets the Destinations field's value.
func (s *CreateInputInput) SetDestinations(v []*InputDestinationRequest) *CreateInputInput {
	s.Destinations = v
	return s
}

// SetInputSecurityGroups sets the InputSecurityGroups field's value.
func (s *CreateInputInput) SetInputSecurityGroups(v []*string) *CreateInputInput {
	s.InputSecurityGroups = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateInputInput) SetName(v string) *CreateInputInput {
	s.Name = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateInputInput) SetRequestId(v string) *CreateInputInput {
	s.RequestId = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateInputInput) SetSources(v []*InputSourceRequest) *CreateInputInput {
	s.Sources = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateInputInput) SetType(v string) *CreateInputInput {
	s.Type = &v
	return s
}

type CreateInputOutput struct {
	_ struct{} `type:"structure"`

	Input *Input `locationName:"input" type:"structure"`
}

// String returns the string representation
func (s CreateInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInputOutput) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *CreateInputOutput) SetInput(v *Input) *CreateInputOutput {
	s.Input = v
	return s
}

type CreateInputSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	WhitelistRules []*InputWhitelistRuleCidr `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation
func (s CreateInputSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInputSecurityGroupInput) GoString() string {
	return s.String()
}

// SetWhitelistRules sets the WhitelistRules field's value.
func (s *CreateInputSecurityGroupInput) SetWhitelistRules(v []*InputWhitelistRuleCidr) *CreateInputSecurityGroupInput {
	s.WhitelistRules = v
	return s
}

type CreateInputSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// An Input Security Group
	SecurityGroup *InputSecurityGroup `locationName:"securityGroup" type:"structure"`
}

// String returns the string representation
func (s CreateInputSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInputSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetSecurityGroup sets the SecurityGroup field's value.
func (s *CreateInputSecurityGroupOutput) SetSecurityGroup(v *InputSecurityGroup) *CreateInputSecurityGroupOutput {
	s.SecurityGroup = v
	return s
}

type DeleteChannelInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DeleteChannelInput) SetChannelId(v string) *DeleteChannelInput {
	s.ChannelId = &v
	return s
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`
}

// String returns the string representation
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteChannelOutput) SetArn(v string) *DeleteChannelOutput {
	s.Arn = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DeleteChannelOutput) SetDestinations(v []*OutputDestination) *DeleteChannelOutput {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *DeleteChannelOutput) SetEgressEndpoints(v []*ChannelEgressEndpoint) *DeleteChannelOutput {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *DeleteChannelOutput) SetEncoderSettings(v *EncoderSettings) *DeleteChannelOutput {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteChannelOutput) SetId(v string) *DeleteChannelOutput {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *DeleteChannelOutput) SetInputAttachments(v []*InputAttachment) *DeleteChannelOutput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *DeleteChannelOutput) SetInputSpecification(v *InputSpecification) *DeleteChannelOutput {
	s.InputSpecification = v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteChannelOutput) SetName(v string) *DeleteChannelOutput {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *DeleteChannelOutput) SetPipelinesRunningCount(v int64) *DeleteChannelOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DeleteChannelOutput) SetRoleArn(v string) *DeleteChannelOutput {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteChannelOutput) SetState(v string) *DeleteChannelOutput {
	s.State = &v
	return s
}

type DeleteInputInput struct {
	_ struct{} `type:"structure"`

	// InputId is a required field
	InputId *string `location:"uri" locationName:"inputId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInputInput"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputId sets the InputId field's value.
func (s *DeleteInputInput) SetInputId(v string) *DeleteInputInput {
	s.InputId = &v
	return s
}

type DeleteInputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInputOutput) GoString() string {
	return s.String()
}

type DeleteInputSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// InputSecurityGroupId is a required field
	InputSecurityGroupId *string `location:"uri" locationName:"inputSecurityGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInputSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInputSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInputSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInputSecurityGroupInput"}
	if s.InputSecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSecurityGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputSecurityGroupId sets the InputSecurityGroupId field's value.
func (s *DeleteInputSecurityGroupInput) SetInputSecurityGroupId(v string) *DeleteInputSecurityGroupInput {
	s.InputSecurityGroupId = &v
	return s
}

type DeleteInputSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInputSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInputSecurityGroupOutput) GoString() string {
	return s.String()
}

type DescribeChannelInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DescribeChannelInput) SetChannelId(v string) *DescribeChannelInput {
	s.ChannelId = &v
	return s
}

type DescribeChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`
}

// String returns the string representation
func (s DescribeChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeChannelOutput) SetArn(v string) *DescribeChannelOutput {
	s.Arn = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DescribeChannelOutput) SetDestinations(v []*OutputDestination) *DescribeChannelOutput {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *DescribeChannelOutput) SetEgressEndpoints(v []*ChannelEgressEndpoint) *DescribeChannelOutput {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *DescribeChannelOutput) SetEncoderSettings(v *EncoderSettings) *DescribeChannelOutput {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeChannelOutput) SetId(v string) *DescribeChannelOutput {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *DescribeChannelOutput) SetInputAttachments(v []*InputAttachment) *DescribeChannelOutput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *DescribeChannelOutput) SetInputSpecification(v *InputSpecification) *DescribeChannelOutput {
	s.InputSpecification = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeChannelOutput) SetName(v string) *DescribeChannelOutput {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *DescribeChannelOutput) SetPipelinesRunningCount(v int64) *DescribeChannelOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeChannelOutput) SetRoleArn(v string) *DescribeChannelOutput {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeChannelOutput) SetState(v string) *DescribeChannelOutput {
	s.State = &v
	return s
}

type DescribeInputInput struct {
	_ struct{} `type:"structure"`

	// InputId is a required field
	InputId *string `location:"uri" locationName:"inputId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInputInput"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputId sets the InputId field's value.
func (s *DescribeInputInput) SetInputId(v string) *DescribeInputInput {
	s.InputId = &v
	return s
}

type DescribeInputOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AttachedChannels []*string `locationName:"attachedChannels" type:"list"`

	Destinations []*InputDestination `locationName:"destinations" type:"list"`

	Id *string `locationName:"id" type:"string"`

	Name *string `locationName:"name" type:"string"`

	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	Sources []*InputSource `locationName:"sources" type:"list"`

	State *string `locationName:"state" type:"string" enum:"InputState"`

	Type *string `locationName:"type" type:"string" enum:"InputType"`
}

// String returns the string representation
func (s DescribeInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeInputOutput) SetArn(v string) *DescribeInputOutput {
	s.Arn = &v
	return s
}

// SetAttachedChannels sets the AttachedChannels field's value.
func (s *DescribeInputOutput) SetAttachedChannels(v []*string) *DescribeInputOutput {
	s.AttachedChannels = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DescribeInputOutput) SetDestinations(v []*InputDestination) *DescribeInputOutput {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeInputOutput) SetId(v string) *DescribeInputOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeInputOutput) SetName(v string) *DescribeInputOutput {
	s.Name = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *DescribeInputOutput) SetSecurityGroups(v []*string) *DescribeInputOutput {
	s.SecurityGroups = v
	return s
}

// SetSources sets the Sources field's value.
func (s *DescribeInputOutput) SetSources(v []*InputSource) *DescribeInputOutput {
	s.Sources = v
	return s
}

// SetState sets the State field's value.
func (s *DescribeInputOutput) SetState(v string) *DescribeInputOutput {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeInputOutput) SetType(v string) *DescribeInputOutput {
	s.Type = &v
	return s
}

type DescribeInputSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// InputSecurityGroupId is a required field
	InputSecurityGroupId *string `location:"uri" locationName:"inputSecurityGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInputSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInputSecurityGroupInput"}
	if s.InputSecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSecurityGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputSecurityGroupId sets the InputSecurityGroupId field's value.
func (s *DescribeInputSecurityGroupInput) SetInputSecurityGroupId(v string) *DescribeInputSecurityGroupInput {
	s.InputSecurityGroupId = &v
	return s
}

type DescribeInputSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Id *string `locationName:"id" type:"string"`

	Inputs []*string `locationName:"inputs" type:"list"`

	State *string `locationName:"state" type:"string" enum:"InputSecurityGroupState"`

	WhitelistRules []*InputWhitelistRule `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation
func (s DescribeInputSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInputSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeInputSecurityGroupOutput) SetArn(v string) *DescribeInputSecurityGroupOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeInputSecurityGroupOutput) SetId(v string) *DescribeInputSecurityGroupOutput {
	s.Id = &v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *DescribeInputSecurityGroupOutput) SetInputs(v []*string) *DescribeInputSecurityGroupOutput {
	s.Inputs = v
	return s
}

// SetState sets the State field's value.
func (s *DescribeInputSecurityGroupOutput) SetState(v string) *DescribeInputSecurityGroupOutput {
	s.State = &v
	return s
}

// SetWhitelistRules sets the WhitelistRules field's value.
func (s *DescribeInputSecurityGroupOutput) SetWhitelistRules(v []*InputWhitelistRule) *DescribeInputSecurityGroupOutput {
	s.WhitelistRules = v
	return s
}

// DVB Network Information Table (NIT)
type DvbNitSettings struct {
	_ struct{} `type:"structure"`

	// The numeric value placed in the Network Information Table (NIT).
	//
	// NetworkId is a required field
	NetworkId *int64 `locationName:"networkId" type:"integer" required:"true"`

	// The network name text placed in the networkNameDescriptor inside the Network
	// Information Table. Maximum length is 256 characters.
	//
	// NetworkName is a required field
	NetworkName *string `locationName:"networkName" min:"1" type:"string" required:"true"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"25" type:"integer"`
}

// String returns the string representation
func (s DvbNitSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DvbNitSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbNitSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbNitSettings"}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkName == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkName"))
	}
	if s.NetworkName != nil && len(*s.NetworkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkName", 1))
	}
	if s.RepInterval != nil && *s.RepInterval < 25 {
		invalidParams.Add(request.NewErrParamMinValue("RepInterval", 25))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkId sets the NetworkId field's value.
func (s *DvbNitSettings) SetNetworkId(v int64) *DvbNitSettings {
	s.NetworkId = &v
	return s
}

// SetNetworkName sets the NetworkName field's value.
func (s *DvbNitSettings) SetNetworkName(v string) *DvbNitSettings {
	s.NetworkName = &v
	return s
}

// SetRepInterval sets the RepInterval field's value.
func (s *DvbNitSettings) SetRepInterval(v int64) *DvbNitSettings {
	s.RepInterval = &v
	return s
}

// DVB Service Description Table (SDT)
type DvbSdtSettings struct {
	_ struct{} `type:"structure"`

	// Selects method of inserting SDT information into output stream. The sdtFollow
	// setting copies SDT information from input stream to output stream. The sdtFollowIfPresent
	// setting copies SDT information from input stream to output stream if SDT
	// information is present in the input, otherwise it will fall back on the user-defined
	// values. The sdtManual setting means user will enter the SDT information.
	// The sdtNone setting means output stream will not contain SDT information.
	OutputSdt *string `locationName:"outputSdt" type:"string" enum:"DvbSdtOutputSdt"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"25" type:"integer"`

	// The service name placed in the serviceDescriptor in the Service Description
	// Table. Maximum length is 256 characters.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`

	// The service provider name placed in the serviceDescriptor in the Service
	// Description Table. Maximum length is 256 characters.
	ServiceProviderName *string `locationName:"serviceProviderName" min:"1" type:"string"`
}

// String returns the string representation
func (s DvbSdtSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DvbSdtSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSdtSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbSdtSettings"}
	if s.RepInterval != nil && *s.RepInterval < 25 {
		invalidParams.Add(request.NewErrParamMinValue("RepInterval", 25))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}
	if s.ServiceProviderName != nil && len(*s.ServiceProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceProviderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutputSdt sets the OutputSdt field's value.
func (s *DvbSdtSettings) SetOutputSdt(v string) *DvbSdtSettings {
	s.OutputSdt = &v
	return s
}

// SetRepInterval sets the RepInterval field's value.
func (s *DvbSdtSettings) SetRepInterval(v int64) *DvbSdtSettings {
	s.RepInterval = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *DvbSdtSettings) SetServiceName(v string) *DvbSdtSettings {
	s.ServiceName = &v
	return s
}

// SetServiceProviderName sets the ServiceProviderName field's value.
func (s *DvbSdtSettings) SetServiceProviderName(v string) *DvbSdtSettings {
	s.ServiceProviderName = &v
	return s
}

type DvbSubDestinationSettings struct {
	_ struct{} `type:"structure"`

	// If no explicit xPosition or yPosition is provided, setting alignment to centered
	// will place the captions at the bottom center of the output. Similarly, setting
	// a left alignment will align captions to the bottom left of the output. If
	// x and y positions are given in conjunction with the alignment parameter,
	// the font will be justified (either left or centered) relative to those coordinates.
	// Selecting "smart" justification will left-justify live subtitles and center-justify
	// pre-recorded subtitles. This option is not valid for source captions that
	// are STL or 608/embedded. These source settings are already pre-defined by
	// the caption stream. All burn-in and DVB-Sub font settings must match.
	Alignment *string `locationName:"alignment" type:"string" enum:"DvbSubDestinationAlignment"`

	// Specifies the color of the rectangle behind the captions. All burn-in and
	// DVB-Sub font settings must match.
	BackgroundColor *string `locationName:"backgroundColor" type:"string" enum:"DvbSubDestinationBackgroundColor"`

	// Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent.
	// Leaving this parameter blank is equivalent to setting it to 0 (transparent).
	// All burn-in and DVB-Sub font settings must match.
	BackgroundOpacity *int64 `locationName:"backgroundOpacity" type:"integer"`

	// External font file used for caption burn-in. File extension must be 'ttf'
	// or 'tte'. Although the user can select output fonts for many different types
	// of input captions, embedded, STL and teletext sources use a strict grid system.
	// Using external fonts with these caption sources could cause unexpected display
	// of proportional fonts. All burn-in and DVB-Sub font settings must match.
	Font *InputLocation `locationName:"font" type:"structure"`

	// Specifies the color of the burned-in captions. This option is not valid for
	// source captions that are STL, 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	FontColor *string `locationName:"fontColor" type:"string" enum:"DvbSubDestinationFontColor"`

	// Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
	// All burn-in and DVB-Sub font settings must match.
	FontOpacity *int64 `locationName:"fontOpacity" type:"integer"`

	// Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and
	// DVB-Sub font settings must match.
	FontResolution *int64 `locationName:"fontResolution" min:"96" type:"integer"`

	// When set to auto fontSize will scale depending on the size of the output.
	// Giving a positive integer will specify the exact font size in points. All
	// burn-in and DVB-Sub font settings must match.
	FontSize *string `locationName:"fontSize" type:"string"`

	// Specifies font outline color. This option is not valid for source captions
	// that are either 608/embedded or teletext. These source settings are already
	// pre-defined by the caption stream. All burn-in and DVB-Sub font settings
	// must match.
	OutlineColor *string `locationName:"outlineColor" type:"string" enum:"DvbSubDestinationOutlineColor"`

	// Specifies font outline size in pixels. This option is not valid for source
	// captions that are either 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	OutlineSize *int64 `locationName:"outlineSize" type:"integer"`

	// Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub
	// font settings must match.
	ShadowColor *string `locationName:"shadowColor" type:"string" enum:"DvbSubDestinationShadowColor"`

	// Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving
	// this parameter blank is equivalent to setting it to 0 (transparent). All
	// burn-in and DVB-Sub font settings must match.
	ShadowOpacity *int64 `locationName:"shadowOpacity" type:"integer"`

	// Specifies the horizontal offset of the shadow relative to the captions in
	// pixels. A value of -2 would result in a shadow offset 2 pixels to the left.
	// All burn-in and DVB-Sub font settings must match.
	ShadowXOffset *int64 `locationName:"shadowXOffset" type:"integer"`

	// Specifies the vertical offset of the shadow relative to the captions in pixels.
	// A value of -2 would result in a shadow offset 2 pixels above the text. All
	// burn-in and DVB-Sub font settings must match.
	ShadowYOffset *int64 `locationName:"shadowYOffset" type:"integer"`

	// Controls whether a fixed grid size will be used to generate the output subtitles
	// bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
	TeletextGridControl *string `locationName:"teletextGridControl" type:"string" enum:"DvbSubDestinationTeletextGridControl"`

	// Specifies the horizontal position of the caption relative to the left side
	// of the output in pixels. A value of 10 would result in the captions starting
	// 10 pixels from the left of the output. If no explicit xPosition is provided,
	// the horizontal caption position will be determined by the alignment parameter.
	// This option is not valid for source captions that are STL, 608/embedded or
	// teletext. These source settings are already pre-defined by the caption stream.
	// All burn-in and DVB-Sub font settings must match.
	XPosition *int64 `locationName:"xPosition" type:"integer"`

	// Specifies the vertical position of the caption relative to the top of the
	// output in pixels. A value of 10 would result in the captions starting 10
	// pixels from the top of the output. If no explicit yPosition is provided,
	// the caption will be positioned towards the bottom of the output. This option
	// is not valid for source captions that are STL, 608/embedded or teletext.
	// These source settings are already pre-defined by the caption stream. All
	// burn-in and DVB-Sub font settings must match.
	YPosition *int64 `locationName:"yPosition" type:"integer"`
}

// String returns the string representation
func (s DvbSubDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DvbSubDestinationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSubDestinationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbSubDestinationSettings"}
	if s.FontResolution != nil && *s.FontResolution < 96 {
		invalidParams.Add(request.NewErrParamMinValue("FontResolution", 96))
	}
	if s.Font != nil {
		if err := s.Font.Validate(); err != nil {
			invalidParams.AddNested("Font", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlignment sets the Alignment field's value.
func (s *DvbSubDestinationSettings) SetAlignment(v string) *DvbSubDestinationSettings {
	s.Alignment = &v
	return s
}

// SetBackgroundColor sets the BackgroundColor field's value.
func (s *DvbSubDestinationSettings) SetBackgroundColor(v string) *DvbSubDestinationSettings {
	s.BackgroundColor = &v
	return s
}

// SetBackgroundOpacity sets the BackgroundOpacity field's value.
func (s *DvbSubDestinationSettings) SetBackgroundOpacity(v int64) *DvbSubDestinationSettings {
	s.BackgroundOpacity = &v
	return s
}

// SetFont sets the Font field's value.
func (s *DvbSubDestinationSettings) SetFont(v *InputLocation) *DvbSubDestinationSettings {
	s.Font = v
	return s
}

// SetFontColor sets the FontColor field's value.
func (s *DvbSubDestinationSettings) SetFontColor(v string) *DvbSubDestinationSettings {
	s.FontColor = &v
	return s
}

// SetFontOpacity sets the FontOpacity field's value.
func (s *DvbSubDestinationSettings) SetFontOpacity(v int64) *DvbSubDestinationSettings {
	s.FontOpacity = &v
	return s
}

// SetFontResolution sets the FontResolution field's value.
func (s *DvbSubDestinationSettings) SetFontResolution(v int64) *DvbSubDestinationSettings {
	s.FontResolution = &v
	return s
}

// SetFontSize sets the FontSize field's value.
func (s *DvbSubDestinationSettings) SetFontSize(v string) *DvbSubDestinationSettings {
	s.FontSize = &v
	return s
}

// SetOutlineColor sets the OutlineColor field's value.
func (s *DvbSubDestinationSettings) SetOutlineColor(v string) *DvbSubDestinationSettings {
	s.OutlineColor = &v
	return s
}

// SetOutlineSize sets the OutlineSize field's value.
func (s *DvbSubDestinationSettings) SetOutlineSize(v int64) *DvbSubDestinationSettings {
	s.OutlineSize = &v
	return s
}

// SetShadowColor sets the ShadowColor field's value.
func (s *DvbSubDestinationSettings) SetShadowColor(v string) *DvbSubDestinationSettings {
	s.ShadowColor = &v
	return s
}

// SetShadowOpacity sets the ShadowOpacity field's value.
func (s *DvbSubDestinationSettings) SetShadowOpacity(v int64) *DvbSubDestinationSettings {
	s.ShadowOpacity = &v
	return s
}

// SetShadowXOffset sets the ShadowXOffset field's value.
func (s *DvbSubDestinationSettings) SetShadowXOffset(v int64) *DvbSubDestinationSettings {
	s.ShadowXOffset = &v
	return s
}

// SetShadowYOffset sets the ShadowYOffset field's value.
func (s *DvbSubDestinationSettings) SetShadowYOffset(v int64) *DvbSubDestinationSettings {
	s.ShadowYOffset = &v
	return s
}

// SetTeletextGridControl sets the TeletextGridControl field's value.
func (s *DvbSubDestinationSettings) SetTeletextGridControl(v string) *DvbSubDestinationSettings {
	s.TeletextGridControl = &v
	return s
}

// SetXPosition sets the XPosition field's value.
func (s *DvbSubDestinationSettings) SetXPosition(v int64) *DvbSubDestinationSettings {
	s.XPosition = &v
	return s
}

// SetYPosition sets the YPosition field's value.
func (s *DvbSubDestinationSettings) SetYPosition(v int64) *DvbSubDestinationSettings {
	s.YPosition = &v
	return s
}

type DvbSubSourceSettings struct {
	_ struct{} `type:"structure"`

	// When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source
	// content. Unused for DVB-Sub passthrough. All DVB-Sub content is passed through,
	// regardless of selectors.
	Pid *int64 `locationName:"pid" min:"1" type:"integer"`
}

// String returns the string representation
func (s DvbSubSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DvbSubSourceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSubSourceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbSubSourceSettings"}
	if s.Pid != nil && *s.Pid < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Pid", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPid sets the Pid field's value.
func (s *DvbSubSourceSettings) SetPid(v int64) *DvbSubSourceSettings {
	s.Pid = &v
	return s
}

// DVB Time and Date Table (SDT)
type DvbTdtSettings struct {
	_ struct{} `type:"structure"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"1000" type:"integer"`
}

// String returns the string representation
func (s DvbTdtSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DvbTdtSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbTdtSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbTdtSettings"}
	if s.RepInterval != nil && *s.RepInterval < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("RepInterval", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepInterval sets the RepInterval field's value.
func (s *DvbTdtSettings) SetRepInterval(v int64) *DvbTdtSettings {
	s.RepInterval = &v
	return s
}

type Eac3Settings struct {
	_ struct{} `type:"structure"`

	// When set to attenuate3Db, applies a 3 dB attenuation to the surround channels.
	// Only used for 3/2 coding mode.
	AttenuationControl *string `locationName:"attenuationControl" type:"string" enum:"Eac3AttenuationControl"`

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC
	// A/52-2012 (Annex E) for background on these values.
	BitstreamMode *string `locationName:"bitstreamMode" type:"string" enum:"Eac3BitstreamMode"`

	// Dolby Digital Plus coding mode. Determines number of channels.
	CodingMode *string `locationName:"codingMode" type:"string" enum:"Eac3CodingMode"`

	// When set to enabled, activates a DC highpass filter for all input channels.
	DcFilter *string `locationName:"dcFilter" type:"string" enum:"Eac3DcFilter"`

	// Sets the dialnorm for the output. If blank and input audio is Dolby Digital
	// Plus, dialnorm will be passed through.
	Dialnorm *int64 `locationName:"dialnorm" min:"1" type:"integer"`

	// Sets the Dolby dynamic range compression profile.
	DrcLine *string `locationName:"drcLine" type:"string" enum:"Eac3DrcLine"`

	// Sets the profile for heavy Dolby dynamic range compression, ensures that
	// the instantaneous signal peaks do not exceed specified levels.
	DrcRf *string `locationName:"drcRf" type:"string" enum:"Eac3DrcRf"`

	// When encoding 3/2 audio, setting to lfe enables the LFE channel
	LfeControl *string `locationName:"lfeControl" type:"string" enum:"Eac3LfeControl"`

	// When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior
	// to encoding. Only valid with codingMode32 coding mode.
	LfeFilter *string `locationName:"lfeFilter" type:"string" enum:"Eac3LfeFilter"`

	// Left only/Right only center mix level. Only used for 3/2 coding mode.
	LoRoCenterMixLevel *float64 `locationName:"loRoCenterMixLevel" type:"double"`

	// Left only/Right only surround mix level. Only used for 3/2 coding mode.
	LoRoSurroundMixLevel *float64 `locationName:"loRoSurroundMixLevel" type:"double"`

	// Left total/Right total center mix level. Only used for 3/2 coding mode.
	LtRtCenterMixLevel *float64 `locationName:"ltRtCenterMixLevel" type:"double"`

	// Left total/Right total surround mix level. Only used for 3/2 coding mode.
	LtRtSurroundMixLevel *float64 `locationName:"ltRtSurroundMixLevel" type:"double"`

	// When set to followInput, encoder metadata will be sourced from the DD, DD+,
	// or DolbyE decoder that supplied this audio data. If audio was not supplied
	// from one of these streams, then the static metadata settings will be used.
	MetadataControl *string `locationName:"metadataControl" type:"string" enum:"Eac3MetadataControl"`

	// When set to whenPossible, input DD+ audio will be passed through if it is
	// present on the input. This detection is dynamic over the life of the transcode.
	// Inputs that alternate between DD+ and non-DD+ content will have a consistent
	// DD+ output as the system alternates between passthrough and encoding.
	PassthroughControl *string `locationName:"passthroughControl" type:"string" enum:"Eac3PassthroughControl"`

	// When set to shift90Degrees, applies a 90-degree phase shift to the surround
	// channels. Only used for 3/2 coding mode.
	PhaseControl *string `locationName:"phaseControl" type:"string" enum:"Eac3PhaseControl"`

	// Stereo downmix preference. Only used for 3/2 coding mode.
	StereoDownmix *string `locationName:"stereoDownmix" type:"string" enum:"Eac3StereoDownmix"`

	// When encoding 3/2 audio, sets whether an extra center back surround channel
	// is matrix encoded into the left and right surround channels.
	SurroundExMode *string `locationName:"surroundExMode" type:"string" enum:"Eac3SurroundExMode"`

	// When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into
	// the two channels.
	SurroundMode *string `locationName:"surroundMode" type:"string" enum:"Eac3SurroundMode"`
}

// String returns the string representation
func (s Eac3Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Eac3Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Eac3Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Eac3Settings"}
	if s.Dialnorm != nil && *s.Dialnorm < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Dialnorm", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttenuationControl sets the AttenuationControl field's value.
func (s *Eac3Settings) SetAttenuationControl(v string) *Eac3Settings {
	s.AttenuationControl = &v
	return s
}

// SetBitrate sets the Bitrate field's value.
func (s *Eac3Settings) SetBitrate(v float64) *Eac3Settings {
	s.Bitrate = &v
	return s
}

// SetBitstreamMode sets the BitstreamMode field's value.
func (s *Eac3Settings) SetBitstreamMode(v string) *Eac3Settings {
	s.BitstreamMode = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *Eac3Settings) SetCodingMode(v string) *Eac3Settings {
	s.CodingMode = &v
	return s
}

// SetDcFilter sets the DcFilter field's value.
func (s *Eac3Settings) SetDcFilter(v string) *Eac3Settings {
	s.DcFilter = &v
	return s
}

// SetDialnorm sets the Dialnorm field's value.
func (s *Eac3Settings) SetDialnorm(v int64) *Eac3Settings {
	s.Dialnorm = &v
	return s
}

// SetDrcLine sets the DrcLine field's value.
func (s *Eac3Settings) SetDrcLine(v string) *Eac3Settings {
	s.DrcLine = &v
	return s
}

// SetDrcRf sets the DrcRf field's value.
func (s *Eac3Settings) SetDrcRf(v string) *Eac3Settings {
	s.DrcRf = &v
	return s
}

// SetLfeControl sets the LfeControl field's value.
func (s *Eac3Settings) SetLfeControl(v string) *Eac3Settings {
	s.LfeControl = &v
	return s
}

// SetLfeFilter sets the LfeFilter field's value.
func (s *Eac3Settings) SetLfeFilter(v string) *Eac3Settings {
	s.LfeFilter = &v
	return s
}

// SetLoRoCenterMixLevel sets the LoRoCenterMixLevel field's value.
func (s *Eac3Settings) SetLoRoCenterMixLevel(v float64) *Eac3Settings {
	s.LoRoCenterMixLevel = &v
	return s
}

// SetLoRoSurroundMixLevel sets the LoRoSurroundMixLevel field's value.
func (s *Eac3Settings) SetLoRoSurroundMixLevel(v float64) *Eac3Settings {
	s.LoRoSurroundMixLevel = &v
	return s
}

// SetLtRtCenterMixLevel sets the LtRtCenterMixLevel field's value.
func (s *Eac3Settings) SetLtRtCenterMixLevel(v float64) *Eac3Settings {
	s.LtRtCenterMixLevel = &v
	return s
}

// SetLtRtSurroundMixLevel sets the LtRtSurroundMixLevel field's value.
func (s *Eac3Settings) SetLtRtSurroundMixLevel(v float64) *Eac3Settings {
	s.LtRtSurroundMixLevel = &v
	return s
}

// SetMetadataControl sets the MetadataControl field's value.
func (s *Eac3Settings) SetMetadataControl(v string) *Eac3Settings {
	s.MetadataControl = &v
	return s
}

// SetPassthroughControl sets the PassthroughControl field's value.
func (s *Eac3Settings) SetPassthroughControl(v string) *Eac3Settings {
	s.PassthroughControl = &v
	return s
}

// SetPhaseControl sets the PhaseControl field's value.
func (s *Eac3Settings) SetPhaseControl(v string) *Eac3Settings {
	s.PhaseControl = &v
	return s
}

// SetStereoDownmix sets the StereoDownmix field's value.
func (s *Eac3Settings) SetStereoDownmix(v string) *Eac3Settings {
	s.StereoDownmix = &v
	return s
}

// SetSurroundExMode sets the SurroundExMode field's value.
func (s *Eac3Settings) SetSurroundExMode(v string) *Eac3Settings {
	s.SurroundExMode = &v
	return s
}

// SetSurroundMode sets the SurroundMode field's value.
func (s *Eac3Settings) SetSurroundMode(v string) *Eac3Settings {
	s.SurroundMode = &v
	return s
}

type EmbeddedDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EmbeddedDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmbeddedDestinationSettings) GoString() string {
	return s.String()
}

type EmbeddedPlusScte20DestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EmbeddedPlusScte20DestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmbeddedPlusScte20DestinationSettings) GoString() string {
	return s.String()
}

type EmbeddedSourceSettings struct {
	_ struct{} `type:"structure"`

	// If upconvert, 608 data is both passed through via the "608 compatibility
	// bytes" fields of the 708 wrapper as well as translated into 708. 708 data
	// present in the source content will be discarded.
	Convert608To708 *string `locationName:"convert608To708" type:"string" enum:"EmbeddedConvert608To708"`

	// Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20
	// and Embedded captions.
	Scte20Detection *string `locationName:"scte20Detection" type:"string" enum:"EmbeddedScte20Detection"`

	// Specifies the 608/708 channel number within the video track from which to
	// extract captions. Unused for passthrough.
	Source608ChannelNumber *int64 `locationName:"source608ChannelNumber" min:"1" type:"integer"`

	// This field is unused and deprecated.
	Source608TrackNumber *int64 `locationName:"source608TrackNumber" min:"1" type:"integer"`
}

// String returns the string representation
func (s EmbeddedSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmbeddedSourceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmbeddedSourceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmbeddedSourceSettings"}
	if s.Source608ChannelNumber != nil && *s.Source608ChannelNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Source608ChannelNumber", 1))
	}
	if s.Source608TrackNumber != nil && *s.Source608TrackNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Source608TrackNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConvert608To708 sets the Convert608To708 field's value.
func (s *EmbeddedSourceSettings) SetConvert608To708(v string) *EmbeddedSourceSettings {
	s.Convert608To708 = &v
	return s
}

// SetScte20Detection sets the Scte20Detection field's value.
func (s *EmbeddedSourceSettings) SetScte20Detection(v string) *EmbeddedSourceSettings {
	s.Scte20Detection = &v
	return s
}

// SetSource608ChannelNumber sets the Source608ChannelNumber field's value.
func (s *EmbeddedSourceSettings) SetSource608ChannelNumber(v int64) *EmbeddedSourceSettings {
	s.Source608ChannelNumber = &v
	return s
}

// SetSource608TrackNumber sets the Source608TrackNumber field's value.
func (s *EmbeddedSourceSettings) SetSource608TrackNumber(v int64) *EmbeddedSourceSettings {
	s.Source608TrackNumber = &v
	return s
}

type EncoderSettings struct {
	_ struct{} `type:"structure"`

	// AudioDescriptions is a required field
	AudioDescriptions []*AudioDescription `locationName:"audioDescriptions" type:"list" required:"true"`

	// Settings for ad avail blanking.
	AvailBlanking *AvailBlanking `locationName:"availBlanking" type:"structure"`

	// Event-wide configuration settings for ad avail insertion.
	AvailConfiguration *AvailConfiguration `locationName:"availConfiguration" type:"structure"`

	// Settings for blackout slate.
	BlackoutSlate *BlackoutSlate `locationName:"blackoutSlate" type:"structure"`

	// Settings for caption decriptions
	CaptionDescriptions []*CaptionDescription `locationName:"captionDescriptions" type:"list"`

	// Configuration settings that apply to the event as a whole.
	GlobalConfiguration *GlobalConfiguration `locationName:"globalConfiguration" type:"structure"`

	// OutputGroups is a required field
	OutputGroups []*OutputGroup `locationName:"outputGroups" type:"list" required:"true"`

	// Contains settings used to acquire and adjust timecode information from inputs.
	//
	// TimecodeConfig is a required field
	TimecodeConfig *TimecodeConfig `locationName:"timecodeConfig" type:"structure" required:"true"`

	// VideoDescriptions is a required field
	VideoDescriptions []*VideoDescription `locationName:"videoDescriptions" type:"list" required:"true"`
}

// String returns the string representation
func (s EncoderSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncoderSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncoderSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncoderSettings"}
	if s.AudioDescriptions == nil {
		invalidParams.Add(request.NewErrParamRequired("AudioDescriptions"))
	}
	if s.OutputGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputGroups"))
	}
	if s.TimecodeConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("TimecodeConfig"))
	}
	if s.VideoDescriptions == nil {
		invalidParams.Add(request.NewErrParamRequired("VideoDescriptions"))
	}
	if s.AudioDescriptions != nil {
		for i, v := range s.AudioDescriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioDescriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AvailBlanking != nil {
		if err := s.AvailBlanking.Validate(); err != nil {
			invalidParams.AddNested("AvailBlanking", err.(request.ErrInvalidParams))
		}
	}
	if s.AvailConfiguration != nil {
		if err := s.AvailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AvailConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.BlackoutSlate != nil {
		if err := s.BlackoutSlate.Validate(); err != nil {
			invalidParams.AddNested("BlackoutSlate", err.(request.ErrInvalidParams))
		}
	}
	if s.CaptionDescriptions != nil {
		for i, v := range s.CaptionDescriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionDescriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.GlobalConfiguration != nil {
		if err := s.GlobalConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GlobalConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputGroups != nil {
		for i, v := range s.OutputGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TimecodeConfig != nil {
		if err := s.TimecodeConfig.Validate(); err != nil {
			invalidParams.AddNested("TimecodeConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VideoDescriptions != nil {
		for i, v := range s.VideoDescriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VideoDescriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioDescriptions sets the AudioDescriptions field's value.
func (s *EncoderSettings) SetAudioDescriptions(v []*AudioDescription) *EncoderSettings {
	s.AudioDescriptions = v
	return s
}

// SetAvailBlanking sets the AvailBlanking field's value.
func (s *EncoderSettings) SetAvailBlanking(v *AvailBlanking) *EncoderSettings {
	s.AvailBlanking = v
	return s
}

// SetAvailConfiguration sets the AvailConfiguration field's value.
func (s *EncoderSettings) SetAvailConfiguration(v *AvailConfiguration) *EncoderSettings {
	s.AvailConfiguration = v
	return s
}

// SetBlackoutSlate sets the BlackoutSlate field's value.
func (s *EncoderSettings) SetBlackoutSlate(v *BlackoutSlate) *EncoderSettings {
	s.BlackoutSlate = v
	return s
}

// SetCaptionDescriptions sets the CaptionDescriptions field's value.
func (s *EncoderSettings) SetCaptionDescriptions(v []*CaptionDescription) *EncoderSettings {
	s.CaptionDescriptions = v
	return s
}

// SetGlobalConfiguration sets the GlobalConfiguration field's value.
func (s *EncoderSettings) SetGlobalConfiguration(v *GlobalConfiguration) *EncoderSettings {
	s.GlobalConfiguration = v
	return s
}

// SetOutputGroups sets the OutputGroups field's value.
func (s *EncoderSettings) SetOutputGroups(v []*OutputGroup) *EncoderSettings {
	s.OutputGroups = v
	return s
}

// SetTimecodeConfig sets the TimecodeConfig field's value.
func (s *EncoderSettings) SetTimecodeConfig(v *TimecodeConfig) *EncoderSettings {
	s.TimecodeConfig = v
	return s
}

// SetVideoDescriptions sets the VideoDescriptions field's value.
func (s *EncoderSettings) SetVideoDescriptions(v []*VideoDescription) *EncoderSettings {
	s.VideoDescriptions = v
	return s
}

type FecOutputSettings struct {
	_ struct{} `type:"structure"`

	// Parameter D from SMPTE 2022-1. The height of the FEC protection matrix. The
	// number of transport stream packets per column error correction packet. Must
	// be between 4 and 20, inclusive.
	ColumnDepth *int64 `locationName:"columnDepth" min:"4" type:"integer"`

	// Enables column only or column and row based FEC
	IncludeFec *string `locationName:"includeFec" type:"string" enum:"FecOutputIncludeFec"`

	// Parameter L from SMPTE 2022-1. The width of the FEC protection matrix. Must
	// be between 1 and 20, inclusive. If only Column FEC is used, then larger values
	// increase robustness. If Row FEC is used, then this is the number of transport
	// stream packets per row error correction packet, and the value must be between
	// 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column,
	// this value must be 1 to 20, inclusive.
	RowLength *int64 `locationName:"rowLength" min:"1" type:"integer"`
}

// String returns the string representation
func (s FecOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FecOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FecOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FecOutputSettings"}
	if s.ColumnDepth != nil && *s.ColumnDepth < 4 {
		invalidParams.Add(request.NewErrParamMinValue("ColumnDepth", 4))
	}
	if s.RowLength != nil && *s.RowLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RowLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnDepth sets the ColumnDepth field's value.
func (s *FecOutputSettings) SetColumnDepth(v int64) *FecOutputSettings {
	s.ColumnDepth = &v
	return s
}

// SetIncludeFec sets the IncludeFec field's value.
func (s *FecOutputSettings) SetIncludeFec(v string) *FecOutputSettings {
	s.IncludeFec = &v
	return s
}

// SetRowLength sets the RowLength field's value.
func (s *FecOutputSettings) SetRowLength(v int64) *FecOutputSettings {
	s.RowLength = &v
	return s
}

type GlobalConfiguration struct {
	_ struct{} `type:"structure"`

	// Value to set the initial audio gain for the Live Event.
	InitialAudioGain *int64 `locationName:"initialAudioGain" type:"integer"`

	// Indicates the action to take when an input completes (e.g. end-of-file.)
	// Options include immediately switching to the next sequential input (via "switchInput"),
	// switching to the next input and looping back to the first input when last
	// input ends (via "switchAndLoopInputs") or not switching inputs and instead
	// transcoding black / color / slate images per the "Input Loss Behavior" configuration
	// until an activateInput REST command is received (via "none").
	InputEndAction *string `locationName:"inputEndAction" type:"string" enum:"GlobalConfigurationInputEndAction"`

	// Settings for system actions when input is lost.
	InputLossBehavior *InputLossBehavior `locationName:"inputLossBehavior" type:"structure"`

	// Indicates whether the rate of frames emitted by the Live encoder should be
	// paced by its system clock (which optionally may be locked to another source
	// via NTP) or should be locked to the clock of the source that is providing
	// the input stream.
	OutputTimingSource *string `locationName:"outputTimingSource" type:"string" enum:"GlobalConfigurationOutputTimingSource"`

	// Adjusts video input buffer for streams with very low video framerates. This
	// is commonly set to enabled for music channels with less than one video frame
	// per second.
	SupportLowFramerateInputs *string `locationName:"supportLowFramerateInputs" type:"string" enum:"GlobalConfigurationLowFramerateInputs"`
}

// String returns the string representation
func (s GlobalConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlobalConfiguration"}
	if s.InitialAudioGain != nil && *s.InitialAudioGain < -60 {
		invalidParams.Add(request.NewErrParamMinValue("InitialAudioGain", -60))
	}
	if s.InputLossBehavior != nil {
		if err := s.InputLossBehavior.Validate(); err != nil {
			invalidParams.AddNested("InputLossBehavior", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialAudioGain sets the InitialAudioGain field's value.
func (s *GlobalConfiguration) SetInitialAudioGain(v int64) *GlobalConfiguration {
	s.InitialAudioGain = &v
	return s
}

// SetInputEndAction sets the InputEndAction field's value.
func (s *GlobalConfiguration) SetInputEndAction(v string) *GlobalConfiguration {
	s.InputEndAction = &v
	return s
}

// SetInputLossBehavior sets the InputLossBehavior field's value.
func (s *GlobalConfiguration) SetInputLossBehavior(v *InputLossBehavior) *GlobalConfiguration {
	s.InputLossBehavior = v
	return s
}

// SetOutputTimingSource sets the OutputTimingSource field's value.
func (s *GlobalConfiguration) SetOutputTimingSource(v string) *GlobalConfiguration {
	s.OutputTimingSource = &v
	return s
}

// SetSupportLowFramerateInputs sets the SupportLowFramerateInputs field's value.
func (s *GlobalConfiguration) SetSupportLowFramerateInputs(v string) *GlobalConfiguration {
	s.SupportLowFramerateInputs = &v
	return s
}

type H264Settings struct {
	_ struct{} `type:"structure"`

	// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual
	// quality.
	AdaptiveQuantization *string `locationName:"adaptiveQuantization" type:"string" enum:"H264AdaptiveQuantization"`

	// Indicates that AFD values will be written into the output stream. If afdSignaling
	// is "auto", the system will try to preserve the input AFD value (in cases
	// where multiple AFD values are valid). If set to "fixed", the AFD value will
	// be the value configured in the fixedAfd parameter.
	AfdSignaling *string `locationName:"afdSignaling" type:"string" enum:"AfdSignaling"`

	// Average bitrate in bits/second. Required for VBR, CBR, and ABR. For MS Smooth
	// outputs, bitrates must be unique when rounded down to the nearest multiple
	// of 1000.
	Bitrate *int64 `locationName:"bitrate" min:"1000" type:"integer"`

	// Percentage of the buffer that should initially be filled (HRD buffer model).
	BufFillPct *int64 `locationName:"bufFillPct" type:"integer"`

	// Size of buffer (HRD buffer model) in bits/second.
	BufSize *int64 `locationName:"bufSize" type:"integer"`

	// Includes colorspace metadata in the output.
	ColorMetadata *string `locationName:"colorMetadata" type:"string" enum:"H264ColorMetadata"`

	// Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
	EntropyEncoding *string `locationName:"entropyEncoding" type:"string" enum:"H264EntropyEncoding"`

	// Four bit AFD value to write on all frames of video in the output stream.
	// Only valid when afdSignaling is set to 'Fixed'.
	FixedAfd *string `locationName:"fixedAfd" type:"string" enum:"FixedAfd"`

	// If set to enabled, adjust quantization within each frame to reduce flicker
	// or 'pop' on I-frames.
	FlickerAq *string `locationName:"flickerAq" type:"string" enum:"H264FlickerAq"`

	// This field indicates how the output video frame rate is specified. If "specified"
	// is selected then the output video frame rate is determined by framerateNumerator
	// and framerateDenominator, else if "initializeFromSource" is selected then
	// the output video frame rate will be set equal to the input video frame rate
	// of the first input.
	FramerateControl *string `locationName:"framerateControl" type:"string" enum:"H264FramerateControl"`

	// Framerate denominator.
	FramerateDenominator *int64 `locationName:"framerateDenominator" type:"integer"`

	// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976
	// fps.
	FramerateNumerator *int64 `locationName:"framerateNumerator" type:"integer"`

	// If enabled, use reference B frames for GOP structures that have B frames
	// > 1.
	GopBReference *string `locationName:"gopBReference" type:"string" enum:"H264GopBReference"`

	// Frequency of closed GOPs. In streaming applications, it is recommended that
	// this be set to 1 so a decoder joining mid-stream will receive an IDR frame
	// as quickly as possible. Setting this value to 0 will break output segmenting.
	GopClosedCadence *int64 `locationName:"gopClosedCadence" type:"integer"`

	// Number of B-frames between reference frames.
	GopNumBFrames *int64 `locationName:"gopNumBFrames" type:"integer"`

	// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.
	// Must be greater than zero.
	GopSize *float64 `locationName:"gopSize" type:"double"`

	// Indicates if the gopSize is specified in frames or seconds. If seconds the
	// system will convert the gopSize into a frame count at run time.
	GopSizeUnits *string `locationName:"gopSizeUnits" type:"string" enum:"H264GopSizeUnits"`

	// H.264 Level.
	Level *string `locationName:"level" type:"string" enum:"H264Level"`

	// Amount of lookahead. A value of low can decrease latency and memory usage,
	// while high can produce better quality for certain content.
	LookAheadRateControl *string `locationName:"lookAheadRateControl" type:"string" enum:"H264LookAheadRateControl"`

	// Maximum bitrate in bits/second (for VBR mode only).
	MaxBitrate *int64 `locationName:"maxBitrate" min:"1000" type:"integer"`

	// Only meaningful if sceneChangeDetect is set to enabled. Enforces separation
	// between repeated (cadence) I-frames and I-frames inserted by Scene Change
	// Detection. If a scene change I-frame is within I-interval frames of a cadence
	// I-frame, the GOP is shrunk and/or stretched to the scene change I-frame.
	// GOP stretch requires enabling lookahead as well as setting I-interval. The
	// normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP
	// size + Min-I-interval - 1
	MinIInterval *int64 `locationName:"minIInterval" type:"integer"`

	// Number of reference frames to use. The encoder may use more than requested
	// if using B-frames and/or interlaced encoding.
	NumRefFrames *int64 `locationName:"numRefFrames" min:"1" type:"integer"`

	// This field indicates how the output pixel aspect ratio is specified. If "specified"
	// is selected then the output video pixel aspect ratio is determined by parNumerator
	// and parDenominator, else if "initializeFromSource" is selected then the output
	// pixsel aspect ratio will be set equal to the input video pixel aspect ratio
	// of the first input.
	ParControl *string `locationName:"parControl" type:"string" enum:"H264ParControl"`

	// Pixel Aspect Ratio denominator.
	ParDenominator *int64 `locationName:"parDenominator" min:"1" type:"integer"`

	// Pixel Aspect Ratio numerator.
	ParNumerator *int64 `locationName:"parNumerator" type:"integer"`

	// H.264 Profile.
	Profile *string `locationName:"profile" type:"string" enum:"H264Profile"`

	// Rate control mode.
	RateControlMode *string `locationName:"rateControlMode" type:"string" enum:"H264RateControlMode"`

	// Sets the scan type of the output to progressive or top-field-first interlaced.
	ScanType *string `locationName:"scanType" type:"string" enum:"H264ScanType"`

	// Scene change detection. Inserts I-frames on scene changes when enabled.
	SceneChangeDetect *string `locationName:"sceneChangeDetect" type:"string" enum:"H264SceneChangeDetect"`

	// Number of slices per picture. Must be less than or equal to the number of
	// macroblock rows for progressive pictures, and less than or equal to half
	// the number of macroblock rows for interlaced pictures.This field is optional;
	// when no value is specified the encoder will choose the number of slices based
	// on encode resolution.
	Slices *int64 `locationName:"slices" min:"1" type:"integer"`

	// Softness. Selects quantizer matrix, larger values reduce high-frequency content
	// in the encoded image.
	Softness *int64 `locationName:"softness" type:"integer"`

	// If set to enabled, adjust quantization within each frame based on spatial
	// variation of content complexity.
	SpatialAq *string `locationName:"spatialAq" type:"string" enum:"H264SpatialAq"`

	// Produces a bitstream compliant with SMPTE RP-2027.
	Syntax *string `locationName:"syntax" type:"string" enum:"H264Syntax"`

	// If set to enabled, adjust quantization within each frame based on temporal
	// variation of content complexity.
	TemporalAq *string `locationName:"temporalAq" type:"string" enum:"H264TemporalAq"`

	// Determines how timecodes should be inserted into the video elementary stream.-
	// 'disabled': Do not include timecodes- 'picTimingSei': Pass through picture
	// timing SEI messages from the source specified in Timecode Config
	TimecodeInsertion *string `locationName:"timecodeInsertion" type:"string" enum:"H264TimecodeInsertionBehavior"`
}

// String returns the string representation
func (s H264Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s H264Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *H264Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "H264Settings"}
	if s.Bitrate != nil && *s.Bitrate < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("Bitrate", 1000))
	}
	if s.MaxBitrate != nil && *s.MaxBitrate < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("MaxBitrate", 1000))
	}
	if s.NumRefFrames != nil && *s.NumRefFrames < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumRefFrames", 1))
	}
	if s.ParDenominator != nil && *s.ParDenominator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParDenominator", 1))
	}
	if s.Slices != nil && *s.Slices < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Slices", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdaptiveQuantization sets the AdaptiveQuantization field's value.
func (s *H264Settings) SetAdaptiveQuantization(v string) *H264Settings {
	s.AdaptiveQuantization = &v
	return s
}

// SetAfdSignaling sets the AfdSignaling field's value.
func (s *H264Settings) SetAfdSignaling(v string) *H264Settings {
	s.AfdSignaling = &v
	return s
}

// SetBitrate sets the Bitrate field's value.
func (s *H264Settings) SetBitrate(v int64) *H264Settings {
	s.Bitrate = &v
	return s
}

// SetBufFillPct sets the BufFillPct field's value.
func (s *H264Settings) SetBufFillPct(v int64) *H264Settings {
	s.BufFillPct = &v
	return s
}

// SetBufSize sets the BufSize field's value.
func (s *H264Settings) SetBufSize(v int64) *H264Settings {
	s.BufSize = &v
	return s
}

// SetColorMetadata sets the ColorMetadata field's value.
func (s *H264Settings) SetColorMetadata(v string) *H264Settings {
	s.ColorMetadata = &v
	return s
}

// SetEntropyEncoding sets the EntropyEncoding field's value.
func (s *H264Settings) SetEntropyEncoding(v string) *H264Settings {
	s.EntropyEncoding = &v
	return s
}

// SetFixedAfd sets the FixedAfd field's value.
func (s *H264Settings) SetFixedAfd(v string) *H264Settings {
	s.FixedAfd = &v
	return s
}

// SetFlickerAq sets the FlickerAq field's value.
func (s *H264Settings) SetFlickerAq(v string) *H264Settings {
	s.FlickerAq = &v
	return s
}

// SetFramerateControl sets the FramerateControl field's value.
func (s *H264Settings) SetFramerateControl(v string) *H264Settings {
	s.FramerateControl = &v
	return s
}

// SetFramerateDenominator sets the FramerateDenominator field's value.
func (s *H264Settings) SetFramerateDenominator(v int64) *H264Settings {
	s.FramerateDenominator = &v
	return s
}

// SetFramerateNumerator sets the FramerateNumerator field's value.
func (s *H264Settings) SetFramerateNumerator(v int64) *H264Settings {
	s.FramerateNumerator = &v
	return s
}

// SetGopBReference sets the GopBReference field's value.
func (s *H264Settings) SetGopBReference(v string) *H264Settings {
	s.GopBReference = &v
	return s
}

// SetGopClosedCadence sets the GopClosedCadence field's value.
func (s *H264Settings) SetGopClosedCadence(v int64) *H264Settings {
	s.GopClosedCadence = &v
	return s
}

// SetGopNumBFrames sets the GopNumBFrames field's value.
func (s *H264Settings) SetGopNumBFrames(v int64) *H264Settings {
	s.GopNumBFrames = &v
	return s
}

// SetGopSize sets the GopSize field's value.
func (s *H264Settings) SetGopSize(v float64) *H264Settings {
	s.GopSize = &v
	return s
}

// SetGopSizeUnits sets the GopSizeUnits field's value.
func (s *H264Settings) SetGopSizeUnits(v string) *H264Settings {
	s.GopSizeUnits = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *H264Settings) SetLevel(v string) *H264Settings {
	s.Level = &v
	return s
}

// SetLookAheadRateControl sets the LookAheadRateControl field's value.
func (s *H264Settings) SetLookAheadRateControl(v string) *H264Settings {
	s.LookAheadRateControl = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *H264Settings) SetMaxBitrate(v int64) *H264Settings {
	s.MaxBitrate = &v
	return s
}

// SetMinIInterval sets the MinIInterval field's value.
func (s *H264Settings) SetMinIInterval(v int64) *H264Settings {
	s.MinIInterval = &v
	return s
}

// SetNumRefFrames sets the NumRefFrames field's value.
func (s *H264Settings) SetNumRefFrames(v int64) *H264Settings {
	s.NumRefFrames = &v
	return s
}

// SetParControl sets the ParControl field's value.
func (s *H264Settings) SetParControl(v string) *H264Settings {
	s.ParControl = &v
	return s
}

// SetParDenominator sets the ParDenominator field's value.
func (s *H264Settings) SetParDenominator(v int64) *H264Settings {
	s.ParDenominator = &v
	return s
}

// SetParNumerator sets the ParNumerator field's value.
func (s *H264Settings) SetParNumerator(v int64) *H264Settings {
	s.ParNumerator = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *H264Settings) SetProfile(v string) *H264Settings {
	s.Profile = &v
	return s
}

// SetRateControlMode sets the RateControlMode field's value.
func (s *H264Settings) SetRateControlMode(v string) *H264Settings {
	s.RateControlMode = &v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *H264Settings) SetScanType(v string) *H264Settings {
	s.ScanType = &v
	return s
}

// SetSceneChangeDetect sets the SceneChangeDetect field's value.
func (s *H264Settings) SetSceneChangeDetect(v string) *H264Settings {
	s.SceneChangeDetect = &v
	return s
}

// SetSlices sets the Slices field's value.
func (s *H264Settings) SetSlices(v int64) *H264Settings {
	s.Slices = &v
	return s
}

// SetSoftness sets the Softness field's value.
func (s *H264Settings) SetSoftness(v int64) *H264Settings {
	s.Softness = &v
	return s
}

// SetSpatialAq sets the SpatialAq field's value.
func (s *H264Settings) SetSpatialAq(v string) *H264Settings {
	s.SpatialAq = &v
	return s
}

// SetSyntax sets the Syntax field's value.
func (s *H264Settings) SetSyntax(v string) *H264Settings {
	s.Syntax = &v
	return s
}

// SetTemporalAq sets the TemporalAq field's value.
func (s *H264Settings) SetTemporalAq(v string) *H264Settings {
	s.TemporalAq = &v
	return s
}

// SetTimecodeInsertion sets the TimecodeInsertion field's value.
func (s *H264Settings) SetTimecodeInsertion(v string) *H264Settings {
	s.TimecodeInsertion = &v
	return s
}

type HlsAkamaiSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Specify whether or not to use chunked transfer encoding to Akamai. User should
	// contact Akamai to enable this feature.
	HttpTransferMode *string `locationName:"httpTransferMode" type:"string" enum:"HlsAkamaiHttpTransferMode"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`

	// Salt for authenticated Akamai.
	Salt *string `locationName:"salt" type:"string"`

	// Token parameter for authenticated akamai. If not specified, _gda_ is used.
	Token *string `locationName:"token" type:"string"`
}

// String returns the string representation
func (s HlsAkamaiSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsAkamaiSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsAkamaiSettings) SetConnectionRetryInterval(v int64) *HlsAkamaiSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsAkamaiSettings) SetFilecacheDuration(v int64) *HlsAkamaiSettings {
	s.FilecacheDuration = &v
	return s
}

// SetHttpTransferMode sets the HttpTransferMode field's value.
func (s *HlsAkamaiSettings) SetHttpTransferMode(v string) *HlsAkamaiSettings {
	s.HttpTransferMode = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsAkamaiSettings) SetNumRetries(v int64) *HlsAkamaiSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsAkamaiSettings) SetRestartDelay(v int64) *HlsAkamaiSettings {
	s.RestartDelay = &v
	return s
}

// SetSalt sets the Salt field's value.
func (s *HlsAkamaiSettings) SetSalt(v string) *HlsAkamaiSettings {
	s.Salt = &v
	return s
}

// SetToken sets the Token field's value.
func (s *HlsAkamaiSettings) SetToken(v string) *HlsAkamaiSettings {
	s.Token = &v
	return s
}

type HlsBasicPutSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s HlsBasicPutSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsBasicPutSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsBasicPutSettings) SetConnectionRetryInterval(v int64) *HlsBasicPutSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsBasicPutSettings) SetFilecacheDuration(v int64) *HlsBasicPutSettings {
	s.FilecacheDuration = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsBasicPutSettings) SetNumRetries(v int64) *HlsBasicPutSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsBasicPutSettings) SetRestartDelay(v int64) *HlsBasicPutSettings {
	s.RestartDelay = &v
	return s
}

type HlsCdnSettings struct {
	_ struct{} `type:"structure"`

	HlsAkamaiSettings *HlsAkamaiSettings `locationName:"hlsAkamaiSettings" type:"structure"`

	HlsBasicPutSettings *HlsBasicPutSettings `locationName:"hlsBasicPutSettings" type:"structure"`

	HlsMediaStoreSettings *HlsMediaStoreSettings `locationName:"hlsMediaStoreSettings" type:"structure"`

	HlsWebdavSettings *HlsWebdavSettings `locationName:"hlsWebdavSettings" type:"structure"`
}

// String returns the string representation
func (s HlsCdnSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsCdnSettings) GoString() string {
	return s.String()
}

// SetHlsAkamaiSettings sets the HlsAkamaiSettings field's value.
func (s *HlsCdnSettings) SetHlsAkamaiSettings(v *HlsAkamaiSettings) *HlsCdnSettings {
	s.HlsAkamaiSettings = v
	return s
}

// SetHlsBasicPutSettings sets the HlsBasicPutSettings field's value.
func (s *HlsCdnSettings) SetHlsBasicPutSettings(v *HlsBasicPutSettings) *HlsCdnSettings {
	s.HlsBasicPutSettings = v
	return s
}

// SetHlsMediaStoreSettings sets the HlsMediaStoreSettings field's value.
func (s *HlsCdnSettings) SetHlsMediaStoreSettings(v *HlsMediaStoreSettings) *HlsCdnSettings {
	s.HlsMediaStoreSettings = v
	return s
}

// SetHlsWebdavSettings sets the HlsWebdavSettings field's value.
func (s *HlsCdnSettings) SetHlsWebdavSettings(v *HlsWebdavSettings) *HlsCdnSettings {
	s.HlsWebdavSettings = v
	return s
}

type HlsGroupSettings struct {
	_ struct{} `type:"structure"`

	// Choose one or more ad marker types to pass SCTE35 signals through to this
	// group of Apple HLS outputs.
	AdMarkers []*string `locationName:"adMarkers" type:"list"`

	// A partial URI prefix that will be prepended to each output in the media .m3u8
	// file. Can be used if base manifest is delivered from a different URL than
	// the main .m3u8 file.
	BaseUrlContent *string `locationName:"baseUrlContent" type:"string"`

	// A partial URI prefix that will be prepended to each output in the media .m3u8
	// file. Can be used if base manifest is delivered from a different URL than
	// the main .m3u8 file.
	BaseUrlManifest *string `locationName:"baseUrlManifest" type:"string"`

	// Mapping of up to 4 caption channels to caption languages. Is only meaningful
	// if captionLanguageSetting is set to "insert".
	CaptionLanguageMappings []*CaptionLanguageMapping `locationName:"captionLanguageMappings" type:"list"`

	// Applies only to 608 Embedded output captions.insert: Include CLOSED-CAPTIONS
	// lines in the manifest. Specify at least one language in the CC1 Language
	// Code field. One CLOSED-CAPTION line is added for each Language Code you specify.
	// Make sure to specify the languages in the order in which they appear in the
	// original source (if the source is embedded format) or the order of the caption
	// selectors (if the source is other than embedded). Otherwise, languages in
	// the manifest will not match up properly with the output captions.none: Include
	// CLOSED-CAPTIONS=NONE line in the manifest.omit: Omit any CLOSED-CAPTIONS
	// line from the manifest.
	CaptionLanguageSetting *string `locationName:"captionLanguageSetting" type:"string" enum:"HlsCaptionLanguageSetting"`

	// When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest,
	// which prevents clients from saving media segments for later replay.
	ClientCache *string `locationName:"clientCache" type:"string" enum:"HlsClientCache"`

	// Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist
	// generation.
	CodecSpecification *string `locationName:"codecSpecification" type:"string" enum:"HlsCodecSpecification"`

	// For use with encryptionType. This is a 128-bit, 16-byte hex value represented
	// by a 32-character text string. If ivSource is set to "explicit" then this
	// parameter is required and is used as the IV for encryption.
	ConstantIv *string `locationName:"constantIv" min:"32" type:"string"`

	// A directory or HTTP destination for the HLS segments, manifest files, and
	// encryption keys (if enabled).
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Place segments in subdirectories.
	DirectoryStructure *string `locationName:"directoryStructure" type:"string" enum:"HlsDirectoryStructure"`

	// Encrypts the segments with the given encryption scheme. Exclude this parameter
	// if no encryption is desired.
	EncryptionType *string `locationName:"encryptionType" type:"string" enum:"HlsEncryptionType"`

	// Parameters that control interactions with the CDN.
	HlsCdnSettings *HlsCdnSettings `locationName:"hlsCdnSettings" type:"structure"`

	// If mode is "live", the number of segments to retain in the manifest (.m3u8)
	// file. This number must be less than or equal to keepSegments. If mode is
	// "vod", this parameter has no effect.
	IndexNSegments *int64 `locationName:"indexNSegments" min:"3" type:"integer"`

	// Parameter that control output group behavior on input loss.
	InputLossAction *string `locationName:"inputLossAction" type:"string" enum:"InputLossActionForHlsOut"`

	// For use with encryptionType. The IV (Initialization Vector) is a 128-bit
	// number used in conjunction with the key for encrypting blocks. If set to
	// "include", IV is listed in the manifest, otherwise the IV is not in the manifest.
	IvInManifest *string `locationName:"ivInManifest" type:"string" enum:"HlsIvInManifest"`

	// For use with encryptionType. The IV (Initialization Vector) is a 128-bit
	// number used in conjunction with the key for encrypting blocks. If this setting
	// is "followsSegmentNumber", it will cause the IV to change every segment (to
	// match the segment number). If this is set to "explicit", you must enter a
	// constantIv value.
	IvSource *string `locationName:"ivSource" type:"string" enum:"HlsIvSource"`

	// If mode is "live", the number of TS segments to retain in the destination
	// directory. If mode is "vod", this parameter has no effect.
	KeepSegments *int64 `locationName:"keepSegments" min:"1" type:"integer"`

	// The value specifies how the key is represented in the resource identified
	// by the URI. If parameter is absent, an implicit value of "identity" is used.
	// A reverse DNS string can also be given.
	KeyFormat *string `locationName:"keyFormat" type:"string"`

	// Either a single positive integer version value or a slash delimited list
	// of version values (1/2/3).
	KeyFormatVersions *string `locationName:"keyFormatVersions" type:"string"`

	// The key provider settings.
	KeyProviderSettings *KeyProviderSettings `locationName:"keyProviderSettings" type:"structure"`

	// When set to gzip, compresses HLS playlist.
	ManifestCompression *string `locationName:"manifestCompression" type:"string" enum:"HlsManifestCompression"`

	// Indicates whether the output manifest should use floating point or integer
	// values for segment duration.
	ManifestDurationFormat *string `locationName:"manifestDurationFormat" type:"string" enum:"HlsManifestDurationFormat"`

	// When set, minimumSegmentLength is enforced by looking ahead and back within
	// the specified range for a nearby avail and extending the segment size if
	// needed.
	MinSegmentLength *int64 `locationName:"minSegmentLength" type:"integer"`

	// If "vod", all segments are indexed and kept permanently in the destination
	// and manifest. If "live", only the number segments specified in keepSegments
	// and indexNSegments are kept; newer segments replace older segments, which
	// may prevent players from rewinding all the way to the beginning of the event.VOD
	// mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running,
	// converting it to a "VOD" type manifest on completion of the stream.
	Mode *string `locationName:"mode" type:"string" enum:"HlsMode"`

	// Generates the .m3u8 playlist file for this HLS output group. The segmentsOnly
	// option will output segments without the .m3u8 file.
	OutputSelection *string `locationName:"outputSelection" type:"string" enum:"HlsOutputSelection"`

	// Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files.
	// The value is calculated as follows: either the program date and time are
	// initialized using the input timecode source, or the time is initialized using
	// the input timecode source and the date is initialized using the timestampOffset.
	ProgramDateTime *string `locationName:"programDateTime" type:"string" enum:"HlsProgramDateTime"`

	// Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
	ProgramDateTimePeriod *int64 `locationName:"programDateTimePeriod" type:"integer"`

	// Length of MPEG-2 Transport Stream segments to create (in seconds). Note that
	// segments will end on the next keyframe after this number of seconds, so actual
	// segment length may be longer.
	SegmentLength *int64 `locationName:"segmentLength" min:"1" type:"integer"`

	// When set to useInputSegmentation, the output segment or fragment points are
	// set by the RAI markers from the input streams.
	SegmentationMode *string `locationName:"segmentationMode" type:"string" enum:"HlsSegmentationMode"`

	// Number of segments to write to a subdirectory before starting a new one.
	// directoryStructure must be subdirectoryPerStream for this setting to have
	// an effect.
	SegmentsPerSubdirectory *int64 `locationName:"segmentsPerSubdirectory" min:"1" type:"integer"`

	// Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag
	// of variant manifest.
	StreamInfResolution *string `locationName:"streamInfResolution" type:"string" enum:"HlsStreamInfResolution"`

	// Indicates ID3 frame that has the timecode.
	TimedMetadataId3Frame *string `locationName:"timedMetadataId3Frame" type:"string" enum:"HlsTimedMetadataId3Frame"`

	// Timed Metadata interval in seconds.
	TimedMetadataId3Period *int64 `locationName:"timedMetadataId3Period" type:"integer"`

	// Provides an extra millisecond delta offset to fine tune the timestamps.
	TimestampDeltaMilliseconds *int64 `locationName:"timestampDeltaMilliseconds" type:"integer"`

	// When set to "singleFile", emits the program as a single media resource (.ts)
	// file, and uses #EXT-X-BYTERANGE tags to index segment for playback. Playback
	// of VOD mode content during event is not guaranteed due to HTTP server caching.
	TsFileMode *string `locationName:"tsFileMode" type:"string" enum:"HlsTsFileMode"`
}

// String returns the string representation
func (s HlsGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsGroupSettings"}
	if s.ConstantIv != nil && len(*s.ConstantIv) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ConstantIv", 32))
	}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.IndexNSegments != nil && *s.IndexNSegments < 3 {
		invalidParams.Add(request.NewErrParamMinValue("IndexNSegments", 3))
	}
	if s.KeepSegments != nil && *s.KeepSegments < 1 {
		invalidParams.Add(request.NewErrParamMinValue("KeepSegments", 1))
	}
	if s.SegmentLength != nil && *s.SegmentLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SegmentLength", 1))
	}
	if s.SegmentsPerSubdirectory != nil && *s.SegmentsPerSubdirectory < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SegmentsPerSubdirectory", 1))
	}
	if s.CaptionLanguageMappings != nil {
		for i, v := range s.CaptionLanguageMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionLanguageMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.KeyProviderSettings != nil {
		if err := s.KeyProviderSettings.Validate(); err != nil {
			invalidParams.AddNested("KeyProviderSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdMarkers sets the AdMarkers field's value.
func (s *HlsGroupSettings) SetAdMarkers(v []*string) *HlsGroupSettings {
	s.AdMarkers = v
	return s
}

// SetBaseUrlContent sets the BaseUrlContent field's value.
func (s *HlsGroupSettings) SetBaseUrlContent(v string) *HlsGroupSettings {
	s.BaseUrlContent = &v
	return s
}

// SetBaseUrlManifest sets the BaseUrlManifest field's value.
func (s *HlsGroupSettings) SetBaseUrlManifest(v string) *HlsGroupSettings {
	s.BaseUrlManifest = &v
	return s
}

// SetCaptionLanguageMappings sets the CaptionLanguageMappings field's value.
func (s *HlsGroupSettings) SetCaptionLanguageMappings(v []*CaptionLanguageMapping) *HlsGroupSettings {
	s.CaptionLanguageMappings = v
	return s
}

// SetCaptionLanguageSetting sets the CaptionLanguageSetting field's value.
func (s *HlsGroupSettings) SetCaptionLanguageSetting(v string) *HlsGroupSettings {
	s.CaptionLanguageSetting = &v
	return s
}

// SetClientCache sets the ClientCache field's value.
func (s *HlsGroupSettings) SetClientCache(v string) *HlsGroupSettings {
	s.ClientCache = &v
	return s
}

// SetCodecSpecification sets the CodecSpecification field's value.
func (s *HlsGroupSettings) SetCodecSpecification(v string) *HlsGroupSettings {
	s.CodecSpecification = &v
	return s
}

// SetConstantIv sets the ConstantIv field's value.
func (s *HlsGroupSettings) SetConstantIv(v string) *HlsGroupSettings {
	s.ConstantIv = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *HlsGroupSettings) SetDestination(v *OutputLocationRef) *HlsGroupSettings {
	s.Destination = v
	return s
}

// SetDirectoryStructure sets the DirectoryStructure field's value.
func (s *HlsGroupSettings) SetDirectoryStructure(v string) *HlsGroupSettings {
	s.DirectoryStructure = &v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *HlsGroupSettings) SetEncryptionType(v string) *HlsGroupSettings {
	s.EncryptionType = &v
	return s
}

// SetHlsCdnSettings sets the HlsCdnSettings field's value.
func (s *HlsGroupSettings) SetHlsCdnSettings(v *HlsCdnSettings) *HlsGroupSettings {
	s.HlsCdnSettings = v
	return s
}

// SetIndexNSegments sets the IndexNSegments field's value.
func (s *HlsGroupSettings) SetIndexNSegments(v int64) *HlsGroupSettings {
	s.IndexNSegments = &v
	return s
}

// SetInputLossAction sets the InputLossAction field's value.
func (s *HlsGroupSettings) SetInputLossAction(v string) *HlsGroupSettings {
	s.InputLossAction = &v
	return s
}

// SetIvInManifest sets the IvInManifest field's value.
func (s *HlsGroupSettings) SetIvInManifest(v string) *HlsGroupSettings {
	s.IvInManifest = &v
	return s
}

// SetIvSource sets the IvSource field's value.
func (s *HlsGroupSettings) SetIvSource(v string) *HlsGroupSettings {
	s.IvSource = &v
	return s
}

// SetKeepSegments sets the KeepSegments field's value.
func (s *HlsGroupSettings) SetKeepSegments(v int64) *HlsGroupSettings {
	s.KeepSegments = &v
	return s
}

// SetKeyFormat sets the KeyFormat field's value.
func (s *HlsGroupSettings) SetKeyFormat(v string) *HlsGroupSettings {
	s.KeyFormat = &v
	return s
}

// SetKeyFormatVersions sets the KeyFormatVersions field's value.
func (s *HlsGroupSettings) SetKeyFormatVersions(v string) *HlsGroupSettings {
	s.KeyFormatVersions = &v
	return s
}

// SetKeyProviderSettings sets the KeyProviderSettings field's value.
func (s *HlsGroupSettings) SetKeyProviderSettings(v *KeyProviderSettings) *HlsGroupSettings {
	s.KeyProviderSettings = v
	return s
}

// SetManifestCompression sets the ManifestCompression field's value.
func (s *HlsGroupSettings) SetManifestCompression(v string) *HlsGroupSettings {
	s.ManifestCompression = &v
	return s
}

// SetManifestDurationFormat sets the ManifestDurationFormat field's value.
func (s *HlsGroupSettings) SetManifestDurationFormat(v string) *HlsGroupSettings {
	s.ManifestDurationFormat = &v
	return s
}

// SetMinSegmentLength sets the MinSegmentLength field's value.
func (s *HlsGroupSettings) SetMinSegmentLength(v int64) *HlsGroupSettings {
	s.MinSegmentLength = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *HlsGroupSettings) SetMode(v string) *HlsGroupSettings {
	s.Mode = &v
	return s
}

// SetOutputSelection sets the OutputSelection field's value.
func (s *HlsGroupSettings) SetOutputSelection(v string) *HlsGroupSettings {
	s.OutputSelection = &v
	return s
}

// SetProgramDateTime sets the ProgramDateTime field's value.
func (s *HlsGroupSettings) SetProgramDateTime(v string) *HlsGroupSettings {
	s.ProgramDateTime = &v
	return s
}

// SetProgramDateTimePeriod sets the ProgramDateTimePeriod field's value.
func (s *HlsGroupSettings) SetProgramDateTimePeriod(v int64) *HlsGroupSettings {
	s.ProgramDateTimePeriod = &v
	return s
}

// SetSegmentLength sets the SegmentLength field's value.
func (s *HlsGroupSettings) SetSegmentLength(v int64) *HlsGroupSettings {
	s.SegmentLength = &v
	return s
}

// SetSegmentationMode sets the SegmentationMode field's value.
func (s *HlsGroupSettings) SetSegmentationMode(v string) *HlsGroupSettings {
	s.SegmentationMode = &v
	return s
}

// SetSegmentsPerSubdirectory sets the SegmentsPerSubdirectory field's value.
func (s *HlsGroupSettings) SetSegmentsPerSubdirectory(v int64) *HlsGroupSettings {
	s.SegmentsPerSubdirectory = &v
	return s
}

// SetStreamInfResolution sets the StreamInfResolution field's value.
func (s *HlsGroupSettings) SetStreamInfResolution(v string) *HlsGroupSettings {
	s.StreamInfResolution = &v
	return s
}

// SetTimedMetadataId3Frame sets the TimedMetadataId3Frame field's value.
func (s *HlsGroupSettings) SetTimedMetadataId3Frame(v string) *HlsGroupSettings {
	s.TimedMetadataId3Frame = &v
	return s
}

// SetTimedMetadataId3Period sets the TimedMetadataId3Period field's value.
func (s *HlsGroupSettings) SetTimedMetadataId3Period(v int64) *HlsGroupSettings {
	s.TimedMetadataId3Period = &v
	return s
}

// SetTimestampDeltaMilliseconds sets the TimestampDeltaMilliseconds field's value.
func (s *HlsGroupSettings) SetTimestampDeltaMilliseconds(v int64) *HlsGroupSettings {
	s.TimestampDeltaMilliseconds = &v
	return s
}

// SetTsFileMode sets the TsFileMode field's value.
func (s *HlsGroupSettings) SetTsFileMode(v string) *HlsGroupSettings {
	s.TsFileMode = &v
	return s
}

type HlsInputSettings struct {
	_ struct{} `type:"structure"`

	// When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches
	// this value will be chosen, otherwise the highest bandwidth stream in the
	// m3u8 will be chosen. The bitrate is specified in bits per second, as in an
	// HLS manifest.
	Bandwidth *int64 `locationName:"bandwidth" type:"integer"`

	// When specified, reading of the HLS input will begin this many buffer segments
	// from the end (most recently written segment). When not specified, the HLS
	// input will begin with the first segment specified in the m3u8.
	BufferSegments *int64 `locationName:"bufferSegments" type:"integer"`

	// The number of consecutive times that attempts to read a manifest or segment
	// must fail before the input is considered unavailable.
	Retries *int64 `locationName:"retries" type:"integer"`

	// The number of seconds between retries when an attempt to read a manifest
	// or segment fails.
	RetryInterval *int64 `locationName:"retryInterval" type:"integer"`
}

// String returns the string representation
func (s HlsInputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsInputSettings) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *HlsInputSettings) SetBandwidth(v int64) *HlsInputSettings {
	s.Bandwidth = &v
	return s
}

// SetBufferSegments sets the BufferSegments field's value.
func (s *HlsInputSettings) SetBufferSegments(v int64) *HlsInputSettings {
	s.BufferSegments = &v
	return s
}

// SetRetries sets the Retries field's value.
func (s *HlsInputSettings) SetRetries(v int64) *HlsInputSettings {
	s.Retries = &v
	return s
}

// SetRetryInterval sets the RetryInterval field's value.
func (s *HlsInputSettings) SetRetryInterval(v int64) *HlsInputSettings {
	s.RetryInterval = &v
	return s
}

type HlsMediaStoreSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// When set to temporal, output files are stored in non-persistent memory for
	// faster reading and writing.
	MediaStoreStorageClass *string `locationName:"mediaStoreStorageClass" type:"string" enum:"HlsMediaStoreStorageClass"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s HlsMediaStoreSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsMediaStoreSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsMediaStoreSettings) SetConnectionRetryInterval(v int64) *HlsMediaStoreSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsMediaStoreSettings) SetFilecacheDuration(v int64) *HlsMediaStoreSettings {
	s.FilecacheDuration = &v
	return s
}

// SetMediaStoreStorageClass sets the MediaStoreStorageClass field's value.
func (s *HlsMediaStoreSettings) SetMediaStoreStorageClass(v string) *HlsMediaStoreSettings {
	s.MediaStoreStorageClass = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsMediaStoreSettings) SetNumRetries(v int64) *HlsMediaStoreSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsMediaStoreSettings) SetRestartDelay(v int64) *HlsMediaStoreSettings {
	s.RestartDelay = &v
	return s
}

type HlsOutputSettings struct {
	_ struct{} `type:"structure"`

	// Settings regarding the underlying stream. These settings are different for
	// audio-only outputs.
	//
	// HlsSettings is a required field
	HlsSettings *HlsSettings `locationName:"hlsSettings" type:"structure" required:"true"`

	// String concatenated to the end of the destination filename. Accepts \"Format
	// Identifiers\":#formatIdentifierParameters.
	NameModifier *string `locationName:"nameModifier" min:"1" type:"string"`

	// String concatenated to end of segment filenames.
	SegmentModifier *string `locationName:"segmentModifier" type:"string"`
}

// String returns the string representation
func (s HlsOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsOutputSettings"}
	if s.HlsSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("HlsSettings"))
	}
	if s.NameModifier != nil && len(*s.NameModifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameModifier", 1))
	}
	if s.HlsSettings != nil {
		if err := s.HlsSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHlsSettings sets the HlsSettings field's value.
func (s *HlsOutputSettings) SetHlsSettings(v *HlsSettings) *HlsOutputSettings {
	s.HlsSettings = v
	return s
}

// SetNameModifier sets the NameModifier field's value.
func (s *HlsOutputSettings) SetNameModifier(v string) *HlsOutputSettings {
	s.NameModifier = &v
	return s
}

// SetSegmentModifier sets the SegmentModifier field's value.
func (s *HlsOutputSettings) SetSegmentModifier(v string) *HlsOutputSettings {
	s.SegmentModifier = &v
	return s
}

type HlsSettings struct {
	_ struct{} `type:"structure"`

	AudioOnlyHlsSettings *AudioOnlyHlsSettings `locationName:"audioOnlyHlsSettings" type:"structure"`

	StandardHlsSettings *StandardHlsSettings `locationName:"standardHlsSettings" type:"structure"`
}

// String returns the string representation
func (s HlsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsSettings"}
	if s.AudioOnlyHlsSettings != nil {
		if err := s.AudioOnlyHlsSettings.Validate(); err != nil {
			invalidParams.AddNested("AudioOnlyHlsSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.StandardHlsSettings != nil {
		if err := s.StandardHlsSettings.Validate(); err != nil {
			invalidParams.AddNested("StandardHlsSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioOnlyHlsSettings sets the AudioOnlyHlsSettings field's value.
func (s *HlsSettings) SetAudioOnlyHlsSettings(v *AudioOnlyHlsSettings) *HlsSettings {
	s.AudioOnlyHlsSettings = v
	return s
}

// SetStandardHlsSettings sets the StandardHlsSettings field's value.
func (s *HlsSettings) SetStandardHlsSettings(v *StandardHlsSettings) *HlsSettings {
	s.StandardHlsSettings = v
	return s
}

type HlsWebdavSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Specify whether or not to use chunked transfer encoding to WebDAV.
	HttpTransferMode *string `locationName:"httpTransferMode" type:"string" enum:"HlsWebdavHttpTransferMode"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s HlsWebdavSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsWebdavSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsWebdavSettings) SetConnectionRetryInterval(v int64) *HlsWebdavSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsWebdavSettings) SetFilecacheDuration(v int64) *HlsWebdavSettings {
	s.FilecacheDuration = &v
	return s
}

// SetHttpTransferMode sets the HttpTransferMode field's value.
func (s *HlsWebdavSettings) SetHttpTransferMode(v string) *HlsWebdavSettings {
	s.HttpTransferMode = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsWebdavSettings) SetNumRetries(v int64) *HlsWebdavSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsWebdavSettings) SetRestartDelay(v int64) *HlsWebdavSettings {
	s.RestartDelay = &v
	return s
}

type Input struct {
	_ struct{} `type:"structure"`

	// The Unique ARN of the input (generated, immutable).
	Arn *string `locationName:"arn" type:"string"`

	// A list of channel IDs that that input is attached to (currently an input
	// can only be attached to one channel).
	AttachedChannels []*string `locationName:"attachedChannels" type:"list"`

	// A list of the destinations of the input (PUSH-type).
	Destinations []*InputDestination `locationName:"destinations" type:"list"`

	// The generated ID of the input (unique for user account, immutable).
	Id *string `locationName:"id" type:"string"`

	// The user-assigned name (This is a mutable value).
	Name *string `locationName:"name" type:"string"`

	// A list of IDs for all the security groups attached to the input.
	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// A list of the sources of the input (PULL-type).
	Sources []*InputSource `locationName:"sources" type:"list"`

	State *string `locationName:"state" type:"string" enum:"InputState"`

	Type *string `locationName:"type" type:"string" enum:"InputType"`
}

// String returns the string representation
func (s Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Input) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Input) SetArn(v string) *Input {
	s.Arn = &v
	return s
}

// SetAttachedChannels sets the AttachedChannels field's value.
func (s *Input) SetAttachedChannels(v []*string) *Input {
	s.AttachedChannels = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *Input) SetDestinations(v []*InputDestination) *Input {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *Input) SetId(v string) *Input {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Input) SetName(v string) *Input {
	s.Name = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *Input) SetSecurityGroups(v []*string) *Input {
	s.SecurityGroups = v
	return s
}

// SetSources sets the Sources field's value.
func (s *Input) SetSources(v []*InputSource) *Input {
	s.Sources = v
	return s
}

// SetState sets the State field's value.
func (s *Input) SetState(v string) *Input {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *Input) SetType(v string) *Input {
	s.Type = &v
	return s
}

type InputAttachment struct {
	_ struct{} `type:"structure"`

	// The ID of the input
	InputId *string `locationName:"inputId" type:"string"`

	// Settings of an input (caption selector, etc.)
	InputSettings *InputSettings `locationName:"inputSettings" type:"structure"`
}

// String returns the string representation
func (s InputAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputAttachment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputAttachment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputAttachment"}
	if s.InputSettings != nil {
		if err := s.InputSettings.Validate(); err != nil {
			invalidParams.AddNested("InputSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputId sets the InputId field's value.
func (s *InputAttachment) SetInputId(v string) *InputAttachment {
	s.InputId = &v
	return s
}

// SetInputSettings sets the InputSettings field's value.
func (s *InputAttachment) SetInputSettings(v *InputSettings) *InputAttachment {
	s.InputSettings = v
	return s
}

type InputChannelLevel struct {
	_ struct{} `type:"structure"`

	// Remixing value. Units are in dB and acceptable values are within the range
	// from -60 (mute) and 6 dB.
	//
	// Gain is a required field
	Gain *int64 `locationName:"gain" type:"integer" required:"true"`

	// The index of the input channel used as a source.
	//
	// InputChannel is a required field
	InputChannel *int64 `locationName:"inputChannel" type:"integer" required:"true"`
}

// String returns the string representation
func (s InputChannelLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputChannelLevel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputChannelLevel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputChannelLevel"}
	if s.Gain == nil {
		invalidParams.Add(request.NewErrParamRequired("Gain"))
	}
	if s.Gain != nil && *s.Gain < -60 {
		invalidParams.Add(request.NewErrParamMinValue("Gain", -60))
	}
	if s.InputChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("InputChannel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGain sets the Gain field's value.
func (s *InputChannelLevel) SetGain(v int64) *InputChannelLevel {
	s.Gain = &v
	return s
}

// SetInputChannel sets the InputChannel field's value.
func (s *InputChannelLevel) SetInputChannel(v int64) *InputChannelLevel {
	s.InputChannel = &v
	return s
}

// The settings for a PUSH type input.
type InputDestination struct {
	_ struct{} `type:"structure"`

	// The system-generated static IP address of endpoint.It remains fixed for the
	// lifetime of the input.
	Ip *string `locationName:"ip" type:"string"`

	// The port number for the input.
	Port *string `locationName:"port" type:"string"`

	// This represents the endpoint that the customer stream will bepushed to.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s InputDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDestination) GoString() string {
	return s.String()
}

// SetIp sets the Ip field's value.
func (s *InputDestination) SetIp(v string) *InputDestination {
	s.Ip = &v
	return s
}

// SetPort sets the Port field's value.
func (s *InputDestination) SetPort(v string) *InputDestination {
	s.Port = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *InputDestination) SetUrl(v string) *InputDestination {
	s.Url = &v
	return s
}

// Endpoint settings for a PUSH type input.
type InputDestinationRequest struct {
	_ struct{} `type:"structure"`

	// A unique name for the location the RTMP stream is being pushedto.
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation
func (s InputDestinationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDestinationRequest) GoString() string {
	return s.String()
}

// SetStreamName sets the StreamName field's value.
func (s *InputDestinationRequest) SetStreamName(v string) *InputDestinationRequest {
	s.StreamName = &v
	return s
}

type InputLocation struct {
	_ struct{} `type:"structure"`

	// key used to extract the password from EC2 Parameter store
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// Uniform Resource Identifier - This should be a path to a file accessible
	// to the Live system (eg. a http:// URI) depending on the output type. For
	// example, a RTMP destination should have a uri simliar to: "rtmp://fmsserver/live".
	//
	// Uri is a required field
	Uri *string `locationName:"uri" type:"string" required:"true"`

	// Username if credentials are required to access a file or publishing point.
	// This can be either a plaintext username, or a reference to an AWS parameter
	// store name from which the username can be retrieved. AWS Parameter store
	// format: "ssm://"
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s InputLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputLocation"}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *InputLocation) SetPasswordParam(v string) *InputLocation {
	s.PasswordParam = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *InputLocation) SetUri(v string) *InputLocation {
	s.Uri = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InputLocation) SetUsername(v string) *InputLocation {
	s.Username = &v
	return s
}

type InputLossBehavior struct {
	_ struct{} `type:"structure"`

	// On input loss, the number of milliseconds to substitute black into the output
	// before switching to the frame specified by inputLossImageType. A value x,
	// where 0 <= x <= 1,000,000 and a value of 1,000,000 will be interpreted as
	// infinite.
	BlackFrameMsec *int64 `locationName:"blackFrameMsec" type:"integer"`

	// When input loss image type is "color" this field specifies the color to use.
	// Value: 6 hex characters representing the values of RGB.
	InputLossImageColor *string `locationName:"inputLossImageColor" min:"6" type:"string"`

	// When input loss image type is "slate" these fields specify the parameters
	// for accessing the slate.
	InputLossImageSlate *InputLocation `locationName:"inputLossImageSlate" type:"structure"`

	// Indicates whether to substitute a solid color or a slate into the output
	// after input loss exceeds blackFrameMsec.
	InputLossImageType *string `locationName:"inputLossImageType" type:"string" enum:"InputLossImageType"`

	// On input loss, the number of milliseconds to repeat the previous picture
	// before substituting black into the output. A value x, where 0 <= x <= 1,000,000
	// and a value of 1,000,000 will be interpreted as infinite.
	RepeatFrameMsec *int64 `locationName:"repeatFrameMsec" type:"integer"`
}

// String returns the string representation
func (s InputLossBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputLossBehavior) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLossBehavior) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputLossBehavior"}
	if s.InputLossImageColor != nil && len(*s.InputLossImageColor) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("InputLossImageColor", 6))
	}
	if s.InputLossImageSlate != nil {
		if err := s.InputLossImageSlate.Validate(); err != nil {
			invalidParams.AddNested("InputLossImageSlate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlackFrameMsec sets the BlackFrameMsec field's value.
func (s *InputLossBehavior) SetBlackFrameMsec(v int64) *InputLossBehavior {
	s.BlackFrameMsec = &v
	return s
}

// SetInputLossImageColor sets the InputLossImageColor field's value.
func (s *InputLossBehavior) SetInputLossImageColor(v string) *InputLossBehavior {
	s.InputLossImageColor = &v
	return s
}

// SetInputLossImageSlate sets the InputLossImageSlate field's value.
func (s *InputLossBehavior) SetInputLossImageSlate(v *InputLocation) *InputLossBehavior {
	s.InputLossImageSlate = v
	return s
}

// SetInputLossImageType sets the InputLossImageType field's value.
func (s *InputLossBehavior) SetInputLossImageType(v string) *InputLossBehavior {
	s.InputLossImageType = &v
	return s
}

// SetRepeatFrameMsec sets the RepeatFrameMsec field's value.
func (s *InputLossBehavior) SetRepeatFrameMsec(v int64) *InputLossBehavior {
	s.RepeatFrameMsec = &v
	return s
}

// An Input Security Group
type InputSecurityGroup struct {
	_ struct{} `type:"structure"`

	// Unique ARN of Input Security Group
	Arn *string `locationName:"arn" type:"string"`

	// The Id of the Input Security Group
	Id *string `locationName:"id" type:"string"`

	// The list of inputs currently using this Input Security Group.
	Inputs []*string `locationName:"inputs" type:"list"`

	// The current state of the Input Security Group.
	State *string `locationName:"state" type:"string" enum:"InputSecurityGroupState"`

	// Whitelist rules and their sync status
	WhitelistRules []*InputWhitelistRule `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation
func (s InputSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSecurityGroup) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InputSecurityGroup) SetArn(v string) *InputSecurityGroup {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *InputSecurityGroup) SetId(v string) *InputSecurityGroup {
	s.Id = &v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *InputSecurityGroup) SetInputs(v []*string) *InputSecurityGroup {
	s.Inputs = v
	return s
}

// SetState sets the State field's value.
func (s *InputSecurityGroup) SetState(v string) *InputSecurityGroup {
	s.State = &v
	return s
}

// SetWhitelistRules sets the WhitelistRules field's value.
func (s *InputSecurityGroup) SetWhitelistRules(v []*InputWhitelistRule) *InputSecurityGroup {
	s.WhitelistRules = v
	return s
}

// Live Event input parameters. There can be multiple inputs in a single Live
// Event.
type InputSettings struct {
	_ struct{} `type:"structure"`

	// Used to select the audio stream to decode for inputs that have multiple available.
	AudioSelectors []*AudioSelector `locationName:"audioSelectors" type:"list"`

	// Used to select the caption input to use for inputs that have multiple available.
	CaptionSelectors []*CaptionSelector `locationName:"captionSelectors" type:"list"`

	// Enable or disable the deblock filter when filtering.
	DeblockFilter *string `locationName:"deblockFilter" type:"string" enum:"InputDeblockFilter"`

	// Enable or disable the denoise filter when filtering.
	DenoiseFilter *string `locationName:"denoiseFilter" type:"string" enum:"InputDenoiseFilter"`

	// Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
	FilterStrength *int64 `locationName:"filterStrength" min:"1" type:"integer"`

	// Turns on the filter for this input. MPEG-2 inputs have the deblocking filter
	// enabled by default.1) auto - filtering will be applied depending on input
	// type/quality2) disabled - no filtering will be applied to the input3) forced
	// - filtering will be applied regardless of input type
	InputFilter *string `locationName:"inputFilter" type:"string" enum:"InputFilter"`

	// Input settings.
	NetworkInputSettings *NetworkInputSettings `locationName:"networkInputSettings" type:"structure"`

	// Loop input if it is a file. This allows a file input to be streamed indefinitely.
	SourceEndBehavior *string `locationName:"sourceEndBehavior" type:"string" enum:"InputSourceEndBehavior"`

	// Informs which video elementary stream to decode for input types that have
	// multiple available.
	VideoSelector *VideoSelector `locationName:"videoSelector" type:"structure"`
}

// String returns the string representation
func (s InputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputSettings"}
	if s.FilterStrength != nil && *s.FilterStrength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FilterStrength", 1))
	}
	if s.AudioSelectors != nil {
		for i, v := range s.AudioSelectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioSelectors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CaptionSelectors != nil {
		for i, v := range s.CaptionSelectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionSelectors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioSelectors sets the AudioSelectors field's value.
func (s *InputSettings) SetAudioSelectors(v []*AudioSelector) *InputSettings {
	s.AudioSelectors = v
	return s
}

// SetCaptionSelectors sets the CaptionSelectors field's value.
func (s *InputSettings) SetCaptionSelectors(v []*CaptionSelector) *InputSettings {
	s.CaptionSelectors = v
	return s
}

// SetDeblockFilter sets the DeblockFilter field's value.
func (s *InputSettings) SetDeblockFilter(v string) *InputSettings {
	s.DeblockFilter = &v
	return s
}

// SetDenoiseFilter sets the DenoiseFilter field's value.
func (s *InputSettings) SetDenoiseFilter(v string) *InputSettings {
	s.DenoiseFilter = &v
	return s
}

// SetFilterStrength sets the FilterStrength field's value.
func (s *InputSettings) SetFilterStrength(v int64) *InputSettings {
	s.FilterStrength = &v
	return s
}

// SetInputFilter sets the InputFilter field's value.
func (s *InputSettings) SetInputFilter(v string) *InputSettings {
	s.InputFilter = &v
	return s
}

// SetNetworkInputSettings sets the NetworkInputSettings field's value.
func (s *InputSettings) SetNetworkInputSettings(v *NetworkInputSettings) *InputSettings {
	s.NetworkInputSettings = v
	return s
}

// SetSourceEndBehavior sets the SourceEndBehavior field's value.
func (s *InputSettings) SetSourceEndBehavior(v string) *InputSettings {
	s.SourceEndBehavior = &v
	return s
}

// SetVideoSelector sets the VideoSelector field's value.
func (s *InputSettings) SetVideoSelector(v *VideoSelector) *InputSettings {
	s.VideoSelector = v
	return s
}

// The settings for a PULL type input.
type InputSource struct {
	_ struct{} `type:"structure"`

	// The key used to extract the password from EC2 Parameter store.
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// This represents the customer's source URL where stream ispulled from.
	Url *string `locationName:"url" type:"string"`

	// The username for the input source.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s InputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSource) GoString() string {
	return s.String()
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *InputSource) SetPasswordParam(v string) *InputSource {
	s.PasswordParam = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *InputSource) SetUrl(v string) *InputSource {
	s.Url = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InputSource) SetUsername(v string) *InputSource {
	s.Username = &v
	return s
}

// Settings for for a PULL type input.
type InputSourceRequest struct {
	_ struct{} `type:"structure"`

	// The key used to extract the password from EC2 Parameter store.
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// This represents the customer's source URL where stream ispulled from.
	Url *string `locationName:"url" type:"string"`

	// The username for the input source.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s InputSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSourceRequest) GoString() string {
	return s.String()
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *InputSourceRequest) SetPasswordParam(v string) *InputSourceRequest {
	s.PasswordParam = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *InputSourceRequest) SetUrl(v string) *InputSourceRequest {
	s.Url = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InputSourceRequest) SetUsername(v string) *InputSourceRequest {
	s.Username = &v
	return s
}

type InputSpecification struct {
	_ struct{} `type:"structure"`

	// Input codec
	Codec *string `locationName:"codec" type:"string" enum:"InputCodec"`

	// Maximum input bitrate, categorized coarsely
	MaximumBitrate *string `locationName:"maximumBitrate" type:"string" enum:"InputMaximumBitrate"`

	// Input resolution, categorized coarsely
	Resolution *string `locationName:"resolution" type:"string" enum:"InputResolution"`
}

// String returns the string representation
func (s InputSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSpecification) GoString() string {
	return s.String()
}

// SetCodec sets the Codec field's value.
func (s *InputSpecification) SetCodec(v string) *InputSpecification {
	s.Codec = &v
	return s
}

// SetMaximumBitrate sets the MaximumBitrate field's value.
func (s *InputSpecification) SetMaximumBitrate(v string) *InputSpecification {
	s.MaximumBitrate = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *InputSpecification) SetResolution(v string) *InputSpecification {
	s.Resolution = &v
	return s
}

// Whitelist rule
type InputWhitelistRule struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR that's whitelisted.
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation
func (s InputWhitelistRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputWhitelistRule) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *InputWhitelistRule) SetCidr(v string) *InputWhitelistRule {
	s.Cidr = &v
	return s
}

// An IPv4 CIDR to whitelist.
type InputWhitelistRuleCidr struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR to whitelist.
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation
func (s InputWhitelistRuleCidr) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputWhitelistRuleCidr) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *InputWhitelistRuleCidr) SetCidr(v string) *InputWhitelistRuleCidr {
	s.Cidr = &v
	return s
}

type KeyProviderSettings struct {
	_ struct{} `type:"structure"`

	StaticKeySettings *StaticKeySettings `locationName:"staticKeySettings" type:"structure"`
}

// String returns the string representation
func (s KeyProviderSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyProviderSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyProviderSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyProviderSettings"}
	if s.StaticKeySettings != nil {
		if err := s.StaticKeySettings.Validate(); err != nil {
			invalidParams.AddNested("StaticKeySettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticKeySettings sets the StaticKeySettings field's value.
func (s *KeyProviderSettings) SetStaticKeySettings(v *StaticKeySettings) *KeyProviderSettings {
	s.StaticKeySettings = v
	return s
}

type ListChannelsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsInput) SetMaxResults(v int64) *ListChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsInput) SetNextToken(v string) *ListChannelsInput {
	s.NextToken = &v
	return s
}

type ListChannelsOutput struct {
	_ struct{} `type:"structure"`

	Channels []*ChannelSummary `locationName:"channels" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListChannelsOutput) SetChannels(v []*ChannelSummary) *ListChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsOutput) SetNextToken(v string) *ListChannelsOutput {
	s.NextToken = &v
	return s
}

type ListInputSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputSecurityGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInputSecurityGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInputSecurityGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInputSecurityGroupsInput) SetMaxResults(v int64) *ListInputSecurityGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputSecurityGroupsInput) SetNextToken(v string) *ListInputSecurityGroupsInput {
	s.NextToken = &v
	return s
}

type ListInputSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	InputSecurityGroups []*InputSecurityGroup `locationName:"inputSecurityGroups" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputSecurityGroupsOutput) GoString() string {
	return s.String()
}

// SetInputSecurityGroups sets the InputSecurityGroups field's value.
func (s *ListInputSecurityGroupsOutput) SetInputSecurityGroups(v []*InputSecurityGroup) *ListInputSecurityGroupsOutput {
	s.InputSecurityGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputSecurityGroupsOutput) SetNextToken(v string) *ListInputSecurityGroupsOutput {
	s.NextToken = &v
	return s
}

type ListInputsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInputsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInputsInput) SetMaxResults(v int64) *ListInputsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputsInput) SetNextToken(v string) *ListInputsInput {
	s.NextToken = &v
	return s
}

type ListInputsOutput struct {
	_ struct{} `type:"structure"`

	Inputs []*Input `locationName:"inputs" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListInputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInputsOutput) GoString() string {
	return s.String()
}

// SetInputs sets the Inputs field's value.
func (s *ListInputsOutput) SetInputs(v []*Input) *ListInputsOutput {
	s.Inputs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInputsOutput) SetNextToken(v string) *ListInputsOutput {
	s.NextToken = &v
	return s
}

type M2tsSettings struct {
	_ struct{} `type:"structure"`

	// When set to drop, output audio streams will be removed from the program if
	// the selected input audio stream is removed from the input. This allows the
	// output audio configuration to dynamically change based on input configuration.
	// If this is set to encodeSilence, all output audio streams will output encoded
	// silence when not connected to an active input stream.
	AbsentInputAudioBehavior *string `locationName:"absentInputAudioBehavior" type:"string" enum:"M2tsAbsentInputAudioBehavior"`

	// When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
	Arib *string `locationName:"arib" type:"string" enum:"M2tsArib"`

	// Packet Identifier (PID) for ARIB Captions in the transport stream. Can be
	// entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182
	// (or 0x1ff6).
	AribCaptionsPid *string `locationName:"aribCaptionsPid" type:"string"`

	// If set to auto, pid number used for ARIB Captions will be auto-selected from
	// unused pids. If set to useConfigured, ARIB Captions will be on the configured
	// pid number.
	AribCaptionsPidControl *string `locationName:"aribCaptionsPidControl" type:"string" enum:"M2tsAribCaptionsPidControl"`

	// When set to dvb, uses DVB buffer model for Dolby Digital audio. When set
	// to atsc, the ATSC model is used.
	AudioBufferModel *string `locationName:"audioBufferModel" type:"string" enum:"M2tsAudioBufferModel"`

	// The number of audio frames to insert for each PES packet.
	AudioFramesPerPes *int64 `locationName:"audioFramesPerPes" type:"integer"`

	// Packet Identifier (PID) of the elementary audio stream(s) in the transport
	// stream. Multiple values are accepted, and can be entered in ranges and/or
	// by comma separation. Can be entered as decimal or hexadecimal values. Each
	// PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	AudioPids *string `locationName:"audioPids" type:"string"`

	// When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87
	// for EAC3. When set to dvb, uses stream type = 0x06.
	AudioStreamType *string `locationName:"audioStreamType" type:"string" enum:"M2tsAudioStreamType"`

	// The output bitrate of the transport stream in bits per second. Setting to
	// 0 lets the muxer automatically determine the appropriate bitrate.
	Bitrate *int64 `locationName:"bitrate" type:"integer"`

	// If set to multiplex, use multiplex buffer model for accurate interleaving.
	// Setting to bufferModel to none can lead to lower latency, but low-memory
	// devices may not be able to play back the stream without interruptions.
	BufferModel *string `locationName:"bufferModel" type:"string" enum:"M2tsBufferModel"`

	// When set to enabled, generates captionServiceDescriptor in PMT.
	CcDescriptor *string `locationName:"ccDescriptor" type:"string" enum:"M2tsCcDescriptor"`

	// Inserts DVB Network Information Table (NIT) at the specified table repetition
	// interval.
	DvbNitSettings *DvbNitSettings `locationName:"dvbNitSettings" type:"structure"`

	// Inserts DVB Service Description Table (SDT) at the specified table repetition
	// interval.
	DvbSdtSettings *DvbSdtSettings `locationName:"dvbSdtSettings" type:"structure"`

	// Packet Identifier (PID) for input source DVB Subtitle data to this output.
	// Multiple values are accepted, and can be entered in ranges and/or by comma
	// separation. Can be entered as decimal or hexadecimal values. Each PID specified
	// must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	DvbSubPids *string `locationName:"dvbSubPids" type:"string"`

	// Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.
	DvbTdtSettings *DvbTdtSettings `locationName:"dvbTdtSettings" type:"structure"`

	// Packet Identifier (PID) for input source DVB Teletext data to this output.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	DvbTeletextPid *string `locationName:"dvbTeletextPid" type:"string"`

	// If set to passthrough, passes any EBIF data from the input source to this
	// output.
	Ebif *string `locationName:"ebif" type:"string" enum:"M2tsEbifControl"`

	// When videoAndFixedIntervals is selected, audio EBP markers will be added
	// to partitions 3 and 4. The interval between these additional markers will
	// be fixed, and will be slightly shorter than the video EBP marker interval.
	// Only available when EBP Cablelabs segmentation markers are selected. Partitions
	// 1 and 2 will always follow the video interval.
	EbpAudioInterval *string `locationName:"ebpAudioInterval" type:"string" enum:"M2tsAudioInterval"`

	// When set, enforces that Encoder Boundary Points do not come within the specified
	// time interval of each other by looking ahead at input video. If another EBP
	// is going to come in within the specified time interval, the current EBP is
	// not emitted, and the segment is "stretched" to the next marker. The lookahead
	// value does not add latency to the system. The Live Event must be configured
	// elsewhere to create sufficient latency to make the lookahead accurate.
	EbpLookaheadMs *int64 `locationName:"ebpLookaheadMs" type:"integer"`

	// Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP
	// markers will be placed on the video PID and all audio PIDs. If set to videoPid,
	// EBP markers will be placed on only the video PID.
	EbpPlacement *string `locationName:"ebpPlacement" type:"string" enum:"M2tsEbpPlacement"`

	// This field is unused and deprecated.
	EcmPid *string `locationName:"ecmPid" type:"string"`

	// Include or exclude the ES Rate field in the PES header.
	EsRateInPes *string `locationName:"esRateInPes" type:"string" enum:"M2tsEsRateInPes"`

	// Packet Identifier (PID) for input source ETV Platform data to this output.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	EtvPlatformPid *string `locationName:"etvPlatformPid" type:"string"`

	// Packet Identifier (PID) for input source ETV Signal data to this output.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	EtvSignalPid *string `locationName:"etvSignalPid" type:"string"`

	// The length in seconds of each fragment. Only used with EBP markers.
	FragmentTime *float64 `locationName:"fragmentTime" type:"double"`

	// If set to passthrough, passes any KLV data from the input source to this
	// output.
	Klv *string `locationName:"klv" type:"string" enum:"M2tsKlv"`

	// Packet Identifier (PID) for input source KLV data to this output. Multiple
	// values are accepted, and can be entered in ranges and/or by comma separation.
	// Can be entered as decimal or hexadecimal values. Each PID specified must
	// be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	KlvDataPids *string `locationName:"klvDataPids" type:"string"`

	// Value in bits per second of extra null packets to insert into the transport
	// stream. This can be used if a downstream encryption system requires periodic
	// null packets.
	NullPacketBitrate *float64 `locationName:"nullPacketBitrate" type:"double"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. Valid values are 0, 10..1000.
	PatInterval *int64 `locationName:"patInterval" type:"integer"`

	// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted
	// for every Packetized Elementary Stream (PES) header. This parameter is effective
	// only when the PCR PID is the same as the video or audio elementary stream.
	PcrControl *string `locationName:"pcrControl" type:"string" enum:"M2tsPcrControl"`

	// Maximum time in milliseconds between Program Clock Reference (PCRs) inserted
	// into the transport stream.
	PcrPeriod *int64 `locationName:"pcrPeriod" type:"integer"`

	// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport
	// stream. When no value is given, the encoder will assign the same value as
	// the Video PID. Can be entered as a decimal or hexadecimal value. Valid values
	// are 32 (or 0x20)..8182 (or 0x1ff6).
	PcrPid *string `locationName:"pcrPid" type:"string"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. Valid values are 0, 10..1000.
	PmtInterval *int64 `locationName:"pmtInterval" type:"integer"`

	// Packet Identifier (PID) for the Program Map Table (PMT) in the transport
	// stream. Can be entered as a decimal or hexadecimal value. Valid values are
	// 32 (or 0x20)..8182 (or 0x1ff6).
	PmtPid *string `locationName:"pmtPid" type:"string"`

	// The value of the program number field in the Program Map Table.
	ProgramNum *int64 `locationName:"programNum" type:"integer"`

	// When vbr, does not insert null packets into transport stream to fill specified
	// bitrate. The bitrate setting acts as the maximum bitrate when vbr is set.
	RateMode *string `locationName:"rateMode" type:"string" enum:"M2tsRateMode"`

	// Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple
	// values are accepted, and can be entered in ranges and/or by comma separation.
	// Can be entered as decimal or hexadecimal values. Each PID specified must
	// be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	Scte27Pids *string `locationName:"scte27Pids" type:"string"`

	// Optionally pass SCTE-35 signals from the input source to this output.
	Scte35Control *string `locationName:"scte35Control" type:"string" enum:"M2tsScte35Control"`

	// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can
	// be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182
	// (or 0x1ff6).
	Scte35Pid *string `locationName:"scte35Pid" type:"string"`

	// Inserts segmentation markers at each segmentationTime period. raiSegstart
	// sets the Random Access Indicator bit in the adaptation field. raiAdapt sets
	// the RAI bit and adds the current timecode in the private data bytes. psiSegstart
	// inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary
	// Point information to the adaptation field as per OpenCable specification
	// OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to
	// the adaptation field using a legacy proprietary format.
	SegmentationMarkers *string `locationName:"segmentationMarkers" type:"string" enum:"M2tsSegmentationMarkers"`

	// The segmentation style parameter controls how segmentation markers are inserted
	// into the transport stream. With avails, it is possible that segments may
	// be truncated, which can influence where future segmentation markers are inserted.When
	// a segmentation style of "resetCadence" is selected and a segment is truncated
	// due to an avail, we will reset the segmentation cadence. This means the subsequent
	// segment will have a duration of $segmentationTime seconds.When a segmentation
	// style of "maintainCadence" is selected and a segment is truncated due to
	// an avail, we will not reset the segmentation cadence. This means the subsequent
	// segment will likely be truncated as well. However, all segments after that
	// will have a duration of $segmentationTime seconds. Note that EBP lookahead
	// is a slight exception to this rule.
	SegmentationStyle *string `locationName:"segmentationStyle" type:"string" enum:"M2tsSegmentationStyle"`

	// The length in seconds of each segment. Required unless markers is set to
	// None_.
	SegmentationTime *float64 `locationName:"segmentationTime" type:"double"`

	// When set to passthrough, timed metadata will be passed through from input
	// to output.
	TimedMetadataBehavior *string `locationName:"timedMetadataBehavior" type:"string" enum:"M2tsTimedMetadataBehavior"`

	// Packet Identifier (PID) of the timed metadata stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	TimedMetadataPid *string `locationName:"timedMetadataPid" type:"string"`

	// The value of the transport stream ID field in the Program Map Table.
	TransportStreamId *int64 `locationName:"transportStreamId" type:"integer"`

	// Packet Identifier (PID) of the elementary video stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	VideoPid *string `locationName:"videoPid" type:"string"`
}

// String returns the string representation
func (s M2tsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s M2tsSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *M2tsSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "M2tsSettings"}
	if s.DvbNitSettings != nil {
		if err := s.DvbNitSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbNitSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.DvbSdtSettings != nil {
		if err := s.DvbSdtSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbSdtSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.DvbTdtSettings != nil {
		if err := s.DvbTdtSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbTdtSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbsentInputAudioBehavior sets the AbsentInputAudioBehavior field's value.
func (s *M2tsSettings) SetAbsentInputAudioBehavior(v string) *M2tsSettings {
	s.AbsentInputAudioBehavior = &v
	return s
}

// SetArib sets the Arib field's value.
func (s *M2tsSettings) SetArib(v string) *M2tsSettings {
	s.Arib = &v
	return s
}

// SetAribCaptionsPid sets the AribCaptionsPid field's value.
func (s *M2tsSettings) SetAribCaptionsPid(v string) *M2tsSettings {
	s.AribCaptionsPid = &v
	return s
}

// SetAribCaptionsPidControl sets the AribCaptionsPidControl field's value.
func (s *M2tsSettings) SetAribCaptionsPidControl(v string) *M2tsSettings {
	s.AribCaptionsPidControl = &v
	return s
}

// SetAudioBufferModel sets the AudioBufferModel field's value.
func (s *M2tsSettings) SetAudioBufferModel(v string) *M2tsSettings {
	s.AudioBufferModel = &v
	return s
}

// SetAudioFramesPerPes sets the AudioFramesPerPes field's value.
func (s *M2tsSettings) SetAudioFramesPerPes(v int64) *M2tsSettings {
	s.AudioFramesPerPes = &v
	return s
}

// SetAudioPids sets the AudioPids field's value.
func (s *M2tsSettings) SetAudioPids(v string) *M2tsSettings {
	s.AudioPids = &v
	return s
}

// SetAudioStreamType sets the AudioStreamType field's value.
func (s *M2tsSettings) SetAudioStreamType(v string) *M2tsSettings {
	s.AudioStreamType = &v
	return s
}

// SetBitrate sets the Bitrate field's value.
func (s *M2tsSettings) SetBitrate(v int64) *M2tsSettings {
	s.Bitrate = &v
	return s
}

// SetBufferModel sets the BufferModel field's value.
func (s *M2tsSettings) SetBufferModel(v string) *M2tsSettings {
	s.BufferModel = &v
	return s
}

// SetCcDescriptor sets the CcDescriptor field's value.
func (s *M2tsSettings) SetCcDescriptor(v string) *M2tsSettings {
	s.CcDescriptor = &v
	return s
}

// SetDvbNitSettings sets the DvbNitSettings field's value.
func (s *M2tsSettings) SetDvbNitSettings(v *DvbNitSettings) *M2tsSettings {
	s.DvbNitSettings = v
	return s
}

// SetDvbSdtSettings sets the DvbSdtSettings field's value.
func (s *M2tsSettings) SetDvbSdtSettings(v *DvbSdtSettings) *M2tsSettings {
	s.DvbSdtSettings = v
	return s
}

// SetDvbSubPids sets the DvbSubPids field's value.
func (s *M2tsSettings) SetDvbSubPids(v string) *M2tsSettings {
	s.DvbSubPids = &v
	return s
}

// SetDvbTdtSettings sets the DvbTdtSettings field's value.
func (s *M2tsSettings) SetDvbTdtSettings(v *DvbTdtSettings) *M2tsSettings {
	s.DvbTdtSettings = v
	return s
}

// SetDvbTeletextPid sets the DvbTeletextPid field's value.
func (s *M2tsSettings) SetDvbTeletextPid(v string) *M2tsSettings {
	s.DvbTeletextPid = &v
	return s
}

// SetEbif sets the Ebif field's value.
func (s *M2tsSettings) SetEbif(v string) *M2tsSettings {
	s.Ebif = &v
	return s
}

// SetEbpAudioInterval sets the EbpAudioInterval field's value.
func (s *M2tsSettings) SetEbpAudioInterval(v string) *M2tsSettings {
	s.EbpAudioInterval = &v
	return s
}

// SetEbpLookaheadMs sets the EbpLookaheadMs field's value.
func (s *M2tsSettings) SetEbpLookaheadMs(v int64) *M2tsSettings {
	s.EbpLookaheadMs = &v
	return s
}

// SetEbpPlacement sets the EbpPlacement field's value.
func (s *M2tsSettings) SetEbpPlacement(v string) *M2tsSettings {
	s.EbpPlacement = &v
	return s
}

// SetEcmPid sets the EcmPid field's value.
func (s *M2tsSettings) SetEcmPid(v string) *M2tsSettings {
	s.EcmPid = &v
	return s
}

// SetEsRateInPes sets the EsRateInPes field's value.
func (s *M2tsSettings) SetEsRateInPes(v string) *M2tsSettings {
	s.EsRateInPes = &v
	return s
}

// SetEtvPlatformPid sets the EtvPlatformPid field's value.
func (s *M2tsSettings) SetEtvPlatformPid(v string) *M2tsSettings {
	s.EtvPlatformPid = &v
	return s
}

// SetEtvSignalPid sets the EtvSignalPid field's value.
func (s *M2tsSettings) SetEtvSignalPid(v string) *M2tsSettings {
	s.EtvSignalPid = &v
	return s
}

// SetFragmentTime sets the FragmentTime field's value.
func (s *M2tsSettings) SetFragmentTime(v float64) *M2tsSettings {
	s.FragmentTime = &v
	return s
}

// SetKlv sets the Klv field's value.
func (s *M2tsSettings) SetKlv(v string) *M2tsSettings {
	s.Klv = &v
	return s
}

// SetKlvDataPids sets the KlvDataPids field's value.
func (s *M2tsSettings) SetKlvDataPids(v string) *M2tsSettings {
	s.KlvDataPids = &v
	return s
}

// SetNullPacketBitrate sets the NullPacketBitrate field's value.
func (s *M2tsSettings) SetNullPacketBitrate(v float64) *M2tsSettings {
	s.NullPacketBitrate = &v
	return s
}

// SetPatInterval sets the PatInterval field's value.
func (s *M2tsSettings) SetPatInterval(v int64) *M2tsSettings {
	s.PatInterval = &v
	return s
}

// SetPcrControl sets the PcrControl field's value.
func (s *M2tsSettings) SetPcrControl(v string) *M2tsSettings {
	s.PcrControl = &v
	return s
}

// SetPcrPeriod sets the PcrPeriod field's value.
func (s *M2tsSettings) SetPcrPeriod(v int64) *M2tsSettings {
	s.PcrPeriod = &v
	return s
}

// SetPcrPid sets the PcrPid field's value.
func (s *M2tsSettings) SetPcrPid(v string) *M2tsSettings {
	s.PcrPid = &v
	return s
}

// SetPmtInterval sets the PmtInterval field's value.
func (s *M2tsSettings) SetPmtInterval(v int64) *M2tsSettings {
	s.PmtInterval = &v
	return s
}

// SetPmtPid sets the PmtPid field's value.
func (s *M2tsSettings) SetPmtPid(v string) *M2tsSettings {
	s.PmtPid = &v
	return s
}

// SetProgramNum sets the ProgramNum field's value.
func (s *M2tsSettings) SetProgramNum(v int64) *M2tsSettings {
	s.ProgramNum = &v
	return s
}

// SetRateMode sets the RateMode field's value.
func (s *M2tsSettings) SetRateMode(v string) *M2tsSettings {
	s.RateMode = &v
	return s
}

// SetScte27Pids sets the Scte27Pids field's value.
func (s *M2tsSettings) SetScte27Pids(v string) *M2tsSettings {
	s.Scte27Pids = &v
	return s
}

// SetScte35Control sets the Scte35Control field's value.
func (s *M2tsSettings) SetScte35Control(v string) *M2tsSettings {
	s.Scte35Control = &v
	return s
}

// SetScte35Pid sets the Scte35Pid field's value.
func (s *M2tsSettings) SetScte35Pid(v string) *M2tsSettings {
	s.Scte35Pid = &v
	return s
}

// SetSegmentationMarkers sets the SegmentationMarkers field's value.
func (s *M2tsSettings) SetSegmentationMarkers(v string) *M2tsSettings {
	s.SegmentationMarkers = &v
	return s
}

// SetSegmentationStyle sets the SegmentationStyle field's value.
func (s *M2tsSettings) SetSegmentationStyle(v string) *M2tsSettings {
	s.SegmentationStyle = &v
	return s
}

// SetSegmentationTime sets the SegmentationTime field's value.
func (s *M2tsSettings) SetSegmentationTime(v float64) *M2tsSettings {
	s.SegmentationTime = &v
	return s
}

// SetTimedMetadataBehavior sets the TimedMetadataBehavior field's value.
func (s *M2tsSettings) SetTimedMetadataBehavior(v string) *M2tsSettings {
	s.TimedMetadataBehavior = &v
	return s
}

// SetTimedMetadataPid sets the TimedMetadataPid field's value.
func (s *M2tsSettings) SetTimedMetadataPid(v string) *M2tsSettings {
	s.TimedMetadataPid = &v
	return s
}

// SetTransportStreamId sets the TransportStreamId field's value.
func (s *M2tsSettings) SetTransportStreamId(v int64) *M2tsSettings {
	s.TransportStreamId = &v
	return s
}

// SetVideoPid sets the VideoPid field's value.
func (s *M2tsSettings) SetVideoPid(v string) *M2tsSettings {
	s.VideoPid = &v
	return s
}

// Settings information for the .m3u8 container
type M3u8Settings struct {
	_ struct{} `type:"structure"`

	// The number of audio frames to insert for each PES packet.
	AudioFramesPerPes *int64 `locationName:"audioFramesPerPes" type:"integer"`

	// Packet Identifier (PID) of the elementary audio stream(s) in the transport
	// stream. Multiple values are accepted, and can be entered in ranges and/or
	// by comma separation. Can be entered as decimal or hexadecimal values.
	AudioPids *string `locationName:"audioPids" type:"string"`

	// This parameter is unused and deprecated.
	EcmPid *string `locationName:"ecmPid" type:"string"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. A value of \"0\" writes out the PMT once per segment file.
	PatInterval *int64 `locationName:"patInterval" type:"integer"`

	// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted
	// for every Packetized Elementary Stream (PES) header. This parameter is effective
	// only when the PCR PID is the same as the video or audio elementary stream.
	PcrControl *string `locationName:"pcrControl" type:"string" enum:"M3u8PcrControl"`

	// Maximum time in milliseconds between Program Clock References (PCRs) inserted
	// into the transport stream.
	PcrPeriod *int64 `locationName:"pcrPeriod" type:"integer"`

	// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport
	// stream. When no value is given, the encoder will assign the same value as
	// the Video PID. Can be entered as a decimal or hexadecimal value.
	PcrPid *string `locationName:"pcrPid" type:"string"`

	// The number of milliseconds between instances of this table in the output
	// transport stream. A value of \"0\" writes out the PMT once per segment file.
	PmtInterval *int64 `locationName:"pmtInterval" type:"integer"`

	// Packet Identifier (PID) for the Program Map Table (PMT) in the transport
	// stream. Can be entered as a decimal or hexadecimal value.
	PmtPid *string `locationName:"pmtPid" type:"string"`

	// The value of the program number field in the Program Map Table.
	ProgramNum *int64 `locationName:"programNum" type:"integer"`

	// If set to passthrough, passes any SCTE-35 signals from the input source to
	// this output.
	Scte35Behavior *string `locationName:"scte35Behavior" type:"string" enum:"M3u8Scte35Behavior"`

	// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can
	// be entered as a decimal or hexadecimal value.
	Scte35Pid *string `locationName:"scte35Pid" type:"string"`

	// When set to passthrough, timed metadata is passed through from input to output.
	TimedMetadataBehavior *string `locationName:"timedMetadataBehavior" type:"string" enum:"M3u8TimedMetadataBehavior"`

	// Packet Identifier (PID) of the timed metadata stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	TimedMetadataPid *string `locationName:"timedMetadataPid" type:"string"`

	// The value of the transport stream ID field in the Program Map Table.
	TransportStreamId *int64 `locationName:"transportStreamId" type:"integer"`

	// Packet Identifier (PID) of the elementary video stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value.
	VideoPid *string `locationName:"videoPid" type:"string"`
}

// String returns the string representation
func (s M3u8Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s M3u8Settings) GoString() string {
	return s.String()
}

// SetAudioFramesPerPes sets the AudioFramesPerPes field's value.
func (s *M3u8Settings) SetAudioFramesPerPes(v int64) *M3u8Settings {
	s.AudioFramesPerPes = &v
	return s
}

// SetAudioPids sets the AudioPids field's value.
func (s *M3u8Settings) SetAudioPids(v string) *M3u8Settings {
	s.AudioPids = &v
	return s
}

// SetEcmPid sets the EcmPid field's value.
func (s *M3u8Settings) SetEcmPid(v string) *M3u8Settings {
	s.EcmPid = &v
	return s
}

// SetPatInterval sets the PatInterval field's value.
func (s *M3u8Settings) SetPatInterval(v int64) *M3u8Settings {
	s.PatInterval = &v
	return s
}

// SetPcrControl sets the PcrControl field's value.
func (s *M3u8Settings) SetPcrControl(v string) *M3u8Settings {
	s.PcrControl = &v
	return s
}

// SetPcrPeriod sets the PcrPeriod field's value.
func (s *M3u8Settings) SetPcrPeriod(v int64) *M3u8Settings {
	s.PcrPeriod = &v
	return s
}

// SetPcrPid sets the PcrPid field's value.
func (s *M3u8Settings) SetPcrPid(v string) *M3u8Settings {
	s.PcrPid = &v
	return s
}

// SetPmtInterval sets the PmtInterval field's value.
func (s *M3u8Settings) SetPmtInterval(v int64) *M3u8Settings {
	s.PmtInterval = &v
	return s
}

// SetPmtPid sets the PmtPid field's value.
func (s *M3u8Settings) SetPmtPid(v string) *M3u8Settings {
	s.PmtPid = &v
	return s
}

// SetProgramNum sets the ProgramNum field's value.
func (s *M3u8Settings) SetProgramNum(v int64) *M3u8Settings {
	s.ProgramNum = &v
	return s
}

// SetScte35Behavior sets the Scte35Behavior field's value.
func (s *M3u8Settings) SetScte35Behavior(v string) *M3u8Settings {
	s.Scte35Behavior = &v
	return s
}

// SetScte35Pid sets the Scte35Pid field's value.
func (s *M3u8Settings) SetScte35Pid(v string) *M3u8Settings {
	s.Scte35Pid = &v
	return s
}

// SetTimedMetadataBehavior sets the TimedMetadataBehavior field's value.
func (s *M3u8Settings) SetTimedMetadataBehavior(v string) *M3u8Settings {
	s.TimedMetadataBehavior = &v
	return s
}

// SetTimedMetadataPid sets the TimedMetadataPid field's value.
func (s *M3u8Settings) SetTimedMetadataPid(v string) *M3u8Settings {
	s.TimedMetadataPid = &v
	return s
}

// SetTransportStreamId sets the TransportStreamId field's value.
func (s *M3u8Settings) SetTransportStreamId(v int64) *M3u8Settings {
	s.TransportStreamId = &v
	return s
}

// SetVideoPid sets the VideoPid field's value.
func (s *M3u8Settings) SetVideoPid(v string) *M3u8Settings {
	s.VideoPid = &v
	return s
}

type Mp2Settings struct {
	_ struct{} `type:"structure"`

	// Average bitrate in bits/second.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or
	// codingMode20 (for stereo).
	CodingMode *string `locationName:"codingMode" type:"string" enum:"Mp2CodingMode"`

	// Sample rate in Hz.
	SampleRate *float64 `locationName:"sampleRate" type:"double"`
}

// String returns the string representation
func (s Mp2Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Mp2Settings) GoString() string {
	return s.String()
}

// SetBitrate sets the Bitrate field's value.
func (s *Mp2Settings) SetBitrate(v float64) *Mp2Settings {
	s.Bitrate = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *Mp2Settings) SetCodingMode(v string) *Mp2Settings {
	s.CodingMode = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *Mp2Settings) SetSampleRate(v float64) *Mp2Settings {
	s.SampleRate = &v
	return s
}

type MsSmoothGroupSettings struct {
	_ struct{} `type:"structure"`

	// The value of the "Acquisition Point Identity" element used in each message
	// placed in the sparse track. Only enabled if sparseTrackType is not "none".
	AcquisitionPointId *string `locationName:"acquisitionPointId" type:"string"`

	// If set to passthrough for an audio-only MS Smooth output, the fragment absolute
	// time will be set to the current timecode. This option does not write timecodes
	// to the audio elementary stream.
	AudioOnlyTimecodeControl *string `locationName:"audioOnlyTimecodeControl" type:"string" enum:"SmoothGroupAudioOnlyTimecodeControl"`

	// If set to verifyAuthenticity, verify the https certificate chain to a trusted
	// Certificate Authority (CA). This will cause https outputs to self-signed
	// certificates to fail.
	CertificateMode *string `locationName:"certificateMode" type:"string" enum:"SmoothGroupCertificateMode"`

	// Number of seconds to wait before retrying connection to the IIS server if
	// the connection is lost. Content will be cached during this time and the cache
	// will be be delivered to the IIS server once the connection is re-established.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Smooth Streaming publish point on an IIS server. Elemental Live acts as a
	// "Push" encoder to IIS.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// MS Smooth event ID to be sent to the IIS server.Should only be specified
	// if eventIdMode is set to useConfigured.
	EventId *string `locationName:"eventId" type:"string"`

	// Specifies whether or not to send an event ID to the IIS server. If no event
	// ID is sent and the same Live Event is used without changing the publishing
	// point, clients might see cached video from the previous run.Options:- "useConfigured"
	// - use the value provided in eventId- "useTimestamp" - generate and send an
	// event ID based on the current timestamp- "noEventId" - do not send an event
	// ID to the IIS server.
	EventIdMode *string `locationName:"eventIdMode" type:"string" enum:"SmoothGroupEventIdMode"`

	// When set to sendEos, send EOS signal to IIS server when stopping the event
	EventStopBehavior *string `locationName:"eventStopBehavior" type:"string" enum:"SmoothGroupEventStopBehavior"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Length of mp4 fragments to generate (in seconds). Fragment length must be
	// compatible with GOP size and framerate.
	FragmentLength *int64 `locationName:"fragmentLength" min:"1" type:"integer"`

	// Parameter that control output group behavior on input loss.
	InputLossAction *string `locationName:"inputLossAction" type:"string" enum:"InputLossActionForMsSmoothOut"`

	// Number of retry attempts.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// Number of seconds before initiating a restart due to output failure, due
	// to exhausting the numRetries on one segment, or exceeding filecacheDuration.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`

	// When set to useInputSegmentation, the output segment or fragment points are
	// set by the RAI markers from the input streams.
	SegmentationMode *string `locationName:"segmentationMode" type:"string" enum:"SmoothGroupSegmentationMode"`

	// Outputs that are "output locked" can use this delay. Assign a delay to the
	// output that is "secondary". Do not assign a delay to the "primary" output.
	// The delay means that the primary output will always reach the downstream
	// system before the secondary, which helps ensure that the downstream system
	// always uses the primary output. (If there were no delay, the downstream system
	// might flip-flop between whichever output happens to arrive first.) If the
	// primary fails, the downstream system will switch to the secondary output.
	// When the primary is restarted, the downstream system will switch back to
	// the primary (because once again it is always arriving first)
	SendDelayMs *int64 `locationName:"sendDelayMs" type:"integer"`

	// If set to scte35, use incoming SCTE-35 messages to generate a sparse track
	// in this group of MS-Smooth outputs.
	SparseTrackType *string `locationName:"sparseTrackType" type:"string" enum:"SmoothGroupSparseTrackType"`

	// When set to send, send stream manifest so publishing point doesn't start
	// until all streams start.
	StreamManifestBehavior *string `locationName:"streamManifestBehavior" type:"string" enum:"SmoothGroupStreamManifestBehavior"`

	// Timestamp offset for the event. Only used if timestampOffsetMode is set to
	// useConfiguredOffset.
	TimestampOffset *string `locationName:"timestampOffset" type:"string"`

	// Type of timestamp date offset to use.- useEventStartDate: Use the date the
	// event was started as the offset- useConfiguredOffset: Use an explicitly configured
	// date as the offset
	TimestampOffsetMode *string `locationName:"timestampOffsetMode" type:"string" enum:"SmoothGroupTimestampOffsetMode"`
}

// String returns the string representation
func (s MsSmoothGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MsSmoothGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MsSmoothGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MsSmoothGroupSettings"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.FragmentLength != nil && *s.FragmentLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FragmentLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcquisitionPointId sets the AcquisitionPointId field's value.
func (s *MsSmoothGroupSettings) SetAcquisitionPointId(v string) *MsSmoothGroupSettings {
	s.AcquisitionPointId = &v
	return s
}

// SetAudioOnlyTimecodeControl sets the AudioOnlyTimecodeControl field's value.
func (s *MsSmoothGroupSettings) SetAudioOnlyTimecodeControl(v string) *MsSmoothGroupSettings {
	s.AudioOnlyTimecodeControl = &v
	return s
}

// SetCertificateMode sets the CertificateMode field's value.
func (s *MsSmoothGroupSettings) SetCertificateMode(v string) *MsSmoothGroupSettings {
	s.CertificateMode = &v
	return s
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *MsSmoothGroupSettings) SetConnectionRetryInterval(v int64) *MsSmoothGroupSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *MsSmoothGroupSettings) SetDestination(v *OutputLocationRef) *MsSmoothGroupSettings {
	s.Destination = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *MsSmoothGroupSettings) SetEventId(v string) *MsSmoothGroupSettings {
	s.EventId = &v
	return s
}

// SetEventIdMode sets the EventIdMode field's value.
func (s *MsSmoothGroupSettings) SetEventIdMode(v string) *MsSmoothGroupSettings {
	s.EventIdMode = &v
	return s
}

// SetEventStopBehavior sets the EventStopBehavior field's value.
func (s *MsSmoothGroupSettings) SetEventStopBehavior(v string) *MsSmoothGroupSettings {
	s.EventStopBehavior = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *MsSmoothGroupSettings) SetFilecacheDuration(v int64) *MsSmoothGroupSettings {
	s.FilecacheDuration = &v
	return s
}

// SetFragmentLength sets the FragmentLength field's value.
func (s *MsSmoothGroupSettings) SetFragmentLength(v int64) *MsSmoothGroupSettings {
	s.FragmentLength = &v
	return s
}

// SetInputLossAction sets the InputLossAction field's value.
func (s *MsSmoothGroupSettings) SetInputLossAction(v string) *MsSmoothGroupSettings {
	s.InputLossAction = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *MsSmoothGroupSettings) SetNumRetries(v int64) *MsSmoothGroupSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *MsSmoothGroupSettings) SetRestartDelay(v int64) *MsSmoothGroupSettings {
	s.RestartDelay = &v
	return s
}

// SetSegmentationMode sets the SegmentationMode field's value.
func (s *MsSmoothGroupSettings) SetSegmentationMode(v string) *MsSmoothGroupSettings {
	s.SegmentationMode = &v
	return s
}

// SetSendDelayMs sets the SendDelayMs field's value.
func (s *MsSmoothGroupSettings) SetSendDelayMs(v int64) *MsSmoothGroupSettings {
	s.SendDelayMs = &v
	return s
}

// SetSparseTrackType sets the SparseTrackType field's value.
func (s *MsSmoothGroupSettings) SetSparseTrackType(v string) *MsSmoothGroupSettings {
	s.SparseTrackType = &v
	return s
}

// SetStreamManifestBehavior sets the StreamManifestBehavior field's value.
func (s *MsSmoothGroupSettings) SetStreamManifestBehavior(v string) *MsSmoothGroupSettings {
	s.StreamManifestBehavior = &v
	return s
}

// SetTimestampOffset sets the TimestampOffset field's value.
func (s *MsSmoothGroupSettings) SetTimestampOffset(v string) *MsSmoothGroupSettings {
	s.TimestampOffset = &v
	return s
}

// SetTimestampOffsetMode sets the TimestampOffsetMode field's value.
func (s *MsSmoothGroupSettings) SetTimestampOffsetMode(v string) *MsSmoothGroupSettings {
	s.TimestampOffsetMode = &v
	return s
}

type MsSmoothOutputSettings struct {
	_ struct{} `type:"structure"`

	// String concatenated to the end of the destination filename. Required for
	// multiple outputs of the same type.
	NameModifier *string `locationName:"nameModifier" type:"string"`
}

// String returns the string representation
func (s MsSmoothOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MsSmoothOutputSettings) GoString() string {
	return s.String()
}

// SetNameModifier sets the NameModifier field's value.
func (s *MsSmoothOutputSettings) SetNameModifier(v string) *MsSmoothOutputSettings {
	s.NameModifier = &v
	return s
}

// Network source to transcode. Must be accessible to the Elemental Live node
// that is running the live event through a network connection.
type NetworkInputSettings struct {
	_ struct{} `type:"structure"`

	// Specifies HLS input settings when the uri is for a HLS manifest.
	HlsInputSettings *HlsInputSettings `locationName:"hlsInputSettings" type:"structure"`

	// Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography
	// in the certificate will be checked, but not the server's name. Certain subdomains
	// (notably S3 buckets that use dots in the bucket name) do not strictly match
	// the corresponding certificate's wildcard pattern and would otherwise cause
	// the event to error. This setting is ignored for protocols that do not use
	// https.
	ServerValidation *string `locationName:"serverValidation" type:"string" enum:"NetworkInputServerValidation"`
}

// String returns the string representation
func (s NetworkInputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInputSettings) GoString() string {
	return s.String()
}

// SetHlsInputSettings sets the HlsInputSettings field's value.
func (s *NetworkInputSettings) SetHlsInputSettings(v *HlsInputSettings) *NetworkInputSettings {
	s.HlsInputSettings = v
	return s
}

// SetServerValidation sets the ServerValidation field's value.
func (s *NetworkInputSettings) SetServerValidation(v string) *NetworkInputSettings {
	s.ServerValidation = &v
	return s
}

// Output settings. There can be multiple outputs within a group.
type Output struct {
	_ struct{} `type:"structure"`

	// The names of the AudioDescriptions used as audio sources for this output.
	AudioDescriptionNames []*string `locationName:"audioDescriptionNames" type:"list"`

	// The names of the CaptionDescriptions used as caption sources for this output.
	CaptionDescriptionNames []*string `locationName:"captionDescriptionNames" type:"list"`

	// The name used to identify an output.
	OutputName *string `locationName:"outputName" min:"1" type:"string"`

	// Output type-specific settings.
	//
	// OutputSettings is a required field
	OutputSettings *OutputSettings `locationName:"outputSettings" type:"structure" required:"true"`

	// The name of the VideoDescription used as the source for this output.
	VideoDescriptionName *string `locationName:"videoDescriptionName" type:"string"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Output) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Output) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Output"}
	if s.OutputName != nil && len(*s.OutputName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputName", 1))
	}
	if s.OutputSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputSettings"))
	}
	if s.OutputSettings != nil {
		if err := s.OutputSettings.Validate(); err != nil {
			invalidParams.AddNested("OutputSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioDescriptionNames sets the AudioDescriptionNames field's value.
func (s *Output) SetAudioDescriptionNames(v []*string) *Output {
	s.AudioDescriptionNames = v
	return s
}

// SetCaptionDescriptionNames sets the CaptionDescriptionNames field's value.
func (s *Output) SetCaptionDescriptionNames(v []*string) *Output {
	s.CaptionDescriptionNames = v
	return s
}

// SetOutputName sets the OutputName field's value.
func (s *Output) SetOutputName(v string) *Output {
	s.OutputName = &v
	return s
}

// SetOutputSettings sets the OutputSettings field's value.
func (s *Output) SetOutputSettings(v *OutputSettings) *Output {
	s.OutputSettings = v
	return s
}

// SetVideoDescriptionName sets the VideoDescriptionName field's value.
func (s *Output) SetVideoDescriptionName(v string) *Output {
	s.VideoDescriptionName = &v
	return s
}

type OutputDestination struct {
	_ struct{} `type:"structure"`

	// User-specified id. This is used in an output group or an output.
	Id *string `locationName:"id" type:"string"`

	// Destination settings for output; one for each redundant encoder.
	Settings []*OutputDestinationSettings `locationName:"settings" type:"list"`
}

// String returns the string representation
func (s OutputDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputDestination) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *OutputDestination) SetId(v string) *OutputDestination {
	s.Id = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *OutputDestination) SetSettings(v []*OutputDestinationSettings) *OutputDestination {
	s.Settings = v
	return s
}

type OutputDestinationSettings struct {
	_ struct{} `type:"structure"`

	// key used to extract the password from EC2 Parameter store
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// Stream name for RTMP destinations (URLs of type rtmp://)
	StreamName *string `locationName:"streamName" type:"string"`

	// A URL specifying a destination
	Url *string `locationName:"url" type:"string"`

	// username for destination
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s OutputDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputDestinationSettings) GoString() string {
	return s.String()
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *OutputDestinationSettings) SetPasswordParam(v string) *OutputDestinationSettings {
	s.PasswordParam = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *OutputDestinationSettings) SetStreamName(v string) *OutputDestinationSettings {
	s.StreamName = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *OutputDestinationSettings) SetUrl(v string) *OutputDestinationSettings {
	s.Url = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *OutputDestinationSettings) SetUsername(v string) *OutputDestinationSettings {
	s.Username = &v
	return s
}

// Output groups for this Live Event. Output groups contain information about
// where streams should be distributed.
type OutputGroup struct {
	_ struct{} `type:"structure"`

	// Custom output group name optionally defined by the user. Only letters, numbers,
	// and the underscore character allowed; only 32 characters allowed.
	Name *string `locationName:"name" type:"string"`

	// Settings associated with the output group.
	//
	// OutputGroupSettings is a required field
	OutputGroupSettings *OutputGroupSettings `locationName:"outputGroupSettings" type:"structure" required:"true"`

	// Outputs is a required field
	Outputs []*Output `locationName:"outputs" type:"list" required:"true"`
}

// String returns the string representation
func (s OutputGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputGroup"}
	if s.OutputGroupSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputGroupSettings"))
	}
	if s.Outputs == nil {
		invalidParams.Add(request.NewErrParamRequired("Outputs"))
	}
	if s.OutputGroupSettings != nil {
		if err := s.OutputGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("OutputGroupSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *OutputGroup) SetName(v string) *OutputGroup {
	s.Name = &v
	return s
}

// SetOutputGroupSettings sets the OutputGroupSettings field's value.
func (s *OutputGroup) SetOutputGroupSettings(v *OutputGroupSettings) *OutputGroup {
	s.OutputGroupSettings = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *OutputGroup) SetOutputs(v []*Output) *OutputGroup {
	s.Outputs = v
	return s
}

type OutputGroupSettings struct {
	_ struct{} `type:"structure"`

	ArchiveGroupSettings *ArchiveGroupSettings `locationName:"archiveGroupSettings" type:"structure"`

	HlsGroupSettings *HlsGroupSettings `locationName:"hlsGroupSettings" type:"structure"`

	MsSmoothGroupSettings *MsSmoothGroupSettings `locationName:"msSmoothGroupSettings" type:"structure"`

	RtmpGroupSettings *RtmpGroupSettings `locationName:"rtmpGroupSettings" type:"structure"`

	UdpGroupSettings *UdpGroupSettings `locationName:"udpGroupSettings" type:"structure"`
}

// String returns the string representation
func (s OutputGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputGroupSettings"}
	if s.ArchiveGroupSettings != nil {
		if err := s.ArchiveGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("ArchiveGroupSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.HlsGroupSettings != nil {
		if err := s.HlsGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsGroupSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.MsSmoothGroupSettings != nil {
		if err := s.MsSmoothGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("MsSmoothGroupSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.RtmpGroupSettings != nil {
		if err := s.RtmpGroupSettings.Validate(); err != nil {
			invalidParams.AddNested("RtmpGroupSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveGroupSettings sets the ArchiveGroupSettings field's value.
func (s *OutputGroupSettings) SetArchiveGroupSettings(v *ArchiveGroupSettings) *OutputGroupSettings {
	s.ArchiveGroupSettings = v
	return s
}

// SetHlsGroupSettings sets the HlsGroupSettings field's value.
func (s *OutputGroupSettings) SetHlsGroupSettings(v *HlsGroupSettings) *OutputGroupSettings {
	s.HlsGroupSettings = v
	return s
}

// SetMsSmoothGroupSettings sets the MsSmoothGroupSettings field's value.
func (s *OutputGroupSettings) SetMsSmoothGroupSettings(v *MsSmoothGroupSettings) *OutputGroupSettings {
	s.MsSmoothGroupSettings = v
	return s
}

// SetRtmpGroupSettings sets the RtmpGroupSettings field's value.
func (s *OutputGroupSettings) SetRtmpGroupSettings(v *RtmpGroupSettings) *OutputGroupSettings {
	s.RtmpGroupSettings = v
	return s
}

// SetUdpGroupSettings sets the UdpGroupSettings field's value.
func (s *OutputGroupSettings) SetUdpGroupSettings(v *UdpGroupSettings) *OutputGroupSettings {
	s.UdpGroupSettings = v
	return s
}

// Reference to an OutputDestination ID defined in the channel
type OutputLocationRef struct {
	_ struct{} `type:"structure"`

	DestinationRefId *string `locationName:"destinationRefId" type:"string"`
}

// String returns the string representation
func (s OutputLocationRef) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputLocationRef) GoString() string {
	return s.String()
}

// SetDestinationRefId sets the DestinationRefId field's value.
func (s *OutputLocationRef) SetDestinationRefId(v string) *OutputLocationRef {
	s.DestinationRefId = &v
	return s
}

type OutputSettings struct {
	_ struct{} `type:"structure"`

	ArchiveOutputSettings *ArchiveOutputSettings `locationName:"archiveOutputSettings" type:"structure"`

	HlsOutputSettings *HlsOutputSettings `locationName:"hlsOutputSettings" type:"structure"`

	MsSmoothOutputSettings *MsSmoothOutputSettings `locationName:"msSmoothOutputSettings" type:"structure"`

	RtmpOutputSettings *RtmpOutputSettings `locationName:"rtmpOutputSettings" type:"structure"`

	UdpOutputSettings *UdpOutputSettings `locationName:"udpOutputSettings" type:"structure"`
}

// String returns the string representation
func (s OutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputSettings"}
	if s.ArchiveOutputSettings != nil {
		if err := s.ArchiveOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("ArchiveOutputSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.HlsOutputSettings != nil {
		if err := s.HlsOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsOutputSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.RtmpOutputSettings != nil {
		if err := s.RtmpOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("RtmpOutputSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.UdpOutputSettings != nil {
		if err := s.UdpOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("UdpOutputSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveOutputSettings sets the ArchiveOutputSettings field's value.
func (s *OutputSettings) SetArchiveOutputSettings(v *ArchiveOutputSettings) *OutputSettings {
	s.ArchiveOutputSettings = v
	return s
}

// SetHlsOutputSettings sets the HlsOutputSettings field's value.
func (s *OutputSettings) SetHlsOutputSettings(v *HlsOutputSettings) *OutputSettings {
	s.HlsOutputSettings = v
	return s
}

// SetMsSmoothOutputSettings sets the MsSmoothOutputSettings field's value.
func (s *OutputSettings) SetMsSmoothOutputSettings(v *MsSmoothOutputSettings) *OutputSettings {
	s.MsSmoothOutputSettings = v
	return s
}

// SetRtmpOutputSettings sets the RtmpOutputSettings field's value.
func (s *OutputSettings) SetRtmpOutputSettings(v *RtmpOutputSettings) *OutputSettings {
	s.RtmpOutputSettings = v
	return s
}

// SetUdpOutputSettings sets the UdpOutputSettings field's value.
func (s *OutputSettings) SetUdpOutputSettings(v *UdpOutputSettings) *OutputSettings {
	s.UdpOutputSettings = v
	return s
}

type PassThroughSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PassThroughSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PassThroughSettings) GoString() string {
	return s.String()
}

type RemixSettings struct {
	_ struct{} `type:"structure"`

	// Mapping of input channels to output channels, with appropriate gain adjustments.
	//
	// ChannelMappings is a required field
	ChannelMappings []*AudioChannelMapping `locationName:"channelMappings" type:"list" required:"true"`

	// Number of input channels to be used.
	ChannelsIn *int64 `locationName:"channelsIn" min:"1" type:"integer"`

	// Number of output channels to be produced.Valid values: 1, 2, 4, 6, 8
	ChannelsOut *int64 `locationName:"channelsOut" min:"1" type:"integer"`
}

// String returns the string representation
func (s RemixSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemixSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemixSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemixSettings"}
	if s.ChannelMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelMappings"))
	}
	if s.ChannelsIn != nil && *s.ChannelsIn < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ChannelsIn", 1))
	}
	if s.ChannelsOut != nil && *s.ChannelsOut < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ChannelsOut", 1))
	}
	if s.ChannelMappings != nil {
		for i, v := range s.ChannelMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ChannelMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelMappings sets the ChannelMappings field's value.
func (s *RemixSettings) SetChannelMappings(v []*AudioChannelMapping) *RemixSettings {
	s.ChannelMappings = v
	return s
}

// SetChannelsIn sets the ChannelsIn field's value.
func (s *RemixSettings) SetChannelsIn(v int64) *RemixSettings {
	s.ChannelsIn = &v
	return s
}

// SetChannelsOut sets the ChannelsOut field's value.
func (s *RemixSettings) SetChannelsOut(v int64) *RemixSettings {
	s.ChannelsOut = &v
	return s
}

type RtmpCaptionInfoDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RtmpCaptionInfoDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RtmpCaptionInfoDestinationSettings) GoString() string {
	return s.String()
}

type RtmpGroupSettings struct {
	_ struct{} `type:"structure"`

	// Authentication scheme to use when connecting with CDN
	AuthenticationScheme *string `locationName:"authenticationScheme" type:"string" enum:"AuthenticationScheme"`

	// Controls behavior when content cache fills up. If remote origin server stalls
	// the RTMP connection and does not accept content fast enough the 'Media Cache'
	// will fill up. When the cache reaches the duration specified by cacheLength
	// the cache will stop accepting new content. If set to disconnectImmediately,
	// the RTMP output will force a disconnect. Clear the media cache, and reconnect
	// after restartDelay seconds. If set to waitForServer, the RTMP output will
	// wait up to 5 minutes to allow the origin server to begin accepting data again.
	CacheFullBehavior *string `locationName:"cacheFullBehavior" type:"string" enum:"RtmpCacheFullBehavior"`

	// Cache length, in seconds, is used to calculate buffer size.
	CacheLength *int64 `locationName:"cacheLength" min:"30" type:"integer"`

	// Controls the types of data that passes to onCaptionInfo outputs. If set to
	// 'all' then 608 and 708 carried DTVCC data will be passed. If set to 'field1AndField2608'
	// then DTVCC data will be stripped out, but 608 data from both fields will
	// be passed. If set to 'field1608' then only the data carried in 608 from field
	// 1 video will be passed.
	CaptionData *string `locationName:"captionData" type:"string" enum:"RtmpCaptionData"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation
func (s RtmpGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RtmpGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RtmpGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RtmpGroupSettings"}
	if s.CacheLength != nil && *s.CacheLength < 30 {
		invalidParams.Add(request.NewErrParamMinValue("CacheLength", 30))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationScheme sets the AuthenticationScheme field's value.
func (s *RtmpGroupSettings) SetAuthenticationScheme(v string) *RtmpGroupSettings {
	s.AuthenticationScheme = &v
	return s
}

// SetCacheFullBehavior sets the CacheFullBehavior field's value.
func (s *RtmpGroupSettings) SetCacheFullBehavior(v string) *RtmpGroupSettings {
	s.CacheFullBehavior = &v
	return s
}

// SetCacheLength sets the CacheLength field's value.
func (s *RtmpGroupSettings) SetCacheLength(v int64) *RtmpGroupSettings {
	s.CacheLength = &v
	return s
}

// SetCaptionData sets the CaptionData field's value.
func (s *RtmpGroupSettings) SetCaptionData(v string) *RtmpGroupSettings {
	s.CaptionData = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *RtmpGroupSettings) SetRestartDelay(v int64) *RtmpGroupSettings {
	s.RestartDelay = &v
	return s
}

type RtmpOutputSettings struct {
	_ struct{} `type:"structure"`

	// If set to verifyAuthenticity, verify the tls certificate chain to a trusted
	// Certificate Authority (CA). This will cause rtmps outputs with self-signed
	// certificates to fail.
	CertificateMode *string `locationName:"certificateMode" type:"string" enum:"RtmpOutputCertificateMode"`

	// Number of seconds to wait before retrying a connection to the Flash Media
	// server if the connection is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" min:"1" type:"integer"`

	// The RTMP endpoint excluding the stream name (eg. rtmp://host/appname). For
	// connection to Akamai, a username and password must be supplied. URI fields
	// accept format identifiers.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Number of retry attempts.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`
}

// String returns the string representation
func (s RtmpOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RtmpOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RtmpOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RtmpOutputSettings"}
	if s.ConnectionRetryInterval != nil && *s.ConnectionRetryInterval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ConnectionRetryInterval", 1))
	}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateMode sets the CertificateMode field's value.
func (s *RtmpOutputSettings) SetCertificateMode(v string) *RtmpOutputSettings {
	s.CertificateMode = &v
	return s
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *RtmpOutputSettings) SetConnectionRetryInterval(v int64) *RtmpOutputSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *RtmpOutputSettings) SetDestination(v *OutputLocationRef) *RtmpOutputSettings {
	s.Destination = v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *RtmpOutputSettings) SetNumRetries(v int64) *RtmpOutputSettings {
	s.NumRetries = &v
	return s
}

type Scte20PlusEmbeddedDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Scte20PlusEmbeddedDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte20PlusEmbeddedDestinationSettings) GoString() string {
	return s.String()
}

type Scte20SourceSettings struct {
	_ struct{} `type:"structure"`

	// If upconvert, 608 data is both passed through via the "608 compatibility
	// bytes" fields of the 708 wrapper as well as translated into 708. 708 data
	// present in the source content will be discarded.
	Convert608To708 *string `locationName:"convert608To708" type:"string" enum:"Scte20Convert608To708"`

	// Specifies the 608/708 channel number within the video track from which to
	// extract captions. Unused for passthrough.
	Source608ChannelNumber *int64 `locationName:"source608ChannelNumber" min:"1" type:"integer"`
}

// String returns the string representation
func (s Scte20SourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte20SourceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte20SourceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte20SourceSettings"}
	if s.Source608ChannelNumber != nil && *s.Source608ChannelNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Source608ChannelNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConvert608To708 sets the Convert608To708 field's value.
func (s *Scte20SourceSettings) SetConvert608To708(v string) *Scte20SourceSettings {
	s.Convert608To708 = &v
	return s
}

// SetSource608ChannelNumber sets the Source608ChannelNumber field's value.
func (s *Scte20SourceSettings) SetSource608ChannelNumber(v int64) *Scte20SourceSettings {
	s.Source608ChannelNumber = &v
	return s
}

type Scte27DestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Scte27DestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte27DestinationSettings) GoString() string {
	return s.String()
}

type Scte27SourceSettings struct {
	_ struct{} `type:"structure"`

	// The pid field is used in conjunction with the caption selector languageCode
	// field as follows: - Specify PID and Language: Extracts captions from that
	// PID; the language is "informational". - Specify PID and omit Language: Extracts
	// the specified PID. - Omit PID and specify Language: Extracts the specified
	// language, whichever PID that happens to be. - Omit PID and omit Language:
	// Valid only if source is DVB-Sub that is being passed through; all languages
	// will be passed through.
	Pid *int64 `locationName:"pid" min:"1" type:"integer"`
}

// String returns the string representation
func (s Scte27SourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte27SourceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte27SourceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte27SourceSettings"}
	if s.Pid != nil && *s.Pid < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Pid", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPid sets the Pid field's value.
func (s *Scte27SourceSettings) SetPid(v int64) *Scte27SourceSettings {
	s.Pid = &v
	return s
}

type Scte35SpliceInsert struct {
	_ struct{} `type:"structure"`

	// When specified, this offset (in milliseconds) is added to the input Ad Avail
	// PTS time. This only applies to embedded SCTE 104/35 messages and does not
	// apply to OOB messages.
	AdAvailOffset *int64 `locationName:"adAvailOffset" type:"integer"`

	// When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	NoRegionalBlackoutFlag *string `locationName:"noRegionalBlackoutFlag" type:"string" enum:"Scte35SpliceInsertNoRegionalBlackoutBehavior"`

	// When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	WebDeliveryAllowedFlag *string `locationName:"webDeliveryAllowedFlag" type:"string" enum:"Scte35SpliceInsertWebDeliveryAllowedBehavior"`
}

// String returns the string representation
func (s Scte35SpliceInsert) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte35SpliceInsert) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35SpliceInsert) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte35SpliceInsert"}
	if s.AdAvailOffset != nil && *s.AdAvailOffset < -1000 {
		invalidParams.Add(request.NewErrParamMinValue("AdAvailOffset", -1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdAvailOffset sets the AdAvailOffset field's value.
func (s *Scte35SpliceInsert) SetAdAvailOffset(v int64) *Scte35SpliceInsert {
	s.AdAvailOffset = &v
	return s
}

// SetNoRegionalBlackoutFlag sets the NoRegionalBlackoutFlag field's value.
func (s *Scte35SpliceInsert) SetNoRegionalBlackoutFlag(v string) *Scte35SpliceInsert {
	s.NoRegionalBlackoutFlag = &v
	return s
}

// SetWebDeliveryAllowedFlag sets the WebDeliveryAllowedFlag field's value.
func (s *Scte35SpliceInsert) SetWebDeliveryAllowedFlag(v string) *Scte35SpliceInsert {
	s.WebDeliveryAllowedFlag = &v
	return s
}

type Scte35TimeSignalApos struct {
	_ struct{} `type:"structure"`

	// When specified, this offset (in milliseconds) is added to the input Ad Avail
	// PTS time. This only applies to embedded SCTE 104/35 messages and does not
	// apply to OOB messages.
	AdAvailOffset *int64 `locationName:"adAvailOffset" type:"integer"`

	// When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	NoRegionalBlackoutFlag *string `locationName:"noRegionalBlackoutFlag" type:"string" enum:"Scte35AposNoRegionalBlackoutBehavior"`

	// When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to
	// 0 will no longer trigger blackouts or Ad Avail slates
	WebDeliveryAllowedFlag *string `locationName:"webDeliveryAllowedFlag" type:"string" enum:"Scte35AposWebDeliveryAllowedBehavior"`
}

// String returns the string representation
func (s Scte35TimeSignalApos) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scte35TimeSignalApos) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scte35TimeSignalApos) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scte35TimeSignalApos"}
	if s.AdAvailOffset != nil && *s.AdAvailOffset < -1000 {
		invalidParams.Add(request.NewErrParamMinValue("AdAvailOffset", -1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdAvailOffset sets the AdAvailOffset field's value.
func (s *Scte35TimeSignalApos) SetAdAvailOffset(v int64) *Scte35TimeSignalApos {
	s.AdAvailOffset = &v
	return s
}

// SetNoRegionalBlackoutFlag sets the NoRegionalBlackoutFlag field's value.
func (s *Scte35TimeSignalApos) SetNoRegionalBlackoutFlag(v string) *Scte35TimeSignalApos {
	s.NoRegionalBlackoutFlag = &v
	return s
}

// SetWebDeliveryAllowedFlag sets the WebDeliveryAllowedFlag field's value.
func (s *Scte35TimeSignalApos) SetWebDeliveryAllowedFlag(v string) *Scte35TimeSignalApos {
	s.WebDeliveryAllowedFlag = &v
	return s
}

type SmpteTtDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SmpteTtDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SmpteTtDestinationSettings) GoString() string {
	return s.String()
}

type StandardHlsSettings struct {
	_ struct{} `type:"structure"`

	// List all the audio groups that are used with the video output stream. Input
	// all the audio GROUP-IDs that are associated to the video, separate by ','.
	AudioRenditionSets *string `locationName:"audioRenditionSets" type:"string"`

	// Settings information for the .m3u8 container
	//
	// M3u8Settings is a required field
	M3u8Settings *M3u8Settings `locationName:"m3u8Settings" type:"structure" required:"true"`
}

// String returns the string representation
func (s StandardHlsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StandardHlsSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StandardHlsSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StandardHlsSettings"}
	if s.M3u8Settings == nil {
		invalidParams.Add(request.NewErrParamRequired("M3u8Settings"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioRenditionSets sets the AudioRenditionSets field's value.
func (s *StandardHlsSettings) SetAudioRenditionSets(v string) *StandardHlsSettings {
	s.AudioRenditionSets = &v
	return s
}

// SetM3u8Settings sets the M3u8Settings field's value.
func (s *StandardHlsSettings) SetM3u8Settings(v *M3u8Settings) *StandardHlsSettings {
	s.M3u8Settings = v
	return s
}

type StartChannelInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation
func (s StartChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *StartChannelInput) SetChannelId(v string) *StartChannelInput {
	s.ChannelId = &v
	return s
}

type StartChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`
}

// String returns the string representation
func (s StartChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartChannelOutput) SetArn(v string) *StartChannelOutput {
	s.Arn = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *StartChannelOutput) SetDestinations(v []*OutputDestination) *StartChannelOutput {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *StartChannelOutput) SetEgressEndpoints(v []*ChannelEgressEndpoint) *StartChannelOutput {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *StartChannelOutput) SetEncoderSettings(v *EncoderSettings) *StartChannelOutput {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *StartChannelOutput) SetId(v string) *StartChannelOutput {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *StartChannelOutput) SetInputAttachments(v []*InputAttachment) *StartChannelOutput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *StartChannelOutput) SetInputSpecification(v *InputSpecification) *StartChannelOutput {
	s.InputSpecification = v
	return s
}

// SetName sets the Name field's value.
func (s *StartChannelOutput) SetName(v string) *StartChannelOutput {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *StartChannelOutput) SetPipelinesRunningCount(v int64) *StartChannelOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StartChannelOutput) SetRoleArn(v string) *StartChannelOutput {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *StartChannelOutput) SetState(v string) *StartChannelOutput {
	s.State = &v
	return s
}

type StaticKeySettings struct {
	_ struct{} `type:"structure"`

	// The URL of the license server used for protecting content.
	KeyProviderServer *InputLocation `locationName:"keyProviderServer" type:"structure"`

	// Static key value as a 32 character hexadecimal string.
	//
	// StaticKeyValue is a required field
	StaticKeyValue *string `locationName:"staticKeyValue" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s StaticKeySettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StaticKeySettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StaticKeySettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StaticKeySettings"}
	if s.StaticKeyValue == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticKeyValue"))
	}
	if s.StaticKeyValue != nil && len(*s.StaticKeyValue) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("StaticKeyValue", 32))
	}
	if s.KeyProviderServer != nil {
		if err := s.KeyProviderServer.Validate(); err != nil {
			invalidParams.AddNested("KeyProviderServer", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyProviderServer sets the KeyProviderServer field's value.
func (s *StaticKeySettings) SetKeyProviderServer(v *InputLocation) *StaticKeySettings {
	s.KeyProviderServer = v
	return s
}

// SetStaticKeyValue sets the StaticKeyValue field's value.
func (s *StaticKeySettings) SetStaticKeyValue(v string) *StaticKeySettings {
	s.StaticKeyValue = &v
	return s
}

type StopChannelInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *StopChannelInput) SetChannelId(v string) *StopChannelInput {
	s.ChannelId = &v
	return s
}

type StopChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`
}

// String returns the string representation
func (s StopChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StopChannelOutput) SetArn(v string) *StopChannelOutput {
	s.Arn = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *StopChannelOutput) SetDestinations(v []*OutputDestination) *StopChannelOutput {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *StopChannelOutput) SetEgressEndpoints(v []*ChannelEgressEndpoint) *StopChannelOutput {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *StopChannelOutput) SetEncoderSettings(v *EncoderSettings) *StopChannelOutput {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *StopChannelOutput) SetId(v string) *StopChannelOutput {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *StopChannelOutput) SetInputAttachments(v []*InputAttachment) *StopChannelOutput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *StopChannelOutput) SetInputSpecification(v *InputSpecification) *StopChannelOutput {
	s.InputSpecification = v
	return s
}

// SetName sets the Name field's value.
func (s *StopChannelOutput) SetName(v string) *StopChannelOutput {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *StopChannelOutput) SetPipelinesRunningCount(v int64) *StopChannelOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *StopChannelOutput) SetRoleArn(v string) *StopChannelOutput {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *StopChannelOutput) SetState(v string) *StopChannelOutput {
	s.State = &v
	return s
}

type TeletextDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TeletextDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TeletextDestinationSettings) GoString() string {
	return s.String()
}

type TeletextSourceSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the teletext page number within the data stream from which to extract
	// captions. Range of 0x100 (256) to 0x8FF (2303). Unused for passthrough. Should
	// be specified as a hexadecimal string with no "0x" prefix.
	PageNumber *string `locationName:"pageNumber" type:"string"`
}

// String returns the string representation
func (s TeletextSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TeletextSourceSettings) GoString() string {
	return s.String()
}

// SetPageNumber sets the PageNumber field's value.
func (s *TeletextSourceSettings) SetPageNumber(v string) *TeletextSourceSettings {
	s.PageNumber = &v
	return s
}

type TimecodeConfig struct {
	_ struct{} `type:"structure"`

	// Identifies the source for the timecode that will be associated with the events
	// outputs.-Embedded (embedded): Initialize the output timecode with timecode
	// from the the source. If no embedded timecode is detected in the source, the
	// system falls back to using "Start at 0" (zerobased).-System Clock (systemclock):
	// Use the UTC time.-Start at 0 (zerobased): The time of the first frame of
	// the event will be 00:00:00:00.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true" enum:"TimecodeConfigSource"`

	// Threshold in frames beyond which output timecode is resynchronized to the
	// input timecode. Discrepancies below this threshold are permitted to avoid
	// unnecessary discontinuities in the output timecode. No timecode sync when
	// this is not specified.
	SyncThreshold *int64 `locationName:"syncThreshold" min:"1" type:"integer"`
}

// String returns the string representation
func (s TimecodeConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimecodeConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimecodeConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimecodeConfig"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.SyncThreshold != nil && *s.SyncThreshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SyncThreshold", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *TimecodeConfig) SetSource(v string) *TimecodeConfig {
	s.Source = &v
	return s
}

// SetSyncThreshold sets the SyncThreshold field's value.
func (s *TimecodeConfig) SetSyncThreshold(v int64) *TimecodeConfig {
	s.SyncThreshold = &v
	return s
}

type TtmlDestinationSettings struct {
	_ struct{} `type:"structure"`

	// When set to passthrough, passes through style and position information from
	// a TTML-like input source (TTML, SMPTE-TT, CFF-TT) to the CFF-TT output or
	// TTML output.
	StyleControl *string `locationName:"styleControl" type:"string" enum:"TtmlDestinationStyleControl"`
}

// String returns the string representation
func (s TtmlDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TtmlDestinationSettings) GoString() string {
	return s.String()
}

// SetStyleControl sets the StyleControl field's value.
func (s *TtmlDestinationSettings) SetStyleControl(v string) *TtmlDestinationSettings {
	s.StyleControl = &v
	return s
}

type UdpContainerSettings struct {
	_ struct{} `type:"structure"`

	M2tsSettings *M2tsSettings `locationName:"m2tsSettings" type:"structure"`
}

// String returns the string representation
func (s UdpContainerSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UdpContainerSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UdpContainerSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UdpContainerSettings"}
	if s.M2tsSettings != nil {
		if err := s.M2tsSettings.Validate(); err != nil {
			invalidParams.AddNested("M2tsSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetM2tsSettings sets the M2tsSettings field's value.
func (s *UdpContainerSettings) SetM2tsSettings(v *M2tsSettings) *UdpContainerSettings {
	s.M2tsSettings = v
	return s
}

type UdpGroupSettings struct {
	_ struct{} `type:"structure"`

	// Specifies behavior of last resort when input video is lost, and no more backup
	// inputs are available. When dropTs is selected the entire transport stream
	// will stop being emitted. When dropProgram is selected the program can be
	// dropped from the transport stream (and replaced with null packets to meet
	// the TS bitrate requirement). Or, when emitProgram is chosen the transport
	// stream will continue to be produced normally with repeat frames, black frames,
	// or slate frames substituted for the absent input video.
	InputLossAction *string `locationName:"inputLossAction" type:"string" enum:"InputLossActionForUdpOut"`

	// Indicates ID3 frame that has the timecode.
	TimedMetadataId3Frame *string `locationName:"timedMetadataId3Frame" type:"string" enum:"UdpTimedMetadataId3Frame"`

	// Timed Metadata interval in seconds.
	TimedMetadataId3Period *int64 `locationName:"timedMetadataId3Period" type:"integer"`
}

// String returns the string representation
func (s UdpGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UdpGroupSettings) GoString() string {
	return s.String()
}

// SetInputLossAction sets the InputLossAction field's value.
func (s *UdpGroupSettings) SetInputLossAction(v string) *UdpGroupSettings {
	s.InputLossAction = &v
	return s
}

// SetTimedMetadataId3Frame sets the TimedMetadataId3Frame field's value.
func (s *UdpGroupSettings) SetTimedMetadataId3Frame(v string) *UdpGroupSettings {
	s.TimedMetadataId3Frame = &v
	return s
}

// SetTimedMetadataId3Period sets the TimedMetadataId3Period field's value.
func (s *UdpGroupSettings) SetTimedMetadataId3Period(v int64) *UdpGroupSettings {
	s.TimedMetadataId3Period = &v
	return s
}

type UdpOutputSettings struct {
	_ struct{} `type:"structure"`

	// UDP output buffering in milliseconds. Larger values increase latency through
	// the transcoder but simultaneously assist the transcoder in maintaining a
	// constant, low-jitter UDP/RTP output while accommodating clock recovery, input
	// switching, input disruptions, picture reordering, etc.
	BufferMsec *int64 `locationName:"bufferMsec" type:"integer"`

	// ContainerSettings is a required field
	ContainerSettings *UdpContainerSettings `locationName:"containerSettings" type:"structure" required:"true"`

	// Destination address and port number for RTP or UDP packets. Can be unicast
	// or multicast RTP or UDP (eg. rtp://239.10.10.10:5001 or udp://10.100.100.100:5002).
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Settings for enabling and adjusting Forward Error Correction on UDP outputs.
	FecOutputSettings *FecOutputSettings `locationName:"fecOutputSettings" type:"structure"`
}

// String returns the string representation
func (s UdpOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UdpOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UdpOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UdpOutputSettings"}
	if s.ContainerSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerSettings"))
	}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.ContainerSettings != nil {
		if err := s.ContainerSettings.Validate(); err != nil {
			invalidParams.AddNested("ContainerSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.FecOutputSettings != nil {
		if err := s.FecOutputSettings.Validate(); err != nil {
			invalidParams.AddNested("FecOutputSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferMsec sets the BufferMsec field's value.
func (s *UdpOutputSettings) SetBufferMsec(v int64) *UdpOutputSettings {
	s.BufferMsec = &v
	return s
}

// SetContainerSettings sets the ContainerSettings field's value.
func (s *UdpOutputSettings) SetContainerSettings(v *UdpContainerSettings) *UdpOutputSettings {
	s.ContainerSettings = v
	return s
}

// SetDestination sets the Destination field's value.
func (s *UdpOutputSettings) SetDestination(v *OutputLocationRef) *UdpOutputSettings {
	s.Destination = v
	return s
}

// SetFecOutputSettings sets the FecOutputSettings field's value.
func (s *UdpOutputSettings) SetFecOutputSettings(v *FecOutputSettings) *UdpOutputSettings {
	s.FecOutputSettings = v
	return s
}

type UpdateChannelInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation
func (s UpdateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.EncoderSettings != nil {
		if err := s.EncoderSettings.Validate(); err != nil {
			invalidParams.AddNested("EncoderSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.InputAttachments != nil {
		for i, v := range s.InputAttachments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputAttachments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *UpdateChannelInput) SetChannelId(v string) *UpdateChannelInput {
	s.ChannelId = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *UpdateChannelInput) SetDestinations(v []*OutputDestination) *UpdateChannelInput {
	s.Destinations = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *UpdateChannelInput) SetEncoderSettings(v *EncoderSettings) *UpdateChannelInput {
	s.EncoderSettings = v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *UpdateChannelInput) SetInputAttachments(v []*InputAttachment) *UpdateChannelInput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *UpdateChannelInput) SetInputSpecification(v *InputSpecification) *UpdateChannelInput {
	s.InputSpecification = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateChannelInput) SetName(v string) *UpdateChannelInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateChannelInput) SetRoleArn(v string) *UpdateChannelInput {
	s.RoleArn = &v
	return s
}

type UpdateChannelOutput struct {
	_ struct{} `type:"structure"`

	Channel *Channel `locationName:"channel" type:"structure"`
}

// String returns the string representation
func (s UpdateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *UpdateChannelOutput) SetChannel(v *Channel) *UpdateChannelOutput {
	s.Channel = v
	return s
}

type UpdateInputInput struct {
	_ struct{} `type:"structure"`

	Destinations []*InputDestinationRequest `locationName:"destinations" type:"list"`

	// InputId is a required field
	InputId *string `location:"uri" locationName:"inputId" type:"string" required:"true"`

	InputSecurityGroups []*string `locationName:"inputSecurityGroups" type:"list"`

	Name *string `locationName:"name" type:"string"`

	Sources []*InputSourceRequest `locationName:"sources" type:"list"`
}

// String returns the string representation
func (s UpdateInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInputInput"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinations sets the Destinations field's value.
func (s *UpdateInputInput) SetDestinations(v []*InputDestinationRequest) *UpdateInputInput {
	s.Destinations = v
	return s
}

// SetInputId sets the InputId field's value.
func (s *UpdateInputInput) SetInputId(v string) *UpdateInputInput {
	s.InputId = &v
	return s
}

// SetInputSecurityGroups sets the InputSecurityGroups field's value.
func (s *UpdateInputInput) SetInputSecurityGroups(v []*string) *UpdateInputInput {
	s.InputSecurityGroups = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateInputInput) SetName(v string) *UpdateInputInput {
	s.Name = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *UpdateInputInput) SetSources(v []*InputSourceRequest) *UpdateInputInput {
	s.Sources = v
	return s
}

type UpdateInputOutput struct {
	_ struct{} `type:"structure"`

	Input *Input `locationName:"input" type:"structure"`
}

// String returns the string representation
func (s UpdateInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputOutput) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *UpdateInputOutput) SetInput(v *Input) *UpdateInputOutput {
	s.Input = v
	return s
}

type UpdateInputSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// InputSecurityGroupId is a required field
	InputSecurityGroupId *string `location:"uri" locationName:"inputSecurityGroupId" type:"string" required:"true"`

	WhitelistRules []*InputWhitelistRuleCidr `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation
func (s UpdateInputSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInputSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInputSecurityGroupInput"}
	if s.InputSecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSecurityGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputSecurityGroupId sets the InputSecurityGroupId field's value.
func (s *UpdateInputSecurityGroupInput) SetInputSecurityGroupId(v string) *UpdateInputSecurityGroupInput {
	s.InputSecurityGroupId = &v
	return s
}

// SetWhitelistRules sets the WhitelistRules field's value.
func (s *UpdateInputSecurityGroupInput) SetWhitelistRules(v []*InputWhitelistRuleCidr) *UpdateInputSecurityGroupInput {
	s.WhitelistRules = v
	return s
}

type UpdateInputSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// An Input Security Group
	SecurityGroup *InputSecurityGroup `locationName:"securityGroup" type:"structure"`
}

// String returns the string representation
func (s UpdateInputSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInputSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetSecurityGroup sets the SecurityGroup field's value.
func (s *UpdateInputSecurityGroupOutput) SetSecurityGroup(v *InputSecurityGroup) *UpdateInputSecurityGroupOutput {
	s.SecurityGroup = v
	return s
}

type ValidationError struct {
	_ struct{} `type:"structure"`

	ElementPath *string `locationName:"elementPath" type:"string"`

	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation
func (s ValidationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationError) GoString() string {
	return s.String()
}

// SetElementPath sets the ElementPath field's value.
func (s *ValidationError) SetElementPath(v string) *ValidationError {
	s.ElementPath = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ValidationError) SetErrorMessage(v string) *ValidationError {
	s.ErrorMessage = &v
	return s
}

type VideoCodecSettings struct {
	_ struct{} `type:"structure"`

	H264Settings *H264Settings `locationName:"h264Settings" type:"structure"`
}

// String returns the string representation
func (s VideoCodecSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoCodecSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VideoCodecSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VideoCodecSettings"}
	if s.H264Settings != nil {
		if err := s.H264Settings.Validate(); err != nil {
			invalidParams.AddNested("H264Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetH264Settings sets the H264Settings field's value.
func (s *VideoCodecSettings) SetH264Settings(v *H264Settings) *VideoCodecSettings {
	s.H264Settings = v
	return s
}

// Video settings for this stream.
type VideoDescription struct {
	_ struct{} `type:"structure"`

	// Video codec settings.
	CodecSettings *VideoCodecSettings `locationName:"codecSettings" type:"structure"`

	// Output video height (in pixels). Leave blank to use source video height.
	// If left blank, width must also be unspecified.
	Height *int64 `locationName:"height" type:"integer"`

	// The name of this VideoDescription. Outputs will use this name to uniquely
	// identify this Description. Description names should be unique within this
	// Live Event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Indicates how to respond to the AFD values in the input stream. Setting to
	// "respond" causes input video to be clipped, depending on AFD value, input
	// display aspect ratio and output display aspect ratio.
	RespondToAfd *string `locationName:"respondToAfd" type:"string" enum:"VideoDescriptionRespondToAfd"`

	// When set to "stretchToOutput", automatically configures the output position
	// to stretch the video to the specified output resolution. This option will
	// override any position value.
	ScalingBehavior *string `locationName:"scalingBehavior" type:"string" enum:"VideoDescriptionScalingBehavior"`

	// Changes the width of the anti-alias filter kernel used for scaling. Only
	// applies if scaling is being performed and antiAlias is set to true. 0 is
	// the softest setting, 100 the sharpest, and 50 recommended for most content.
	Sharpness *int64 `locationName:"sharpness" type:"integer"`

	// Output video width (in pixels). Leave out to use source video width. If left
	// out, height must also be left out. Display aspect ratio is always preserved
	// by letterboxing or pillarboxing when necessary.
	Width *int64 `locationName:"width" type:"integer"`
}

// String returns the string representation
func (s VideoDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoDescription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VideoDescription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VideoDescription"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.CodecSettings != nil {
		if err := s.CodecSettings.Validate(); err != nil {
			invalidParams.AddNested("CodecSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodecSettings sets the CodecSettings field's value.
func (s *VideoDescription) SetCodecSettings(v *VideoCodecSettings) *VideoDescription {
	s.CodecSettings = v
	return s
}

// SetHeight sets the Height field's value.
func (s *VideoDescription) SetHeight(v int64) *VideoDescription {
	s.Height = &v
	return s
}

// SetName sets the Name field's value.
func (s *VideoDescription) SetName(v string) *VideoDescription {
	s.Name = &v
	return s
}

// SetRespondToAfd sets the RespondToAfd field's value.
func (s *VideoDescription) SetRespondToAfd(v string) *VideoDescription {
	s.RespondToAfd = &v
	return s
}

// SetScalingBehavior sets the ScalingBehavior field's value.
func (s *VideoDescription) SetScalingBehavior(v string) *VideoDescription {
	s.ScalingBehavior = &v
	return s
}

// SetSharpness sets the Sharpness field's value.
func (s *VideoDescription) SetSharpness(v int64) *VideoDescription {
	s.Sharpness = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *VideoDescription) SetWidth(v int64) *VideoDescription {
	s.Width = &v
	return s
}

// Specifies a particular video stream within an input source. An input may
// have only a single video selector.
type VideoSelector struct {
	_ struct{} `type:"structure"`

	// Specifies the colorspace of an input. This setting works in tandem with colorSpaceConversion
	// to determine if any conversion will be performed.
	ColorSpace *string `locationName:"colorSpace" type:"string" enum:"VideoSelectorColorSpace"`

	// Applies only if colorSpace is a value other than follow. This field controls
	// how the value in the colorSpace field will be used. fallback means that when
	// the input does include color space data, that data will be used, but when
	// the input has no color space data, the value in colorSpace will be used.
	// Choose fallback if your input is sometimes missing color space data, but
	// when it does have color space data, that data is correct. force means to
	// always use the value in colorSpace. Choose force if your input usually has
	// no color space data or might have unreliable color space data.
	ColorSpaceUsage *string `locationName:"colorSpaceUsage" type:"string" enum:"VideoSelectorColorSpaceUsage"`

	// The video selector settings.
	SelectorSettings *VideoSelectorSettings `locationName:"selectorSettings" type:"structure"`
}

// String returns the string representation
func (s VideoSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoSelector) GoString() string {
	return s.String()
}

// SetColorSpace sets the ColorSpace field's value.
func (s *VideoSelector) SetColorSpace(v string) *VideoSelector {
	s.ColorSpace = &v
	return s
}

// SetColorSpaceUsage sets the ColorSpaceUsage field's value.
func (s *VideoSelector) SetColorSpaceUsage(v string) *VideoSelector {
	s.ColorSpaceUsage = &v
	return s
}

// SetSelectorSettings sets the SelectorSettings field's value.
func (s *VideoSelector) SetSelectorSettings(v *VideoSelectorSettings) *VideoSelector {
	s.SelectorSettings = v
	return s
}

type VideoSelectorPid struct {
	_ struct{} `type:"structure"`

	// Selects a specific PID from within a video source.
	Pid *int64 `locationName:"pid" type:"integer"`
}

// String returns the string representation
func (s VideoSelectorPid) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoSelectorPid) GoString() string {
	return s.String()
}

// SetPid sets the Pid field's value.
func (s *VideoSelectorPid) SetPid(v int64) *VideoSelectorPid {
	s.Pid = &v
	return s
}

type VideoSelectorProgramId struct {
	_ struct{} `type:"structure"`

	// Selects a specific program from within a multi-program transport stream.
	// If the program doesn't exist, the first program within the transport stream
	// will be selected by default.
	ProgramId *int64 `locationName:"programId" type:"integer"`
}

// String returns the string representation
func (s VideoSelectorProgramId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoSelectorProgramId) GoString() string {
	return s.String()
}

// SetProgramId sets the ProgramId field's value.
func (s *VideoSelectorProgramId) SetProgramId(v int64) *VideoSelectorProgramId {
	s.ProgramId = &v
	return s
}

type VideoSelectorSettings struct {
	_ struct{} `type:"structure"`

	VideoSelectorPid *VideoSelectorPid `locationName:"videoSelectorPid" type:"structure"`

	VideoSelectorProgramId *VideoSelectorProgramId `locationName:"videoSelectorProgramId" type:"structure"`
}

// String returns the string representation
func (s VideoSelectorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoSelectorSettings) GoString() string {
	return s.String()
}

// SetVideoSelectorPid sets the VideoSelectorPid field's value.
func (s *VideoSelectorSettings) SetVideoSelectorPid(v *VideoSelectorPid) *VideoSelectorSettings {
	s.VideoSelectorPid = v
	return s
}

// SetVideoSelectorProgramId sets the VideoSelectorProgramId field's value.
func (s *VideoSelectorSettings) SetVideoSelectorProgramId(v *VideoSelectorProgramId) *VideoSelectorSettings {
	s.VideoSelectorProgramId = v
	return s
}

type WebvttDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s WebvttDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebvttDestinationSettings) GoString() string {
	return s.String()
}

const (
	// AacCodingModeAdReceiverMix is a AacCodingMode enum value
	AacCodingModeAdReceiverMix = "AD_RECEIVER_MIX"

	// AacCodingModeCodingMode10 is a AacCodingMode enum value
	AacCodingModeCodingMode10 = "CODING_MODE_1_0"

	// AacCodingModeCodingMode11 is a AacCodingMode enum value
	AacCodingModeCodingMode11 = "CODING_MODE_1_1"

	// AacCodingModeCodingMode20 is a AacCodingMode enum value
	AacCodingModeCodingMode20 = "CODING_MODE_2_0"

	// AacCodingModeCodingMode51 is a AacCodingMode enum value
	AacCodingModeCodingMode51 = "CODING_MODE_5_1"
)

const (
	// AacInputTypeBroadcasterMixedAd is a AacInputType enum value
	AacInputTypeBroadcasterMixedAd = "BROADCASTER_MIXED_AD"

	// AacInputTypeNormal is a AacInputType enum value
	AacInputTypeNormal = "NORMAL"
)

const (
	// AacProfileHev1 is a AacProfile enum value
	AacProfileHev1 = "HEV1"

	// AacProfileHev2 is a AacProfile enum value
	AacProfileHev2 = "HEV2"

	// AacProfileLc is a AacProfile enum value
	AacProfileLc = "LC"
)

const (
	// AacRateControlModeCbr is a AacRateControlMode enum value
	AacRateControlModeCbr = "CBR"

	// AacRateControlModeVbr is a AacRateControlMode enum value
	AacRateControlModeVbr = "VBR"
)

const (
	// AacRawFormatLatmLoas is a AacRawFormat enum value
	AacRawFormatLatmLoas = "LATM_LOAS"

	// AacRawFormatNone is a AacRawFormat enum value
	AacRawFormatNone = "NONE"
)

const (
	// AacSpecMpeg2 is a AacSpec enum value
	AacSpecMpeg2 = "MPEG2"

	// AacSpecMpeg4 is a AacSpec enum value
	AacSpecMpeg4 = "MPEG4"
)

const (
	// AacVbrQualityHigh is a AacVbrQuality enum value
	AacVbrQualityHigh = "HIGH"

	// AacVbrQualityLow is a AacVbrQuality enum value
	AacVbrQualityLow = "LOW"

	// AacVbrQualityMediumHigh is a AacVbrQuality enum value
	AacVbrQualityMediumHigh = "MEDIUM_HIGH"

	// AacVbrQualityMediumLow is a AacVbrQuality enum value
	AacVbrQualityMediumLow = "MEDIUM_LOW"
)

const (
	// Ac3BitstreamModeCommentary is a Ac3BitstreamMode enum value
	Ac3BitstreamModeCommentary = "COMMENTARY"

	// Ac3BitstreamModeCompleteMain is a Ac3BitstreamMode enum value
	Ac3BitstreamModeCompleteMain = "COMPLETE_MAIN"

	// Ac3BitstreamModeDialogue is a Ac3BitstreamMode enum value
	Ac3BitstreamModeDialogue = "DIALOGUE"

	// Ac3BitstreamModeEmergency is a Ac3BitstreamMode enum value
	Ac3BitstreamModeEmergency = "EMERGENCY"

	// Ac3BitstreamModeHearingImpaired is a Ac3BitstreamMode enum value
	Ac3BitstreamModeHearingImpaired = "HEARING_IMPAIRED"

	// Ac3BitstreamModeMusicAndEffects is a Ac3BitstreamMode enum value
	Ac3BitstreamModeMusicAndEffects = "MUSIC_AND_EFFECTS"

	// Ac3BitstreamModeVisuallyImpaired is a Ac3BitstreamMode enum value
	Ac3BitstreamModeVisuallyImpaired = "VISUALLY_IMPAIRED"

	// Ac3BitstreamModeVoiceOver is a Ac3BitstreamMode enum value
	Ac3BitstreamModeVoiceOver = "VOICE_OVER"
)

const (
	// Ac3CodingModeCodingMode10 is a Ac3CodingMode enum value
	Ac3CodingModeCodingMode10 = "CODING_MODE_1_0"

	// Ac3CodingModeCodingMode11 is a Ac3CodingMode enum value
	Ac3CodingModeCodingMode11 = "CODING_MODE_1_1"

	// Ac3CodingModeCodingMode20 is a Ac3CodingMode enum value
	Ac3CodingModeCodingMode20 = "CODING_MODE_2_0"

	// Ac3CodingModeCodingMode32Lfe is a Ac3CodingMode enum value
	Ac3CodingModeCodingMode32Lfe = "CODING_MODE_3_2_LFE"
)

const (
	// Ac3DrcProfileFilmStandard is a Ac3DrcProfile enum value
	Ac3DrcProfileFilmStandard = "FILM_STANDARD"

	// Ac3DrcProfileNone is a Ac3DrcProfile enum value
	Ac3DrcProfileNone = "NONE"
)

const (
	// Ac3LfeFilterDisabled is a Ac3LfeFilter enum value
	Ac3LfeFilterDisabled = "DISABLED"

	// Ac3LfeFilterEnabled is a Ac3LfeFilter enum value
	Ac3LfeFilterEnabled = "ENABLED"
)

const (
	// Ac3MetadataControlFollowInput is a Ac3MetadataControl enum value
	Ac3MetadataControlFollowInput = "FOLLOW_INPUT"

	// Ac3MetadataControlUseConfigured is a Ac3MetadataControl enum value
	Ac3MetadataControlUseConfigured = "USE_CONFIGURED"
)

const (
	// AfdSignalingAuto is a AfdSignaling enum value
	AfdSignalingAuto = "AUTO"

	// AfdSignalingFixed is a AfdSignaling enum value
	AfdSignalingFixed = "FIXED"

	// AfdSignalingNone is a AfdSignaling enum value
	AfdSignalingNone = "NONE"
)

const (
	// AudioDescriptionAudioTypeControlFollowInput is a AudioDescriptionAudioTypeControl enum value
	AudioDescriptionAudioTypeControlFollowInput = "FOLLOW_INPUT"

	// AudioDescriptionAudioTypeControlUseConfigured is a AudioDescriptionAudioTypeControl enum value
	AudioDescriptionAudioTypeControlUseConfigured = "USE_CONFIGURED"
)

const (
	// AudioDescriptionLanguageCodeControlFollowInput is a AudioDescriptionLanguageCodeControl enum value
	AudioDescriptionLanguageCodeControlFollowInput = "FOLLOW_INPUT"

	// AudioDescriptionLanguageCodeControlUseConfigured is a AudioDescriptionLanguageCodeControl enum value
	AudioDescriptionLanguageCodeControlUseConfigured = "USE_CONFIGURED"
)

const (
	// AudioLanguageSelectionPolicyLoose is a AudioLanguageSelectionPolicy enum value
	AudioLanguageSelectionPolicyLoose = "LOOSE"

	// AudioLanguageSelectionPolicyStrict is a AudioLanguageSelectionPolicy enum value
	AudioLanguageSelectionPolicyStrict = "STRICT"
)

const (
	// AudioNormalizationAlgorithmItu17701 is a AudioNormalizationAlgorithm enum value
	AudioNormalizationAlgorithmItu17701 = "ITU_1770_1"

	// AudioNormalizationAlgorithmItu17702 is a AudioNormalizationAlgorithm enum value
	AudioNormalizationAlgorithmItu17702 = "ITU_1770_2"
)

const (
	// AudioNormalizationAlgorithmControlCorrectAudio is a AudioNormalizationAlgorithmControl enum value
	AudioNormalizationAlgorithmControlCorrectAudio = "CORRECT_AUDIO"
)

const (
	// AudioOnlyHlsTrackTypeAlternateAudioAutoSelect is a AudioOnlyHlsTrackType enum value
	AudioOnlyHlsTrackTypeAlternateAudioAutoSelect = "ALTERNATE_AUDIO_AUTO_SELECT"

	// AudioOnlyHlsTrackTypeAlternateAudioAutoSelectDefault is a AudioOnlyHlsTrackType enum value
	AudioOnlyHlsTrackTypeAlternateAudioAutoSelectDefault = "ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT"

	// AudioOnlyHlsTrackTypeAlternateAudioNotAutoSelect is a AudioOnlyHlsTrackType enum value
	AudioOnlyHlsTrackTypeAlternateAudioNotAutoSelect = "ALTERNATE_AUDIO_NOT_AUTO_SELECT"

	// AudioOnlyHlsTrackTypeAudioOnlyVariantStream is a AudioOnlyHlsTrackType enum value
	AudioOnlyHlsTrackTypeAudioOnlyVariantStream = "AUDIO_ONLY_VARIANT_STREAM"
)

const (
	// AudioTypeCleanEffects is a AudioType enum value
	AudioTypeCleanEffects = "CLEAN_EFFECTS"

	// AudioTypeHearingImpaired is a AudioType enum value
	AudioTypeHearingImpaired = "HEARING_IMPAIRED"

	// AudioTypeUndefined is a AudioType enum value
	AudioTypeUndefined = "UNDEFINED"

	// AudioTypeVisualImpairedCommentary is a AudioType enum value
	AudioTypeVisualImpairedCommentary = "VISUAL_IMPAIRED_COMMENTARY"
)

const (
	// AuthenticationSchemeAkamai is a AuthenticationScheme enum value
	AuthenticationSchemeAkamai = "AKAMAI"

	// AuthenticationSchemeCommon is a AuthenticationScheme enum value
	AuthenticationSchemeCommon = "COMMON"
)

const (
	// AvailBlankingStateDisabled is a AvailBlankingState enum value
	AvailBlankingStateDisabled = "DISABLED"

	// AvailBlankingStateEnabled is a AvailBlankingState enum value
	AvailBlankingStateEnabled = "ENABLED"
)

const (
	// BlackoutSlateNetworkEndBlackoutDisabled is a BlackoutSlateNetworkEndBlackout enum value
	BlackoutSlateNetworkEndBlackoutDisabled = "DISABLED"

	// BlackoutSlateNetworkEndBlackoutEnabled is a BlackoutSlateNetworkEndBlackout enum value
	BlackoutSlateNetworkEndBlackoutEnabled = "ENABLED"
)

const (
	// BlackoutSlateStateDisabled is a BlackoutSlateState enum value
	BlackoutSlateStateDisabled = "DISABLED"

	// BlackoutSlateStateEnabled is a BlackoutSlateState enum value
	BlackoutSlateStateEnabled = "ENABLED"
)

const (
	// BurnInAlignmentCentered is a BurnInAlignment enum value
	BurnInAlignmentCentered = "CENTERED"

	// BurnInAlignmentLeft is a BurnInAlignment enum value
	BurnInAlignmentLeft = "LEFT"

	// BurnInAlignmentSmart is a BurnInAlignment enum value
	BurnInAlignmentSmart = "SMART"
)

const (
	// BurnInBackgroundColorBlack is a BurnInBackgroundColor enum value
	BurnInBackgroundColorBlack = "BLACK"

	// BurnInBackgroundColorNone is a BurnInBackgroundColor enum value
	BurnInBackgroundColorNone = "NONE"

	// BurnInBackgroundColorWhite is a BurnInBackgroundColor enum value
	BurnInBackgroundColorWhite = "WHITE"
)

const (
	// BurnInFontColorBlack is a BurnInFontColor enum value
	BurnInFontColorBlack = "BLACK"

	// BurnInFontColorBlue is a BurnInFontColor enum value
	BurnInFontColorBlue = "BLUE"

	// BurnInFontColorGreen is a BurnInFontColor enum value
	BurnInFontColorGreen = "GREEN"

	// BurnInFontColorRed is a BurnInFontColor enum value
	BurnInFontColorRed = "RED"

	// BurnInFontColorWhite is a BurnInFontColor enum value
	BurnInFontColorWhite = "WHITE"

	// BurnInFontColorYellow is a BurnInFontColor enum value
	BurnInFontColorYellow = "YELLOW"
)

const (
	// BurnInOutlineColorBlack is a BurnInOutlineColor enum value
	BurnInOutlineColorBlack = "BLACK"

	// BurnInOutlineColorBlue is a BurnInOutlineColor enum value
	BurnInOutlineColorBlue = "BLUE"

	// BurnInOutlineColorGreen is a BurnInOutlineColor enum value
	BurnInOutlineColorGreen = "GREEN"

	// BurnInOutlineColorRed is a BurnInOutlineColor enum value
	BurnInOutlineColorRed = "RED"

	// BurnInOutlineColorWhite is a BurnInOutlineColor enum value
	BurnInOutlineColorWhite = "WHITE"

	// BurnInOutlineColorYellow is a BurnInOutlineColor enum value
	BurnInOutlineColorYellow = "YELLOW"
)

const (
	// BurnInShadowColorBlack is a BurnInShadowColor enum value
	BurnInShadowColorBlack = "BLACK"

	// BurnInShadowColorNone is a BurnInShadowColor enum value
	BurnInShadowColorNone = "NONE"

	// BurnInShadowColorWhite is a BurnInShadowColor enum value
	BurnInShadowColorWhite = "WHITE"
)

const (
	// BurnInTeletextGridControlFixed is a BurnInTeletextGridControl enum value
	BurnInTeletextGridControlFixed = "FIXED"

	// BurnInTeletextGridControlScaled is a BurnInTeletextGridControl enum value
	BurnInTeletextGridControlScaled = "SCALED"
)

const (
	// ChannelStateCreating is a ChannelState enum value
	ChannelStateCreating = "CREATING"

	// ChannelStateCreateFailed is a ChannelState enum value
	ChannelStateCreateFailed = "CREATE_FAILED"

	// ChannelStateIdle is a ChannelState enum value
	ChannelStateIdle = "IDLE"

	// ChannelStateStarting is a ChannelState enum value
	ChannelStateStarting = "STARTING"

	// ChannelStateRunning is a ChannelState enum value
	ChannelStateRunning = "RUNNING"

	// ChannelStateRecovering is a ChannelState enum value
	ChannelStateRecovering = "RECOVERING"

	// ChannelStateStopping is a ChannelState enum value
	ChannelStateStopping = "STOPPING"

	// ChannelStateDeleting is a ChannelState enum value
	ChannelStateDeleting = "DELETING"

	// ChannelStateDeleted is a ChannelState enum value
	ChannelStateDeleted = "DELETED"
)

const (
	// DvbSdtOutputSdtSdtFollow is a DvbSdtOutputSdt enum value
	DvbSdtOutputSdtSdtFollow = "SDT_FOLLOW"

	// DvbSdtOutputSdtSdtFollowIfPresent is a DvbSdtOutputSdt enum value
	DvbSdtOutputSdtSdtFollowIfPresent = "SDT_FOLLOW_IF_PRESENT"

	// DvbSdtOutputSdtSdtManual is a DvbSdtOutputSdt enum value
	DvbSdtOutputSdtSdtManual = "SDT_MANUAL"

	// DvbSdtOutputSdtSdtNone is a DvbSdtOutputSdt enum value
	DvbSdtOutputSdtSdtNone = "SDT_NONE"
)

const (
	// DvbSubDestinationAlignmentCentered is a DvbSubDestinationAlignment enum value
	DvbSubDestinationAlignmentCentered = "CENTERED"

	// DvbSubDestinationAlignmentLeft is a DvbSubDestinationAlignment enum value
	DvbSubDestinationAlignmentLeft = "LEFT"

	// DvbSubDestinationAlignmentSmart is a DvbSubDestinationAlignment enum value
	DvbSubDestinationAlignmentSmart = "SMART"
)

const (
	// DvbSubDestinationBackgroundColorBlack is a DvbSubDestinationBackgroundColor enum value
	DvbSubDestinationBackgroundColorBlack = "BLACK"

	// DvbSubDestinationBackgroundColorNone is a DvbSubDestinationBackgroundColor enum value
	DvbSubDestinationBackgroundColorNone = "NONE"

	// DvbSubDestinationBackgroundColorWhite is a DvbSubDestinationBackgroundColor enum value
	DvbSubDestinationBackgroundColorWhite = "WHITE"
)

const (
	// DvbSubDestinationFontColorBlack is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorBlack = "BLACK"

	// DvbSubDestinationFontColorBlue is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorBlue = "BLUE"

	// DvbSubDestinationFontColorGreen is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorGreen = "GREEN"

	// DvbSubDestinationFontColorRed is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorRed = "RED"

	// DvbSubDestinationFontColorWhite is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorWhite = "WHITE"

	// DvbSubDestinationFontColorYellow is a DvbSubDestinationFontColor enum value
	DvbSubDestinationFontColorYellow = "YELLOW"
)

const (
	// DvbSubDestinationOutlineColorBlack is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorBlack = "BLACK"

	// DvbSubDestinationOutlineColorBlue is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorBlue = "BLUE"

	// DvbSubDestinationOutlineColorGreen is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorGreen = "GREEN"

	// DvbSubDestinationOutlineColorRed is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorRed = "RED"

	// DvbSubDestinationOutlineColorWhite is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorWhite = "WHITE"

	// DvbSubDestinationOutlineColorYellow is a DvbSubDestinationOutlineColor enum value
	DvbSubDestinationOutlineColorYellow = "YELLOW"
)

const (
	// DvbSubDestinationShadowColorBlack is a DvbSubDestinationShadowColor enum value
	DvbSubDestinationShadowColorBlack = "BLACK"

	// DvbSubDestinationShadowColorNone is a DvbSubDestinationShadowColor enum value
	DvbSubDestinationShadowColorNone = "NONE"

	// DvbSubDestinationShadowColorWhite is a DvbSubDestinationShadowColor enum value
	DvbSubDestinationShadowColorWhite = "WHITE"
)

const (
	// DvbSubDestinationTeletextGridControlFixed is a DvbSubDestinationTeletextGridControl enum value
	DvbSubDestinationTeletextGridControlFixed = "FIXED"

	// DvbSubDestinationTeletextGridControlScaled is a DvbSubDestinationTeletextGridControl enum value
	DvbSubDestinationTeletextGridControlScaled = "SCALED"
)

const (
	// Eac3AttenuationControlAttenuate3Db is a Eac3AttenuationControl enum value
	Eac3AttenuationControlAttenuate3Db = "ATTENUATE_3_DB"

	// Eac3AttenuationControlNone is a Eac3AttenuationControl enum value
	Eac3AttenuationControlNone = "NONE"
)

const (
	// Eac3BitstreamModeCommentary is a Eac3BitstreamMode enum value
	Eac3BitstreamModeCommentary = "COMMENTARY"

	// Eac3BitstreamModeCompleteMain is a Eac3BitstreamMode enum value
	Eac3BitstreamModeCompleteMain = "COMPLETE_MAIN"

	// Eac3BitstreamModeEmergency is a Eac3BitstreamMode enum value
	Eac3BitstreamModeEmergency = "EMERGENCY"

	// Eac3BitstreamModeHearingImpaired is a Eac3BitstreamMode enum value
	Eac3BitstreamModeHearingImpaired = "HEARING_IMPAIRED"

	// Eac3BitstreamModeVisuallyImpaired is a Eac3BitstreamMode enum value
	Eac3BitstreamModeVisuallyImpaired = "VISUALLY_IMPAIRED"
)

const (
	// Eac3CodingModeCodingMode10 is a Eac3CodingMode enum value
	Eac3CodingModeCodingMode10 = "CODING_MODE_1_0"

	// Eac3CodingModeCodingMode20 is a Eac3CodingMode enum value
	Eac3CodingModeCodingMode20 = "CODING_MODE_2_0"

	// Eac3CodingModeCodingMode32 is a Eac3CodingMode enum value
	Eac3CodingModeCodingMode32 = "CODING_MODE_3_2"
)

const (
	// Eac3DcFilterDisabled is a Eac3DcFilter enum value
	Eac3DcFilterDisabled = "DISABLED"

	// Eac3DcFilterEnabled is a Eac3DcFilter enum value
	Eac3DcFilterEnabled = "ENABLED"
)

const (
	// Eac3DrcLineFilmLight is a Eac3DrcLine enum value
	Eac3DrcLineFilmLight = "FILM_LIGHT"

	// Eac3DrcLineFilmStandard is a Eac3DrcLine enum value
	Eac3DrcLineFilmStandard = "FILM_STANDARD"

	// Eac3DrcLineMusicLight is a Eac3DrcLine enum value
	Eac3DrcLineMusicLight = "MUSIC_LIGHT"

	// Eac3DrcLineMusicStandard is a Eac3DrcLine enum value
	Eac3DrcLineMusicStandard = "MUSIC_STANDARD"

	// Eac3DrcLineNone is a Eac3DrcLine enum value
	Eac3DrcLineNone = "NONE"

	// Eac3DrcLineSpeech is a Eac3DrcLine enum value
	Eac3DrcLineSpeech = "SPEECH"
)

const (
	// Eac3DrcRfFilmLight is a Eac3DrcRf enum value
	Eac3DrcRfFilmLight = "FILM_LIGHT"

	// Eac3DrcRfFilmStandard is a Eac3DrcRf enum value
	Eac3DrcRfFilmStandard = "FILM_STANDARD"

	// Eac3DrcRfMusicLight is a Eac3DrcRf enum value
	Eac3DrcRfMusicLight = "MUSIC_LIGHT"

	// Eac3DrcRfMusicStandard is a Eac3DrcRf enum value
	Eac3DrcRfMusicStandard = "MUSIC_STANDARD"

	// Eac3DrcRfNone is a Eac3DrcRf enum value
	Eac3DrcRfNone = "NONE"

	// Eac3DrcRfSpeech is a Eac3DrcRf enum value
	Eac3DrcRfSpeech = "SPEECH"
)

const (
	// Eac3LfeControlLfe is a Eac3LfeControl enum value
	Eac3LfeControlLfe = "LFE"

	// Eac3LfeControlNoLfe is a Eac3LfeControl enum value
	Eac3LfeControlNoLfe = "NO_LFE"
)

const (
	// Eac3LfeFilterDisabled is a Eac3LfeFilter enum value
	Eac3LfeFilterDisabled = "DISABLED"

	// Eac3LfeFilterEnabled is a Eac3LfeFilter enum value
	Eac3LfeFilterEnabled = "ENABLED"
)

const (
	// Eac3MetadataControlFollowInput is a Eac3MetadataControl enum value
	Eac3MetadataControlFollowInput = "FOLLOW_INPUT"

	// Eac3MetadataControlUseConfigured is a Eac3MetadataControl enum value
	Eac3MetadataControlUseConfigured = "USE_CONFIGURED"
)

const (
	// Eac3PassthroughControlNoPassthrough is a Eac3PassthroughControl enum value
	Eac3PassthroughControlNoPassthrough = "NO_PASSTHROUGH"

	// Eac3PassthroughControlWhenPossible is a Eac3PassthroughControl enum value
	Eac3PassthroughControlWhenPossible = "WHEN_POSSIBLE"
)

const (
	// Eac3PhaseControlNoShift is a Eac3PhaseControl enum value
	Eac3PhaseControlNoShift = "NO_SHIFT"

	// Eac3PhaseControlShift90Degrees is a Eac3PhaseControl enum value
	Eac3PhaseControlShift90Degrees = "SHIFT_90_DEGREES"
)

const (
	// Eac3StereoDownmixDpl2 is a Eac3StereoDownmix enum value
	Eac3StereoDownmixDpl2 = "DPL2"

	// Eac3StereoDownmixLoRo is a Eac3StereoDownmix enum value
	Eac3StereoDownmixLoRo = "LO_RO"

	// Eac3StereoDownmixLtRt is a Eac3StereoDownmix enum value
	Eac3StereoDownmixLtRt = "LT_RT"

	// Eac3StereoDownmixNotIndicated is a Eac3StereoDownmix enum value
	Eac3StereoDownmixNotIndicated = "NOT_INDICATED"
)

const (
	// Eac3SurroundExModeDisabled is a Eac3SurroundExMode enum value
	Eac3SurroundExModeDisabled = "DISABLED"

	// Eac3SurroundExModeEnabled is a Eac3SurroundExMode enum value
	Eac3SurroundExModeEnabled = "ENABLED"

	// Eac3SurroundExModeNotIndicated is a Eac3SurroundExMode enum value
	Eac3SurroundExModeNotIndicated = "NOT_INDICATED"
)

const (
	// Eac3SurroundModeDisabled is a Eac3SurroundMode enum value
	Eac3SurroundModeDisabled = "DISABLED"

	// Eac3SurroundModeEnabled is a Eac3SurroundMode enum value
	Eac3SurroundModeEnabled = "ENABLED"

	// Eac3SurroundModeNotIndicated is a Eac3SurroundMode enum value
	Eac3SurroundModeNotIndicated = "NOT_INDICATED"
)

const (
	// EmbeddedConvert608To708Disabled is a EmbeddedConvert608To708 enum value
	EmbeddedConvert608To708Disabled = "DISABLED"

	// EmbeddedConvert608To708Upconvert is a EmbeddedConvert608To708 enum value
	EmbeddedConvert608To708Upconvert = "UPCONVERT"
)

const (
	// EmbeddedScte20DetectionAuto is a EmbeddedScte20Detection enum value
	EmbeddedScte20DetectionAuto = "AUTO"

	// EmbeddedScte20DetectionOff is a EmbeddedScte20Detection enum value
	EmbeddedScte20DetectionOff = "OFF"
)

const (
	// FecOutputIncludeFecColumn is a FecOutputIncludeFec enum value
	FecOutputIncludeFecColumn = "COLUMN"

	// FecOutputIncludeFecColumnAndRow is a FecOutputIncludeFec enum value
	FecOutputIncludeFecColumnAndRow = "COLUMN_AND_ROW"
)

const (
	// FixedAfdAfd0000 is a FixedAfd enum value
	FixedAfdAfd0000 = "AFD_0000"

	// FixedAfdAfd0010 is a FixedAfd enum value
	FixedAfdAfd0010 = "AFD_0010"

	// FixedAfdAfd0011 is a FixedAfd enum value
	FixedAfdAfd0011 = "AFD_0011"

	// FixedAfdAfd0100 is a FixedAfd enum value
	FixedAfdAfd0100 = "AFD_0100"

	// FixedAfdAfd1000 is a FixedAfd enum value
	FixedAfdAfd1000 = "AFD_1000"

	// FixedAfdAfd1001 is a FixedAfd enum value
	FixedAfdAfd1001 = "AFD_1001"

	// FixedAfdAfd1010 is a FixedAfd enum value
	FixedAfdAfd1010 = "AFD_1010"

	// FixedAfdAfd1011 is a FixedAfd enum value
	FixedAfdAfd1011 = "AFD_1011"

	// FixedAfdAfd1101 is a FixedAfd enum value
	FixedAfdAfd1101 = "AFD_1101"

	// FixedAfdAfd1110 is a FixedAfd enum value
	FixedAfdAfd1110 = "AFD_1110"

	// FixedAfdAfd1111 is a FixedAfd enum value
	FixedAfdAfd1111 = "AFD_1111"
)

const (
	// GlobalConfigurationInputEndActionNone is a GlobalConfigurationInputEndAction enum value
	GlobalConfigurationInputEndActionNone = "NONE"

	// GlobalConfigurationInputEndActionSwitchAndLoopInputs is a GlobalConfigurationInputEndAction enum value
	GlobalConfigurationInputEndActionSwitchAndLoopInputs = "SWITCH_AND_LOOP_INPUTS"
)

const (
	// GlobalConfigurationLowFramerateInputsDisabled is a GlobalConfigurationLowFramerateInputs enum value
	GlobalConfigurationLowFramerateInputsDisabled = "DISABLED"

	// GlobalConfigurationLowFramerateInputsEnabled is a GlobalConfigurationLowFramerateInputs enum value
	GlobalConfigurationLowFramerateInputsEnabled = "ENABLED"
)

const (
	// GlobalConfigurationOutputTimingSourceInputClock is a GlobalConfigurationOutputTimingSource enum value
	GlobalConfigurationOutputTimingSourceInputClock = "INPUT_CLOCK"

	// GlobalConfigurationOutputTimingSourceSystemClock is a GlobalConfigurationOutputTimingSource enum value
	GlobalConfigurationOutputTimingSourceSystemClock = "SYSTEM_CLOCK"
)

const (
	// H264AdaptiveQuantizationHigh is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationHigh = "HIGH"

	// H264AdaptiveQuantizationHigher is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationHigher = "HIGHER"

	// H264AdaptiveQuantizationLow is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationLow = "LOW"

	// H264AdaptiveQuantizationMax is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationMax = "MAX"

	// H264AdaptiveQuantizationMedium is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationMedium = "MEDIUM"

	// H264AdaptiveQuantizationOff is a H264AdaptiveQuantization enum value
	H264AdaptiveQuantizationOff = "OFF"
)

const (
	// H264ColorMetadataIgnore is a H264ColorMetadata enum value
	H264ColorMetadataIgnore = "IGNORE"

	// H264ColorMetadataInsert is a H264ColorMetadata enum value
	H264ColorMetadataInsert = "INSERT"
)

const (
	// H264EntropyEncodingCabac is a H264EntropyEncoding enum value
	H264EntropyEncodingCabac = "CABAC"

	// H264EntropyEncodingCavlc is a H264EntropyEncoding enum value
	H264EntropyEncodingCavlc = "CAVLC"
)

const (
	// H264FlickerAqDisabled is a H264FlickerAq enum value
	H264FlickerAqDisabled = "DISABLED"

	// H264FlickerAqEnabled is a H264FlickerAq enum value
	H264FlickerAqEnabled = "ENABLED"
)

const (
	// H264FramerateControlInitializeFromSource is a H264FramerateControl enum value
	H264FramerateControlInitializeFromSource = "INITIALIZE_FROM_SOURCE"

	// H264FramerateControlSpecified is a H264FramerateControl enum value
	H264FramerateControlSpecified = "SPECIFIED"
)

const (
	// H264GopBReferenceDisabled is a H264GopBReference enum value
	H264GopBReferenceDisabled = "DISABLED"

	// H264GopBReferenceEnabled is a H264GopBReference enum value
	H264GopBReferenceEnabled = "ENABLED"
)

const (
	// H264GopSizeUnitsFrames is a H264GopSizeUnits enum value
	H264GopSizeUnitsFrames = "FRAMES"

	// H264GopSizeUnitsSeconds is a H264GopSizeUnits enum value
	H264GopSizeUnitsSeconds = "SECONDS"
)

const (
	// H264LevelH264Level1 is a H264Level enum value
	H264LevelH264Level1 = "H264_LEVEL_1"

	// H264LevelH264Level11 is a H264Level enum value
	H264LevelH264Level11 = "H264_LEVEL_1_1"

	// H264LevelH264Level12 is a H264Level enum value
	H264LevelH264Level12 = "H264_LEVEL_1_2"

	// H264LevelH264Level13 is a H264Level enum value
	H264LevelH264Level13 = "H264_LEVEL_1_3"

	// H264LevelH264Level2 is a H264Level enum value
	H264LevelH264Level2 = "H264_LEVEL_2"

	// H264LevelH264Level21 is a H264Level enum value
	H264LevelH264Level21 = "H264_LEVEL_2_1"

	// H264LevelH264Level22 is a H264Level enum value
	H264LevelH264Level22 = "H264_LEVEL_2_2"

	// H264LevelH264Level3 is a H264Level enum value
	H264LevelH264Level3 = "H264_LEVEL_3"

	// H264LevelH264Level31 is a H264Level enum value
	H264LevelH264Level31 = "H264_LEVEL_3_1"

	// H264LevelH264Level32 is a H264Level enum value
	H264LevelH264Level32 = "H264_LEVEL_3_2"

	// H264LevelH264Level4 is a H264Level enum value
	H264LevelH264Level4 = "H264_LEVEL_4"

	// H264LevelH264Level41 is a H264Level enum value
	H264LevelH264Level41 = "H264_LEVEL_4_1"

	// H264LevelH264Level42 is a H264Level enum value
	H264LevelH264Level42 = "H264_LEVEL_4_2"

	// H264LevelH264Level5 is a H264Level enum value
	H264LevelH264Level5 = "H264_LEVEL_5"

	// H264LevelH264Level51 is a H264Level enum value
	H264LevelH264Level51 = "H264_LEVEL_5_1"

	// H264LevelH264Level52 is a H264Level enum value
	H264LevelH264Level52 = "H264_LEVEL_5_2"

	// H264LevelH264LevelAuto is a H264Level enum value
	H264LevelH264LevelAuto = "H264_LEVEL_AUTO"
)

const (
	// H264LookAheadRateControlHigh is a H264LookAheadRateControl enum value
	H264LookAheadRateControlHigh = "HIGH"

	// H264LookAheadRateControlLow is a H264LookAheadRateControl enum value
	H264LookAheadRateControlLow = "LOW"

	// H264LookAheadRateControlMedium is a H264LookAheadRateControl enum value
	H264LookAheadRateControlMedium = "MEDIUM"
)

const (
	// H264ParControlInitializeFromSource is a H264ParControl enum value
	H264ParControlInitializeFromSource = "INITIALIZE_FROM_SOURCE"

	// H264ParControlSpecified is a H264ParControl enum value
	H264ParControlSpecified = "SPECIFIED"
)

const (
	// H264ProfileBaseline is a H264Profile enum value
	H264ProfileBaseline = "BASELINE"

	// H264ProfileHigh is a H264Profile enum value
	H264ProfileHigh = "HIGH"

	// H264ProfileHigh10bit is a H264Profile enum value
	H264ProfileHigh10bit = "HIGH_10BIT"

	// H264ProfileHigh422 is a H264Profile enum value
	H264ProfileHigh422 = "HIGH_422"

	// H264ProfileHigh42210bit is a H264Profile enum value
	H264ProfileHigh42210bit = "HIGH_422_10BIT"

	// H264ProfileMain is a H264Profile enum value
	H264ProfileMain = "MAIN"
)

const (
	// H264RateControlModeCbr is a H264RateControlMode enum value
	H264RateControlModeCbr = "CBR"

	// H264RateControlModeVbr is a H264RateControlMode enum value
	H264RateControlModeVbr = "VBR"
)

const (
	// H264ScanTypeInterlaced is a H264ScanType enum value
	H264ScanTypeInterlaced = "INTERLACED"

	// H264ScanTypeProgressive is a H264ScanType enum value
	H264ScanTypeProgressive = "PROGRESSIVE"
)

const (
	// H264SceneChangeDetectDisabled is a H264SceneChangeDetect enum value
	H264SceneChangeDetectDisabled = "DISABLED"

	// H264SceneChangeDetectEnabled is a H264SceneChangeDetect enum value
	H264SceneChangeDetectEnabled = "ENABLED"
)

const (
	// H264SpatialAqDisabled is a H264SpatialAq enum value
	H264SpatialAqDisabled = "DISABLED"

	// H264SpatialAqEnabled is a H264SpatialAq enum value
	H264SpatialAqEnabled = "ENABLED"
)

const (
	// H264SyntaxDefault is a H264Syntax enum value
	H264SyntaxDefault = "DEFAULT"

	// H264SyntaxRp2027 is a H264Syntax enum value
	H264SyntaxRp2027 = "RP2027"
)

const (
	// H264TemporalAqDisabled is a H264TemporalAq enum value
	H264TemporalAqDisabled = "DISABLED"

	// H264TemporalAqEnabled is a H264TemporalAq enum value
	H264TemporalAqEnabled = "ENABLED"
)

const (
	// H264TimecodeInsertionBehaviorDisabled is a H264TimecodeInsertionBehavior enum value
	H264TimecodeInsertionBehaviorDisabled = "DISABLED"

	// H264TimecodeInsertionBehaviorPicTimingSei is a H264TimecodeInsertionBehavior enum value
	H264TimecodeInsertionBehaviorPicTimingSei = "PIC_TIMING_SEI"
)

const (
	// HlsAdMarkersAdobe is a HlsAdMarkers enum value
	HlsAdMarkersAdobe = "ADOBE"

	// HlsAdMarkersElemental is a HlsAdMarkers enum value
	HlsAdMarkersElemental = "ELEMENTAL"

	// HlsAdMarkersElementalScte35 is a HlsAdMarkers enum value
	HlsAdMarkersElementalScte35 = "ELEMENTAL_SCTE35"
)

const (
	// HlsAkamaiHttpTransferModeChunked is a HlsAkamaiHttpTransferMode enum value
	HlsAkamaiHttpTransferModeChunked = "CHUNKED"

	// HlsAkamaiHttpTransferModeNonChunked is a HlsAkamaiHttpTransferMode enum value
	HlsAkamaiHttpTransferModeNonChunked = "NON_CHUNKED"
)

const (
	// HlsCaptionLanguageSettingInsert is a HlsCaptionLanguageSetting enum value
	HlsCaptionLanguageSettingInsert = "INSERT"

	// HlsCaptionLanguageSettingNone is a HlsCaptionLanguageSetting enum value
	HlsCaptionLanguageSettingNone = "NONE"

	// HlsCaptionLanguageSettingOmit is a HlsCaptionLanguageSetting enum value
	HlsCaptionLanguageSettingOmit = "OMIT"
)

const (
	// HlsClientCacheDisabled is a HlsClientCache enum value
	HlsClientCacheDisabled = "DISABLED"

	// HlsClientCacheEnabled is a HlsClientCache enum value
	HlsClientCacheEnabled = "ENABLED"
)

const (
	// HlsCodecSpecificationRfc4281 is a HlsCodecSpecification enum value
	HlsCodecSpecificationRfc4281 = "RFC_4281"

	// HlsCodecSpecificationRfc6381 is a HlsCodecSpecification enum value
	HlsCodecSpecificationRfc6381 = "RFC_6381"
)

const (
	// HlsDirectoryStructureSingleDirectory is a HlsDirectoryStructure enum value
	HlsDirectoryStructureSingleDirectory = "SINGLE_DIRECTORY"

	// HlsDirectoryStructureSubdirectoryPerStream is a HlsDirectoryStructure enum value
	HlsDirectoryStructureSubdirectoryPerStream = "SUBDIRECTORY_PER_STREAM"
)

const (
	// HlsEncryptionTypeAes128 is a HlsEncryptionType enum value
	HlsEncryptionTypeAes128 = "AES128"

	// HlsEncryptionTypeSampleAes is a HlsEncryptionType enum value
	HlsEncryptionTypeSampleAes = "SAMPLE_AES"
)

const (
	// HlsIvInManifestExclude is a HlsIvInManifest enum value
	HlsIvInManifestExclude = "EXCLUDE"

	// HlsIvInManifestInclude is a HlsIvInManifest enum value
	HlsIvInManifestInclude = "INCLUDE"
)

const (
	// HlsIvSourceExplicit is a HlsIvSource enum value
	HlsIvSourceExplicit = "EXPLICIT"

	// HlsIvSourceFollowsSegmentNumber is a HlsIvSource enum value
	HlsIvSourceFollowsSegmentNumber = "FOLLOWS_SEGMENT_NUMBER"
)

const (
	// HlsManifestCompressionGzip is a HlsManifestCompression enum value
	HlsManifestCompressionGzip = "GZIP"

	// HlsManifestCompressionNone is a HlsManifestCompression enum value
	HlsManifestCompressionNone = "NONE"
)

const (
	// HlsManifestDurationFormatFloatingPoint is a HlsManifestDurationFormat enum value
	HlsManifestDurationFormatFloatingPoint = "FLOATING_POINT"

	// HlsManifestDurationFormatInteger is a HlsManifestDurationFormat enum value
	HlsManifestDurationFormatInteger = "INTEGER"
)

const (
	// HlsMediaStoreStorageClassTemporal is a HlsMediaStoreStorageClass enum value
	HlsMediaStoreStorageClassTemporal = "TEMPORAL"
)

const (
	// HlsModeLive is a HlsMode enum value
	HlsModeLive = "LIVE"

	// HlsModeVod is a HlsMode enum value
	HlsModeVod = "VOD"
)

const (
	// HlsOutputSelectionManifestsAndSegments is a HlsOutputSelection enum value
	HlsOutputSelectionManifestsAndSegments = "MANIFESTS_AND_SEGMENTS"

	// HlsOutputSelectionSegmentsOnly is a HlsOutputSelection enum value
	HlsOutputSelectionSegmentsOnly = "SEGMENTS_ONLY"
)

const (
	// HlsProgramDateTimeExclude is a HlsProgramDateTime enum value
	HlsProgramDateTimeExclude = "EXCLUDE"

	// HlsProgramDateTimeInclude is a HlsProgramDateTime enum value
	HlsProgramDateTimeInclude = "INCLUDE"
)

const (
	// HlsSegmentationModeUseInputSegmentation is a HlsSegmentationMode enum value
	HlsSegmentationModeUseInputSegmentation = "USE_INPUT_SEGMENTATION"

	// HlsSegmentationModeUseSegmentDuration is a HlsSegmentationMode enum value
	HlsSegmentationModeUseSegmentDuration = "USE_SEGMENT_DURATION"
)

const (
	// HlsStreamInfResolutionExclude is a HlsStreamInfResolution enum value
	HlsStreamInfResolutionExclude = "EXCLUDE"

	// HlsStreamInfResolutionInclude is a HlsStreamInfResolution enum value
	HlsStreamInfResolutionInclude = "INCLUDE"
)

const (
	// HlsTimedMetadataId3FrameNone is a HlsTimedMetadataId3Frame enum value
	HlsTimedMetadataId3FrameNone = "NONE"

	// HlsTimedMetadataId3FramePriv is a HlsTimedMetadataId3Frame enum value
	HlsTimedMetadataId3FramePriv = "PRIV"

	// HlsTimedMetadataId3FrameTdrl is a HlsTimedMetadataId3Frame enum value
	HlsTimedMetadataId3FrameTdrl = "TDRL"
)

const (
	// HlsTsFileModeSegmentedFiles is a HlsTsFileMode enum value
	HlsTsFileModeSegmentedFiles = "SEGMENTED_FILES"

	// HlsTsFileModeSingleFile is a HlsTsFileMode enum value
	HlsTsFileModeSingleFile = "SINGLE_FILE"
)

const (
	// HlsWebdavHttpTransferModeChunked is a HlsWebdavHttpTransferMode enum value
	HlsWebdavHttpTransferModeChunked = "CHUNKED"

	// HlsWebdavHttpTransferModeNonChunked is a HlsWebdavHttpTransferMode enum value
	HlsWebdavHttpTransferModeNonChunked = "NON_CHUNKED"
)

// codec in increasing order of complexity
const (
	// InputCodecMpeg2 is a InputCodec enum value
	InputCodecMpeg2 = "MPEG2"

	// InputCodecAvc is a InputCodec enum value
	InputCodecAvc = "AVC"

	// InputCodecHevc is a InputCodec enum value
	InputCodecHevc = "HEVC"
)

const (
	// InputDeblockFilterDisabled is a InputDeblockFilter enum value
	InputDeblockFilterDisabled = "DISABLED"

	// InputDeblockFilterEnabled is a InputDeblockFilter enum value
	InputDeblockFilterEnabled = "ENABLED"
)

const (
	// InputDenoiseFilterDisabled is a InputDenoiseFilter enum value
	InputDenoiseFilterDisabled = "DISABLED"

	// InputDenoiseFilterEnabled is a InputDenoiseFilter enum value
	InputDenoiseFilterEnabled = "ENABLED"
)

const (
	// InputFilterAuto is a InputFilter enum value
	InputFilterAuto = "AUTO"

	// InputFilterDisabled is a InputFilter enum value
	InputFilterDisabled = "DISABLED"

	// InputFilterForced is a InputFilter enum value
	InputFilterForced = "FORCED"
)

const (
	// InputLossActionForHlsOutEmitOutput is a InputLossActionForHlsOut enum value
	InputLossActionForHlsOutEmitOutput = "EMIT_OUTPUT"

	// InputLossActionForHlsOutPauseOutput is a InputLossActionForHlsOut enum value
	InputLossActionForHlsOutPauseOutput = "PAUSE_OUTPUT"
)

const (
	// InputLossActionForMsSmoothOutEmitOutput is a InputLossActionForMsSmoothOut enum value
	InputLossActionForMsSmoothOutEmitOutput = "EMIT_OUTPUT"

	// InputLossActionForMsSmoothOutPauseOutput is a InputLossActionForMsSmoothOut enum value
	InputLossActionForMsSmoothOutPauseOutput = "PAUSE_OUTPUT"
)

const (
	// InputLossActionForUdpOutDropProgram is a InputLossActionForUdpOut enum value
	InputLossActionForUdpOutDropProgram = "DROP_PROGRAM"

	// InputLossActionForUdpOutDropTs is a InputLossActionForUdpOut enum value
	InputLossActionForUdpOutDropTs = "DROP_TS"

	// InputLossActionForUdpOutEmitProgram is a InputLossActionForUdpOut enum value
	InputLossActionForUdpOutEmitProgram = "EMIT_PROGRAM"
)

const (
	// InputLossImageTypeColor is a InputLossImageType enum value
	InputLossImageTypeColor = "COLOR"

	// InputLossImageTypeSlate is a InputLossImageType enum value
	InputLossImageTypeSlate = "SLATE"
)

// Maximum input bitrate in megabits per second. Bitrates up to 50 Mbps are
// supported currently.
const (
	// InputMaximumBitrateMax10Mbps is a InputMaximumBitrate enum value
	InputMaximumBitrateMax10Mbps = "MAX_10_MBPS"

	// InputMaximumBitrateMax20Mbps is a InputMaximumBitrate enum value
	InputMaximumBitrateMax20Mbps = "MAX_20_MBPS"

	// InputMaximumBitrateMax50Mbps is a InputMaximumBitrate enum value
	InputMaximumBitrateMax50Mbps = "MAX_50_MBPS"
)

// Input resolution based on lines of vertical resolution in the input; SD is
// less than 720 lines, HD is 720 to 1080 lines, UHD is greater than 1080 lines
const (
	// InputResolutionSd is a InputResolution enum value
	InputResolutionSd = "SD"

	// InputResolutionHd is a InputResolution enum value
	InputResolutionHd = "HD"

	// InputResolutionUhd is a InputResolution enum value
	InputResolutionUhd = "UHD"
)

const (
	// InputSecurityGroupStateIdle is a InputSecurityGroupState enum value
	InputSecurityGroupStateIdle = "IDLE"

	// InputSecurityGroupStateInUse is a InputSecurityGroupState enum value
	InputSecurityGroupStateInUse = "IN_USE"

	// InputSecurityGroupStateUpdating is a InputSecurityGroupState enum value
	InputSecurityGroupStateUpdating = "UPDATING"

	// InputSecurityGroupStateDeleted is a InputSecurityGroupState enum value
	InputSecurityGroupStateDeleted = "DELETED"
)

const (
	// InputSourceEndBehaviorContinue is a InputSourceEndBehavior enum value
	InputSourceEndBehaviorContinue = "CONTINUE"

	// InputSourceEndBehaviorLoop is a InputSourceEndBehavior enum value
	InputSourceEndBehaviorLoop = "LOOP"
)

const (
	// InputStateCreating is a InputState enum value
	InputStateCreating = "CREATING"

	// InputStateDetached is a InputState enum value
	InputStateDetached = "DETACHED"

	// InputStateAttached is a InputState enum value
	InputStateAttached = "ATTACHED"

	// InputStateDeleting is a InputState enum value
	InputStateDeleting = "DELETING"

	// InputStateDeleted is a InputState enum value
	InputStateDeleted = "DELETED"
)

const (
	// InputTypeUdpPush is a InputType enum value
	InputTypeUdpPush = "UDP_PUSH"

	// InputTypeRtpPush is a InputType enum value
	InputTypeRtpPush = "RTP_PUSH"

	// InputTypeRtmpPush is a InputType enum value
	InputTypeRtmpPush = "RTMP_PUSH"

	// InputTypeRtmpPull is a InputType enum value
	InputTypeRtmpPull = "RTMP_PULL"

	// InputTypeUrlPull is a InputType enum value
	InputTypeUrlPull = "URL_PULL"
)

const (
	// M2tsAbsentInputAudioBehaviorDrop is a M2tsAbsentInputAudioBehavior enum value
	M2tsAbsentInputAudioBehaviorDrop = "DROP"

	// M2tsAbsentInputAudioBehaviorEncodeSilence is a M2tsAbsentInputAudioBehavior enum value
	M2tsAbsentInputAudioBehaviorEncodeSilence = "ENCODE_SILENCE"
)

const (
	// M2tsAribDisabled is a M2tsArib enum value
	M2tsAribDisabled = "DISABLED"

	// M2tsAribEnabled is a M2tsArib enum value
	M2tsAribEnabled = "ENABLED"
)

const (
	// M2tsAribCaptionsPidControlAuto is a M2tsAribCaptionsPidControl enum value
	M2tsAribCaptionsPidControlAuto = "AUTO"

	// M2tsAribCaptionsPidControlUseConfigured is a M2tsAribCaptionsPidControl enum value
	M2tsAribCaptionsPidControlUseConfigured = "USE_CONFIGURED"
)

const (
	// M2tsAudioBufferModelAtsc is a M2tsAudioBufferModel enum value
	M2tsAudioBufferModelAtsc = "ATSC"

	// M2tsAudioBufferModelDvb is a M2tsAudioBufferModel enum value
	M2tsAudioBufferModelDvb = "DVB"
)

const (
	// M2tsAudioIntervalVideoAndFixedIntervals is a M2tsAudioInterval enum value
	M2tsAudioIntervalVideoAndFixedIntervals = "VIDEO_AND_FIXED_INTERVALS"

	// M2tsAudioIntervalVideoInterval is a M2tsAudioInterval enum value
	M2tsAudioIntervalVideoInterval = "VIDEO_INTERVAL"
)

const (
	// M2tsAudioStreamTypeAtsc is a M2tsAudioStreamType enum value
	M2tsAudioStreamTypeAtsc = "ATSC"

	// M2tsAudioStreamTypeDvb is a M2tsAudioStreamType enum value
	M2tsAudioStreamTypeDvb = "DVB"
)

const (
	// M2tsBufferModelMultiplex is a M2tsBufferModel enum value
	M2tsBufferModelMultiplex = "MULTIPLEX"

	// M2tsBufferModelNone is a M2tsBufferModel enum value
	M2tsBufferModelNone = "NONE"
)

const (
	// M2tsCcDescriptorDisabled is a M2tsCcDescriptor enum value
	M2tsCcDescriptorDisabled = "DISABLED"

	// M2tsCcDescriptorEnabled is a M2tsCcDescriptor enum value
	M2tsCcDescriptorEnabled = "ENABLED"
)

const (
	// M2tsEbifControlNone is a M2tsEbifControl enum value
	M2tsEbifControlNone = "NONE"

	// M2tsEbifControlPassthrough is a M2tsEbifControl enum value
	M2tsEbifControlPassthrough = "PASSTHROUGH"
)

const (
	// M2tsEbpPlacementVideoAndAudioPids is a M2tsEbpPlacement enum value
	M2tsEbpPlacementVideoAndAudioPids = "VIDEO_AND_AUDIO_PIDS"

	// M2tsEbpPlacementVideoPid is a M2tsEbpPlacement enum value
	M2tsEbpPlacementVideoPid = "VIDEO_PID"
)

const (
	// M2tsEsRateInPesExclude is a M2tsEsRateInPes enum value
	M2tsEsRateInPesExclude = "EXCLUDE"

	// M2tsEsRateInPesInclude is a M2tsEsRateInPes enum value
	M2tsEsRateInPesInclude = "INCLUDE"
)

const (
	// M2tsKlvNone is a M2tsKlv enum value
	M2tsKlvNone = "NONE"

	// M2tsKlvPassthrough is a M2tsKlv enum value
	M2tsKlvPassthrough = "PASSTHROUGH"
)

const (
	// M2tsPcrControlConfiguredPcrPeriod is a M2tsPcrControl enum value
	M2tsPcrControlConfiguredPcrPeriod = "CONFIGURED_PCR_PERIOD"

	// M2tsPcrControlPcrEveryPesPacket is a M2tsPcrControl enum value
	M2tsPcrControlPcrEveryPesPacket = "PCR_EVERY_PES_PACKET"
)

const (
	// M2tsRateModeCbr is a M2tsRateMode enum value
	M2tsRateModeCbr = "CBR"

	// M2tsRateModeVbr is a M2tsRateMode enum value
	M2tsRateModeVbr = "VBR"
)

const (
	// M2tsScte35ControlNone is a M2tsScte35Control enum value
	M2tsScte35ControlNone = "NONE"

	// M2tsScte35ControlPassthrough is a M2tsScte35Control enum value
	M2tsScte35ControlPassthrough = "PASSTHROUGH"
)

const (
	// M2tsSegmentationMarkersEbp is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersEbp = "EBP"

	// M2tsSegmentationMarkersEbpLegacy is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersEbpLegacy = "EBP_LEGACY"

	// M2tsSegmentationMarkersNone is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersNone = "NONE"

	// M2tsSegmentationMarkersPsiSegstart is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersPsiSegstart = "PSI_SEGSTART"

	// M2tsSegmentationMarkersRaiAdapt is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersRaiAdapt = "RAI_ADAPT"

	// M2tsSegmentationMarkersRaiSegstart is a M2tsSegmentationMarkers enum value
	M2tsSegmentationMarkersRaiSegstart = "RAI_SEGSTART"
)

const (
	// M2tsSegmentationStyleMaintainCadence is a M2tsSegmentationStyle enum value
	M2tsSegmentationStyleMaintainCadence = "MAINTAIN_CADENCE"

	// M2tsSegmentationStyleResetCadence is a M2tsSegmentationStyle enum value
	M2tsSegmentationStyleResetCadence = "RESET_CADENCE"
)

const (
	// M2tsTimedMetadataBehaviorNoPassthrough is a M2tsTimedMetadataBehavior enum value
	M2tsTimedMetadataBehaviorNoPassthrough = "NO_PASSTHROUGH"

	// M2tsTimedMetadataBehaviorPassthrough is a M2tsTimedMetadataBehavior enum value
	M2tsTimedMetadataBehaviorPassthrough = "PASSTHROUGH"
)

const (
	// M3u8PcrControlConfiguredPcrPeriod is a M3u8PcrControl enum value
	M3u8PcrControlConfiguredPcrPeriod = "CONFIGURED_PCR_PERIOD"

	// M3u8PcrControlPcrEveryPesPacket is a M3u8PcrControl enum value
	M3u8PcrControlPcrEveryPesPacket = "PCR_EVERY_PES_PACKET"
)

const (
	// M3u8Scte35BehaviorNoPassthrough is a M3u8Scte35Behavior enum value
	M3u8Scte35BehaviorNoPassthrough = "NO_PASSTHROUGH"

	// M3u8Scte35BehaviorPassthrough is a M3u8Scte35Behavior enum value
	M3u8Scte35BehaviorPassthrough = "PASSTHROUGH"
)

const (
	// M3u8TimedMetadataBehaviorNoPassthrough is a M3u8TimedMetadataBehavior enum value
	M3u8TimedMetadataBehaviorNoPassthrough = "NO_PASSTHROUGH"

	// M3u8TimedMetadataBehaviorPassthrough is a M3u8TimedMetadataBehavior enum value
	M3u8TimedMetadataBehaviorPassthrough = "PASSTHROUGH"
)

const (
	// Mp2CodingModeCodingMode10 is a Mp2CodingMode enum value
	Mp2CodingModeCodingMode10 = "CODING_MODE_1_0"

	// Mp2CodingModeCodingMode20 is a Mp2CodingMode enum value
	Mp2CodingModeCodingMode20 = "CODING_MODE_2_0"
)

const (
	// NetworkInputServerValidationCheckCryptographyAndValidateName is a NetworkInputServerValidation enum value
	NetworkInputServerValidationCheckCryptographyAndValidateName = "CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME"

	// NetworkInputServerValidationCheckCryptographyOnly is a NetworkInputServerValidation enum value
	NetworkInputServerValidationCheckCryptographyOnly = "CHECK_CRYPTOGRAPHY_ONLY"
)

const (
	// RtmpCacheFullBehaviorDisconnectImmediately is a RtmpCacheFullBehavior enum value
	RtmpCacheFullBehaviorDisconnectImmediately = "DISCONNECT_IMMEDIATELY"

	// RtmpCacheFullBehaviorWaitForServer is a RtmpCacheFullBehavior enum value
	RtmpCacheFullBehaviorWaitForServer = "WAIT_FOR_SERVER"
)

const (
	// RtmpCaptionDataAll is a RtmpCaptionData enum value
	RtmpCaptionDataAll = "ALL"

	// RtmpCaptionDataField1608 is a RtmpCaptionData enum value
	RtmpCaptionDataField1608 = "FIELD1_608"

	// RtmpCaptionDataField1AndField2608 is a RtmpCaptionData enum value
	RtmpCaptionDataField1AndField2608 = "FIELD1_AND_FIELD2_608"
)

const (
	// RtmpOutputCertificateModeSelfSigned is a RtmpOutputCertificateMode enum value
	RtmpOutputCertificateModeSelfSigned = "SELF_SIGNED"

	// RtmpOutputCertificateModeVerifyAuthenticity is a RtmpOutputCertificateMode enum value
	RtmpOutputCertificateModeVerifyAuthenticity = "VERIFY_AUTHENTICITY"
)

const (
	// Scte20Convert608To708Disabled is a Scte20Convert608To708 enum value
	Scte20Convert608To708Disabled = "DISABLED"

	// Scte20Convert608To708Upconvert is a Scte20Convert608To708 enum value
	Scte20Convert608To708Upconvert = "UPCONVERT"
)

const (
	// Scte35AposNoRegionalBlackoutBehaviorFollow is a Scte35AposNoRegionalBlackoutBehavior enum value
	Scte35AposNoRegionalBlackoutBehaviorFollow = "FOLLOW"

	// Scte35AposNoRegionalBlackoutBehaviorIgnore is a Scte35AposNoRegionalBlackoutBehavior enum value
	Scte35AposNoRegionalBlackoutBehaviorIgnore = "IGNORE"
)

const (
	// Scte35AposWebDeliveryAllowedBehaviorFollow is a Scte35AposWebDeliveryAllowedBehavior enum value
	Scte35AposWebDeliveryAllowedBehaviorFollow = "FOLLOW"

	// Scte35AposWebDeliveryAllowedBehaviorIgnore is a Scte35AposWebDeliveryAllowedBehavior enum value
	Scte35AposWebDeliveryAllowedBehaviorIgnore = "IGNORE"
)

const (
	// Scte35SpliceInsertNoRegionalBlackoutBehaviorFollow is a Scte35SpliceInsertNoRegionalBlackoutBehavior enum value
	Scte35SpliceInsertNoRegionalBlackoutBehaviorFollow = "FOLLOW"

	// Scte35SpliceInsertNoRegionalBlackoutBehaviorIgnore is a Scte35SpliceInsertNoRegionalBlackoutBehavior enum value
	Scte35SpliceInsertNoRegionalBlackoutBehaviorIgnore = "IGNORE"
)

const (
	// Scte35SpliceInsertWebDeliveryAllowedBehaviorFollow is a Scte35SpliceInsertWebDeliveryAllowedBehavior enum value
	Scte35SpliceInsertWebDeliveryAllowedBehaviorFollow = "FOLLOW"

	// Scte35SpliceInsertWebDeliveryAllowedBehaviorIgnore is a Scte35SpliceInsertWebDeliveryAllowedBehavior enum value
	Scte35SpliceInsertWebDeliveryAllowedBehaviorIgnore = "IGNORE"
)

const (
	// SmoothGroupAudioOnlyTimecodeControlPassthrough is a SmoothGroupAudioOnlyTimecodeControl enum value
	SmoothGroupAudioOnlyTimecodeControlPassthrough = "PASSTHROUGH"

	// SmoothGroupAudioOnlyTimecodeControlUseConfiguredClock is a SmoothGroupAudioOnlyTimecodeControl enum value
	SmoothGroupAudioOnlyTimecodeControlUseConfiguredClock = "USE_CONFIGURED_CLOCK"
)

const (
	// SmoothGroupCertificateModeSelfSigned is a SmoothGroupCertificateMode enum value
	SmoothGroupCertificateModeSelfSigned = "SELF_SIGNED"

	// SmoothGroupCertificateModeVerifyAuthenticity is a SmoothGroupCertificateMode enum value
	SmoothGroupCertificateModeVerifyAuthenticity = "VERIFY_AUTHENTICITY"
)

const (
	// SmoothGroupEventIdModeNoEventId is a SmoothGroupEventIdMode enum value
	SmoothGroupEventIdModeNoEventId = "NO_EVENT_ID"

	// SmoothGroupEventIdModeUseConfigured is a SmoothGroupEventIdMode enum value
	SmoothGroupEventIdModeUseConfigured = "USE_CONFIGURED"

	// SmoothGroupEventIdModeUseTimestamp is a SmoothGroupEventIdMode enum value
	SmoothGroupEventIdModeUseTimestamp = "USE_TIMESTAMP"
)

const (
	// SmoothGroupEventStopBehaviorNone is a SmoothGroupEventStopBehavior enum value
	SmoothGroupEventStopBehaviorNone = "NONE"

	// SmoothGroupEventStopBehaviorSendEos is a SmoothGroupEventStopBehavior enum value
	SmoothGroupEventStopBehaviorSendEos = "SEND_EOS"
)

const (
	// SmoothGroupSegmentationModeUseInputSegmentation is a SmoothGroupSegmentationMode enum value
	SmoothGroupSegmentationModeUseInputSegmentation = "USE_INPUT_SEGMENTATION"

	// SmoothGroupSegmentationModeUseSegmentDuration is a SmoothGroupSegmentationMode enum value
	SmoothGroupSegmentationModeUseSegmentDuration = "USE_SEGMENT_DURATION"
)

const (
	// SmoothGroupSparseTrackTypeNone is a SmoothGroupSparseTrackType enum value
	SmoothGroupSparseTrackTypeNone = "NONE"

	// SmoothGroupSparseTrackTypeScte35 is a SmoothGroupSparseTrackType enum value
	SmoothGroupSparseTrackTypeScte35 = "SCTE_35"
)

const (
	// SmoothGroupStreamManifestBehaviorDoNotSend is a SmoothGroupStreamManifestBehavior enum value
	SmoothGroupStreamManifestBehaviorDoNotSend = "DO_NOT_SEND"

	// SmoothGroupStreamManifestBehaviorSend is a SmoothGroupStreamManifestBehavior enum value
	SmoothGroupStreamManifestBehaviorSend = "SEND"
)

const (
	// SmoothGroupTimestampOffsetModeUseConfiguredOffset is a SmoothGroupTimestampOffsetMode enum value
	SmoothGroupTimestampOffsetModeUseConfiguredOffset = "USE_CONFIGURED_OFFSET"

	// SmoothGroupTimestampOffsetModeUseEventStartDate is a SmoothGroupTimestampOffsetMode enum value
	SmoothGroupTimestampOffsetModeUseEventStartDate = "USE_EVENT_START_DATE"
)

const (
	// TimecodeConfigSourceEmbedded is a TimecodeConfigSource enum value
	TimecodeConfigSourceEmbedded = "EMBEDDED"

	// TimecodeConfigSourceSystemclock is a TimecodeConfigSource enum value
	TimecodeConfigSourceSystemclock = "SYSTEMCLOCK"

	// TimecodeConfigSourceZerobased is a TimecodeConfigSource enum value
	TimecodeConfigSourceZerobased = "ZEROBASED"
)

const (
	// TtmlDestinationStyleControlPassthrough is a TtmlDestinationStyleControl enum value
	TtmlDestinationStyleControlPassthrough = "PASSTHROUGH"

	// TtmlDestinationStyleControlUseConfigured is a TtmlDestinationStyleControl enum value
	TtmlDestinationStyleControlUseConfigured = "USE_CONFIGURED"
)

const (
	// UdpTimedMetadataId3FrameNone is a UdpTimedMetadataId3Frame enum value
	UdpTimedMetadataId3FrameNone = "NONE"

	// UdpTimedMetadataId3FramePriv is a UdpTimedMetadataId3Frame enum value
	UdpTimedMetadataId3FramePriv = "PRIV"

	// UdpTimedMetadataId3FrameTdrl is a UdpTimedMetadataId3Frame enum value
	UdpTimedMetadataId3FrameTdrl = "TDRL"
)

const (
	// VideoDescriptionRespondToAfdNone is a VideoDescriptionRespondToAfd enum value
	VideoDescriptionRespondToAfdNone = "NONE"

	// VideoDescriptionRespondToAfdPassthrough is a VideoDescriptionRespondToAfd enum value
	VideoDescriptionRespondToAfdPassthrough = "PASSTHROUGH"

	// VideoDescriptionRespondToAfdRespond is a VideoDescriptionRespondToAfd enum value
	VideoDescriptionRespondToAfdRespond = "RESPOND"
)

const (
	// VideoDescriptionScalingBehaviorDefault is a VideoDescriptionScalingBehavior enum value
	VideoDescriptionScalingBehaviorDefault = "DEFAULT"

	// VideoDescriptionScalingBehaviorStretchToOutput is a VideoDescriptionScalingBehavior enum value
	VideoDescriptionScalingBehaviorStretchToOutput = "STRETCH_TO_OUTPUT"
)

const (
	// VideoSelectorColorSpaceFollow is a VideoSelectorColorSpace enum value
	VideoSelectorColorSpaceFollow = "FOLLOW"

	// VideoSelectorColorSpaceRec601 is a VideoSelectorColorSpace enum value
	VideoSelectorColorSpaceRec601 = "REC_601"

	// VideoSelectorColorSpaceRec709 is a VideoSelectorColorSpace enum value
	VideoSelectorColorSpaceRec709 = "REC_709"
)

const (
	// VideoSelectorColorSpaceUsageFallback is a VideoSelectorColorSpaceUsage enum value
	VideoSelectorColorSpaceUsageFallback = "FALLBACK"

	// VideoSelectorColorSpaceUsageForce is a VideoSelectorColorSpaceUsage enum value
	VideoSelectorColorSpaceUsageForce = "FORCE"
)
