// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StartDeviceSyncInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device to sync. Required.
	DeviceArn *string `type:"string"`

	// Request structure to start the device sync. Required.
	//
	// Features is a required field
	Features []Feature `type:"list" required:"true"`

	// The ARN of the room with which the device to sync is associated. Required.
	RoomArn *string `type:"string"`
}

// String returns the string representation
func (s StartDeviceSyncInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDeviceSyncInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartDeviceSyncInput"}

	if s.Features == nil {
		invalidParams.Add(aws.NewErrParamRequired("Features"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StartDeviceSyncOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartDeviceSyncOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartDeviceSync = "StartDeviceSync"

// StartDeviceSyncRequest returns a request value for making API operation for
// Alexa For Business.
//
// Resets a device and its account to the known default settings. This clears
// all information and settings set by previous users in the following ways:
//
//    * Bluetooth - This unpairs all bluetooth devices paired with your echo
//    device.
//
//    * Volume - This resets the echo device's volume to the default value.
//
//    * Notifications - This clears all notifications from your echo device.
//
//    * Lists - This clears all to-do items from your echo device.
//
//    * Settings - This internally syncs the room's profile (if the device is
//    assigned to a room), contacts, address books, delegation access for account
//    linking, and communications (if enabled on the room profile).
//
//    // Example sending a request using StartDeviceSyncRequest.
//    req := client.StartDeviceSyncRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync
func (c *Client) StartDeviceSyncRequest(input *StartDeviceSyncInput) StartDeviceSyncRequest {
	op := &aws.Operation{
		Name:       opStartDeviceSync,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDeviceSyncInput{}
	}

	req := c.newRequest(op, input, &StartDeviceSyncOutput{})
	return StartDeviceSyncRequest{Request: req, Input: input, Copy: c.StartDeviceSyncRequest}
}

// StartDeviceSyncRequest is the request type for the
// StartDeviceSync API operation.
type StartDeviceSyncRequest struct {
	*aws.Request
	Input *StartDeviceSyncInput
	Copy  func(*StartDeviceSyncInput) StartDeviceSyncRequest
}

// Send marshals and sends the StartDeviceSync API request.
func (r StartDeviceSyncRequest) Send(ctx context.Context) (*StartDeviceSyncResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartDeviceSyncResponse{
		StartDeviceSyncOutput: r.Request.Data.(*StartDeviceSyncOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartDeviceSyncResponse is the response type for the
// StartDeviceSync API operation.
type StartDeviceSyncResponse struct {
	*StartDeviceSyncOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartDeviceSync request.
func (r *StartDeviceSyncResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
