// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateDeviceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the device to update. Required.
	DeviceArn *string `type:"string"`

	// The updated device name. Required.
	DeviceName *string `min:"2" type:"string"`
}

// String returns the string representation
func (s UpdateDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDeviceInput"}
	if s.DeviceName != nil && len(*s.DeviceName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("DeviceName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDevice = "UpdateDevice"

// UpdateDeviceRequest returns a request value for making API operation for
// Alexa For Business.
//
// Updates the device name by device ARN.
//
//    // Example sending a request using UpdateDeviceRequest.
//    req := client.UpdateDeviceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice
func (c *Client) UpdateDeviceRequest(input *UpdateDeviceInput) UpdateDeviceRequest {
	op := &aws.Operation{
		Name:       opUpdateDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeviceInput{}
	}

	req := c.newRequest(op, input, &UpdateDeviceOutput{})
	return UpdateDeviceRequest{Request: req, Input: input, Copy: c.UpdateDeviceRequest}
}

// UpdateDeviceRequest is the request type for the
// UpdateDevice API operation.
type UpdateDeviceRequest struct {
	*aws.Request
	Input *UpdateDeviceInput
	Copy  func(*UpdateDeviceInput) UpdateDeviceRequest
}

// Send marshals and sends the UpdateDevice API request.
func (r UpdateDeviceRequest) Send(ctx context.Context) (*UpdateDeviceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDeviceResponse{
		UpdateDeviceOutput: r.Request.Data.(*UpdateDeviceOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDeviceResponse is the response type for the
// UpdateDevice API operation.
type UpdateDeviceResponse struct {
	*UpdateDeviceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDevice request.
func (r *UpdateDeviceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
