// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteDeploymentStrategyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment strategy you want to delete.
	//
	// DeploymentStrategyId is a required field
	DeploymentStrategyId *string `location:"uri" locationName:"DeploymentStrategyId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeploymentStrategyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeploymentStrategyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDeploymentStrategyInput"}

	if s.DeploymentStrategyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeploymentStrategyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDeploymentStrategyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeploymentStrategyId != nil {
		v := *s.DeploymentStrategyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DeploymentStrategyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteDeploymentStrategyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeploymentStrategyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDeploymentStrategyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteDeploymentStrategy = "DeleteDeploymentStrategy"

// DeleteDeploymentStrategyRequest returns a request value for making API operation for
// Amazon AppConfig.
//
// Delete a deployment strategy. Deleting a deployment strategy does not delete
// a configuration from a host.
//
//    // Example sending a request using DeleteDeploymentStrategyRequest.
//    req := client.DeleteDeploymentStrategyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteDeploymentStrategy
func (c *Client) DeleteDeploymentStrategyRequest(input *DeleteDeploymentStrategyInput) DeleteDeploymentStrategyRequest {
	op := &aws.Operation{
		Name:       opDeleteDeploymentStrategy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/deployementstrategies/{DeploymentStrategyId}",
	}

	if input == nil {
		input = &DeleteDeploymentStrategyInput{}
	}

	req := c.newRequest(op, input, &DeleteDeploymentStrategyOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteDeploymentStrategyRequest{Request: req, Input: input, Copy: c.DeleteDeploymentStrategyRequest}
}

// DeleteDeploymentStrategyRequest is the request type for the
// DeleteDeploymentStrategy API operation.
type DeleteDeploymentStrategyRequest struct {
	*aws.Request
	Input *DeleteDeploymentStrategyInput
	Copy  func(*DeleteDeploymentStrategyInput) DeleteDeploymentStrategyRequest
}

// Send marshals and sends the DeleteDeploymentStrategy API request.
func (r DeleteDeploymentStrategyRequest) Send(ctx context.Context) (*DeleteDeploymentStrategyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDeploymentStrategyResponse{
		DeleteDeploymentStrategyOutput: r.Request.Data.(*DeleteDeploymentStrategyOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDeploymentStrategyResponse is the response type for the
// DeleteDeploymentStrategy API operation.
type DeleteDeploymentStrategyResponse struct {
	*DeleteDeploymentStrategyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDeploymentStrategy request.
func (r *DeleteDeploymentStrategyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
