// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeUsageReportSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeUsageReportSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUsageReportSubscriptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeUsageReportSubscriptionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeUsageReportSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// Information about the usage report subscription.
	UsageReportSubscriptions []UsageReportSubscription `type:"list"`
}

// String returns the string representation
func (s DescribeUsageReportSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeUsageReportSubscriptions = "DescribeUsageReportSubscriptions"

// DescribeUsageReportSubscriptionsRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Retrieves a list that describes one or more usage report subscriptions.
//
//    // Example sending a request using DescribeUsageReportSubscriptionsRequest.
//    req := client.DescribeUsageReportSubscriptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsageReportSubscriptions
func (c *Client) DescribeUsageReportSubscriptionsRequest(input *DescribeUsageReportSubscriptionsInput) DescribeUsageReportSubscriptionsRequest {
	op := &aws.Operation{
		Name:       opDescribeUsageReportSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUsageReportSubscriptionsInput{}
	}

	req := c.newRequest(op, input, &DescribeUsageReportSubscriptionsOutput{})
	return DescribeUsageReportSubscriptionsRequest{Request: req, Input: input, Copy: c.DescribeUsageReportSubscriptionsRequest}
}

// DescribeUsageReportSubscriptionsRequest is the request type for the
// DescribeUsageReportSubscriptions API operation.
type DescribeUsageReportSubscriptionsRequest struct {
	*aws.Request
	Input *DescribeUsageReportSubscriptionsInput
	Copy  func(*DescribeUsageReportSubscriptionsInput) DescribeUsageReportSubscriptionsRequest
}

// Send marshals and sends the DescribeUsageReportSubscriptions API request.
func (r DescribeUsageReportSubscriptionsRequest) Send(ctx context.Context) (*DescribeUsageReportSubscriptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeUsageReportSubscriptionsResponse{
		DescribeUsageReportSubscriptionsOutput: r.Request.Data.(*DescribeUsageReportSubscriptionsOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeUsageReportSubscriptionsResponse is the response type for the
// DescribeUsageReportSubscriptions API operation.
type DescribeUsageReportSubscriptionsResponse struct {
	*DescribeUsageReportSubscriptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeUsageReportSubscriptions request.
func (r *DescribeUsageReportSubscriptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
