// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetIntrospectionSchemaInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The schema format: SDL or JSON.
	//
	// Format is a required field
	Format OutputType `location:"querystring" locationName:"format" type:"string" required:"true" enum:"true"`

	// A flag that specifies whether the schema introspection should contain directives.
	IncludeDirectives *bool `location:"querystring" locationName:"includeDirectives" type:"boolean"`
}

// String returns the string representation
func (s GetIntrospectionSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntrospectionSchemaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetIntrospectionSchemaInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetIntrospectionSchemaInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.IncludeDirectives != nil {
		v := *s.IncludeDirectives

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "includeDirectives", protocol.BoolValue(v), metadata)
	}
	return nil
}

type GetIntrospectionSchemaOutput struct {
	_ struct{} `type:"structure" payload:"Schema"`

	// The schema, in GraphQL Schema Definition Language (SDL) format.
	//
	// For more information, see the GraphQL SDL documentation (http://graphql.org/learn/schema/).
	Schema []byte `locationName:"schema" type:"blob"`
}

// String returns the string representation
func (s GetIntrospectionSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetIntrospectionSchemaOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Schema != nil {
		v := s.Schema

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "schema", protocol.BytesStream(v), metadata)
	}
	return nil
}

const opGetIntrospectionSchema = "GetIntrospectionSchema"

// GetIntrospectionSchemaRequest returns a request value for making API operation for
// AWS AppSync.
//
// Retrieves the introspection schema for a GraphQL API.
//
//    // Example sending a request using GetIntrospectionSchemaRequest.
//    req := client.GetIntrospectionSchemaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetIntrospectionSchema
func (c *Client) GetIntrospectionSchemaRequest(input *GetIntrospectionSchemaInput) GetIntrospectionSchemaRequest {
	op := &aws.Operation{
		Name:       opGetIntrospectionSchema,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/schema",
	}

	if input == nil {
		input = &GetIntrospectionSchemaInput{}
	}

	req := c.newRequest(op, input, &GetIntrospectionSchemaOutput{})
	return GetIntrospectionSchemaRequest{Request: req, Input: input, Copy: c.GetIntrospectionSchemaRequest}
}

// GetIntrospectionSchemaRequest is the request type for the
// GetIntrospectionSchema API operation.
type GetIntrospectionSchemaRequest struct {
	*aws.Request
	Input *GetIntrospectionSchemaInput
	Copy  func(*GetIntrospectionSchemaInput) GetIntrospectionSchemaRequest
}

// Send marshals and sends the GetIntrospectionSchema API request.
func (r GetIntrospectionSchemaRequest) Send(ctx context.Context) (*GetIntrospectionSchemaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetIntrospectionSchemaResponse{
		GetIntrospectionSchemaOutput: r.Request.Data.(*GetIntrospectionSchemaOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetIntrospectionSchemaResponse is the response type for the
// GetIntrospectionSchema API operation.
type GetIntrospectionSchemaResponse struct {
	*GetIntrospectionSchemaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetIntrospectionSchema request.
func (r *GetIntrospectionSchemaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
