// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeNotificationConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupNames []string `type:"list"`

	// The maximum number of items to return with this call. The default value is
	// 50 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeNotificationConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeNotificationConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`

	// The notification configurations.
	//
	// NotificationConfigurations is a required field
	NotificationConfigurations []NotificationConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeNotificationConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeNotificationConfigurations = "DescribeNotificationConfigurations"

// DescribeNotificationConfigurationsRequest returns a request value for making API operation for
// Auto Scaling.
//
// Describes the notification actions associated with the specified Auto Scaling
// group.
//
//    // Example sending a request using DescribeNotificationConfigurationsRequest.
//    req := client.DescribeNotificationConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations
func (c *Client) DescribeNotificationConfigurationsRequest(input *DescribeNotificationConfigurationsInput) DescribeNotificationConfigurationsRequest {
	op := &aws.Operation{
		Name:       opDescribeNotificationConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNotificationConfigurationsInput{}
	}

	req := c.newRequest(op, input, &DescribeNotificationConfigurationsOutput{})
	return DescribeNotificationConfigurationsRequest{Request: req, Input: input, Copy: c.DescribeNotificationConfigurationsRequest}
}

// DescribeNotificationConfigurationsRequest is the request type for the
// DescribeNotificationConfigurations API operation.
type DescribeNotificationConfigurationsRequest struct {
	*aws.Request
	Input *DescribeNotificationConfigurationsInput
	Copy  func(*DescribeNotificationConfigurationsInput) DescribeNotificationConfigurationsRequest
}

// Send marshals and sends the DescribeNotificationConfigurations API request.
func (r DescribeNotificationConfigurationsRequest) Send(ctx context.Context) (*DescribeNotificationConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeNotificationConfigurationsResponse{
		DescribeNotificationConfigurationsOutput: r.Request.Data.(*DescribeNotificationConfigurationsOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeNotificationConfigurationsRequestPaginator returns a paginator for DescribeNotificationConfigurations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeNotificationConfigurationsRequest(input)
//   p := autoscaling.NewDescribeNotificationConfigurationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeNotificationConfigurationsPaginator(req DescribeNotificationConfigurationsRequest) DescribeNotificationConfigurationsPaginator {
	return DescribeNotificationConfigurationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeNotificationConfigurationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeNotificationConfigurationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeNotificationConfigurationsPaginator struct {
	aws.Pager
}

func (p *DescribeNotificationConfigurationsPaginator) CurrentPage() *DescribeNotificationConfigurationsOutput {
	return p.Pager.CurrentPage().(*DescribeNotificationConfigurationsOutput)
}

// DescribeNotificationConfigurationsResponse is the response type for the
// DescribeNotificationConfigurations API operation.
type DescribeNotificationConfigurationsResponse struct {
	*DescribeNotificationConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeNotificationConfigurations request.
func (r *DescribeNotificationConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
