// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloud9

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateEnvironmentMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment that contains the environment member you want to
	// add.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The type of environment member permissions you want to associate with this
	// environment member. Available values include:
	//
	//    * read-only: Has read-only access to the environment.
	//
	//    * read-write: Has read-write access to the environment.
	//
	// Permissions is a required field
	Permissions MemberPermissions `locationName:"permissions" type:"string" required:"true" enum:"true"`

	// The Amazon Resource Name (ARN) of the environment member you want to add.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEnvironmentMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentMembershipInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEnvironmentMembershipInput"}

	if s.EnvironmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EnvironmentId"))
	}
	if len(s.Permissions) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Permissions"))
	}

	if s.UserArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateEnvironmentMembershipOutput struct {
	_ struct{} `type:"structure"`

	// Information about the environment member that was added.
	Membership *EnvironmentMember `locationName:"membership" type:"structure"`
}

// String returns the string representation
func (s CreateEnvironmentMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateEnvironmentMembership = "CreateEnvironmentMembership"

// CreateEnvironmentMembershipRequest returns a request value for making API operation for
// AWS Cloud9.
//
// Adds an environment member to an AWS Cloud9 development environment.
//
//    // Example sending a request using CreateEnvironmentMembershipRequest.
//    req := client.CreateEnvironmentMembershipRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/CreateEnvironmentMembership
func (c *Client) CreateEnvironmentMembershipRequest(input *CreateEnvironmentMembershipInput) CreateEnvironmentMembershipRequest {
	op := &aws.Operation{
		Name:       opCreateEnvironmentMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEnvironmentMembershipInput{}
	}

	req := c.newRequest(op, input, &CreateEnvironmentMembershipOutput{})
	return CreateEnvironmentMembershipRequest{Request: req, Input: input, Copy: c.CreateEnvironmentMembershipRequest}
}

// CreateEnvironmentMembershipRequest is the request type for the
// CreateEnvironmentMembership API operation.
type CreateEnvironmentMembershipRequest struct {
	*aws.Request
	Input *CreateEnvironmentMembershipInput
	Copy  func(*CreateEnvironmentMembershipInput) CreateEnvironmentMembershipRequest
}

// Send marshals and sends the CreateEnvironmentMembership API request.
func (r CreateEnvironmentMembershipRequest) Send(ctx context.Context) (*CreateEnvironmentMembershipResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateEnvironmentMembershipResponse{
		CreateEnvironmentMembershipOutput: r.Request.Data.(*CreateEnvironmentMembershipOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateEnvironmentMembershipResponse is the response type for the
// CreateEnvironmentMembership API operation.
type CreateEnvironmentMembershipResponse struct {
	*CreateEnvironmentMembershipOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateEnvironmentMembership request.
func (r *CreateEnvironmentMembershipResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
