// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListLunaClientsInput struct {
	_ struct{} `type:"structure"`

	// The NextToken value from a previous call to ListLunaClients. Pass null if
	// this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLunaClientsInput) String() string {
	return awsutil.Prettify(s)
}

type ListLunaClientsOutput struct {
	_ struct{} `type:"structure"`

	// The list of clients.
	//
	// ClientList is a required field
	ClientList []string `type:"list" required:"true"`

	// If not null, more results are available. Pass this to ListLunaClients to
	// retrieve the next set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLunaClientsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListLunaClients = "ListLunaClients"

// ListLunaClientsRequest returns a request value for making API operation for
// Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Lists all of the clients.
//
// This operation supports pagination with the use of the NextToken member.
// If more results are available, the NextToken member of the response contains
// a token that you pass in the next call to ListLunaClients to retrieve the
// next set of items.
//
//    // Example sending a request using ListLunaClientsRequest.
//    req := client.ListLunaClientsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListLunaClients
func (c *Client) ListLunaClientsRequest(input *ListLunaClientsInput) ListLunaClientsRequest {
	op := &aws.Operation{
		Name:       opListLunaClients,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLunaClientsInput{}
	}

	req := c.newRequest(op, input, &ListLunaClientsOutput{})
	return ListLunaClientsRequest{Request: req, Input: input, Copy: c.ListLunaClientsRequest}
}

// ListLunaClientsRequest is the request type for the
// ListLunaClients API operation.
type ListLunaClientsRequest struct {
	*aws.Request
	Input *ListLunaClientsInput
	Copy  func(*ListLunaClientsInput) ListLunaClientsRequest
}

// Send marshals and sends the ListLunaClients API request.
func (r ListLunaClientsRequest) Send(ctx context.Context) (*ListLunaClientsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLunaClientsResponse{
		ListLunaClientsOutput: r.Request.Data.(*ListLunaClientsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListLunaClientsResponse is the response type for the
// ListLunaClients API operation.
type ListLunaClientsResponse struct {
	*ListLunaClientsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLunaClients request.
func (r *ListLunaClientsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
