// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteDocumentClassifierInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	//
	// DocumentClassifierArn is a required field
	DocumentClassifierArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDocumentClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDocumentClassifierInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDocumentClassifierInput"}

	if s.DocumentClassifierArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentClassifierArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteDocumentClassifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDocumentClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDocumentClassifier = "DeleteDocumentClassifier"

// DeleteDocumentClassifierRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Deletes a previously created document classifier
//
// Only those classifiers that are in terminated states (IN_ERROR, TRAINED)
// will be deleted. If an active inference job is using the model, a ResourceInUseException
// will be returned.
//
// This is an asynchronous action that puts the classifier into a DELETING state,
// and it is then removed by a background job. Once removed, the classifier
// disappears from your account and is no longer available for use.
//
//    // Example sending a request using DeleteDocumentClassifierRequest.
//    req := client.DeleteDocumentClassifierRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier
func (c *Client) DeleteDocumentClassifierRequest(input *DeleteDocumentClassifierInput) DeleteDocumentClassifierRequest {
	op := &aws.Operation{
		Name:       opDeleteDocumentClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDocumentClassifierInput{}
	}

	req := c.newRequest(op, input, &DeleteDocumentClassifierOutput{})
	return DeleteDocumentClassifierRequest{Request: req, Input: input, Copy: c.DeleteDocumentClassifierRequest}
}

// DeleteDocumentClassifierRequest is the request type for the
// DeleteDocumentClassifier API operation.
type DeleteDocumentClassifierRequest struct {
	*aws.Request
	Input *DeleteDocumentClassifierInput
	Copy  func(*DeleteDocumentClassifierInput) DeleteDocumentClassifierRequest
}

// Send marshals and sends the DeleteDocumentClassifier API request.
func (r DeleteDocumentClassifierRequest) Send(ctx context.Context) (*DeleteDocumentClassifierResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDocumentClassifierResponse{
		DeleteDocumentClassifierOutput: r.Request.Data.(*DeleteDocumentClassifierOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDocumentClassifierResponse is the response type for the
// DeleteDocumentClassifier API operation.
type DeleteDocumentClassifierResponse struct {
	*DeleteDocumentClassifierOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDocumentClassifier request.
func (r *DeleteDocumentClassifierResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
