// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// An extracted segment of the text that is an attribute of an entity, or otherwise
// related to an entity, such as the dosage of a medication taken. It contains
// information about the attribute such as id, begin and end offset within the
// input text, and the segment of the input text.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The 0-based character offset in the input text that shows where the attribute
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The 0-based character offset in the input text that shows where the attribute
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for this attribute. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend Medical has that this attribute
	// is correctly related to this entity.
	RelationshipScore *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend Medical has that the segment
	// of text is correctly recognized as an attribute.
	Score *float64 `type:"float"`

	// The segment of input text extracted as this attribute.
	Text *string `min:"1" type:"string"`

	// Contextual information for this attribute.
	Traits []Trait `type:"list"`

	// The type of attribute.
	Type EntitySubType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// Provides information for filtering a list of detection jobs.
type ComprehendMedicalAsyncJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus JobStatus `type:"string" enum:"true"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ComprehendMedicalAsyncJobFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComprehendMedicalAsyncJobFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ComprehendMedicalAsyncJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about a detection job.
type ComprehendMedicalAsyncJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend Medical read
	// access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The date and time that job metadata is deleted from the server. Output files
	// in your S3 bucket will not be deleted. After the metadata is deleted, the
	// job will no longer appear in the results of the ListEntitiesDetectionV2Job
	// or the ListPHIDetectionJobs operation.
	ExpirationTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the detection
	// job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the detection job. If the status is FAILED, the Message
	// field shows the reason for the failure.
	JobStatus JobStatus `type:"string" enum:"true"`

	// The AWS Key Management Service key, if any, used to encrypt the output files.
	KMSKey *string `min:"1" type:"string"`

	// The language code of the input documents.
	LanguageCode LanguageCode `type:"string" enum:"true"`

	// The path to the file that describes the results of a batch job.
	ManifestFilePath *string `min:"1" type:"string"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The version of the model used to analyze the documents. The version number
	// looks like X.X.X. You can use this information to track the model used for
	// a particular batch of documents.
	ModelVersion *string `type:"string"`

	// The output data configuration that you supplied when you created the detection
	// job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ComprehendMedicalAsyncJobProperties) String() string {
	return awsutil.Prettify(s)
}

// Provides information about an extracted medical entity.
type Entity struct {
	_ struct{} `type:"structure"`

	// The extracted attributes that relate to this entity.
	Attributes []Attribute `type:"list"`

	// The 0-based character offset in the input text that shows where the entity
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The category of the entity.
	Category EntityType `type:"string" enum:"true"`

	// The 0-based character offset in the input text that shows where the entity
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for the entity. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend Medical has in the accuracy
	// of the detection.
	Score *float64 `type:"float"`

	// The segment of input text extracted as this entity.
	Text *string `min:"1" type:"string"`

	// Contextual information for the entity
	Traits []Trait `type:"list"`

	// Describes the specific type of entity with category of entities.
	Type EntitySubType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// The input properties for an entities detection job
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The URI of the S3 bucket that contains the input data. The bucket must be
	// in the same region as the API endpoint that you are calling.
	//
	// Each file in the document collection must be less than 40 KB. You can store
	// a maximum of 30 GB in the bucket.
	//
	// S3Bucket is a required field
	S3Bucket *string `min:"3" type:"string" required:"true"`

	// The path to the input data files in the S3 bucket.
	S3Key *string `type:"string"`
}

// String returns the string representation
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputDataConfig"}

	if s.S3Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output properties for a detection job.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// When you use the OutputDataConfig object with asynchronous operations, you
	// specify the Amazon S3 location where you want to write the output data. The
	// URI must be in the same region as the API endpoint that you are calling.
	// The location is used as the prefix for the actual location of the output.
	//
	// S3Bucket is a required field
	S3Bucket *string `min:"3" type:"string" required:"true"`

	// The path to the output data files in the S3 bucket. Amazon Comprehend Medical
	// creates an output directory using the job ID so that the output from one
	// job does not overwrite the output of another.
	S3Key *string `type:"string"`
}

// String returns the string representation
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputDataConfig"}

	if s.S3Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides contextual information about the extracted entity.
type Trait struct {
	_ struct{} `type:"structure"`

	// Provides a name or contextual description about the trait.
	Name AttributeName `type:"string" enum:"true"`

	// The level of confidence that Amazon Comprehend Medical has in the accuracy
	// of this trait.
	Score *float64 `type:"float"`
}

// String returns the string representation
func (s Trait) String() string {
	return awsutil.Prettify(s)
}

// An attribute that we extracted, but were unable to relate to an entity.
type UnmappedAttribute struct {
	_ struct{} `type:"structure"`

	// The specific attribute that has been extracted but not mapped to an entity.
	Attribute *Attribute `type:"structure"`

	// The type of the attribute, could be one of the following values: "MEDICATION",
	// "MEDICAL_CONDITION", "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE" or "PROTECTED_HEALTH_INFORMATION".
	Type EntityType `type:"string" enum:"true"`
}

// String returns the string representation
func (s UnmappedAttribute) String() string {
	return awsutil.Prettify(s)
}
