// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteConnectionInput"}

	if s.EndpointArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointArn"))
	}

	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The connection that is being deleted.
	Connection *Connection `type:"structure"`
}

// String returns the string representation
func (s DeleteConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Deletes the connection between a replication instance and an endpoint.
//
//    // Example sending a request using DeleteConnectionRequest.
//    req := client.DeleteConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection
func (c *Client) DeleteConnectionRequest(input *DeleteConnectionInput) DeleteConnectionRequest {
	op := &aws.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	req := c.newRequest(op, input, &DeleteConnectionOutput{})
	return DeleteConnectionRequest{Request: req, Input: input, Copy: c.DeleteConnectionRequest}
}

// DeleteConnectionRequest is the request type for the
// DeleteConnection API operation.
type DeleteConnectionRequest struct {
	*aws.Request
	Input *DeleteConnectionInput
	Copy  func(*DeleteConnectionInput) DeleteConnectionRequest
}

// Send marshals and sends the DeleteConnection API request.
func (r DeleteConnectionRequest) Send(ctx context.Context) (*DeleteConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteConnectionResponse{
		DeleteConnectionOutput: r.Request.Data.(*DeleteConnectionOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteConnectionResponse is the response type for the
// DeleteConnection API operation.
type DeleteConnectionResponse struct {
	*DeleteConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteConnection request.
func (r *DeleteConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
