// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datapipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Contains the parameters for SetStatus.
type SetStatusInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the objects. The corresponding objects can be either physical
	// or components, but not a mix of both types.
	//
	// ObjectIds is a required field
	ObjectIds []string `locationName:"objectIds" type:"list" required:"true"`

	// The ID of the pipeline that contains the objects.
	//
	// PipelineId is a required field
	PipelineId *string `locationName:"pipelineId" min:"1" type:"string" required:"true"`

	// The status to be set on all the objects specified in objectIds. For components,
	// use PAUSE or RESUME. For instances, use TRY_CANCEL, RERUN, or MARK_FINISHED.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true"`
}

// String returns the string representation
func (s SetStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetStatusInput"}

	if s.ObjectIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("ObjectIds"))
	}

	if s.PipelineId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineId"))
	}
	if s.PipelineId != nil && len(*s.PipelineId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineId", 1))
	}

	if s.Status == nil {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetStatus = "SetStatus"

// SetStatusRequest returns a request value for making API operation for
// AWS Data Pipeline.
//
// Requests that the status of the specified physical or logical pipeline objects
// be updated in the specified pipeline. This update might not occur immediately,
// but is eventually consistent. The status that can be set depends on the type
// of object (for example, DataNode or Activity). You cannot perform this operation
// on FINISHED pipelines and attempting to do so returns InvalidRequestException.
//
//    // Example sending a request using SetStatusRequest.
//    req := client.SetStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/SetStatus
func (c *Client) SetStatusRequest(input *SetStatusInput) SetStatusRequest {
	op := &aws.Operation{
		Name:       opSetStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetStatusInput{}
	}

	req := c.newRequest(op, input, &SetStatusOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return SetStatusRequest{Request: req, Input: input, Copy: c.SetStatusRequest}
}

// SetStatusRequest is the request type for the
// SetStatus API operation.
type SetStatusRequest struct {
	*aws.Request
	Input *SetStatusInput
	Copy  func(*SetStatusInput) SetStatusRequest
}

// Send marshals and sends the SetStatus API request.
func (r SetStatusRequest) Send(ctx context.Context) (*SetStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetStatusResponse{
		SetStatusOutput: r.Request.Data.(*SetStatusOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetStatusResponse is the response type for the
// SetStatus API operation.
type SetStatusResponse struct {
	*SetStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetStatus request.
func (r *SetStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
