// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetPasswordDataInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the Windows instance.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetPasswordDataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPasswordDataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPasswordDataInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetPasswordDataOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Windows instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The password of the instance. Returns an empty string if the password is
	// not available.
	PasswordData *string `locationName:"passwordData" type:"string"`

	// The time the data was last updated.
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp"`
}

// String returns the string representation
func (s GetPasswordDataOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetPasswordData = "GetPasswordData"

// GetPasswordDataRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Retrieves the encrypted administrator password for a running Windows instance.
//
// The Windows password is generated at boot by the EC2Config service or EC2Launch
// scripts (Windows Server 2016 and later). This usually only happens the first
// time an instance is launched. For more information, see EC2Config (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/UsingConfig_WinAMI.html)
// and EC2Launch (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2launch.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// For the EC2Config service, the password is not generated for rebundled AMIs
// unless Ec2SetPassword is enabled before bundling.
//
// The password is encrypted using the key pair that you specified when you
// launched the instance. You must provide the corresponding key pair file.
//
// When you launch an instance, password generation and encryption may take
// a few minutes. If you try to retrieve the password before it's available,
// the output returns an empty string. We recommend that you wait up to 15 minutes
// after launching an instance before trying to retrieve the generated password.
//
//    // Example sending a request using GetPasswordDataRequest.
//    req := client.GetPasswordDataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/GetPasswordData
func (c *Client) GetPasswordDataRequest(input *GetPasswordDataInput) GetPasswordDataRequest {
	op := &aws.Operation{
		Name:       opGetPasswordData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPasswordDataInput{}
	}

	req := c.newRequest(op, input, &GetPasswordDataOutput{})
	return GetPasswordDataRequest{Request: req, Input: input, Copy: c.GetPasswordDataRequest}
}

// GetPasswordDataRequest is the request type for the
// GetPasswordData API operation.
type GetPasswordDataRequest struct {
	*aws.Request
	Input *GetPasswordDataInput
	Copy  func(*GetPasswordDataInput) GetPasswordDataRequest
}

// Send marshals and sends the GetPasswordData API request.
func (r GetPasswordDataRequest) Send(ctx context.Context) (*GetPasswordDataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPasswordDataResponse{
		GetPasswordDataOutput: r.Request.Data.(*GetPasswordDataOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPasswordDataResponse is the response type for the
// GetPasswordData API operation.
type GetPasswordDataResponse struct {
	*GetPasswordDataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPasswordData request.
func (r *GetPasswordDataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
