// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DisableAvailabilityZonesForLoadBalancer.
type DisableAvailabilityZonesForLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zones.
	//
	// AvailabilityZones is a required field
	AvailabilityZones []string `type:"list" required:"true"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableAvailabilityZonesForLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableAvailabilityZonesForLoadBalancerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableAvailabilityZonesForLoadBalancerInput"}

	if s.AvailabilityZones == nil {
		invalidParams.Add(aws.NewErrParamRequired("AvailabilityZones"))
	}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output for DisableAvailabilityZonesForLoadBalancer.
type DisableAvailabilityZonesForLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// The remaining Availability Zones for the load balancer.
	AvailabilityZones []string `type:"list"`
}

// String returns the string representation
func (s DisableAvailabilityZonesForLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableAvailabilityZonesForLoadBalancer = "DisableAvailabilityZonesForLoadBalancer"

// DisableAvailabilityZonesForLoadBalancerRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Removes the specified Availability Zones from the set of Availability Zones
// for the specified load balancer in EC2-Classic or a default VPC.
//
// For load balancers in a non-default VPC, use DetachLoadBalancerFromSubnets.
//
// There must be at least one Availability Zone registered with a load balancer
// at all times. After an Availability Zone is removed, all instances registered
// with the load balancer that are in the removed Availability Zone go into
// the OutOfService state. Then, the load balancer attempts to equally balance
// the traffic among its remaining Availability Zones.
//
// For more information, see Add or Remove Availability Zones (http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html)
// in the Classic Load Balancers Guide.
//
//    // Example sending a request using DisableAvailabilityZonesForLoadBalancerRequest.
//    req := client.DisableAvailabilityZonesForLoadBalancerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DisableAvailabilityZonesForLoadBalancer
func (c *Client) DisableAvailabilityZonesForLoadBalancerRequest(input *DisableAvailabilityZonesForLoadBalancerInput) DisableAvailabilityZonesForLoadBalancerRequest {
	op := &aws.Operation{
		Name:       opDisableAvailabilityZonesForLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableAvailabilityZonesForLoadBalancerInput{}
	}

	req := c.newRequest(op, input, &DisableAvailabilityZonesForLoadBalancerOutput{})
	return DisableAvailabilityZonesForLoadBalancerRequest{Request: req, Input: input, Copy: c.DisableAvailabilityZonesForLoadBalancerRequest}
}

// DisableAvailabilityZonesForLoadBalancerRequest is the request type for the
// DisableAvailabilityZonesForLoadBalancer API operation.
type DisableAvailabilityZonesForLoadBalancerRequest struct {
	*aws.Request
	Input *DisableAvailabilityZonesForLoadBalancerInput
	Copy  func(*DisableAvailabilityZonesForLoadBalancerInput) DisableAvailabilityZonesForLoadBalancerRequest
}

// Send marshals and sends the DisableAvailabilityZonesForLoadBalancer API request.
func (r DisableAvailabilityZonesForLoadBalancerRequest) Send(ctx context.Context) (*DisableAvailabilityZonesForLoadBalancerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableAvailabilityZonesForLoadBalancerResponse{
		DisableAvailabilityZonesForLoadBalancerOutput: r.Request.Data.(*DisableAvailabilityZonesForLoadBalancerOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableAvailabilityZonesForLoadBalancerResponse is the response type for the
// DisableAvailabilityZonesForLoadBalancer API operation.
type DisableAvailabilityZonesForLoadBalancerResponse struct {
	*DisableAvailabilityZonesForLoadBalancerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableAvailabilityZonesForLoadBalancer request.
func (r *DisableAvailabilityZonesForLoadBalancerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
