// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAdminAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAdminAccountInput) String() string {
	return awsutil.Prettify(s)
}

type GetAdminAccountOutput struct {
	_ struct{} `type:"structure"`

	// The AWS account that is set as the AWS Firewall Manager administrator.
	AdminAccount *string `min:"1" type:"string"`

	// The status of the AWS account that you set as the AWS Firewall Manager administrator.
	RoleStatus AccountRoleStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetAdminAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAdminAccount = "GetAdminAccount"

// GetAdminAccountRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Returns the AWS Organizations master account that is associated with AWS
// Firewall Manager as the AWS Firewall Manager administrator.
//
//    // Example sending a request using GetAdminAccountRequest.
//    req := client.GetAdminAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAdminAccount
func (c *Client) GetAdminAccountRequest(input *GetAdminAccountInput) GetAdminAccountRequest {
	op := &aws.Operation{
		Name:       opGetAdminAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAdminAccountInput{}
	}

	req := c.newRequest(op, input, &GetAdminAccountOutput{})
	return GetAdminAccountRequest{Request: req, Input: input, Copy: c.GetAdminAccountRequest}
}

// GetAdminAccountRequest is the request type for the
// GetAdminAccount API operation.
type GetAdminAccountRequest struct {
	*aws.Request
	Input *GetAdminAccountInput
	Copy  func(*GetAdminAccountInput) GetAdminAccountRequest
}

// Send marshals and sends the GetAdminAccount API request.
func (r GetAdminAccountRequest) Send(ctx context.Context) (*GetAdminAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAdminAccountResponse{
		GetAdminAccountOutput: r.Request.Data.(*GetAdminAccountOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAdminAccountResponse is the response type for the
// GetAdminAccount API operation.
type GetAdminAccountResponse struct {
	*GetAdminAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAdminAccount request.
func (r *GetAdminAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
