// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateForecastExportJobInput struct {
	_ struct{} `type:"structure"`

	// The location where you want to save the forecast and an AWS Identity and
	// Access Management (IAM) role that Amazon Forecast can assume to access the
	// location. The forecast must be exported to an Amazon S3 bucket.
	//
	// If encryption is used, Destination must include an AWS Key Management Service
	// (KMS) key. The IAM role must allow Amazon Forecast permission to access the
	// key.
	//
	// Destination is a required field
	Destination *DataDestination `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the forecast that you want to export.
	//
	// ForecastArn is a required field
	ForecastArn *string `type:"string" required:"true"`

	// The name for the forecast export job.
	//
	// ForecastExportJobName is a required field
	ForecastExportJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateForecastExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateForecastExportJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateForecastExportJobInput"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}

	if s.ForecastArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForecastArn"))
	}

	if s.ForecastExportJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForecastExportJobName"))
	}
	if s.ForecastExportJobName != nil && len(*s.ForecastExportJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ForecastExportJobName", 1))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateForecastExportJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the export job.
	ForecastExportJobArn *string `type:"string"`
}

// String returns the string representation
func (s CreateForecastExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateForecastExportJob = "CreateForecastExportJob"

// CreateForecastExportJobRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Exports a forecast created by the CreateForecast operation to your Amazon
// Simple Storage Service (Amazon S3) bucket. The forecast file name will match
// the following conventions:
//
// <ForecastExportJobName>_<ExportTimestamp>_<PageNumber>
//
// where the <ExportTimestamp> component is in Java SimpleDateFormat (yyyy-MM-ddTHH-mm-ssZ).
//
// You must specify a DataDestination object that includes an AWS Identity and
// Access Management (IAM) role that Amazon Forecast can assume to access the
// Amazon S3 bucket. For more information, see aws-forecast-iam-roles.
//
// For more information, see howitworks-forecast.
//
// To get a list of all your forecast export jobs, use the ListForecastExportJobs
// operation.
//
// The Status of the forecast export job must be ACTIVE before you can access
// the forecast in your Amazon S3 bucket. To get the status, use the DescribeForecastExportJob
// operation.
//
//    // Example sending a request using CreateForecastExportJobRequest.
//    req := client.CreateForecastExportJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateForecastExportJob
func (c *Client) CreateForecastExportJobRequest(input *CreateForecastExportJobInput) CreateForecastExportJobRequest {
	op := &aws.Operation{
		Name:       opCreateForecastExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateForecastExportJobInput{}
	}

	req := c.newRequest(op, input, &CreateForecastExportJobOutput{})
	return CreateForecastExportJobRequest{Request: req, Input: input, Copy: c.CreateForecastExportJobRequest}
}

// CreateForecastExportJobRequest is the request type for the
// CreateForecastExportJob API operation.
type CreateForecastExportJobRequest struct {
	*aws.Request
	Input *CreateForecastExportJobInput
	Copy  func(*CreateForecastExportJobInput) CreateForecastExportJobRequest
}

// Send marshals and sends the CreateForecastExportJob API request.
func (r CreateForecastExportJobRequest) Send(ctx context.Context) (*CreateForecastExportJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateForecastExportJobResponse{
		CreateForecastExportJobOutput: r.Request.Data.(*CreateForecastExportJobOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateForecastExportJobResponse is the response type for the
// CreateForecastExportJob API operation.
type CreateForecastExportJobResponse struct {
	*CreateForecastExportJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateForecastExportJob request.
func (r *CreateForecastExportJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
