// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateScriptInput struct {
	_ struct{} `type:"structure"`

	// Descriptive label that is associated with a script. Script names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Unique identifier for a Realtime script to update.
	//
	// ScriptId is a required field
	ScriptId *string `type:"string" required:"true"`

	// Location of the Amazon S3 bucket where a zipped file containing your Realtime
	// scripts is stored. The storage location must specify the Amazon S3 bucket
	// name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift
	// to access the Amazon S3 storage location. The S3 bucket must be in the same
	// region where you want to create a new script. By default, Amazon GameLift
	// uploads the latest version of the zip file; if you have S3 object versioning
	// turned on, you can use the ObjectVersion parameter to specify an earlier
	// version.
	StorageLocation *S3Location `type:"structure"`

	// Version that is associated with a build or script. Version strings do not
	// need to be unique.
	Version *string `min:"1" type:"string"`

	// Data object containing your Realtime scripts and dependencies as a zip file.
	// The zip file can have one or multiple files. Maximum size of a zip file is
	// 5 MB.
	//
	// When using the AWS CLI tool to create a script, this parameter is set to
	// the zip file name. It must be prepended with the string "fileb://" to indicate
	// that the file data is a binary object. For example: --zip-file fileb://myRealtimeScript.zip.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s UpdateScriptInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateScriptInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateScriptInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.ScriptId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScriptId"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Version", 1))
	}
	if s.StorageLocation != nil {
		if err := s.StorageLocation.Validate(); err != nil {
			invalidParams.AddNested("StorageLocation", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateScriptOutput struct {
	_ struct{} `type:"structure"`

	// The newly created script record with a unique script ID. The new script's
	// storage location reflects an Amazon S3 location: (1) If the script was uploaded
	// from an S3 bucket under your account, the storage location reflects the information
	// that was provided in the CreateScript request; (2) If the script file was
	// uploaded from a local zip file, the storage location reflects an S3 location
	// controls by the Amazon GameLift service.
	Script *Script `type:"structure"`
}

// String returns the string representation
func (s UpdateScriptOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateScript = "UpdateScript"

// UpdateScriptRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Updates Realtime script metadata and content.
//
// To update script metadata, specify the script ID and provide updated name
// and/or version values.
//
// To update script content, provide an updated zip file by pointing to either
// a local file or an Amazon S3 bucket location. You can use either method regardless
// of how the original script was uploaded. Use the Version parameter to track
// updates to the script.
//
// If the call is successful, the updated metadata is stored in the script record
// and a revised script is uploaded to the Amazon GameLift service. Once the
// script is updated and acquired by a fleet instance, the new version is used
// for all new game sessions.
//
// Learn more
//
// Amazon GameLift Realtime Servers (https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
//
// Related operations
//
//    * CreateScript
//
//    * ListScripts
//
//    * DescribeScript
//
//    * UpdateScript
//
//    * DeleteScript
//
//    // Example sending a request using UpdateScriptRequest.
//    req := client.UpdateScriptRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateScript
func (c *Client) UpdateScriptRequest(input *UpdateScriptInput) UpdateScriptRequest {
	op := &aws.Operation{
		Name:       opUpdateScript,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateScriptInput{}
	}

	req := c.newRequest(op, input, &UpdateScriptOutput{})
	return UpdateScriptRequest{Request: req, Input: input, Copy: c.UpdateScriptRequest}
}

// UpdateScriptRequest is the request type for the
// UpdateScript API operation.
type UpdateScriptRequest struct {
	*aws.Request
	Input *UpdateScriptInput
	Copy  func(*UpdateScriptInput) UpdateScriptRequest
}

// Send marshals and sends the UpdateScript API request.
func (r UpdateScriptRequest) Send(ctx context.Context) (*UpdateScriptResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateScriptResponse{
		UpdateScriptOutput: r.Request.Data.(*UpdateScriptOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateScriptResponse is the response type for the
// UpdateScript API operation.
type UpdateScriptResponse struct {
	*UpdateScriptOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateScript request.
func (r *UpdateScriptResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
