// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchGetCrawlersInput struct {
	_ struct{} `type:"structure"`

	// A list of crawler names, which might be the names returned from the ListCrawlers
	// operation.
	//
	// CrawlerNames is a required field
	CrawlerNames []string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetCrawlersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetCrawlersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetCrawlersInput"}

	if s.CrawlerNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("CrawlerNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchGetCrawlersOutput struct {
	_ struct{} `type:"structure"`

	// A list of crawler definitions.
	Crawlers []Crawler `type:"list"`

	// A list of names of crawlers that were not found.
	CrawlersNotFound []string `type:"list"`
}

// String returns the string representation
func (s BatchGetCrawlersOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchGetCrawlers = "BatchGetCrawlers"

// BatchGetCrawlersRequest returns a request value for making API operation for
// AWS Glue.
//
// Returns a list of resource metadata for a given list of crawler names. After
// calling the ListCrawlers operation, you can call this operation to access
// the data to which you have been granted permissions. This operation supports
// all IAM permissions, including permission conditions that uses tags.
//
//    // Example sending a request using BatchGetCrawlersRequest.
//    req := client.BatchGetCrawlersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetCrawlers
func (c *Client) BatchGetCrawlersRequest(input *BatchGetCrawlersInput) BatchGetCrawlersRequest {
	op := &aws.Operation{
		Name:       opBatchGetCrawlers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetCrawlersInput{}
	}

	req := c.newRequest(op, input, &BatchGetCrawlersOutput{})
	return BatchGetCrawlersRequest{Request: req, Input: input, Copy: c.BatchGetCrawlersRequest}
}

// BatchGetCrawlersRequest is the request type for the
// BatchGetCrawlers API operation.
type BatchGetCrawlersRequest struct {
	*aws.Request
	Input *BatchGetCrawlersInput
	Copy  func(*BatchGetCrawlersInput) BatchGetCrawlersRequest
}

// Send marshals and sends the BatchGetCrawlers API request.
func (r BatchGetCrawlersRequest) Send(ctx context.Context) (*BatchGetCrawlersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetCrawlersResponse{
		BatchGetCrawlersOutput: r.Request.Data.(*BatchGetCrawlersOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetCrawlersResponse is the response type for the
// BatchGetCrawlers API operation.
type BatchGetCrawlersResponse struct {
	*BatchGetCrawlersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetCrawlers request.
func (r *BatchGetCrawlersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
