// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteMLTransformInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the transform to delete.
	//
	// TransformId is a required field
	TransformId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMLTransformInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMLTransformInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMLTransformInput"}

	if s.TransformId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformId"))
	}
	if s.TransformId != nil && len(*s.TransformId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TransformId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteMLTransformOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the transform that was deleted.
	TransformId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteMLTransformOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteMLTransform = "DeleteMLTransform"

// DeleteMLTransformRequest returns a request value for making API operation for
// AWS Glue.
//
// Deletes an AWS Glue machine learning transform. Machine learning transforms
// are a special type of transform that use machine learning to learn the details
// of the transformation to be performed by learning from examples provided
// by humans. These transformations are then saved by AWS Glue. If you no longer
// need a transform, you can delete it by calling DeleteMLTransforms. However,
// any AWS Glue jobs that still reference the deleted transform will no longer
// succeed.
//
//    // Example sending a request using DeleteMLTransformRequest.
//    req := client.DeleteMLTransformRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteMLTransform
func (c *Client) DeleteMLTransformRequest(input *DeleteMLTransformInput) DeleteMLTransformRequest {
	op := &aws.Operation{
		Name:       opDeleteMLTransform,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMLTransformInput{}
	}

	req := c.newRequest(op, input, &DeleteMLTransformOutput{})
	return DeleteMLTransformRequest{Request: req, Input: input, Copy: c.DeleteMLTransformRequest}
}

// DeleteMLTransformRequest is the request type for the
// DeleteMLTransform API operation.
type DeleteMLTransformRequest struct {
	*aws.Request
	Input *DeleteMLTransformInput
	Copy  func(*DeleteMLTransformInput) DeleteMLTransformRequest
}

// Send marshals and sends the DeleteMLTransform API request.
func (r DeleteMLTransformRequest) Send(ctx context.Context) (*DeleteMLTransformResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteMLTransformResponse{
		DeleteMLTransformOutput: r.Request.Data.(*DeleteMLTransformOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteMLTransformResponse is the response type for the
// DeleteMLTransform API operation.
type DeleteMLTransformResponse struct {
	*DeleteMLTransformOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteMLTransform request.
func (r *DeleteMLTransformResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
