// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteTableVersionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the tables reside. If none is provided,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The database in the catalog in which the table resides. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table. For Hive compatibility, this name is entirely lowercase.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// The ID of the table version to be deleted. A VersionID is a string representation
	// of an integer. Each version is incremented by 1.
	//
	// VersionId is a required field
	VersionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTableVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTableVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTableVersionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if s.VersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersionId"))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTableVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTableVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTableVersion = "DeleteTableVersion"

// DeleteTableVersionRequest returns a request value for making API operation for
// AWS Glue.
//
// Deletes a specified version of a table.
//
//    // Example sending a request using DeleteTableVersionRequest.
//    req := client.DeleteTableVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableVersion
func (c *Client) DeleteTableVersionRequest(input *DeleteTableVersionInput) DeleteTableVersionRequest {
	op := &aws.Operation{
		Name:       opDeleteTableVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTableVersionInput{}
	}

	req := c.newRequest(op, input, &DeleteTableVersionOutput{})
	return DeleteTableVersionRequest{Request: req, Input: input, Copy: c.DeleteTableVersionRequest}
}

// DeleteTableVersionRequest is the request type for the
// DeleteTableVersion API operation.
type DeleteTableVersionRequest struct {
	*aws.Request
	Input *DeleteTableVersionInput
	Copy  func(*DeleteTableVersionInput) DeleteTableVersionRequest
}

// Send marshals and sends the DeleteTableVersion API request.
func (r DeleteTableVersionRequest) Send(ctx context.Context) (*DeleteTableVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTableVersionResponse{
		DeleteTableVersionOutput: r.Request.Data.(*DeleteTableVersionOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTableVersionResponse is the response type for the
// DeleteTableVersion API operation.
type DeleteTableVersionResponse struct {
	*DeleteTableVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTableVersion request.
func (r *DeleteTableVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
