// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetDataCatalogEncryptionSettingsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog to retrieve the security configuration for. If
	// none is provided, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetDataCatalogEncryptionSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataCatalogEncryptionSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDataCatalogEncryptionSettingsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetDataCatalogEncryptionSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The requested security configuration.
	DataCatalogEncryptionSettings *DataCatalogEncryptionSettings `type:"structure"`
}

// String returns the string representation
func (s GetDataCatalogEncryptionSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDataCatalogEncryptionSettings = "GetDataCatalogEncryptionSettings"

// GetDataCatalogEncryptionSettingsRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves the security configuration for a specified catalog.
//
//    // Example sending a request using GetDataCatalogEncryptionSettingsRequest.
//    req := client.GetDataCatalogEncryptionSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataCatalogEncryptionSettings
func (c *Client) GetDataCatalogEncryptionSettingsRequest(input *GetDataCatalogEncryptionSettingsInput) GetDataCatalogEncryptionSettingsRequest {
	op := &aws.Operation{
		Name:       opGetDataCatalogEncryptionSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDataCatalogEncryptionSettingsInput{}
	}

	req := c.newRequest(op, input, &GetDataCatalogEncryptionSettingsOutput{})
	return GetDataCatalogEncryptionSettingsRequest{Request: req, Input: input, Copy: c.GetDataCatalogEncryptionSettingsRequest}
}

// GetDataCatalogEncryptionSettingsRequest is the request type for the
// GetDataCatalogEncryptionSettings API operation.
type GetDataCatalogEncryptionSettingsRequest struct {
	*aws.Request
	Input *GetDataCatalogEncryptionSettingsInput
	Copy  func(*GetDataCatalogEncryptionSettingsInput) GetDataCatalogEncryptionSettingsRequest
}

// Send marshals and sends the GetDataCatalogEncryptionSettings API request.
func (r GetDataCatalogEncryptionSettingsRequest) Send(ctx context.Context) (*GetDataCatalogEncryptionSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDataCatalogEncryptionSettingsResponse{
		GetDataCatalogEncryptionSettingsOutput: r.Request.Data.(*GetDataCatalogEncryptionSettingsOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDataCatalogEncryptionSettingsResponse is the response type for the
// GetDataCatalogEncryptionSettings API operation.
type GetDataCatalogEncryptionSettingsResponse struct {
	*GetDataCatalogEncryptionSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDataCatalogEncryptionSettings request.
func (r *GetDataCatalogEncryptionSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
