// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribePublishingDestinationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the publishing destination to retrieve.
	//
	// DestinationId is a required field
	DestinationId *string `location:"uri" locationName:"destinationId" type:"string" required:"true"`

	// The unique ID of the detector associated with the publishing destination
	// to retrieve.
	//
	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePublishingDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePublishingDestinationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribePublishingDestinationInput"}

	if s.DestinationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationId"))
	}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribePublishingDestinationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DestinationId != nil {
		v := *s.DestinationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "destinationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribePublishingDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the publishing destination.
	//
	// DestinationId is a required field
	DestinationId *string `locationName:"destinationId" type:"string" required:"true"`

	// A DestinationProperties object that includes the DestinationArn and KmsKeyArn
	// of the publishing destination.
	//
	// DestinationProperties is a required field
	DestinationProperties *DestinationProperties `locationName:"destinationProperties" type:"structure" required:"true"`

	// The type of the publishing destination. Currently, only S3 is supported.
	//
	// DestinationType is a required field
	DestinationType DestinationType `locationName:"destinationType" min:"1" type:"string" required:"true" enum:"true"`

	// The time, in epoch millisecond format, at which GuardDuty was first unable
	// to publish findings to the destination.
	//
	// PublishingFailureStartTimestamp is a required field
	PublishingFailureStartTimestamp *int64 `locationName:"publishingFailureStartTimestamp" type:"long" required:"true"`

	// The status of the publishing destination.
	//
	// Status is a required field
	Status PublishingStatus `locationName:"status" min:"1" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DescribePublishingDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribePublishingDestinationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationId != nil {
		v := *s.DestinationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destinationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationProperties != nil {
		v := s.DestinationProperties

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destinationProperties", v, metadata)
	}
	if len(s.DestinationType) > 0 {
		v := s.DestinationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destinationType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PublishingFailureStartTimestamp != nil {
		v := *s.PublishingFailureStartTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "publishingFailureStartTimestamp", protocol.Int64Value(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opDescribePublishingDestination = "DescribePublishingDestination"

// DescribePublishingDestinationRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Returns information about the publishing destination specified by the provided
// destinationId.
//
//    // Example sending a request using DescribePublishingDestinationRequest.
//    req := client.DescribePublishingDestinationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribePublishingDestination
func (c *Client) DescribePublishingDestinationRequest(input *DescribePublishingDestinationInput) DescribePublishingDestinationRequest {
	op := &aws.Operation{
		Name:       opDescribePublishingDestination,
		HTTPMethod: "GET",
		HTTPPath:   "/detector/{detectorId}/publishingDestination/{destinationId}",
	}

	if input == nil {
		input = &DescribePublishingDestinationInput{}
	}

	req := c.newRequest(op, input, &DescribePublishingDestinationOutput{})
	return DescribePublishingDestinationRequest{Request: req, Input: input, Copy: c.DescribePublishingDestinationRequest}
}

// DescribePublishingDestinationRequest is the request type for the
// DescribePublishingDestination API operation.
type DescribePublishingDestinationRequest struct {
	*aws.Request
	Input *DescribePublishingDestinationInput
	Copy  func(*DescribePublishingDestinationInput) DescribePublishingDestinationRequest
}

// Send marshals and sends the DescribePublishingDestination API request.
func (r DescribePublishingDestinationRequest) Send(ctx context.Context) (*DescribePublishingDestinationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePublishingDestinationResponse{
		DescribePublishingDestinationOutput: r.Request.Data.(*DescribePublishingDestinationOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribePublishingDestinationResponse is the response type for the
// DescribePublishingDestination API operation.
type DescribePublishingDestinationResponse struct {
	*DescribePublishingDestinationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePublishingDestination request.
func (r *DescribePublishingDestinationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
