// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type UpdateAccountPasswordPolicyInput struct {
	_ struct{} `type:"structure"`

	// Allows all IAM users in your account to use the AWS Management Console to
	// change their own passwords. For more information, see Letting IAM Users Change
	// Their Own Passwords (https://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html)
	// in the IAM User Guide.
	//
	// If you do not specify a value for this parameter, then the operation uses
	// the default value of false. The result is that IAM users in the account do
	// not automatically have permissions to change their own password.
	AllowUsersToChangePassword *bool `type:"boolean"`

	// Prevents IAM users from setting a new password after their password has expired.
	// The IAM user cannot be accessed until an administrator resets the password.
	//
	// If you do not specify a value for this parameter, then the operation uses
	// the default value of false. The result is that IAM users can change their
	// passwords after they expire and continue to sign in as the user.
	HardExpiry *bool `type:"boolean"`

	// The number of days that an IAM user password is valid.
	//
	// If you do not specify a value for this parameter, then the operation uses
	// the default value of 0. The result is that IAM user passwords never expire.
	MaxPasswordAge *int64 `min:"1" type:"integer"`

	// The minimum number of characters allowed in an IAM user password.
	//
	// If you do not specify a value for this parameter, then the operation uses
	// the default value of 6.
	MinimumPasswordLength *int64 `min:"6" type:"integer"`

	// Specifies the number of previous passwords that IAM users are prevented from
	// reusing.
	//
	// If you do not specify a value for this parameter, then the operation uses
	// the default value of 0. The result is that IAM users are not prevented from
	// reusing previous passwords.
	PasswordReusePrevention *int64 `min:"1" type:"integer"`

	// Specifies whether IAM user passwords must contain at least one lowercase
	// character from the ISO basic Latin alphabet (a to z).
	//
	// If you do not specify a value for this parameter, then the operation uses
	// the default value of false. The result is that passwords do not require at
	// least one lowercase character.
	RequireLowercaseCharacters *bool `type:"boolean"`

	// Specifies whether IAM user passwords must contain at least one numeric character
	// (0 to 9).
	//
	// If you do not specify a value for this parameter, then the operation uses
	// the default value of false. The result is that passwords do not require at
	// least one numeric character.
	RequireNumbers *bool `type:"boolean"`

	// Specifies whether IAM user passwords must contain at least one of the following
	// non-alphanumeric characters:
	//
	// ! @ # $ % ^ & * ( ) _ + - = [ ] { } | '
	//
	// If you do not specify a value for this parameter, then the operation uses
	// the default value of false. The result is that passwords do not require at
	// least one symbol character.
	RequireSymbols *bool `type:"boolean"`

	// Specifies whether IAM user passwords must contain at least one uppercase
	// character from the ISO basic Latin alphabet (A to Z).
	//
	// If you do not specify a value for this parameter, then the operation uses
	// the default value of false. The result is that passwords do not require at
	// least one uppercase character.
	RequireUppercaseCharacters *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateAccountPasswordPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccountPasswordPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateAccountPasswordPolicyInput"}
	if s.MaxPasswordAge != nil && *s.MaxPasswordAge < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxPasswordAge", 1))
	}
	if s.MinimumPasswordLength != nil && *s.MinimumPasswordLength < 6 {
		invalidParams.Add(aws.NewErrParamMinValue("MinimumPasswordLength", 6))
	}
	if s.PasswordReusePrevention != nil && *s.PasswordReusePrevention < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("PasswordReusePrevention", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateAccountPasswordPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAccountPasswordPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateAccountPasswordPolicy = "UpdateAccountPasswordPolicy"

// UpdateAccountPasswordPolicyRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Updates the password policy settings for the AWS account.
//
//    * This operation does not support partial updates. No parameters are required,
//    but if you do not specify a parameter, that parameter's value reverts
//    to its default value. See the Request Parameters section for each parameter's
//    default value. Also note that some parameters do not allow the default
//    parameter to be explicitly set. Instead, to invoke the default value,
//    do not include that parameter when you invoke the operation.
//
// For more information about using a password policy, see Managing an IAM Password
// Policy (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html)
// in the IAM User Guide.
//
//    // Example sending a request using UpdateAccountPasswordPolicyRequest.
//    req := client.UpdateAccountPasswordPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccountPasswordPolicy
func (c *Client) UpdateAccountPasswordPolicyRequest(input *UpdateAccountPasswordPolicyInput) UpdateAccountPasswordPolicyRequest {
	op := &aws.Operation{
		Name:       opUpdateAccountPasswordPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAccountPasswordPolicyInput{}
	}

	req := c.newRequest(op, input, &UpdateAccountPasswordPolicyOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateAccountPasswordPolicyRequest{Request: req, Input: input, Copy: c.UpdateAccountPasswordPolicyRequest}
}

// UpdateAccountPasswordPolicyRequest is the request type for the
// UpdateAccountPasswordPolicy API operation.
type UpdateAccountPasswordPolicyRequest struct {
	*aws.Request
	Input *UpdateAccountPasswordPolicyInput
	Copy  func(*UpdateAccountPasswordPolicyInput) UpdateAccountPasswordPolicyRequest
}

// Send marshals and sends the UpdateAccountPasswordPolicy API request.
func (r UpdateAccountPasswordPolicyRequest) Send(ctx context.Context) (*UpdateAccountPasswordPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateAccountPasswordPolicyResponse{
		UpdateAccountPasswordPolicyOutput: r.Request.Data.(*UpdateAccountPasswordPolicyOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateAccountPasswordPolicyResponse is the response type for the
// UpdateAccountPasswordPolicy API operation.
type UpdateAccountPasswordPolicyResponse struct {
	*UpdateAccountPasswordPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateAccountPasswordPolicy request.
func (r *UpdateAccountPasswordPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
