// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteDistributionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the distribution configuration to delete.
	//
	// DistributionConfigurationArn is a required field
	DistributionConfigurationArn *string `location:"querystring" locationName:"distributionConfigurationArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDistributionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDistributionConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDistributionConfigurationInput"}

	if s.DistributionConfigurationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DistributionConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDistributionConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DistributionConfigurationArn != nil {
		v := *s.DistributionConfigurationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "distributionConfigurationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteDistributionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the distribution configuration that was
	// deleted.
	DistributionConfigurationArn *string `locationName:"distributionConfigurationArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteDistributionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteDistributionConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DistributionConfigurationArn != nil {
		v := *s.DistributionConfigurationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "distributionConfigurationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDeleteDistributionConfiguration = "DeleteDistributionConfiguration"

// DeleteDistributionConfigurationRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Deletes a distribution configuration.
//
//    // Example sending a request using DeleteDistributionConfigurationRequest.
//    req := client.DeleteDistributionConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/DeleteDistributionConfiguration
func (c *Client) DeleteDistributionConfigurationRequest(input *DeleteDistributionConfigurationInput) DeleteDistributionConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteDistributionConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/DeleteDistributionConfiguration",
	}

	if input == nil {
		input = &DeleteDistributionConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteDistributionConfigurationOutput{})
	return DeleteDistributionConfigurationRequest{Request: req, Input: input, Copy: c.DeleteDistributionConfigurationRequest}
}

// DeleteDistributionConfigurationRequest is the request type for the
// DeleteDistributionConfiguration API operation.
type DeleteDistributionConfigurationRequest struct {
	*aws.Request
	Input *DeleteDistributionConfigurationInput
	Copy  func(*DeleteDistributionConfigurationInput) DeleteDistributionConfigurationRequest
}

// Send marshals and sends the DeleteDistributionConfiguration API request.
func (r DeleteDistributionConfigurationRequest) Send(ctx context.Context) (*DeleteDistributionConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDistributionConfigurationResponse{
		DeleteDistributionConfigurationOutput: r.Request.Data.(*DeleteDistributionConfigurationOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDistributionConfigurationResponse is the response type for the
// DeleteDistributionConfiguration API operation.
type DeleteDistributionConfigurationResponse struct {
	*DeleteDistributionConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDistributionConfiguration request.
func (r *DeleteDistributionConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
