// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateTopicRuleDestinationInput struct {
	_ struct{} `type:"structure"`

	// The topic rule destination configuration.
	//
	// DestinationConfiguration is a required field
	DestinationConfiguration *TopicRuleDestinationConfiguration `locationName:"destinationConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTopicRuleDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTopicRuleDestinationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTopicRuleDestinationInput"}

	if s.DestinationConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationConfiguration"))
	}
	if s.DestinationConfiguration != nil {
		if err := s.DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DestinationConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateTopicRuleDestinationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DestinationConfiguration != nil {
		v := s.DestinationConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destinationConfiguration", v, metadata)
	}
	return nil
}

type CreateTopicRuleDestinationOutput struct {
	_ struct{} `type:"structure"`

	// The topic rule destination.
	TopicRuleDestination *TopicRuleDestination `locationName:"topicRuleDestination" type:"structure"`
}

// String returns the string representation
func (s CreateTopicRuleDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateTopicRuleDestinationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.TopicRuleDestination != nil {
		v := s.TopicRuleDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "topicRuleDestination", v, metadata)
	}
	return nil
}

const opCreateTopicRuleDestination = "CreateTopicRuleDestination"

// CreateTopicRuleDestinationRequest returns a request value for making API operation for
// AWS IoT.
//
// Creates a topic rule destination. The destination must be confirmed prior
// to use.
//
//    // Example sending a request using CreateTopicRuleDestinationRequest.
//    req := client.CreateTopicRuleDestinationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateTopicRuleDestinationRequest(input *CreateTopicRuleDestinationInput) CreateTopicRuleDestinationRequest {
	op := &aws.Operation{
		Name:       opCreateTopicRuleDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/destinations",
	}

	if input == nil {
		input = &CreateTopicRuleDestinationInput{}
	}

	req := c.newRequest(op, input, &CreateTopicRuleDestinationOutput{})
	return CreateTopicRuleDestinationRequest{Request: req, Input: input, Copy: c.CreateTopicRuleDestinationRequest}
}

// CreateTopicRuleDestinationRequest is the request type for the
// CreateTopicRuleDestination API operation.
type CreateTopicRuleDestinationRequest struct {
	*aws.Request
	Input *CreateTopicRuleDestinationInput
	Copy  func(*CreateTopicRuleDestinationInput) CreateTopicRuleDestinationRequest
}

// Send marshals and sends the CreateTopicRuleDestination API request.
func (r CreateTopicRuleDestinationRequest) Send(ctx context.Context) (*CreateTopicRuleDestinationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTopicRuleDestinationResponse{
		CreateTopicRuleDestinationOutput: r.Request.Data.(*CreateTopicRuleDestinationOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTopicRuleDestinationResponse is the response type for the
// CreateTopicRuleDestination API operation.
type CreateTopicRuleDestinationResponse struct {
	*CreateTopicRuleDestinationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTopicRuleDestination request.
func (r *CreateTopicRuleDestinationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
