// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot1clickdevicesservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type InitiateDeviceClaimInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`
}

// String returns the string representation
func (s InitiateDeviceClaimInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateDeviceClaimInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InitiateDeviceClaimInput"}

	if s.DeviceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InitiateDeviceClaimInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "deviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type InitiateDeviceClaimOutput struct {
	_ struct{} `type:"structure"`

	State *string `locationName:"state" type:"string"`
}

// String returns the string representation
func (s InitiateDeviceClaimOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InitiateDeviceClaimOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opInitiateDeviceClaim = "InitiateDeviceClaim"

// InitiateDeviceClaimRequest returns a request value for making API operation for
// AWS IoT 1-Click Devices Service.
//
// Given a device ID, initiates a claim request for the associated device.
//
// Claiming a device consists of initiating a claim, then publishing a device
// event, and finalizing the claim. For a device of type button, a device event
// can be published by simply clicking the device.
//
//    // Example sending a request using InitiateDeviceClaimRequest.
//    req := client.InitiateDeviceClaimRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InitiateDeviceClaim
func (c *Client) InitiateDeviceClaimRequest(input *InitiateDeviceClaimInput) InitiateDeviceClaimRequest {
	op := &aws.Operation{
		Name:       opInitiateDeviceClaim,
		HTTPMethod: "PUT",
		HTTPPath:   "/devices/{deviceId}/initiate-claim",
	}

	if input == nil {
		input = &InitiateDeviceClaimInput{}
	}

	req := c.newRequest(op, input, &InitiateDeviceClaimOutput{})
	return InitiateDeviceClaimRequest{Request: req, Input: input, Copy: c.InitiateDeviceClaimRequest}
}

// InitiateDeviceClaimRequest is the request type for the
// InitiateDeviceClaim API operation.
type InitiateDeviceClaimRequest struct {
	*aws.Request
	Input *InitiateDeviceClaimInput
	Copy  func(*InitiateDeviceClaimInput) InitiateDeviceClaimRequest
}

// Send marshals and sends the InitiateDeviceClaim API request.
func (r InitiateDeviceClaimRequest) Send(ctx context.Context) (*InitiateDeviceClaimResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &InitiateDeviceClaimResponse{
		InitiateDeviceClaimOutput: r.Request.Data.(*InitiateDeviceClaimOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// InitiateDeviceClaimResponse is the response type for the
// InitiateDeviceClaim API operation.
type InitiateDeviceClaimResponse struct {
	*InitiateDeviceClaimOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// InitiateDeviceClaim request.
func (r *InitiateDeviceClaimResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
