// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotanalytics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CancelPipelineReprocessingInput struct {
	_ struct{} `type:"structure"`

	// The name of pipeline for which data reprocessing is canceled.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The ID of the reprocessing task (returned by "StartPipelineReprocessing").
	//
	// ReprocessingId is a required field
	ReprocessingId *string `location:"uri" locationName:"reprocessingId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelPipelineReprocessingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelPipelineReprocessingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelPipelineReprocessingInput"}

	if s.PipelineName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineName", 1))
	}

	if s.ReprocessingId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReprocessingId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CancelPipelineReprocessingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PipelineName != nil {
		v := *s.PipelineName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "pipelineName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReprocessingId != nil {
		v := *s.ReprocessingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "reprocessingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CancelPipelineReprocessingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelPipelineReprocessingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CancelPipelineReprocessingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opCancelPipelineReprocessing = "CancelPipelineReprocessing"

// CancelPipelineReprocessingRequest returns a request value for making API operation for
// AWS IoT Analytics.
//
// Cancels the reprocessing of data through the pipeline.
//
//    // Example sending a request using CancelPipelineReprocessingRequest.
//    req := client.CancelPipelineReprocessingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/CancelPipelineReprocessing
func (c *Client) CancelPipelineReprocessingRequest(input *CancelPipelineReprocessingInput) CancelPipelineReprocessingRequest {
	op := &aws.Operation{
		Name:       opCancelPipelineReprocessing,
		HTTPMethod: "DELETE",
		HTTPPath:   "/pipelines/{pipelineName}/reprocessing/{reprocessingId}",
	}

	if input == nil {
		input = &CancelPipelineReprocessingInput{}
	}

	req := c.newRequest(op, input, &CancelPipelineReprocessingOutput{})
	return CancelPipelineReprocessingRequest{Request: req, Input: input, Copy: c.CancelPipelineReprocessingRequest}
}

// CancelPipelineReprocessingRequest is the request type for the
// CancelPipelineReprocessing API operation.
type CancelPipelineReprocessingRequest struct {
	*aws.Request
	Input *CancelPipelineReprocessingInput
	Copy  func(*CancelPipelineReprocessingInput) CancelPipelineReprocessingRequest
}

// Send marshals and sends the CancelPipelineReprocessing API request.
func (r CancelPipelineReprocessingRequest) Send(ctx context.Context) (*CancelPipelineReprocessingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelPipelineReprocessingResponse{
		CancelPipelineReprocessingOutput: r.Request.Data.(*CancelPipelineReprocessingOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelPipelineReprocessingResponse is the response type for the
// CancelPipelineReprocessing API operation.
type CancelPipelineReprocessingResponse struct {
	*CancelPipelineReprocessingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelPipelineReprocessing request.
func (r *CancelPipelineReprocessingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
