// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kafka

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Arn is a required field
	Arn *string `location:"uri" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeConfigurationInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Response body for DescribeConfiguration.
type DescribeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The time when the configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the configuration.
	Description *string `locationName:"description" type:"string"`

	// The versions of Apache Kafka with which you can use this MSK configuration.
	KafkaVersions []string `locationName:"kafkaVersions" type:"list"`

	// Latest revision of the configuration.
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure"`

	// The name of the configuration. Configuration names are strings that match
	// the regex "^[0-9A-Za-z-]+$".
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KafkaVersions != nil {
		v := s.KafkaVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "kafkaVersions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.LatestRevision != nil {
		v := s.LatestRevision

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "latestRevision", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeConfiguration = "DescribeConfiguration"

// DescribeConfigurationRequest returns a request value for making API operation for
// Managed Streaming for Kafka.
//
// Returns a description of this MSK configuration.
//
//    // Example sending a request using DescribeConfigurationRequest.
//    req := client.DescribeConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/DescribeConfiguration
func (c *Client) DescribeConfigurationRequest(input *DescribeConfigurationInput) DescribeConfigurationRequest {
	op := &aws.Operation{
		Name:       opDescribeConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/configurations/{arn}",
	}

	if input == nil {
		input = &DescribeConfigurationInput{}
	}

	req := c.newRequest(op, input, &DescribeConfigurationOutput{})
	return DescribeConfigurationRequest{Request: req, Input: input, Copy: c.DescribeConfigurationRequest}
}

// DescribeConfigurationRequest is the request type for the
// DescribeConfiguration API operation.
type DescribeConfigurationRequest struct {
	*aws.Request
	Input *DescribeConfigurationInput
	Copy  func(*DescribeConfigurationInput) DescribeConfigurationRequest
}

// Send marshals and sends the DescribeConfiguration API request.
func (r DescribeConfigurationRequest) Send(ctx context.Context) (*DescribeConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeConfigurationResponse{
		DescribeConfigurationOutput: r.Request.Data.(*DescribeConfigurationOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeConfigurationResponse is the response type for the
// DescribeConfiguration API operation.
type DescribeConfigurationResponse struct {
	*DescribeConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeConfiguration request.
func (r *DescribeConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
