// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter to configure the application.
	ApplicationConfiguration *ApplicationConfiguration `type:"structure"`

	// A summary description of the application.
	ApplicationDescription *string `type:"string"`

	// The name of your application (for example, sample-app).
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Use this parameter to configure an Amazon CloudWatch log stream to monitor
	// application configuration errors.
	CloudWatchLoggingOptions []CloudWatchLoggingOption `type:"list"`

	// The runtime environment for the application (SQL-1.0 or FLINK-1_6).
	//
	// RuntimeEnvironment is a required field
	RuntimeEnvironment RuntimeEnvironment `type:"string" required:"true" enum:"true"`

	// The IAM role used by the application to access Kinesis data streams, Kinesis
	// Data Firehose delivery streams, Amazon S3 objects, and other external resources.
	//
	// ServiceExecutionRole is a required field
	ServiceExecutionRole *string `min:"1" type:"string" required:"true"`

	// A list of one or more tags to assign to the application. A tag is a key-value
	// pair that identifies an application. Note that the maximum number of application
	// tags includes system tags. The maximum number of user-defined application
	// tags is 50. For more information, see Using Tagging (https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
	Tags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateApplicationInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}
	if len(s.RuntimeEnvironment) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RuntimeEnvironment"))
	}

	if s.ServiceExecutionRole == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceExecutionRole"))
	}
	if s.ServiceExecutionRole != nil && len(*s.ServiceExecutionRole) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceExecutionRole", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.ApplicationConfiguration != nil {
		if err := s.ApplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ApplicationConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.CloudWatchLoggingOptions != nil {
		for i, v := range s.CloudWatchLoggingOptions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CloudWatchLoggingOptions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// In response to your CreateApplication request, Kinesis Data Analytics returns
	// a response with details of the application it created.
	//
	// ApplicationDetail is a required field
	ApplicationDetail *ApplicationDetail `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
// Creates an Amazon Kinesis Data Analytics application. For information about
// creating a Kinesis Data Analytics application, see Creating an Application
// (https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html).
//
//    // Example sending a request using CreateApplicationRequest.
//    req := client.CreateApplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplication
func (c *Client) CreateApplicationRequest(input *CreateApplicationInput) CreateApplicationRequest {
	op := &aws.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	req := c.newRequest(op, input, &CreateApplicationOutput{})
	return CreateApplicationRequest{Request: req, Input: input, Copy: c.CreateApplicationRequest}
}

// CreateApplicationRequest is the request type for the
// CreateApplication API operation.
type CreateApplicationRequest struct {
	*aws.Request
	Input *CreateApplicationInput
	Copy  func(*CreateApplicationInput) CreateApplicationRequest
}

// Send marshals and sends the CreateApplication API request.
func (r CreateApplicationRequest) Send(ctx context.Context) (*CreateApplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateApplicationResponse{
		CreateApplicationOutput: r.Request.Data.(*CreateApplicationOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateApplicationResponse is the response type for the
// CreateApplication API operation.
type CreateApplicationResponse struct {
	*CreateApplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateApplication request.
func (r *CreateApplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
