// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisvideo

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UntagStreamInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the stream that you want to remove tags
	// from.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream that you want to remove tags from.
	StreamName *string `min:"1" type:"string"`

	// A list of the keys of the tags that you want to remove.
	//
	// TagKeyList is a required field
	TagKeyList []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UntagStreamInput"}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamName", 1))
	}

	if s.TagKeyList == nil {
		invalidParams.Add(aws.NewErrParamRequired("TagKeyList"))
	}
	if s.TagKeyList != nil && len(s.TagKeyList) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TagKeyList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UntagStreamInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.StreamARN != nil {
		v := *s.StreamARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamName != nil {
		v := *s.StreamName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TagKeyList != nil {
		v := s.TagKeyList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TagKeyList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type UntagStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UntagStreamOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUntagStream = "UntagStream"

// UntagStreamRequest returns a request value for making API operation for
// Amazon Kinesis Video Streams.
//
// Removes one or more tags from a stream. In the request, specify only a tag
// key or keys; don't specify the value. If you specify a tag key that does
// not exist, it's ignored.
//
// In the request, you must provide the StreamName or StreamARN.
//
//    // Example sending a request using UntagStreamRequest.
//    req := client.UntagStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/UntagStream
func (c *Client) UntagStreamRequest(input *UntagStreamInput) UntagStreamRequest {
	op := &aws.Operation{
		Name:       opUntagStream,
		HTTPMethod: "POST",
		HTTPPath:   "/untagStream",
	}

	if input == nil {
		input = &UntagStreamInput{}
	}

	req := c.newRequest(op, input, &UntagStreamOutput{})
	return UntagStreamRequest{Request: req, Input: input, Copy: c.UntagStreamRequest}
}

// UntagStreamRequest is the request type for the
// UntagStream API operation.
type UntagStreamRequest struct {
	*aws.Request
	Input *UntagStreamInput
	Copy  func(*UntagStreamInput) UntagStreamRequest
}

// Send marshals and sends the UntagStream API request.
func (r UntagStreamRequest) Send(ctx context.Context) (*UntagStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UntagStreamResponse{
		UntagStreamOutput: r.Request.Data.(*UntagStreamOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UntagStreamResponse is the response type for the
// UntagStream API operation.
type UntagStreamResponse struct {
	*UntagStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UntagStream request.
func (r *UntagStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
