// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexmodelbuildingservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetIntentVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of intent versions to return in the response. The default
	// is 10.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the intent for which versions should be returned.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// A pagination token for fetching the next page of intent versions. If the
	// response to this call is truncated, Amazon Lex returns a pagination token
	// in the response. To fetch the next page of versions, specify the pagination
	// token in the next request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntentVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetIntentVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetIntentVersionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetIntentVersionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of IntentMetadata objects, one for each numbered version of the
	// intent plus one for the $LATEST version.
	Intents []IntentMetadata `locationName:"intents" type:"list"`

	// A pagination token for fetching the next page of intent versions. If the
	// response to this call is truncated, Amazon Lex returns a pagination token
	// in the response. To fetch the next page of versions, specify the pagination
	// token in the next request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetIntentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetIntentVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Intents != nil {
		v := s.Intents

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "intents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetIntentVersions = "GetIntentVersions"

// GetIntentVersionsRequest returns a request value for making API operation for
// Amazon Lex Model Building Service.
//
// Gets information about all of the versions of an intent.
//
// The GetIntentVersions operation returns an IntentMetadata object for each
// version of an intent. For example, if an intent has three numbered versions,
// the GetIntentVersions operation returns four IntentMetadata objects in the
// response, one for each numbered version and one for the $LATEST version.
//
// The GetIntentVersions operation always returns at least one version, the
// $LATEST version.
//
// This operation requires permissions for the lex:GetIntentVersions action.
//
//    // Example sending a request using GetIntentVersionsRequest.
//    req := client.GetIntentVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntentVersions
func (c *Client) GetIntentVersionsRequest(input *GetIntentVersionsInput) GetIntentVersionsRequest {
	op := &aws.Operation{
		Name:       opGetIntentVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/intents/{name}/versions/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetIntentVersionsInput{}
	}

	req := c.newRequest(op, input, &GetIntentVersionsOutput{})
	return GetIntentVersionsRequest{Request: req, Input: input, Copy: c.GetIntentVersionsRequest}
}

// GetIntentVersionsRequest is the request type for the
// GetIntentVersions API operation.
type GetIntentVersionsRequest struct {
	*aws.Request
	Input *GetIntentVersionsInput
	Copy  func(*GetIntentVersionsInput) GetIntentVersionsRequest
}

// Send marshals and sends the GetIntentVersions API request.
func (r GetIntentVersionsRequest) Send(ctx context.Context) (*GetIntentVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetIntentVersionsResponse{
		GetIntentVersionsOutput: r.Request.Data.(*GetIntentVersionsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetIntentVersionsRequestPaginator returns a paginator for GetIntentVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetIntentVersionsRequest(input)
//   p := lexmodelbuildingservice.NewGetIntentVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetIntentVersionsPaginator(req GetIntentVersionsRequest) GetIntentVersionsPaginator {
	return GetIntentVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetIntentVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetIntentVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetIntentVersionsPaginator struct {
	aws.Pager
}

func (p *GetIntentVersionsPaginator) CurrentPage() *GetIntentVersionsOutput {
	return p.Pager.CurrentPage().(*GetIntentVersionsOutput)
}

// GetIntentVersionsResponse is the response type for the
// GetIntentVersions API operation.
type GetIntentVersionsResponse struct {
	*GetIntentVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetIntentVersions request.
func (r *GetIntentVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
