// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLayersInput struct {
	_ struct{} `type:"structure"`

	// An array of layer IDs that specify the layers to be described. If you omit
	// this parameter, DescribeLayers returns a description of every layer in the
	// specified stack.
	LayerIds []string `type:"list"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeLayersInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the response to a DescribeLayers request.
type DescribeLayersOutput struct {
	_ struct{} `type:"structure"`

	// An array of Layer objects that describe the layers.
	Layers []Layer `type:"list"`
}

// String returns the string representation
func (s DescribeLayersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLayers = "DescribeLayers"

// DescribeLayersRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Requests a description of one or more layers in a specified stack.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DescribeLayersRequest.
//    req := client.DescribeLayersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeLayers
func (c *Client) DescribeLayersRequest(input *DescribeLayersInput) DescribeLayersRequest {
	op := &aws.Operation{
		Name:       opDescribeLayers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLayersInput{}
	}

	req := c.newRequest(op, input, &DescribeLayersOutput{})
	return DescribeLayersRequest{Request: req, Input: input, Copy: c.DescribeLayersRequest}
}

// DescribeLayersRequest is the request type for the
// DescribeLayers API operation.
type DescribeLayersRequest struct {
	*aws.Request
	Input *DescribeLayersInput
	Copy  func(*DescribeLayersInput) DescribeLayersRequest
}

// Send marshals and sends the DescribeLayers API request.
func (r DescribeLayersRequest) Send(ctx context.Context) (*DescribeLayersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLayersResponse{
		DescribeLayersOutput: r.Request.Data.(*DescribeLayersOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLayersResponse is the response type for the
// DescribeLayers API operation.
type DescribeLayersResponse struct {
	*DescribeLayersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLayers request.
func (r *DescribeLayersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
