// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateCampaignInput struct {
	_ struct{} `type:"structure"`

	// Specifies the requested minimum provisioned transactions (recommendations)
	// per second that Amazon Personalize will support.
	//
	// MinProvisionedTPS is a required field
	MinProvisionedTPS *int64 `locationName:"minProvisionedTPS" min:"1" type:"integer" required:"true"`

	// A name for the new campaign. The campaign name must be unique within your
	// account.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the solution version to deploy.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCampaignInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCampaignInput"}

	if s.MinProvisionedTPS == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinProvisionedTPS"))
	}
	if s.MinProvisionedTPS != nil && *s.MinProvisionedTPS < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MinProvisionedTPS", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.SolutionVersionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SolutionVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateCampaignOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the campaign.
	CampaignArn *string `locationName:"campaignArn" type:"string"`
}

// String returns the string representation
func (s CreateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateCampaign = "CreateCampaign"

// CreateCampaignRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Creates a campaign by deploying a solution version. When a client calls the
// GetRecommendations (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
// and GetPersonalizedRanking (https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html)
// APIs, a campaign is specified in the request.
//
// Minimum Provisioned TPS and Auto-Scaling
//
// A transaction is a single GetRecommendations or GetPersonalizedRanking call.
// Transactions per second (TPS) is the throughput and unit of billing for Amazon
// Personalize. The minimum provisioned TPS (minProvisionedTPS) specifies the
// baseline throughput provisioned by Amazon Personalize, and thus, the minimum
// billing charge. If your TPS increases beyond minProvisionedTPS, Amazon Personalize
// auto-scales the provisioned capacity up and down, but never below minProvisionedTPS,
// to maintain a 70% utilization. There's a short time delay while the capacity
// is increased that might cause loss of transactions. It's recommended to start
// with a low minProvisionedTPS, track your usage using Amazon CloudWatch metrics,
// and then increase the minProvisionedTPS as necessary.
//
// Status
//
// A campaign can be in one of the following states:
//
//    * CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE FAILED
//
//    * DELETE PENDING > DELETE IN_PROGRESS
//
// To get the campaign status, call DescribeCampaign.
//
// Wait until the status of the campaign is ACTIVE before asking the campaign
// for recommendations.
//
// Related APIs
//
//    * ListCampaigns
//
//    * DescribeCampaign
//
//    * UpdateCampaign
//
//    * DeleteCampaign
//
//    // Example sending a request using CreateCampaignRequest.
//    req := client.CreateCampaignRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateCampaign
func (c *Client) CreateCampaignRequest(input *CreateCampaignInput) CreateCampaignRequest {
	op := &aws.Operation{
		Name:       opCreateCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCampaignInput{}
	}

	req := c.newRequest(op, input, &CreateCampaignOutput{})
	return CreateCampaignRequest{Request: req, Input: input, Copy: c.CreateCampaignRequest}
}

// CreateCampaignRequest is the request type for the
// CreateCampaign API operation.
type CreateCampaignRequest struct {
	*aws.Request
	Input *CreateCampaignInput
	Copy  func(*CreateCampaignInput) CreateCampaignRequest
}

// Send marshals and sends the CreateCampaign API request.
func (r CreateCampaignRequest) Send(ctx context.Context) (*CreateCampaignResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCampaignResponse{
		CreateCampaignOutput: r.Request.Data.(*CreateCampaignOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCampaignResponse is the response type for the
// CreateCampaign API operation.
type CreateCampaignResponse struct {
	*CreateCampaignOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCampaign request.
func (r *CreateCampaignResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
