// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetSolutionMetricsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the solution version for which to get metrics.
	//
	// SolutionVersionArn is a required field
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSolutionMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSolutionMetricsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSolutionMetricsInput"}

	if s.SolutionVersionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SolutionVersionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetSolutionMetricsOutput struct {
	_ struct{} `type:"structure"`

	// The metrics for the solution version.
	Metrics map[string]float64 `locationName:"metrics" type:"map"`

	// The same solution version ARN as specified in the request.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`
}

// String returns the string representation
func (s GetSolutionMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetSolutionMetrics = "GetSolutionMetrics"

// GetSolutionMetricsRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Gets the metrics for the specified solution version.
//
//    // Example sending a request using GetSolutionMetricsRequest.
//    req := client.GetSolutionMetricsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/GetSolutionMetrics
func (c *Client) GetSolutionMetricsRequest(input *GetSolutionMetricsInput) GetSolutionMetricsRequest {
	op := &aws.Operation{
		Name:       opGetSolutionMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSolutionMetricsInput{}
	}

	req := c.newRequest(op, input, &GetSolutionMetricsOutput{})
	return GetSolutionMetricsRequest{Request: req, Input: input, Copy: c.GetSolutionMetricsRequest}
}

// GetSolutionMetricsRequest is the request type for the
// GetSolutionMetrics API operation.
type GetSolutionMetricsRequest struct {
	*aws.Request
	Input *GetSolutionMetricsInput
	Copy  func(*GetSolutionMetricsInput) GetSolutionMetricsRequest
}

// Send marshals and sends the GetSolutionMetrics API request.
func (r GetSolutionMetricsRequest) Send(ctx context.Context) (*GetSolutionMetricsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSolutionMetricsResponse{
		GetSolutionMetricsOutput: r.Request.Data.(*GetSolutionMetricsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSolutionMetricsResponse is the response type for the
// GetSolutionMetrics API operation.
type GetSolutionMetricsResponse struct {
	*GetSolutionMetricsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSolutionMetrics request.
func (r *GetSolutionMetricsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
