// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteApnsSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsSandboxChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteApnsSandboxChannelInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApnsSandboxChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteApnsSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelResponse"`

	// Provides information about the status and settings of the APNs (Apple Push
	// Notification service) sandbox channel for an application.
	//
	// APNSSandboxChannelResponse is a required field
	APNSSandboxChannelResponse *APNSSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApnsSandboxChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.APNSSandboxChannelResponse != nil {
		v := s.APNSSandboxChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "APNSSandboxChannelResponse", v, metadata)
	}
	return nil
}

const opDeleteApnsSandboxChannel = "DeleteApnsSandboxChannel"

// DeleteApnsSandboxChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Disables the APNs sandbox channel for an application and deletes any existing
// settings for the channel.
//
//    // Example sending a request using DeleteApnsSandboxChannelRequest.
//    req := client.DeleteApnsSandboxChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel
func (c *Client) DeleteApnsSandboxChannelRequest(input *DeleteApnsSandboxChannelInput) DeleteApnsSandboxChannelRequest {
	op := &aws.Operation{
		Name:       opDeleteApnsSandboxChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_sandbox",
	}

	if input == nil {
		input = &DeleteApnsSandboxChannelInput{}
	}

	req := c.newRequest(op, input, &DeleteApnsSandboxChannelOutput{})
	return DeleteApnsSandboxChannelRequest{Request: req, Input: input, Copy: c.DeleteApnsSandboxChannelRequest}
}

// DeleteApnsSandboxChannelRequest is the request type for the
// DeleteApnsSandboxChannel API operation.
type DeleteApnsSandboxChannelRequest struct {
	*aws.Request
	Input *DeleteApnsSandboxChannelInput
	Copy  func(*DeleteApnsSandboxChannelInput) DeleteApnsSandboxChannelRequest
}

// Send marshals and sends the DeleteApnsSandboxChannel API request.
func (r DeleteApnsSandboxChannelRequest) Send(ctx context.Context) (*DeleteApnsSandboxChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteApnsSandboxChannelResponse{
		DeleteApnsSandboxChannelOutput: r.Request.Data.(*DeleteApnsSandboxChannelOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteApnsSandboxChannelResponse is the response type for the
// DeleteApnsSandboxChannel API operation.
type DeleteApnsSandboxChannelResponse struct {
	*DeleteApnsSandboxChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteApnsSandboxChannel request.
func (r *DeleteApnsSandboxChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
