// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchModifyClusterSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A boolean value indicating whether to override an exception if the retention
	// period has passed.
	Force *bool `type:"boolean"`

	// The number of days that a manual snapshot is retained. If you specify the
	// value -1, the manual snapshot is retained indefinitely.
	//
	// The number must be either -1 or an integer between 1 and 3,653.
	//
	// If you decrease the manual snapshot retention period from its current value,
	// existing manual snapshots that fall outside of the new retention period will
	// return an error. If you want to suppress the errors and delete the snapshots,
	// use the force option.
	ManualSnapshotRetentionPeriod *int64 `type:"integer"`

	// A list of snapshot identifiers you want to modify.
	//
	// SnapshotIdentifierList is a required field
	SnapshotIdentifierList []string `locationNameList:"String" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchModifyClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchModifyClusterSnapshotsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchModifyClusterSnapshotsInput"}

	if s.SnapshotIdentifierList == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotIdentifierList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchModifyClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// A list of any errors returned.
	Errors []SnapshotErrorMessage `locationNameList:"SnapshotErrorMessage" type:"list"`

	// A list of the snapshots that were modified.
	Resources []string `locationNameList:"String" type:"list"`
}

// String returns the string representation
func (s BatchModifyClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchModifyClusterSnapshots = "BatchModifyClusterSnapshots"

// BatchModifyClusterSnapshotsRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Modifies the settings for a list of snapshots.
//
//    // Example sending a request using BatchModifyClusterSnapshotsRequest.
//    req := client.BatchModifyClusterSnapshotsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchModifyClusterSnapshots
func (c *Client) BatchModifyClusterSnapshotsRequest(input *BatchModifyClusterSnapshotsInput) BatchModifyClusterSnapshotsRequest {
	op := &aws.Operation{
		Name:       opBatchModifyClusterSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchModifyClusterSnapshotsInput{}
	}

	req := c.newRequest(op, input, &BatchModifyClusterSnapshotsOutput{})
	return BatchModifyClusterSnapshotsRequest{Request: req, Input: input, Copy: c.BatchModifyClusterSnapshotsRequest}
}

// BatchModifyClusterSnapshotsRequest is the request type for the
// BatchModifyClusterSnapshots API operation.
type BatchModifyClusterSnapshotsRequest struct {
	*aws.Request
	Input *BatchModifyClusterSnapshotsInput
	Copy  func(*BatchModifyClusterSnapshotsInput) BatchModifyClusterSnapshotsRequest
}

// Send marshals and sends the BatchModifyClusterSnapshots API request.
func (r BatchModifyClusterSnapshotsRequest) Send(ctx context.Context) (*BatchModifyClusterSnapshotsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchModifyClusterSnapshotsResponse{
		BatchModifyClusterSnapshotsOutput: r.Request.Data.(*BatchModifyClusterSnapshotsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchModifyClusterSnapshotsResponse is the response type for the
// BatchModifyClusterSnapshots API operation.
type BatchModifyClusterSnapshotsResponse struct {
	*BatchModifyClusterSnapshotsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchModifyClusterSnapshots request.
func (r *BatchModifyClusterSnapshotsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
