// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type PutBucketVersioningInput struct {
	_ struct{} `type:"structure" payload:"VersioningConfiguration"`

	// The bucket name.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Container for setting the versioning state.
	//
	// VersioningConfiguration is a required field
	VersioningConfiguration *VersioningConfiguration `locationName:"VersioningConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketVersioningInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketVersioningInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.VersioningConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersioningConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketVersioningInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketVersioningInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.MFA != nil {
		v := *s.MFA

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-mfa", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.VersioningConfiguration != nil {
		v := s.VersioningConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "VersioningConfiguration", v, metadata)
	}
	return nil
}

type PutBucketVersioningOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketVersioningOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBucketVersioning = "PutBucketVersioning"

// PutBucketVersioningRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets the versioning state of an existing bucket. To set the versioning state,
// you must be the bucket owner.
//
// You can set the versioning state with one of the following values:
//
// Enabled—Enables versioning for the objects in the bucket. All objects added
// to the bucket receive a unique version ID.
//
// Suspended—Disables versioning for the objects in the bucket. All objects
// added to the bucket receive the version ID null.
//
// If the versioning state has never been set on a bucket, it has no versioning
// state; a GetBucketVersioning request does not return a versioning state value.
//
// If the bucket owner enables MFA Delete in the bucket versioning configuration,
// the bucket owner must include the x-amz-mfa request header and the Status
// and the MfaDelete request elements in a request to set the versioning state
// of the bucket.
//
// If you have an object expiration lifecycle policy in your non-versioned bucket
// and you want to maintain the same permanent delete behavior when you enable
// versioning, you must add a noncurrent expiration policy. The noncurrent expiration
// lifecycle policy will manage the deletes of the noncurrent object versions
// in the version-enabled bucket. (A version-enabled bucket maintains one current
// and zero or more noncurrent object versions.) For more information, see Lifecycle
// and Versioning (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html#lifecycle-and-other-bucket-config).
//
// Related Resources
//
//    * CreateBucket
//
//    * DeleteBucket
//
//    * GetBucketVersioning
//
//    // Example sending a request using PutBucketVersioningRequest.
//    req := client.PutBucketVersioningRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioning
func (c *Client) PutBucketVersioningRequest(input *PutBucketVersioningInput) PutBucketVersioningRequest {
	op := &aws.Operation{
		Name:       opPutBucketVersioning,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &PutBucketVersioningInput{}
	}

	req := c.newRequest(op, input, &PutBucketVersioningOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutBucketVersioningRequest{Request: req, Input: input, Copy: c.PutBucketVersioningRequest}
}

// PutBucketVersioningRequest is the request type for the
// PutBucketVersioning API operation.
type PutBucketVersioningRequest struct {
	*aws.Request
	Input *PutBucketVersioningInput
	Copy  func(*PutBucketVersioningInput) PutBucketVersioningRequest
}

// Send marshals and sends the PutBucketVersioning API request.
func (r PutBucketVersioningRequest) Send(ctx context.Context) (*PutBucketVersioningResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBucketVersioningResponse{
		PutBucketVersioningOutput: r.Request.Data.(*PutBucketVersioningOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBucketVersioningResponse is the response type for the
// PutBucketVersioning API operation.
type PutBucketVersioningResponse struct {
	*PutBucketVersioningOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBucketVersioning request.
func (r *PutBucketVersioningResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
