// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAppReplicationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ID of the application associated with the replication configuration.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s GetAppReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

type GetAppReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Replication configurations associated with server groups in this application.
	ServerGroupReplicationConfigurations []ServerGroupReplicationConfiguration `locationName:"serverGroupReplicationConfigurations" type:"list"`
}

// String returns the string representation
func (s GetAppReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAppReplicationConfiguration = "GetAppReplicationConfiguration"

// GetAppReplicationConfigurationRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Retrieves an application replication configuration associatd with an application.
//
//    // Example sending a request using GetAppReplicationConfigurationRequest.
//    req := client.GetAppReplicationConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppReplicationConfiguration
func (c *Client) GetAppReplicationConfigurationRequest(input *GetAppReplicationConfigurationInput) GetAppReplicationConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetAppReplicationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAppReplicationConfigurationInput{}
	}

	req := c.newRequest(op, input, &GetAppReplicationConfigurationOutput{})
	return GetAppReplicationConfigurationRequest{Request: req, Input: input, Copy: c.GetAppReplicationConfigurationRequest}
}

// GetAppReplicationConfigurationRequest is the request type for the
// GetAppReplicationConfiguration API operation.
type GetAppReplicationConfigurationRequest struct {
	*aws.Request
	Input *GetAppReplicationConfigurationInput
	Copy  func(*GetAppReplicationConfigurationInput) GetAppReplicationConfigurationRequest
}

// Send marshals and sends the GetAppReplicationConfiguration API request.
func (r GetAppReplicationConfigurationRequest) Send(ctx context.Context) (*GetAppReplicationConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAppReplicationConfigurationResponse{
		GetAppReplicationConfigurationOutput: r.Request.Data.(*GetAppReplicationConfigurationOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAppReplicationConfigurationResponse is the response type for the
// GetAppReplicationConfiguration API operation.
type GetAppReplicationConfigurationResponse struct {
	*GetAppReplicationConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAppReplicationConfiguration request.
func (r *GetAppReplicationConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
