// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RegisterDefaultPatchBaselineInput struct {
	_ struct{} `type:"structure"`

	// The ID of the patch baseline that should be the default patch baseline.
	//
	// BaselineId is a required field
	BaselineId *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterDefaultPatchBaselineInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterDefaultPatchBaselineInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterDefaultPatchBaselineInput"}

	if s.BaselineId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BaselineId"))
	}
	if s.BaselineId != nil && len(*s.BaselineId) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("BaselineId", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterDefaultPatchBaselineOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the default patch baseline.
	BaselineId *string `min:"20" type:"string"`
}

// String returns the string representation
func (s RegisterDefaultPatchBaselineOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterDefaultPatchBaseline = "RegisterDefaultPatchBaseline"

// RegisterDefaultPatchBaselineRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Defines the default patch baseline for the relevant operating system.
//
// To reset the AWS predefined patch baseline as the default, specify the full
// patch baseline ARN as the baseline ID value. For example, for CentOS, specify
// arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed instead
// of pb-0574b43a65ea646ed.
//
//    // Example sending a request using RegisterDefaultPatchBaselineRequest.
//    req := client.RegisterDefaultPatchBaselineRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterDefaultPatchBaseline
func (c *Client) RegisterDefaultPatchBaselineRequest(input *RegisterDefaultPatchBaselineInput) RegisterDefaultPatchBaselineRequest {
	op := &aws.Operation{
		Name:       opRegisterDefaultPatchBaseline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDefaultPatchBaselineInput{}
	}

	req := c.newRequest(op, input, &RegisterDefaultPatchBaselineOutput{})
	return RegisterDefaultPatchBaselineRequest{Request: req, Input: input, Copy: c.RegisterDefaultPatchBaselineRequest}
}

// RegisterDefaultPatchBaselineRequest is the request type for the
// RegisterDefaultPatchBaseline API operation.
type RegisterDefaultPatchBaselineRequest struct {
	*aws.Request
	Input *RegisterDefaultPatchBaselineInput
	Copy  func(*RegisterDefaultPatchBaselineInput) RegisterDefaultPatchBaselineRequest
}

// Send marshals and sends the RegisterDefaultPatchBaseline API request.
func (r RegisterDefaultPatchBaselineRequest) Send(ctx context.Context) (*RegisterDefaultPatchBaselineResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterDefaultPatchBaselineResponse{
		RegisterDefaultPatchBaselineOutput: r.Request.Data.(*RegisterDefaultPatchBaselineOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterDefaultPatchBaselineResponse is the response type for the
// RegisterDefaultPatchBaseline API operation.
type RegisterDefaultPatchBaselineResponse struct {
	*RegisterDefaultPatchBaselineOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterDefaultPatchBaseline request.
func (r *RegisterDefaultPatchBaselineResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
