// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAvailabilityMonitorTestInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAvailabilityMonitorTestInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAvailabilityMonitorTestInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAvailabilityMonitorTestInput"}

	if s.GatewayARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAvailabilityMonitorTestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and AWS Region.
	GatewayARN *string `min:"50" type:"string"`

	// The time the High Availability monitoring test was started. If a test hasn't
	// been performed, the value of this field is null.
	StartTime *time.Time `type:"timestamp"`

	// The status of the High Availability monitoring test. If a test hasn't been
	// performed, the value of this field is null.
	Status AvailabilityMonitorTestStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeAvailabilityMonitorTestOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAvailabilityMonitorTest = "DescribeAvailabilityMonitorTest"

// DescribeAvailabilityMonitorTestRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Returns information about the most recent High Availability monitoring test
// that was performed on the host in a cluster. If a test isn't performed, the
// status and start time in the response would be null.
//
//    // Example sending a request using DescribeAvailabilityMonitorTestRequest.
//    req := client.DescribeAvailabilityMonitorTestRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeAvailabilityMonitorTest
func (c *Client) DescribeAvailabilityMonitorTestRequest(input *DescribeAvailabilityMonitorTestInput) DescribeAvailabilityMonitorTestRequest {
	op := &aws.Operation{
		Name:       opDescribeAvailabilityMonitorTest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAvailabilityMonitorTestInput{}
	}

	req := c.newRequest(op, input, &DescribeAvailabilityMonitorTestOutput{})
	return DescribeAvailabilityMonitorTestRequest{Request: req, Input: input, Copy: c.DescribeAvailabilityMonitorTestRequest}
}

// DescribeAvailabilityMonitorTestRequest is the request type for the
// DescribeAvailabilityMonitorTest API operation.
type DescribeAvailabilityMonitorTestRequest struct {
	*aws.Request
	Input *DescribeAvailabilityMonitorTestInput
	Copy  func(*DescribeAvailabilityMonitorTestInput) DescribeAvailabilityMonitorTestRequest
}

// Send marshals and sends the DescribeAvailabilityMonitorTest API request.
func (r DescribeAvailabilityMonitorTestRequest) Send(ctx context.Context) (*DescribeAvailabilityMonitorTestResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAvailabilityMonitorTestResponse{
		DescribeAvailabilityMonitorTestOutput: r.Request.Data.(*DescribeAvailabilityMonitorTestOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAvailabilityMonitorTestResponse is the response type for the
// DescribeAvailabilityMonitorTest API operation.
type DescribeAvailabilityMonitorTestResponse struct {
	*DescribeAvailabilityMonitorTestOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAvailabilityMonitorTest request.
func (r *DescribeAvailabilityMonitorTestResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
