// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ActivateUserInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Do not set this field when using administrative
	// API actions, as in accessing the API using AWS credentials.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the user.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActivateUserInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateUserInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ActivateUserInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}

	if s.UserId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ActivateUserInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ActivateUserOutput struct {
	_ struct{} `type:"structure"`

	// The user information.
	User *User `type:"structure"`
}

// String returns the string representation
func (s ActivateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ActivateUserOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "User", v, metadata)
	}
	return nil
}

const opActivateUser = "ActivateUser"

// ActivateUserRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Activates the specified user. Only active users can access Amazon WorkDocs.
//
//    // Example sending a request using ActivateUserRequest.
//    req := client.ActivateUserRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/ActivateUser
func (c *Client) ActivateUserRequest(input *ActivateUserInput) ActivateUserRequest {
	op := &aws.Operation{
		Name:       opActivateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/api/v1/users/{UserId}/activation",
	}

	if input == nil {
		input = &ActivateUserInput{}
	}

	req := c.newRequest(op, input, &ActivateUserOutput{})
	return ActivateUserRequest{Request: req, Input: input, Copy: c.ActivateUserRequest}
}

// ActivateUserRequest is the request type for the
// ActivateUser API operation.
type ActivateUserRequest struct {
	*aws.Request
	Input *ActivateUserInput
	Copy  func(*ActivateUserInput) ActivateUserRequest
}

// Send marshals and sends the ActivateUser API request.
func (r ActivateUserRequest) Send(ctx context.Context) (*ActivateUserResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ActivateUserResponse{
		ActivateUserOutput: r.Request.Data.(*ActivateUserOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ActivateUserResponse is the response type for the
// ActivateUser API operation.
type ActivateUserResponse struct {
	*ActivateUserOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ActivateUser request.
func (r *ActivateUserResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
